/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawWayEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractDrawPlanPlugin
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(ContractDrawPlanPlugin.class);

    public void registerListener(EventObject e) {
        TextEdit contractBillNo = (TextEdit)this.getControl("contractbill");
        if (EmptyUtil.isNoEmpty((Object)contractBillNo)) {
            contractBillNo.addClickListener((ClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        IDataModel model;
        String loanType;
        super.afterBindData(e);
        IFormView view = this.getView();
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"contractbill", (Object)this.getModel().getValue("billno"));
        }
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            view.setEnable(Boolean.FALSE, new String[]{"contractbill"});
            view.setVisible(Boolean.FALSE, new String[]{"contractbill"});
        }
        if (!BizTypeEnum.isBond((String)(loanType = (String)(model = this.getModel()).getValue("loantype"))) && !BizTypeEnum.isFinLease((String)loanType)) {
            this.setCanEditByDrawState();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Object value = e.getValue();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = e.getRowIndex();
        switch (key) {
            case "e_plandrawdate": {
                this.planDrawDateBeforePost(e, key, rowIndex, value);
                break;
            }
            case "e_plandrawamt": {
                this.planDrawAmtbeforepost(e, key, rowIndex, new BigDecimal(value + ""));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newVal = changeData.getNewValue();
        Object oldVal = changeData.getOldValue();
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propName) {
            case "e_plandrawamt": {
                int rowCount = model.getEntryRowCount("drawdownplan_entry");
                if (rowIndex == rowCount - 1) break;
                this.calLastRowAmtVal();
                break;
            }
            case "e_plandrawdate": 
            case "e_drawdescription": 
            case "e_drawacctbank": {
                if (!EmptyUtil.isNoEmpty((Object)newVal) || newVal.equals(oldVal)) break;
                this.setUpdateRowInfo(rowIndex);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        if (evt.getSource() instanceof Control && "contractbill".equals(key = ((Control)evt.getSource()).getKey())) {
            this.openContractBill();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if ("contractbill".equals(e.getActionId()) && EmptyUtil.isNoEmpty((Object)returnData)) {
            Object id = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
            ((IBillModel)this.getModel()).load(id);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"contractbill", (Object)((ListSelectedRowCollection)returnData).get(0).getBillNo());
            this.getView().updateView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "drawplannewentry": 
            case "drawplanentryimport": {
                this.beforeNewEntryRowOp(args);
                break;
            }
            case "updatedrawplan": 
            case "drawplansave": {
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("contractbill"))) break;
                this.getView().showErrorNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_4.loadKDString());
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "drawplansave": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"contractbill", (Object)this.getModel().getValue("billno"));
                break;
            }
            case "updatedrawplan": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.updateDrawPlan();
                this.getView().updateView("drawdownplan_entry");
                this.setCanEditByDrawState();
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("drawdownplan_entry".equals(entryName)) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                this.newDrawPlanEntry(row.getRowIndex());
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] indexs = e.getRowIndexs();
        EntryProp entryProp = e.getEntryProp();
        if ("drawdownplan_entry".equals(entryProp.getName()) && indexs.length > 0) {
            String drawStatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"e_drawstate");
            for (int row : indexs) {
                if (!"1".equals(this.getModel().getValue("e_drawstate", row))) continue;
                this.getView().showTipNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_7.loadKDString(drawStatePropName));
                e.setCancel(true);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("drawdownplan_entry".equals(entryName)) {
            this.calLastRowAmtVal();
        }
    }

    private void planDrawDateBeforePost(BeforeFieldPostBackEvent e, String key, int rowIndex, Object value) {
        String fmtStr = ((DateEdit)this.getControl("e_plandrawdate")).getFormatString();
        Date planDrawDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        Date contractStartDate = (Date)this.getModel().getValue("startdate");
        Date contractEndDate = (Date)this.getModel().getValue("enddate");
        Date renewalExpiredate = (Date)this.getModel().getValue("renewalexpiredate");
        if (EmptyUtil.isNoEmpty((Object)renewalExpiredate)) {
            contractEndDate = renewalExpiredate;
        }
        String drawDatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"e_plandrawdate");
        if (EmptyUtil.isNoEmpty((Object)planDrawDate) && planDrawDate.before(contractStartDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_1.loadKDString(drawDatePropName, DateUtils.formatString((Date)contractStartDate, (String)"yyyy-MM-dd")));
            this.getView().updateView(key, rowIndex);
        }
        if (EmptyUtil.isNoEmpty((Object)contractEndDate) && planDrawDate.after(contractEndDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_2.loadKDString(drawDatePropName, DateUtils.formatString((Date)contractEndDate, (String)"yyyy-MM-dd")));
            this.getView().updateView(key, rowIndex);
        }
    }

    private void planDrawAmtbeforepost(BeforeFieldPostBackEvent e, String key, int rowIndex, BigDecimal planDrawAmt) {
        String planDrawAmtName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"e_plandrawamt");
        if (planDrawAmt.compareTo(BigDecimal.ZERO) <= 0) {
            e.setCancel(true);
            this.getView().showTipNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_9.loadKDString(planDrawAmtName));
            this.getView().updateView(key, rowIndex);
        }
        if (((Boolean)this.getModel().getValue("iscycleloan")).booleanValue()) {
            return;
        }
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal allEntryRowsAmt = this.getAllEntryRowsAmt("e_plandrawamt");
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("drawdownplan_entry", rowIndex);
        BigDecimal beforeRowAmt = rowInfo.getBigDecimal("e_plandrawamt");
        BigDecimal newRowtotalAmts = allEntryRowsAmt.subtract(beforeRowAmt).add(planDrawAmt);
        DynamicObjectCollection drawPlanEntry = this.getModel().getEntryEntity("drawdownplan_entry");
        if (newRowtotalAmts.compareTo(amount) > 0 && rowIndex == drawPlanEntry.size() - 1) {
            e.setCancel(true);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            int scale = currency != null ? currency.getInt("amtprecision") : 2;
            this.getView().showTipNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_3.loadKDString(planDrawAmtName, newRowtotalAmts.setScale(scale, RoundingMode.HALF_UP), amount.setScale(scale, RoundingMode.HALF_UP)));
            this.getView().updateView(key, rowIndex);
        }
    }

    private void beforeNewEntryRowOp(BeforeDoOperationEventArgs args) {
        String billFormId = this.getView().getFormShowParameter().getFormId();
        List<String> billFormIds = Arrays.asList("cfm_draw_plan", "cim_invest_draw_plan", "ifm_draw_plan");
        if (billFormIds.contains(billFormId) && EmptyUtil.isEmpty((Object)this.getModel().getValue("contractbill"))) {
            this.getView().showErrorNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_4.loadKDString());
            args.setCancel(true);
        }
        String drawWay = (String)this.getModel().getValue("drawway");
        int rowCount = this.getModel().getEntryRowCount("drawdownplan_entry");
        if (DrawWayEnum.ONCE.getValue().equals(drawWay) && rowCount > 0) {
            String drawWayPropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"drawway");
            this.getView().showTipNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_5.loadKDString(drawWayPropName));
            args.setCancel(true);
        }
    }

    private void updateDrawPlan() {
        Long contractId = (Long)this.getModel().getDataEntity().getPkValue();
        Object[] loanBills = LoanBillRepository.getLoanBillByContractId((Long)contractId);
        String dataSource = (String)this.getModel().getValue("datasource");
        if (EmptyUtil.isEmpty((Object[])loanBills)) {
            this.getView().showTipNotification(CfmFormResourceEnum.ContractDrawPlanPlugin_1.loadKDString(CfmBillCommonHelper.getLoanNameByDataSource((String)dataSource)));
        }
        DynamicObjectCollection drawPlanEntry = this.getModel().getEntryEntity("drawdownplan_entry");
        int seq = 1;
        ContractDrawPlanPlugin.getUnExecutedPlanEntry(drawPlanEntry, seq);
        seq = drawPlanEntry.size() + 1;
        for (Object loanBill : loanBills) {
            this.createDrawPlanEntry(drawPlanEntry.addNew(), (DynamicObject)loanBill, seq++);
        }
        Collections.sort(drawPlanEntry, Comparator.comparing(o -> o.getDate("e_plandrawdate")));
        for (int i = 0; i <= drawPlanEntry.size() - 1; ++i) {
            ((DynamicObject)drawPlanEntry.get(i)).set("seq", (Object)(i + 1));
        }
    }

    public static DynamicObjectCollection getUnExecutedPlanEntry(DynamicObjectCollection drawPlanEntry, int seq) {
        DynamicObjectCollection newDrawPlanEntry = TmcDataServiceHelper.newDynamicObject((String)"cfm_loancontractbill").getDynamicObjectCollection("drawdownplan_entry");
        for (DynamicObject drawPlan : drawPlanEntry) {
            if (!"0".equals(drawPlan.getString("e_drawstate")) || !EmptyUtil.isNoEmpty((Object)drawPlan.get("e_plandrawdate")) || !EmptyUtil.isNoEmpty((Object)drawPlan.get("e_plandrawamt"))) continue;
            newDrawPlanEntry.add((Object)drawPlan);
            ++seq;
        }
        drawPlanEntry.clear();
        for (DynamicObject drawPlan : newDrawPlanEntry) {
            drawPlanEntry.add((Object)drawPlan);
        }
        return drawPlanEntry;
    }

    private void createDrawPlanEntry(DynamicObject planEntry, DynamicObject loanBill, int seq) {
        planEntry.set("seq", (Object)seq);
        planEntry.set("e_plandrawdate", (Object)loanBill.getDate("bizdate"));
        planEntry.set("e_plandrawamt", (Object)loanBill.getBigDecimal("drawamount"));
        planEntry.set("e_drawstate", (Object)"1");
        planEntry.set("e_drawacctbank", DataSourceEnum.isInvest((String)loanBill.getString("datasource")) ? loanBill.get("loaneracctbank") : loanBill.get("accountbank"));
        planEntry.set("e_drawmodifier", (Object)RequestContext.get().getCurrUserId());
        planEntry.set("e_drawmodifytime", (Object)DateUtils.getCurrentTime());
    }

    private void newDrawPlanEntry(int index) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject loanerAcctBank = (DynamicObject)this.getModel().getValue("loaneracctbank");
        String dataSource = (String)this.getModel().getValue("datasource");
        DynamicObject drawAcctBank = DataSourceEnum.isInvest((String)dataSource) ? loanerAcctBank : accountBank;
        String drawway = (String)this.getModel().getValue("drawway");
        this.calLastRowAmtVal();
        if (DrawWayEnum.ONCE.getValue().equals(drawway)) {
            this.getModel().setValue("e_plandrawamt", (Object)amount, index);
        }
        this.getModel().setValue("e_drawstate", (Object)"0", index);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_drawdescription", null, (int)index);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_drawacctbank", (Object)drawAcctBank, (int)index);
        this.setUpdateRowInfo(index);
    }

    private void calLastRowAmtVal() {
        DynamicObjectCollection lastRowInfos = this.getModel().getEntryEntity("drawdownplan_entry");
        if (lastRowInfos.size() > 0) {
            int lastRow = lastRowInfos.getRowCount() - 1;
            BigDecimal allEntryRowsAmt = BigDecimal.ZERO;
            for (int i = 0; i < lastRowInfos.size() - 1; ++i) {
                allEntryRowsAmt = allEntryRowsAmt.add(((DynamicObject)lastRowInfos.get(i)).getBigDecimal("e_plandrawamt"));
            }
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal remainAmt = amount.subtract(allEntryRowsAmt);
            if (EmptyUtil.isNoEmpty((BigDecimal)remainAmt) && !"1".equals(this.getModel().getValue("e_drawstate", lastRow))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_plandrawamt", (Object)remainAmt, (int)lastRow);
            }
        }
    }

    private BigDecimal getAllEntryRowsAmt(String entryField) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("drawdownplan_entry");
        return entryGrid.getSum(entryField);
    }

    private void setUpdateRowInfo(int rowIndex) {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_drawmodifier", (Object)RequestContext.get().getCurrUserId(), (int)rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_drawmodifytime", (Object)DateUtils.getCurrentTime(), (int)rowIndex);
    }

    private void openContractBill() {
        QFilter qFilter = new QFilter("contractstatus", "!=", (Object)LoanContractStatusEnum.CLOSED.getValue());
        String loanType = (String)this.getModel().getValue("loantype");
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("biztype")) {
            String bizType = (String)this.getView().getFormShowParameter().getCustomParam("biztype");
            Object[] bizTypes = bizType.split(",");
            if (EmptyUtil.isNoEmpty((Object[])bizTypes)) {
                qFilter.and(new QFilter("loantype", "in", (Object)bizTypes));
            }
        } else if (EmptyUtil.isNoEmpty((String)loanType)) {
            qFilter.and(new QFilter("loantype", "in", (Object)BizTypeEnum.getSameTypeComb((String)loanType)));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        String billFormId = this.getView().getFormShowParameter().getFormId();
        String formId = "cfm_loancontractbill";
        if ("cfm_draw_plan".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.CFM.getValue());
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
        } else if ("cim_invest_draw_plan".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.INVEST.getValue());
            qFilter.and(new QFilter("creditorg.id", "in", (Object)orgIdSet));
            formId = "cim_invest_contract";
        } else if ("ifm_draw_plan".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.IFM.getValue());
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
            formId = "ifm_loancontractbill";
        }
        ListShowParameter paramter = ShowFormHelper.createShowListForm((String)formId, (boolean)false, (int)0);
        logger.info("ContractDrawPlanPlugin filter:" + qFilter);
        paramter.getListFilterParameter().setFilter(qFilter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "contractbill");
        paramter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)paramter);
    }

    private void setCanEditByDrawState() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("drawdownplan_entry");
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject drawPlan = (DynamicObject)entrys.get(i);
            if (drawPlan.getInt("e_drawstate") != 1) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_plandrawdate", "e_plandrawamt", "e_drawdescription", "e_drawacctbank"});
        }
    }
}

