/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ContractRateAdjustTabEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private static final String[] rateResetProps = new String[]{"rateadjust_entry", "rateadjust_entry.ra_effectdate", "rateadjust_entry.ra_confirmdate", "rateadjust_entry.ra_yearrate", "rateadjust_entry.ra_remark", "rateadjust_entry.ra_modifier", "rateadjust_entry.ra_modifydate"};
    private static final String[] rateAdjustProps = new String[]{"ratehistory_entry", "ratehistory_entry.rh_effectdate", "ratehistory_entry.rh_rateadjno", "ratehistory_entry.id", "ratehistory_entry.rh_remark", "ratehistory_entry.rh_modifier", "ratehistory_entry.rh_modifydate"};

    public void registerListener(EventObject e) {
        EntryGrid rateAdjustList;
        super.registerListener(e);
        this.initControlEvt();
        this.initTabListFilter();
        BillList adjustLoanList = (BillList)this.getControl("rh_loanbilllistap");
        if (adjustLoanList != null) {
            adjustLoanList.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((rateAdjustList = (EntryGrid)this.getControl("rh_rateadjust_entry")) != null) {
            rateAdjustList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTabListFilter();
    }

    private void initControlEvt() {
        if (this.getControl("ra_loanbilllistap") != null) {
            ((BillList)this.getControl("ra_loanbilllistap")).addListRowClickListener(new ListRowClickListener(){

                public void listRowClick(ListRowClickEvent evt) {
                    ListSelectedRow row = evt.getCurrentListSelectedRow();
                    if (EmptyUtil.isEmpty((Object)row)) {
                        return;
                    }
                    boolean isChanged = ContractRateAdjustTabEdit.this.getModel().getDataChanged();
                    ContractRateAdjustTabEdit.this.loadRateResetCalList((Long)row.getPrimaryKeyValue());
                    ContractRateAdjustTabEdit.this.getModel().setDataChanged(isChanged);
                }
            });
        }
        if (this.getControl("rh_loanbilllistap") != null) {
            ((BillList)this.getControl("rh_loanbilllistap")).addListRowClickListener(new ListRowClickListener(){

                public void listRowClick(ListRowClickEvent evt) {
                    ListSelectedRow row = evt.getCurrentListSelectedRow();
                    if (EmptyUtil.isEmpty((Object)row)) {
                        return;
                    }
                    boolean isChanged = ContractRateAdjustTabEdit.this.getModel().getDataChanged();
                    ContractRateAdjustTabEdit.this.loadRateAdjustCalList((Long)row.getPrimaryKeyValue());
                    ContractRateAdjustTabEdit.this.getModel().setDataChanged(isChanged);
                }
            });
        }
        ((Tab)this.getControl("tab_contractinfo")).addTabSelectListener(evt -> {
            BillList rahLoanList;
            String tabKey = evt.getTabKey();
            if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"rateadjusttab")) {
                BillList raLoanList = (BillList)this.getControl("ra_loanbilllistap");
                if (EmptyUtil.isEmpty((Collection)raLoanList.getSelectedRows())) {
                    raLoanList.selectRows(0);
                }
            } else if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"rateadjusthistorytab") && EmptyUtil.isEmpty((Collection)(rahLoanList = (BillList)this.getControl("rh_loanbilllistap")).getSelectedRows())) {
                rahLoanList.selectRows(0);
            }
        });
    }

    private QFilter getContractQFilter() {
        Long contractBillId = (Long)this.getModel().getDataEntity().getPkValue();
        if (EmptyUtil.isEmpty((Long)contractBillId)) {
            return new QFilter("1", "=", (Object)2);
        }
        return new QFilter("sourcebillid", "=", (Object)contractBillId);
    }

    private void initTabListFilter() {
        if (this.getControl("ra_loanbilllistap") != null) {
            BillList raLoanBillList = (BillList)this.getControl("ra_loanbilllistap");
            raLoanBillList.setFilter(this.getContractQFilter());
        }
        if (this.getControl("rh_loanbilllistap") != null) {
            BillList rhLoanBillList = (BillList)this.getControl("rh_loanbilllistap");
            rhLoanBillList.setFilter(this.getContractQFilter());
        }
    }

    private void loadRateResetCalList(Long loanBillId) {
        if (this.getControl("ra_rateadjust_entry") != null) {
            this.getModel().deleteEntryData("ra_rateadjust_entry");
            CharSequence[] selectProps = rateResetProps;
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProps));
            DynamicObjectCollection rateResetCals = loanBill.getDynamicObjectCollection("rateadjust_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rateResetCals)) {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("ra_effectdate", new Object[0]).addField("ra_confirmdate", new Object[0]).addField("ra_yearrate", new Object[0]).addField("ra_remark", new Object[0]).addField("ra_modifier", new Object[0]).addField("ra_modifydate", new Object[0]);
                for (DynamicObject rateResetCal : rateResetCals) {
                    vs.addRow(new Object[]{rateResetCal.getDate("ra_effectdate"), rateResetCal.getDate("ra_confirmdate"), rateResetCal.getBigDecimal("ra_yearrate"), rateResetCal.getString("ra_remark"), rateResetCal.getDynamicObject("ra_modifier").getPkValue(), rateResetCal.getDate("ra_modifydate")});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("ra_rateadjust_entry", vs);
                model.endInit();
                this.getView().updateView("ra_rateadjust_entry");
            }
        }
    }

    private void loadRateAdjustCalList(Long loanBillId) {
        if (this.getControl("rh_rateadjust_entry") != null) {
            this.getModel().deleteEntryData("rh_rateadjust_entry");
            CharSequence[] selectProps = rateAdjustProps;
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProps));
            DynamicObjectCollection rateAdjustCals = loanBill.getDynamicObjectCollection("ratehistory_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rateAdjustCals)) {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("rh_effectdate", new Object[0]).addField("rh_rateadjno", new Object[0]).addField("id", new Object[0]).addField("rh_remark", new Object[0]).addField("rh_modifier", new Object[0]).addField("rh_modifydate", new Object[0]);
                for (DynamicObject rateAdjustCal : rateAdjustCals) {
                    vs.addRow(new Object[]{rateAdjustCal.getDate("rh_effectdate"), rateAdjustCal.getString("rh_rateadjno"), rateAdjustCal.getLong("id"), rateAdjustCal.getString("rh_remark"), rateAdjustCal.getDynamicObject("rh_modifier").getPkValue(), rateAdjustCal.getDate("rh_modifydate")});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("rh_rateadjust_entry", vs);
                model.endInit();
                this.getView().updateView("rh_rateadjust_entry");
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex;
        String fieldName = evt.getFieldName();
        if ("rh_rateadjno".equals(fieldName) && (rowIndex = evt.getRowIndex()) > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("rh_rateadjust_entry", rowIndex);
            String rateAdjNumb = entryRowEntity.getString("rh_rateadjno");
            if (EmptyUtil.isNoEmpty((String)rateAdjNumb)) {
                DynamicObject rateAdjObj = TmcDataServiceHelper.loadSingle((String)"cfm_rateadjustbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)rateAdjNumb)});
                if (EmptyUtil.isEmpty((DynamicObject)rateAdjObj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractRateAdjustTabEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(CfmRateAdjustHelper.getFormEntity((IFormView)this.getView()));
                parameter.setPkId((Object)rateAdjObj.getLong("id"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractRateAdjustTabEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("rateadjust".equals(operateKey) && args.getOperationResult().isSuccess()) {
            BillList ra_loanBillList = (BillList)this.getControl("ra_loanbilllistap");
            ListSelectedRow currentSelectedRowInfo = ra_loanBillList.getCurrentSelectedRowInfo();
            if (currentSelectedRowInfo == null) {
                DynamicObject bizBill = this.getModel().getDataEntity();
                AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
                this.getView().showTipNotification(bizResource.chooseDataIsNull());
                return;
            }
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            if (primaryKeyValue != null && (Long)primaryKeyValue != 0L) {
                DynamicObject cfmLoanBill = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cfm_loanbill"));
                List errorList = CfmRateAdjustHelper.validCanRateAdjustOp((DynamicObject)cfmLoanBill);
                if (CollectionUtils.isEmpty((Collection)errorList) || errorList.size() == 0) {
                    HashMap<String, Object> param = new HashMap<String, Object>(16);
                    param.put("formId", "cfm_rateadjust");
                    param.put("formPrimId", primaryKeyValue);
                    param.put("fromEntityBill", "cfm_loanbill_bond");
                    FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cfm_rateadjust_callback"));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showParameter);
                } else {
                    String str = String.join((CharSequence)",", errorList);
                    this.getView().showMessage(str);
                }
            }
        } else if ("rateadjustop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Long selectedId = this.getModel().getDataEntity().getLong("id");
            QFilter adjustFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("loancontractbill", "=", (Object)selectedId));
            Object[] rateAdjustBills = TmcDataServiceHelper.load((String)"cfm_rateadjustbill", (String)"id,loancontractbill", (QFilter[])new QFilter[]{adjustFilter});
            if (EmptyUtil.isNoEmpty((Object[])rateAdjustBills)) {
                Long rateAdjustId = rateAdjustBills[0].getLong("id");
                HashMap<String, Long> paramMap = new HashMap<String, Long>();
                paramMap.put("selectedId", selectedId);
                paramMap.put("rateAdjustId", rateAdjustId);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u6709\u672a\u5ba1\u6838\u7684\u5229\u7387\u8c03\u6574\u5355\uff0c\u662f\u5426\u8fdb\u884c\u7f16\u8f91\u8be5\u5355\u636e\uff1f", (String)"ContractRateAdjustTabEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_RATEADJUST_CALLBACK"), new HashMap(), JSON.toJSONString(paramMap));
            } else {
                String formId = this.getView().getFormShowParameter().getFormId();
                if (StringUtils.equals((CharSequence)formId, (CharSequence)"cfm_loancontract_bo")) {
                    long openPerpetual = CfmRateAdjustHelper.getLoanBondBillNum((long)selectedId);
                    if (openPerpetual > 0L) {
                        HashMap<String, Long> paramMap = new HashMap<String, Long>();
                        paramMap.put("selectedId", selectedId);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u503a\u5238\u53d1\u884c\u5df2\u8bbe\u7f6e\u5229\u7387\u52a0\u70b9\u6570\uff0c\u8c03\u6574\u751f\u6548\u65e5\u671f\u4ee5\u540e\u7684\u52a0\u70b9\u6570\u5c06\u5931\u6548\u3002", (String)"ContractBaseList_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CALLBACK_OPENPERPETUAL"), new HashMap(), JSON.toJSONString(paramMap));
                    } else {
                        CfmRateAdjustHelper.showRateAdjustForm(null, (Long)selectedId, (IFormView)this.getView());
                    }
                } else {
                    CfmRateAdjustHelper.showRateAdjustForm(null, (Long)selectedId, (IFormView)this.getView());
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String customVaule;
        Map paramMap;
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_RATEADJUST_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            String customVaule2 = messageBoxClosedEvent.getCustomVaule();
            Map paramMap2 = (Map)JSON.parseObject((String)customVaule2, Map.class);
            if (EmptyUtil.isNoEmpty((Object)paramMap2)) {
                Long selectedId = (Long)paramMap2.get("selectedId");
                Long rateAdjustId = (Long)paramMap2.get("rateAdjustId");
                CfmRateAdjustHelper.showRateAdjustForm((Long)rateAdjustId, (Long)selectedId, (IFormView)this.getView());
            }
        } else if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CALLBACK_OPENPERPETUAL") && MessageBoxResult.Yes.equals((Object)res) && EmptyUtil.isNoEmpty((Object)(paramMap = (Map)JSON.parseObject((String)(customVaule = messageBoxClosedEvent.getCustomVaule()), Map.class)))) {
            Long selectedId = (Long)paramMap.get("selectedId");
            CfmRateAdjustHelper.showRateAdjustForm(null, (Long)selectedId, (IFormView)this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("cfm_rateadjust_callback".equals(e.getActionId())) {
            BillList ra_loanBillList = (BillList)this.getControl("ra_loanbilllistap");
            ListSelectedRow currentSelectedRowInfo = ra_loanBillList.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            this.loadRateResetCalList((Long)primaryKeyValue);
        }
    }
}

