/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ContractRepaymentTabEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private static final String[] repayPlan = new String[]{"currency", "repayplan_entry", "repayplan_entry.exrepaymentdate", "repayplan_entry.exdrawamount", "repayplan_entry.repaymentdesc", "repayplan_entry.repaymentmodifier", "repayplan_entry.repaymentmodifytime", "repayplan_entry.erepayamount", "repayplan_entry.enotrepayamount", "repayplan_entry.repaystate"};

    public void registerListener(EventObject e) {
        BillList rpLoanBillList;
        super.registerListener(e);
        this.initControlEvt();
        this.initTabListFilter();
        BillList repaybillList = (BillList)this.getControl("repaymentbilllistap");
        if (repaybillList != null) {
            repaybillList.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((rpLoanBillList = (BillList)this.getControl("rp_loanbilllistap")) != null) {
            rpLoanBillList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTabListFilter();
    }

    private QFilter getContractQFilter() {
        Long contractBillId = (Long)this.getModel().getDataEntity().getPkValue();
        if (EmptyUtil.isEmpty((Long)contractBillId)) {
            return new QFilter("1", "=", (Object)2);
        }
        return new QFilter("sourcebillid", "=", (Object)contractBillId);
    }

    private void initTabListFilter() {
        if (this.getControl("rp_loanbilllistap") != null) {
            BillList rpLoanBillList = (BillList)this.getControl("rp_loanbilllistap");
            rpLoanBillList.addSetFilterListener(evt -> {
                QFilter loanBillFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
                loanBillFilter.and(this.getContractQFilter());
                evt.getQFilters().add(loanBillFilter);
            });
            rpLoanBillList.addBeforePackageDataListener(evt -> {
                DynamicObjectCollection pageDatas = evt.getPageData();
                for (DynamicObject rowData : pageDatas) {
                    if (rowData.getDate("renewalexpiredate") == null) continue;
                    rowData.set("expiredate", (Object)rowData.getDate("renewalexpiredate"));
                }
            });
        }
        if (this.getControl("repaymentbilllistap") != null) {
            BillList repaymentbilllist = (BillList)this.getControl("repaymentbilllistap");
            repaymentbilllist.addSetFilterListener(evt -> {
                Long contractBillId = (Long)this.getModel().getDataEntity().getPkValue();
                QFilter idFilter = EmptyUtil.isEmpty((Long)contractBillId) ? new QFilter("1", "=", (Object)2) : new QFilter("loancontractbill", "=", (Object)contractBillId);
                QFilter repayFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(idFilter);
                evt.getQFilters().add(repayFilter);
            });
        }
    }

    private void initControlEvt() {
        ((Tab)this.getControl("tab_contractinfo")).addTabSelectListener(evt -> {
            BillList rpLoanList;
            String tabKey = evt.getTabKey();
            if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"repayplantab") && EmptyUtil.isEmpty((Collection)(rpLoanList = (BillList)this.getControl("rp_loanbilllistap")).getSelectedRows())) {
                rpLoanList.selectRows(0);
            }
        });
        if (this.getControl("rp_loanbilllistap") != null) {
            ((BillList)this.getControl("rp_loanbilllistap")).addListRowClickListener(new ListRowClickListener(){

                public void listRowClick(ListRowClickEvent evt) {
                    ListSelectedRow row = evt.getCurrentListSelectedRow();
                    if (EmptyUtil.isEmpty((Object)row)) {
                        return;
                    }
                    boolean isChanged = ContractRepaymentTabEdit.this.getModel().getDataChanged();
                    ContractRepaymentTabEdit.this.loadRepayPlanList((Long)row.getPrimaryKeyValue());
                    ContractRepaymentTabEdit.this.getModel().setDataChanged(isChanged);
                }
            });
        }
    }

    private void loadRepayPlanList(Long loanBillId) {
        if (this.getControl("rp_repayplanentry") != null) {
            this.getModel().deleteEntryData("rp_repayplanentry");
            CharSequence[] selectProps = repayPlan;
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProps));
            DynamicObjectCollection repayPlans = loanBill.getDynamicObjectCollection("repayplan_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)repayPlans)) {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("rpl_expectredate", new Object[0]).addField("rpl_loancurrency", new Object[0]).addField("rpl_expectreamount", new Object[0]).addField("rpl_desc", new Object[0]).addField("rpl_modifier", new Object[0]).addField("rpl_modifytime", new Object[0]).addField("rpl_repayamount", new Object[0]).addField("rpl_notrepayamount", new Object[0]).addField("rpl_repaystate", new Object[0]);
                for (DynamicObject repayPlan : repayPlans) {
                    vs.addRow(new Object[]{repayPlan.get("exrepaymentdate"), loanBill.getDynamicObject("currency").getPkValue(), repayPlan.get("exdrawamount"), repayPlan.get("repaymentdesc"), repayPlan.getDynamicObject("repaymentmodifier").getPkValue(), repayPlan.get("repaymentmodifytime"), repayPlan.get("erepayamount"), repayPlan.get("enotrepayamount"), repayPlan.getString("repaystate")});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("rp_repayplanentry", vs);
                model.endInit();
                this.getView().updateView("rp_repayplanentry");
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Object billId;
        String fieldName = evt.getFieldName();
        BillList sourceBill = (BillList)evt.getSource();
        String entityId = sourceBill.getEntityId();
        Object pkId = billId = sourceBill.getFocusRowPkId();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"cfm_repaymentbill") || StringUtils.equals((CharSequence)entityId, (CharSequence)"cim_invest_repaybill") || StringUtils.equals((CharSequence)entityId, (CharSequence)"fl_rentpaybill")) {
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
                FormParameterHelper.showForm((IFormView)this.getView(), (String)FormParameterHelper.getRepayBillFormByBizType((IFormView)this.getView()), (Object)pkId);
            } else {
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"paybill_number")) {
                    String entityName = "cfm_repaymentbill";
                    if (StringUtils.equals((CharSequence)entityId, (CharSequence)"fl_rentpaybill")) {
                        entityName = "fl_rentpaybill";
                    }
                    TmcBotpHelper.showBillParamter((String)entityName, (Long)((Long)billId), (IFormView)this.getView(), (String)"cas_paybill");
                    return;
                }
                if (StringUtils.equals((CharSequence)"recbillno", (CharSequence)fieldName)) {
                    TmcBotpHelper.showBillParamter((String)"cim_invest_repaybill", (Long)((Long)billId), (IFormView)this.getView(), (String)"cas_recbill");
                }
            }
        }
        if ((StringUtils.equals((CharSequence)entityId, (CharSequence)"cfm_loanbill") || StringUtils.equals((CharSequence)entityId, (CharSequence)"cim_invest_loanbill")) && StringUtils.equals((CharSequence)fieldName, (CharSequence)"rp_billno")) {
            FormParameterHelper.showForm((IFormView)this.getView(), (String)FormParameterHelper.getLoanBillFormByBizType((IFormView)this.getView()), (Object)pkId);
        }
    }
}

