/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.common.helper.ContractApplyHelper;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.billversion.AbstractBillVersionTabEdit;

public class LoanContractHistoryPlugin
extends AbstractBillVersionTabEdit {
    private final List<String> hisHeadFields = Arrays.asList("h_id", "h_reason", "h_version", "h_applyid", "h_applycreate", "h_applybillno", "h_creator", "h_createtime");

    protected Map<String, String> getEntryNameAndEntryKey() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("entry_gcontract", "gsrcbillid");
        map.put("project_entry", "e_project");
        return map;
    }

    private void setModifyTabHide(boolean hiden) {
        this.getView().setVisible(Boolean.valueOf(hiden), new String[]{this.getModifyTabName()});
    }

    private String getBillEntityType() {
        if (this.getModel().getDataEntityType().getName().equals("fl_leasecontractbill")) {
            return "fl_leasecontractbill";
        }
        return "cfm_loancontractbill";
    }

    protected void initModifyInfo() {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.setModifyTabHide(false);
            return;
        }
        Long pkId = (Long)this.getModel().getValue("id");
        Object[] historys = BillChangeHistoryHelper.getChangeHistoryByBizId((Long)pkId, (String)this.getBillEntityType());
        if (EmptyUtil.isEmpty((Object[])historys)) {
            this.setModifyTabHide(false);
            return;
        }
        this.setModifyTabHide(true);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(this.getModifyEntryName());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.beginInit();
        List<String> showProps = this.getShowFieldProp();
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>(16);
        for (String showProp : showProps) {
            vs.addField(showProp.contains(".") ? showProp.substring(0, showProp.indexOf(".")) : showProp, new Object[0]);
            String[] split = showProp.split("_");
            maps.put(split[1], showProp);
        }
        for (Object history : historys) {
            ArrayList<Object> addRow = new ArrayList<Object>(16);
            DynamicObject applyBill = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)history);
            for (Map.Entry map : maps.entrySet()) {
                String key = (String)map.getKey();
                String value = (String)map.getValue();
                try {
                    addRow.add(this.hisHeadFields.contains(value) ? history.get(key) : applyBill.get(key));
                }
                catch (Exception e) {}
            }
            vs.addRow(addRow.toArray());
        }
        model.batchCreateNewEntryRow(this.getModifyEntryName(), vs);
        model.endInit();
        this.getView().updateView(this.getModifyEntryName());
        this.getModel().setDataChanged(false);
    }

    protected String getModifyTabName() {
        return "tabpage_history";
    }

    protected String getModifyEntryName() {
        return "history_entry";
    }

    protected List<String> getShowFieldProp() {
        String prefix = "a_";
        String suffix = ".id";
        ArrayList<String> show = new ArrayList<String>(30);
        show.add("h_version");
        show.add("h_id");
        show.add("h_applyid");
        show.add(prefix + "org" + suffix);
        show.add(prefix + "textcreditor");
        show.add(prefix + "currency" + suffix);
        show.add(prefix + "amount");
        show.add(prefix + "startdate");
        show.add(prefix + "enddate");
        show.add(prefix + "creator" + suffix);
        show.add(prefix + "modifier" + suffix);
        show.add(prefix + "modifytime");
        show.add(this.getClickApplyNo());
        return show;
    }

    protected String getClickVersion() {
        return "h_version";
    }

    protected String getClickApplyNo() {
        return "h_applybillno";
    }

    protected List<String> getHiddenButton() {
        return Arrays.asList("bar_save", "bar_submit", "bar_submitandnew", "bar_del", "bar_audit", "bar_track", "bar_print", "bar_modify");
    }

    protected LocaleString getFormTitle() {
        return new LocaleString(ResManager.loadKDString((String)"\u5408\u540c\u5386\u53f2\u7248\u672c\u660e\u7ec6", (String)"LoanContractHistoryPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
    }

    protected String getBizBillInfo() {
        if ("fl_leasecontractbill".equals(this.getBillEntityType())) {
            DynamicObject flLeaseContractBill = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"fl_leasecontractbill");
            return SerializationUtils.serializeToBase64((Object)flLeaseContractBill);
        }
        return SerializationUtils.serializeToBase64((Object)ContractApplyHelper.queryLoanContractBill((Object)this.getModel().getValue("id")));
    }

    protected String getApplyBillEntity() {
        DynamicObject historyObject = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("h_id"), (String)"fcs_changehistory", (String)"applyentity");
        return historyObject.getString("applyentity_id");
    }
}

