/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.DrawWayEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BillSourceEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(LoanBillConvertPlugin.class);
    private final String[] GUARANTEE_USE_PROPS = new String[]{"gcomment", "gcontract", "gcontract.amount", "gcontract.currency", "gratio"};

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = targetExtDataEntitySet.FindByEntityKey(this.getTgtMainType().getName())) {
            DynamicObject convertLoanBillDO = extendedDataEntity.getDataEntity();
            DynamicObject srcBill = convertLoanBillDO.getDynamicObject("loancontractbill");
            convertLoanBillDO.set("startintdate", (Object)LoanBillConvertPlugin.getStartIntDate(convertLoanBillDO, srcBill));
            String loanType = convertLoanBillDO.getString("loantype");
            if (InterestTypeEnum.FLOAT.getValue().equals(convertLoanBillDO.get("interesttype"))) {
                this.validAndSetLoanRate(convertLoanBillDO);
            }
            if (LoanTypeEnum.isBond((String)loanType)) {
                this.dealBondInfo(convertLoanBillDO);
            }
            QFilter contractFilter = new QFilter("loancontractbill", "=", (Object)srcBill.getLong("id"));
            this.validCycleLoan(convertLoanBillDO, srcBill, contractFilter);
            this.callTerm(convertLoanBillDO, srcBill);
            convertLoanBillDO.set("convertdrawamt", (Object)convertLoanBillDO.getBigDecimal("drawamount"));
            String drawWay = convertLoanBillDO.getString("drawway");
            if (StringUtils.equals((CharSequence)drawWay, (CharSequence)DrawWayEnum.STAGE.getValue())) {
                convertLoanBillDO.set("drawamount", null);
                convertLoanBillDO.set("convertdrawamt", null);
            }
            convertLoanBillDO.set("notrepayamount", convertLoanBillDO.get("drawamount"));
            this.dealLoanCacheInfo(convertLoanBillDO);
            this.dealCreditLimitAndSL(convertLoanBillDO, srcBill, loanType);
            this.dealSurety(convertLoanBillDO, srcBill);
            this.resetRateResetCycleDate(convertLoanBillDO, srcBill);
            this.pushFromDrawPlan(convertLoanBillDO, srcBill);
        }
    }

    private void dealSurety(DynamicObject convertLoanBill, DynamicObject srcBill) {
        DynamicObject suretyBill = SuretyHelper.loadSuretyBillByDebit((Long)srcBill.getLong("id"));
        if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill)) {
            DynamicObject row = convertLoanBill.getDynamicObjectCollection("entry_surety").addNew();
            row.set("suretybill", (Object)suretyBill);
            row.set("suretyfinorg", suretyBill.get("finorginfo"));
            row.set("suretyfinorgother", suretyBill.get("finorgother"));
            row.set("suretyinvestorgtype", suretyBill.get("investorgtype"));
            row.set("suretycurrency", suretyBill.get("currency"));
            row.set("suretyamount", (Object)suretyBill.getBigDecimal("amount"));
            row.set("suretyaccount", suretyBill.get("settleaccount"));
            row.set("suretyintdate", (Object)suretyBill.getDate("intdate"));
            row.set("suretyterm", (Object)suretyBill.getString("term"));
            row.set("suretyexpiredate", (Object)suretyBill.getDate("expiredate"));
            row.set("suretysource", (Object)BillSourceEnum.HAND.getValue());
        }
    }

    private static String getSrcBillType(String entityName, Long bizId) {
        if (StringUtils.equals((CharSequence)"cfm_loancontractbill", (CharSequence)entityName)) {
            DynamicObject contract = QueryServiceHelper.queryOne((String)"cfm_loancontractbill", (String)"loantype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizId)});
            String loanType = contract.getString("loantype");
            if (LoanTypeEnum.BANKLOAN.getValue().equals(loanType) || LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
                return "cfm_loancontract_bl_l";
            }
            if (LoanTypeEnum.LINKLEND.getValue().equals(loanType) || LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType)) {
                return "cfm_loancontract_ic_l";
            }
        }
        return entityName;
    }

    private void dealBondInfo(DynamicObject loanBill) {
        DynamicObject factory = loanBill.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)factory)) {
            String productBasis = factory.getString("basis");
            String initBasis = loanBill.getString("basis");
            if (EmptyUtil.isNoEmpty((String)productBasis) && !productBasis.equals(initBasis)) {
                loanBill.set("basis", (Object)productBasis);
            }
            int anInt = factory.getInt("rateresetdays");
            if (EmptyUtil.isEmpty((Integer)loanBill.getInt("rateresetdays")) && EmptyUtil.isNoEmpty((Integer)anInt)) {
                loanBill.set("rateresetdays", (Object)anInt);
            }
        }
    }

    private void resetRateResetCycleDate(DynamicObject loanBillDO, DynamicObject contractBillF7) {
        DynamicObject contractBill = TmcDataServiceHelper.loadSingle((Object)contractBillF7.getPkValue(), (String)"cfm_loancontractbill", (String)"workcalendar,productfactory");
        DynamicObjectCollection workCalendar = contractBill.getDynamicObjectCollection("workcalendar");
        Date startDate = loanBillDO.getDate("startintdate");
        boolean isSofr = LoanBillHelper.isSofr((DynamicObject)loanBillDO);
        if (!isSofr || EmptyUtil.isEmpty((DynamicObjectCollection)workCalendar) || EmptyUtil.isEmpty((Object)startDate)) {
            return;
        }
        int resetDays = loanBillDO.getInt("rateresetdays");
        if (EmptyUtil.isNoEmpty((Integer)resetDays)) {
            Date rateResetCycleDate = CfmBillCommonHelper.getLastDayByWorkCalendar((DynamicObjectCollection)workCalendar, (int)resetDays, (Date)startDate, (int)1);
            logger.info("HEAD_RATEADJUSTDATE={}", (Object)rateResetCycleDate);
            loanBillDO.set("rateadjustdate", (Object)rateResetCycleDate);
        }
    }

    private void dealCreditLimitAndSL(DynamicObject convertLoanBillDO, DynamicObject srcBill, String loanType) {
        DynamicObject conBill;
        DynamicObject applyBill;
        DynamicObject creditLimit = convertLoanBillDO.getDynamicObject("creditlimit");
        convertLoanBillDO.set("creditlimit", null);
        String creditorType = convertLoanBillDO.getString("creditortype");
        if (creditLimit == null && CfmContractBillHelper.creditLoanType((String)loanType, (String)creditorType) && EmptyUtil.isNoEmpty((DynamicObject)(applyBill = (conBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)"loanapply", (QFilter[])new QFilter[]{new QFilter("id", "=", srcBill.getPkValue())})).getDynamicObject("loanapply")))) {
            applyBill = TmcDataServiceHelper.loadSingle((Object)applyBill.getLong("id"), (String)"cfm_loan_apply", (String)"id,creditlimit");
            DynamicObject applyCreditLimit = applyBill.getDynamicObject("creditlimit");
            convertLoanBillDO.set("creditlimit", (Object)applyCreditLimit);
            this.creditLimitLinkGuarantee(convertLoanBillDO, srcBill, applyCreditLimit);
        }
        if (BizTypeEnum.SL.getValue().equals(srcBill.get("loantype"))) {
            srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBill.getPkValue(), (String)"cfm_loancontractbill");
            DynamicObjectCollection loanBillEntry = convertLoanBillDO.getDynamicObjectCollection("banksyndicate_entry");
            DynamicObjectCollection entrys = srcBill.getDynamicObjectCollection("banksyndicate_entry");
            long[] ids = DB.genLongIds((String)"", (int)entrys.size());
            int i = 0;
            for (DynamicObject contractEntryRow : entrys) {
                DynamicObject loanBillEntryRow = loanBillEntry.addNew();
                loanBillEntryRow.set("e_bankrole", contractEntryRow.get("e_bankrole"));
                loanBillEntryRow.set("e_bank", contractEntryRow.get("e_bank"));
                loanBillEntryRow.set("e_contractamount", (Object)contractEntryRow.getBigDecimal("e_shareamount"));
                loanBillEntryRow.set("e_bankdescription", contractEntryRow.get("e_bankdescription"));
                loanBillEntryRow.set("id", (Object)ids[i]);
                ++i;
            }
        }
    }

    private void dealLoanCacheInfo(DynamicObject convertLoanBillDO) {
        IAppCache iAppCache = TmcAppCache.get((String)"cfm", (String)"initbill", (String)"init");
        Map loanBillInfo = (Map)iAppCache.get("tmc_cfm_init_loanbill:" + convertLoanBillDO.getString("sourcebillid"), Map.class);
        if (loanBillInfo != null && loanBillInfo.size() > 0) {
            String loanNo;
            String loanId = (String)loanBillInfo.get("loanBillId");
            if (!EmptyUtil.isEmpty((String)loanId) && !"0".equals(loanId)) {
                convertLoanBillDO.set("id", (Object)Long.valueOf(loanId));
            }
            if (!EmptyUtil.isEmpty((String)(loanNo = (String)loanBillInfo.get("loanBillNo")))) {
                convertLoanBillDO.set("billno", (Object)loanNo);
            }
            iAppCache.remove("tmc_cfm_init_loanbill:" + convertLoanBillDO.getString("sourcebillid"));
        }
    }

    private void validCycleLoan(DynamicObject convertLoanBillDO, DynamicObject srcBill, QFilter contractFilter) {
        DynamicObject ifmContract = QueryServiceHelper.queryOne((String)"ifm_loancontractbill", (String)"id, iscycleloan", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcBill.getLong("id"))});
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(convertLoanBillDO.getString("datasource"));
        if (!ifmContract.getBoolean("iscycleloan")) {
            QFilter loanExistFilter = new QFilter("drawway", "=", (Object)DrawWayEnum.ONCE.getValue()).and(contractFilter);
            DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,loancontractbill.id", (QFilter[])new QFilter[]{loanExistFilter});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanBills)) {
                throw new KDBizException(bizResource.getCbOnlyOnceLoan());
            }
        } else {
            QFilter loanExistFilter = new QFilter("drawway", "=", (Object)DrawWayEnum.ONCE.getValue()).and(contractFilter);
            QFilter notCloseOut = new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
            loanExistFilter.and(notCloseOut);
            if (TmcDataServiceHelper.exists((String)"cfm_loanbill", (QFilter[])new QFilter[]{loanExistFilter})) {
                throw new KDBizException(bizResource.getCbOnlyOnceLoan());
            }
        }
    }

    private void validAndSetLoanRate(DynamicObject convertLoanBillDO) {
        Date startIntDate = convertLoanBillDO.getDate("startintdate");
        BigDecimal loanDateYearRate = CfmRateAdjustHelper.getLoanDateYearRate((DynamicObject)convertLoanBillDO, (Date)startIntDate);
        if (EmptyUtil.isEmpty((BigDecimal)loanDateYearRate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"LoanBillConvertPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        convertLoanBillDO.set("loanrate", (Object)loanDateYearRate);
    }

    private void callTerm(DynamicObject loanBill, DynamicObject loanContractBill) {
        Date expireDate = loanBill.getDate("expiredate");
        Date bizDate = loanBill.getDate("startintdate");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)expireDate)) {
            DynamicObjectCollection workCalendars = loanContractBill.getDynamicObjectCollection("workcalendar");
            DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
            expireDate = EmptyUtil.isNoEmpty((DynamicObject)productFactory) ? TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)expireDate, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)productFactory.getString("loanexpireadjustrule"))) : TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)expireDate, (AdjustMethodEnum)AdjustMethodEnum.no_adjust);
            loanBill.set("term", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)expireDate));
        }
    }

    public static Date getStartIntDate(DynamicObject loanBill, DynamicObject loanContract) {
        DynamicObject factory = loanBill.getDynamicObject("productfactory");
        Date effectDate = loanBill.getDate("startintdate");
        if (EmptyUtil.isNoEmpty((DynamicObject)factory)) {
            String effectDateRule;
            switch (effectDateRule = factory.getString("intdateeffectrule")) {
                case "contracteffectdate": {
                    effectDate = loanContract.getDate("startdate");
                    break;
                }
                case "iousintdate": 
                case "loanissuedate": {
                    effectDate = loanBill.getDate("bizdate");
                }
            }
        }
        return effectDate;
    }

    private void creditLimitLinkGuarantee(DynamicObject convertLoanBillDO, DynamicObject srcBill, DynamicObject applyCreditLimit) {
        block4: {
            Object[] gcUseCreditLimitCol;
            if (!EmptyUtil.isNoEmpty((DynamicObject)applyCreditLimit) || !EmptyUtil.isNoEmpty((Object[])(gcUseCreditLimitCol = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", this.GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", applyCreditLimit.getPkValue())}, (String)"id")))) break block4;
            DynamicObjectCollection gcUseContractBillCol = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)"gcontract", (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", srcBill.getPkValue())}, (String)"id");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)gcUseContractBillCol)) {
                Set ids = gcUseContractBillCol.stream().map(o -> o.get("gcontract")).collect(Collectors.toSet());
                List guaranteeUseBills = Arrays.stream(gcUseCreditLimitCol).filter(o -> !ids.contains(o.getDynamicObject("gcontract").getPkValue())).collect(Collectors.toList());
                for (DynamicObject guaranteeUseBill : guaranteeUseBills) {
                    this.createNewEntryRow(convertLoanBillDO, guaranteeUseBill);
                }
            } else {
                for (Object guaranteeUseBill : gcUseCreditLimitCol) {
                    this.createNewEntryRow(convertLoanBillDO, (DynamicObject)guaranteeUseBill);
                }
            }
        }
    }

    private void createNewEntryRow(DynamicObject convertLoanBill, DynamicObject guaranteeUseBill) {
        BigDecimal rate;
        boolean diffCurrency;
        DynamicObject obj = convertLoanBill.getDynamicObjectCollection("entry_gcontract").addNew();
        obj.set("gcontract", guaranteeUseBill.get("gcontract"));
        BigDecimal amount = convertLoanBill.getBigDecimal("drawamount");
        obj.set("gratio", guaranteeUseBill.get("gratio"));
        obj.set("gcontractamount", guaranteeUseBill.get("gcontract.amount"));
        obj.set("gcontractcurrency", guaranteeUseBill.get("gcontract.currency"));
        obj.set("gamount", (Object)amount.multiply(guaranteeUseBill.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED));
        obj.set("gcomment", guaranteeUseBill.get("gcomment"));
        DynamicObject bizCurrency = convertLoanBill.getDynamicObject("currency");
        DynamicObject guaranteeUseCurrency = guaranteeUseBill.getDynamicObject("gcontract.currency");
        boolean bl = diffCurrency = bizCurrency != null && !guaranteeUseCurrency.getPkValue().equals(bizCurrency.getPkValue());
        if (diffCurrency) {
            DynamicObject company = convertLoanBill.getDynamicObject("org");
            rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCurrency.getLong("id"), (long)guaranteeUseCurrency.getLong("id"), (long)company.getLong("id"), (Date)DateUtils.getCurrentDate());
        } else {
            rate = BigDecimal.ONE;
        }
        obj.set("gexchrate", (Object)rate);
        if (GuaranteeUseHelper.getMultiCreditorFlag((String)convertLoanBill.getDataEntityType().getName())) {
            obj.set("gcreditortype", (Object)convertLoanBill.getString("creditortype"));
            obj.set("gcreditor", (Object)convertLoanBill.getLong("creditor"));
            obj.set("gcreditortext", (Object)convertLoanBill.getString("textcreditor"));
        }
    }

    private void pushFromDrawPlan(DynamicObject loanBill, DynamicObject contractBill) {
        DynamicObjectCollection drawPlans = (contractBill = TmcDataServiceHelper.loadSingleFromCache((Object)contractBill.getPkValue(), (String)"cfm_loancontractbill")).getDynamicObjectCollection("drawdownplan_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)drawPlans)) {
            return;
        }
        Optional<DynamicObject> firstPlan = drawPlans.stream().filter(v -> "0".equals(v.getString("e_drawstate"))).findFirst();
        if (firstPlan.isPresent()) {
            DynamicObject plan = firstPlan.get();
            loanBill.set("bizdate", (Object)plan.getDate("e_plandrawdate"));
            loanBill.set("drawamount", (Object)plan.getBigDecimal("e_plandrawamt"));
            loanBill.set("convertrate", (Object)BigDecimal.ONE);
            loanBill.set("convertdrawamt", (Object)plan.getBigDecimal("e_plandrawamt"));
            String proName = DataSourceEnum.isInvest((String)loanBill.getString("datasource")) ? "loaneracctbank" : "accountbank";
            loanBill.set(proName, (Object)plan.getDynamicObject("e_drawacctbank"));
            loanBill.set("notdrawamount", (Object)contractBill.getBigDecimal("notdrawamount"));
            if (EmptyUtil.isEmpty((Object)loanBill.getDate("rateadjustdate")) && InterestTypeEnum.isFloat((String)loanBill.getString("interesttype")) && RateAdjustStyleEnum.isCycle((String)loanBill.getString("rateadjuststyle"))) {
                loanBill.set("rateadjustdate", (Object)plan.getDate("e_plandrawdate"));
            }
            this.setShareAmount(loanBill);
        }
    }

    private void setShareAmount(DynamicObject loanBill) {
        if (!BizTypeEnum.isSL((String)loanBill.getString("loantype"))) {
            return;
        }
        DynamicObjectCollection loanBillEntrys = loanBill.getDynamicObjectCollection("banksyndicate_entry");
        BigDecimal notDrawAmount = loanBill.getBigDecimal("notdrawamount");
        if (EmptyUtil.isEmpty((BigDecimal)notDrawAmount)) {
            return;
        }
        Map slBankNotdrawamount = LoanBillHelper.getSlBankNotdrawamount((long)loanBill.getLong("sourcebillid"), (long)0L);
        BigDecimal drawAmount = loanBill.getBigDecimal("drawamount");
        BigDecimal ratio = drawAmount.divide(notDrawAmount, 18, 4);
        DynamicObject currecny = loanBill.getDynamicObject("currency");
        int amtPrecision = currecny != null ? currecny.getInt("amtprecision") : 2;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject loanBillEntryRow : loanBillEntrys) {
            loanBillEntryRow.set("e_bankcreditlimit", null);
            loanBillEntryRow.set("e_bankcreditcurrency", null);
            loanBillEntryRow.set("e_bankcreditamt", (Object)BigDecimal.ZERO);
            DynamicObject bank = loanBillEntryRow.getDynamicObject("e_bank");
            BigDecimal bankNotDrawamount = slBankNotdrawamount.getOrDefault(bank.getLong("id"), BigDecimal.ZERO);
            loanBillEntryRow.set("e_notdrawamount", (Object)bankNotDrawamount);
            if (notDrawAmount.compareTo(bankNotDrawamount) == 0) {
                loanBillEntryRow.set("e_shareamount", (Object)drawAmount);
                totalAmount = totalAmount.add(drawAmount);
                continue;
            }
            BigDecimal shareAmount = ratio.multiply(bankNotDrawamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            loanBillEntryRow.set("e_shareamount", (Object)shareAmount);
            totalAmount = totalAmount.add(shareAmount);
        }
        BigDecimal subAmount = drawAmount.subtract(totalAmount);
        DynamicObject mbEntry = loanBillEntrys.stream().filter(o -> "MB".equals(o.getString("e_bankrole"))).findFirst().orElseGet(null);
        if (mbEntry != null) {
            BigDecimal mbAmount = mbEntry.getBigDecimal("e_notdrawamount");
            BigDecimal shareAmt = mbEntry.getBigDecimal("e_shareamount").add(subAmount);
            if (mbAmount.compareTo(BigDecimal.ZERO) > 0 && mbAmount.compareTo(shareAmt) > 0) {
                mbEntry.set("e_shareamount", (Object)shareAmt);
            } else {
                this.setScaleAmount(loanBillEntrys, subAmount);
            }
        }
    }

    private void setScaleAmount(DynamicObjectCollection loanBillEntrys, BigDecimal subAmount) {
        for (DynamicObject loanBillEntry : loanBillEntrys) {
            if (EmptyUtil.isEmpty((BigDecimal)subAmount)) break;
            if ("MB".equals(loanBillEntry.getString("e_bankrole"))) continue;
            BigDecimal notAmount = loanBillEntry.getBigDecimal("e_notdrawamount");
            BigDecimal shareAmount = loanBillEntry.getBigDecimal("e_shareamount");
            BigDecimal eAmount = notAmount.subtract(shareAmount);
            if (subAmount.compareTo(BigDecimal.ZERO) > 0 && eAmount.compareTo(subAmount) < 0) {
                subAmount = subAmount.subtract(eAmount);
                loanBillEntry.set("e_shareamount", (Object)shareAmount.add(eAmount));
                continue;
            }
            loanBillEntry.set("e_shareamount", (Object)shareAmount.add(subAmount));
            break;
        }
    }
}

