/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.drawapply;

import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class DrawApplyBillList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("queryloanbill".equals(opKey) && args.getOperationResult().isSuccess()) {
            Long selectedId = this.getSelectedId();
            if (EmptyUtil.isNoEmpty((Long)selectedId)) {
                DynamicObject applyBill = TmcDataServiceHelper.loadSingle((Object)selectedId, (String)"cfm_draw_apply", (String)"id, billstatus");
                this.queryLoanBill(applyBill);
            }
        } else if (("audit".equals(opKey) || "push2loanbill".equals(opKey)) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void queryLoanBill(DynamicObject applyBill) {
        if (!BillStatusEnum.AUDIT.getValue().equals(applyBill.getString("billstatus"))) {
            this.getView().showTipNotification(CfmFormResourceEnum.DrawApplyBillList_1.loadKDString());
            return;
        }
        QFilter applyFilter = new QFilter("drawapplybill", "=", applyBill.getPkValue());
        DynamicObject loanBill = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"id, loantype", (QFilter[])applyFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            this.getView().showTipNotification(CfmFormResourceEnum.DrawApplyBillList_2.loadKDString());
            return;
        }
        this.openLoanBill(loanBill);
    }

    private void openLoanBill(DynamicObject loanBill) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)loanBill.getLong("id"));
        showParameter.setFormId(this.getFormId(loanBill));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getFormId(DynamicObject loanBill) {
        String loanType = loanBill.getString("loantype");
        String formId = "cfm_loanbill_b_l";
        if (LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) || LoanTypeEnum.LINKLEND.getValue().equals(loanType)) {
            formId = "cfm_loanbill_e_l";
        }
        return formId;
    }
}

