/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.extendapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExtendApplyBillEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(ExtendApplyBillEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid loans = (EntryGrid)this.getControl("loans");
        if (loans != null) {
            loans.addHyperClickListener((HyperLinkClickListener)this);
        }
        BasedataEdit contractBillF7 = (BasedataEdit)this.getControl("loancontractbill");
        contractBillF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", null);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName;
        switch (propName = args.getProperty().getName()) {
            case "loancontractbill": {
                this.contractF7Evt(args);
            }
        }
    }

    private void contractF7Evt(BeforeF7SelectEvent evt) {
        DynamicObject[] extConBills;
        Object[] contractExtIds;
        List<String> contractStatus = Arrays.asList(LoanContractStatusEnum.REGISTERED.getValue(), LoanContractStatusEnum.EXECUTING.getValue());
        QFilter comFilter = new QFilter("contractstatus", "in", contractStatus).and("isnofixedterm", "=", (Object)"0");
        QFilter extFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cfm_loancontractbill", (String)"47150e89000000ac");
        QFilter permQfilter = new QFilter("org.id", "in", (Object)comIdList);
        extFilter.and(permQfilter);
        comFilter.and(permQfilter);
        Object pkId = this.getModel().getValue("id");
        if (EmptyUtil.isNoEmpty((Object)pkId)) {
            extFilter.and("id", "!=", pkId);
        }
        if ("cfm_extendapplybill".equals(this.getModel().getDataEntityType().getName())) {
            comFilter.and("loantype", "in", Arrays.asList(LoanTypeEnum.BANKLOAN.getValue(), LoanTypeEnum.BANKSLOAN.getValue(), LoanTypeEnum.LINKLEND.getValue(), LoanTypeEnum.ENTRUSTLOAN.getValue())).and(new QFilter("creditortype", "!=", (Object)" ").or(new QFilter("creditortype", "!=", (Object)"")));
        }
        QFilter productQfilter = new QFilter("productfactory", "<=", (Object)0).or(new QFilter("productfactory", ">", (Object)0).and("productfactory.iscandefer", "=", (Object)true));
        comFilter.and(productQfilter);
        DynamicObject[] applyBills = TmcDataServiceHelper.load((String)"cfm_extendapplybill", (String)"id,loancontractbill", (QFilter[])extFilter.toArray());
        Object[] contractIds = (Long[])Arrays.stream(applyBills).map(o -> o.getDynamicObject("loancontractbill").getLong("id")).toArray(Long[]::new);
        if (EmptyUtil.isNoEmpty((Object[])contractIds)) {
            comFilter.and("id", "not in", (Object)contractIds);
        }
        if (EmptyUtil.isNoEmpty((Object[])(contractExtIds = (Long[])Arrays.stream(extConBills = TmcDataServiceHelper.load((String)"cfm_contractextendbill", (String)"id,loancontractbill,productfactory,renewalnum", (QFilter[])extFilter.toArray())).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("loancontractbill"))).map(o -> o.getDynamicObject("loancontractbill").getLong("id")).toArray(Long[]::new)))) {
            comFilter.and("id", "not in", (Object)contractExtIds);
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        logger.info("comFilter\u8fc7\u6ee4\u6761\u4ef6\u4e3a" + comFilter);
        sp.getListFilterParameter().getQFilters().add(comFilter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit bizdate = (DateEdit)this.getControl("applydate");
        bizdate.setMaxDate(DateUtils.getCurrentDate());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "loancontractbill": {
                this.loanContractBillchg((DynamicObject)newVal);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "renewalexpiredate": {
                this.renewalExpireDateChg(e, key, value);
                break;
            }
            case "bizdate": {
                this.bizDateChg(e, key, value);
                break;
            }
        }
    }

    private void renewalExpireDateChg(BeforeFieldPostBackEvent e, String key, Object value) {
        Long contractId = ((DynamicObject)this.getModel().getValue("loancontractbill")).getLong("id");
        if (EmptyUtil.isEmpty((Long)contractId)) {
            this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getEbContractbillNotNull());
            e.setCancel(true);
            this.getView().updateView(key);
            return;
        }
        if (value == null) {
            return;
        }
        String dfmtStr = ((DateEdit)this.getControl("renewalexpiredate")).getFormatString();
        Date renewalExpireDate = DateUtils.stringToDate((String)value.toString(), (String)dfmtStr);
        if (renewalExpireDate == null) {
            return;
        }
        Date endDate = (Date)this.getModel().getValue("prevrenewalexpiredate");
        int diffDays = DateUtils.getDiffDays((Date)endDate, (Date)renewalExpireDate) - 1;
        if (diffDays < 0) {
            this.getView().showTipNotification(String.format(new BizResourceFactory().getBizResource("").getEbExpiredateMin(), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    private void bizDateChg(BeforeFieldPostBackEvent e, String key, Object value) {
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        Long contractId = ((DynamicObject)this.getModel().getValue("loancontractbill")).getLong("id");
        if (EmptyUtil.isEmpty((Long)contractId)) {
            this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getEbContractbillNotNull());
            e.setCancel(true);
            this.getView().updateView(key);
            return;
        }
        String fmtStr = ((DateEdit)this.getControl("bizdate")).getFormatString();
        Date bizDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        DynamicObject contractF7 = (DynamicObject)this.getModel().getValue("loancontractbill");
        Date startdate = contractF7.getDate("startdate");
        Date endDate = (Date)this.getModel().getValue("prevrenewalexpiredate");
        int sdiffDays = DateUtils.getDiffDays((Date)startdate, (Date)bizDate) - 1;
        int ediffDays = DateUtils.getDiffDays((Date)endDate, (Date)bizDate) - 1;
        if (sdiffDays < 0 || ediffDays > 0) {
            this.getView().showTipNotification(String.format(new BizResourceFactory().getBizResource("").getEbBizDateOut(), DateUtils.formatString((Date)startdate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    private void loanContractBillchg(DynamicObject contractBillF7) {
        if (EmptyUtil.isNoEmpty((DynamicObject)contractBillF7)) {
            this.fillContractInfo(contractBillF7);
            Object[] loanBills = this.getLoanBills(contractBillF7);
            if (EmptyUtil.isEmpty((Object[])loanBills)) {
                return;
            }
            List loanBillLists = Arrays.stream(loanBills).filter(o -> o.getBigDecimal("notrepayamount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(loanBillLists)) {
                ArrayList billList = new ArrayList(loanBillLists.size());
                for (DynamicObject loanBill : loanBillLists) {
                    HashMap<String, Object> bill = new HashMap<String, Object>(loanBills.length);
                    Date beforExtLoanDate = loanBill.getDate("expiredate");
                    Date afterExtDate = loanBill.getDate("renewalexpiredate");
                    if (EmptyUtil.isNoEmpty((Object)afterExtDate)) {
                        beforExtLoanDate = afterExtDate;
                    }
                    bill.put("e_loanbill", loanBill.getLong("id"));
                    bill.put("e_drawamount", loanBill.get("drawamount"));
                    bill.put("e_repayamount", loanBill.get("repayamount"));
                    bill.put("e_notrepayamount", loanBill.get("notrepayamount"));
                    bill.put("e_extendamount", loanBill.get("drawamount"));
                    bill.put("e_prevrenewalexpiredate", beforExtLoanDate);
                    billList.add(bill);
                }
                TmcViewInputHelper.batchFillEntity((String)"loans", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), billList);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u4e0b,\u6240\u6709\u7684\u63d0\u6b3e\u5df2\u7ecf\u7ed3\u6e05,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RepayApplyBillEdit_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getModel().setValue("org", null);
            this.getModel().setValue("currency", null);
            this.getModel().setValue("amount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("drawamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("notrepayamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("isadjustinterestrate", (Object)false);
            this.getModel().setValue("prevrenewalexpiredate", null);
            this.getModel().setValue("renewalexpiredate", null);
            this.getModel().setValue("bizdate", null);
            this.getModel().setValue("referencerate", null);
            this.getModel().setValue("ratesign", null);
            this.getModel().setValue("ratefloatpoint", (Object)BigDecimal.ZERO);
            this.getModel().setValue("rateadjuststyle", null);
            this.getModel().setValue("rateadjustcycletype", null);
            this.getModel().setValue("rateadjustcycle", null);
            this.getModel().setValue("productfactory", null);
            this.getModel().setValue("renewalinterestrate", (Object)BigDecimal.ZERO);
            this.getModel().deleteEntryData("loans");
        }
    }

    private void fillContractInfo(DynamicObject contractBillF7) {
        this.getModel().setValue("org", contractBillF7.getDynamicObject("org").getPkValue());
        this.getModel().setValue("currency", contractBillF7.getDynamicObject("currency").getPkValue());
        this.getModel().setValue("loantype", (Object)contractBillF7.getString("loantype"));
        DynamicObject productFactory = contractBillF7.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            this.getModel().setValue("productfactory", productFactory.getPkValue());
        }
        this.getModel().setValue("amount", (Object)contractBillF7.getBigDecimal("amount"));
        this.getModel().setValue("drawamount", (Object)contractBillF7.getBigDecimal("drawamount"));
        this.getModel().setValue("notrepayamount", (Object)contractBillF7.getBigDecimal("notrepayamount"));
        Date beforeExtDate = this.getBeforeExtDate(contractBillF7);
        this.getModel().setValue("prevrenewalexpiredate", (Object)beforeExtDate);
        this.getModel().setValue("renewalexpiredate", (Object)beforeExtDate);
        String interestType = contractBillF7.getString("interesttype");
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            this.getModel().setValue("referencerate", contractBillF7.getDynamicObject("referencerate").getPkValue());
            this.getModel().setValue("ratesign", contractBillF7.get("ratesign"));
            this.getModel().setValue("ratefloatpoint", contractBillF7.get("ratefloatpoint"));
            this.getModel().setValue("rateadjuststyle", contractBillF7.get("rateadjuststyle"));
            this.getModel().setValue("rateadjustcycletype", contractBillF7.get("rateadjustcycletype"));
            this.getModel().setValue("rateadjustcycle", contractBillF7.get("rateadjustcycle"));
        } else {
            this.getModel().setValue("renewalinterestrate", contractBillF7.get("interestrate"));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("e_loanbill".equals(fieldName)) {
            this.hyper2LoanBill(evt);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        String opKey = op.getOperateKey();
        if ("trace2extbill".equals(opKey) && operationResult.isSuccess()) {
            CfmBillCommonHelper.trace2RepayExtendBill((DynamicObject)this.getModel().getDataEntity(), (IFormView)this.getView(), (String)"extend");
        }
    }

    private void hyper2LoanBill(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("loans", rowIndex);
            DynamicObject loanBill = entryRowEntity.getDynamicObject("e_loanbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(FormParameterHelper.getLoanBillFormByBizType((IFormView)this.getView()));
                parameter.setPkId((Object)loanBill.getLong("id"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RepayApplyBillEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Date getBeforeExtDate(DynamicObject contractBillF7) {
        Date reNewalExpiredate = contractBillF7.getDate("renewalexpiredate");
        Date beforeExtDate = contractBillF7.getDate("enddate");
        if (EmptyUtil.isNoEmpty((Object)reNewalExpiredate)) {
            beforeExtDate = reNewalExpiredate;
        }
        return beforeExtDate;
    }

    private DynamicObject[] getLoanBills(DynamicObject contractBillF7) {
        QFilter filter = new QFilter("loancontractbill.id", "=", contractBillF7.getPkValue()).and(new QFilter("drawtype", "in", Arrays.asList(DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue())));
        String selects = "id,drawamount,repayamount,notrepayamount,loantype,expiredate,renewalexpiredate";
        return TmcDataServiceHelper.load((String)"cfm_loanbill", (String)selects, (QFilter[])filter.toArray());
    }
}

