/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.extendbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.RateHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ExtendBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static String[] LOANBILL_PROPS = new String[]{"billno", "currency.id", "drawamount", "amount", "bizdate", "loanrate", "expiredate", "repayamount", "renewalexpiredate", "notrepayamount", "interesttype", "referencerate", "ratesign", "ratefloatpoint", "loantype", "rateadjuststyle"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Toolbar)this.getControl("drawentry_toolbar")).addItemClickListener((ItemClickListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl("referencerate");
        BasedataEdit entry_lreferencerate = (BasedataEdit)this.getControl("lreferencerate");
        if (control != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (entry_lreferencerate != null) {
            entry_lreferencerate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", null);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadLoanBillOnSaveStatus();
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if (value != null && this.hasSourceBillId(e, key)) {
            switch (key) {
                case "renewalexpiredate": {
                    this.renewalExpireDateChg(e, key, value);
                    break;
                }
                case "bizdate": {
                    this.bizDateChg(e, key, value);
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "repaymentsc": {
                IDataModel model = this.getModel();
                DynamicObject loanbill_entry = (DynamicObject)model.getEntryEntity("loanbilllist").get(model.getEntryCurrentRowIndex("loanbilllist"));
                BillShowParameter repaymentscParam = new BillShowParameter();
                repaymentscParam.setPkId((Object)loanbill_entry.getLong("drawbillid"));
                String billFormId = this.getView().getFormShowParameter().getFormId();
                if ("cim_invest_extendbill".equals(billFormId)) {
                    repaymentscParam.setFormId("cim_invest_loanbil_plan");
                } else {
                    repaymentscParam.setFormId("cfm_loadbill_view");
                }
                repaymentscParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                repaymentscParam.setBillStatus(BillOperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)repaymentscParam);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("unsubmit".equals(opKey) && afterDoOperationEventArgs.getOperationResult().getValidateResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void renewalExpireDateChg(BeforeFieldPostBackEvent e, String key, Object value) {
        String dfmtStr = ((DateEdit)this.getControl("renewalexpiredate")).getFormatString();
        Date renewalExpireDate = DateUtils.stringToDate((String)value.toString(), (String)dfmtStr);
        if (renewalExpireDate == null) {
            return;
        }
        Date endDate = (Date)this.getModel().getValue("prevrenewalexpiredate");
        int diffDays = DateUtils.getDiffDays((Date)endDate, (Date)renewalExpireDate) - 1;
        if (diffDays < 0) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource("");
            String format = String.format(bizResource.getEbExpiredateMin(), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
            if ("cfm_contractextend_bo".equals(this.getView().getEntityId())) {
                format = String.format(bizResource.getEbBoExpiredateMin(), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
            }
            this.getView().showTipNotification(format);
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    private void bizDateChg(BeforeFieldPostBackEvent e, String key, Object value) {
        String fmtStr = ((DateEdit)this.getControl("bizdate")).getFormatString();
        Date bizDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("prevrenewalexpiredate");
        int sdiffDays = DateUtils.getDiffDays((Date)startdate, (Date)bizDate) - 1;
        int ediffDays = DateUtils.getDiffDays((Date)endDate, (Date)bizDate) - 1;
        if (sdiffDays < 0 || ediffDays > 0) {
            this.getView().showTipNotification(String.format(new BizResourceFactory().getBizResource("").getEbBizDateOut(), DateUtils.formatString((Date)startdate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    private boolean hasSourceBillId(BeforeFieldPostBackEvent e, String key) {
        Long sourcebillid = (Long)this.getModel().getValue("sourcebillid");
        if (EmptyUtil.isEmpty((Long)sourcebillid)) {
            this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getEbContractbillNotNull());
            e.setCancel(true);
            this.getView().updateView(key);
            return false;
        }
        return true;
    }

    private void loadLoanBillOnSaveStatus() {
        Long pkId = (Long)this.getModel().getValue("id");
        if (EmptyUtil.isEmpty((Long)pkId)) {
            ((Container)this.getControl("fs_baseinfo")).setCollapse(false);
        } else {
            ((Container)this.getControl("fs_baseinfo")).setCollapse(true);
        }
        Long contractId = (Long)this.getModel().getValue("sourcebillid");
        if (EmptyUtil.isEmpty((Long)contractId)) {
            return;
        }
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("extendapplyf7"))) {
            return;
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((CharSequence)BillStatusEnum.SAVE.getValue(), (CharSequence)billStatus)) {
            return;
        }
        if (this.getControl("loanbilllist") != null) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("loanbilllist");
            HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject entry : entrys) {
                entryMap.put(entry.getLong("drawbillid"), entry);
            }
            boolean isChanged = this.getModel().getDataChanged();
            this.getModel().deleteEntryData("loanbilllist");
            this.getModel().setDataChanged(isChanged);
            Object[] loanBills = this.getLoanBills(contractId);
            if (EmptyUtil.isNoEmpty((Object[])loanBills)) {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("drawbillid", new Object[0]).addField("drawbillno", new Object[0]).addField("drawcurrency", new Object[0]).addField("ldrawamount", new Object[0]).addField("loandate", new Object[0]).addField("loanrate", new Object[0]).addField("expiredate", new Object[0]).addField("repayamount", new Object[0]).addField("lnotrepayamount", new Object[0]).addField("extendamount", new Object[0]).addField("lrenewalexpiredate", new Object[0]).addField("isrenewal", new Object[0]).addField("e_prevrenewalexpiredate", new Object[0]).addField("exrateadjustdate", new Object[0]);
                if ("bond".equals(loanBills[0].getString("loantype"))) {
                    vs.addField("interesttype", new Object[0]).addField("lisadjustinterestrate", new Object[0]).addField("lreferencerate", new Object[0]).addField("lratesign", new Object[0]).addField("lratefloatpoint", new Object[0]).addField("lrateadjuststyle", new Object[0]);
                }
                for (Object loanBill : loanBills) {
                    Object expiredateBeforeRenewal;
                    boolean isBond = "bond".equals(loanBill.getString("loantype"));
                    DynamicObject entry = (DynamicObject)entryMap.get(loanBill.getPkValue());
                    Boolean isRenewal = Boolean.TRUE;
                    Date renewalExpireDate = (Date)this.getModel().getValue("renewalexpiredate");
                    BigDecimal extendamount = (BigDecimal)loanBill.get("notrepayamount");
                    BigDecimal loanRate = loanBill.getBigDecimal("loanrate");
                    Boolean isAdjustInterestRate = Boolean.FALSE;
                    DynamicObject referenceRate = loanBill.getDynamicObject("referencerate");
                    String rateSign = loanBill.getString("ratesign");
                    BigDecimal rateFloatPoint = loanBill.getBigDecimal("ratefloatpoint");
                    String rateAdjustStyle = loanBill.getString("rateadjuststyle");
                    Date firstAdjustDate = null;
                    if (!EmptyUtil.isEmpty((DynamicObject)entry)) {
                        isRenewal = entry.getBoolean("isrenewal");
                        renewalExpireDate = (Date)entry.get("lrenewalexpiredate");
                        extendamount = entry.getBigDecimal("extendamount");
                        firstAdjustDate = entry.getDate("exrateadjustdate");
                        if (isBond) {
                            loanRate = entry.getBigDecimal("loanrate");
                            isAdjustInterestRate = entry.getBoolean("lisadjustinterestrate");
                            referenceRate = entry.getDynamicObject("lreferencerate");
                            rateSign = entry.getString("lratesign");
                            rateFloatPoint = entry.getBigDecimal("lratefloatpoint");
                        }
                    }
                    long referenceRateId = 0L;
                    if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate)) {
                        referenceRateId = referenceRate.getLong("id");
                    }
                    Object object = expiredateBeforeRenewal = loanBill.get("renewalexpiredate") == null ? loanBill.get("expiredate") : loanBill.get("renewalexpiredate");
                    if (isBond) {
                        vs.addRow(new Object[]{loanBill.getPkValue(), loanBill.get("billno"), loanBill.get("currency.id"), loanBill.get("drawamount"), loanBill.get("bizdate"), loanRate, loanBill.get("expiredate"), loanBill.get("repayamount"), loanBill.get("notrepayamount"), extendamount, renewalExpireDate, isRenewal, expiredateBeforeRenewal, firstAdjustDate, loanBill.get("interesttype"), isAdjustInterestRate, referenceRateId, rateSign, rateFloatPoint, rateAdjustStyle});
                        continue;
                    }
                    vs.addRow(new Object[]{loanBill.getPkValue(), loanBill.get("billno"), loanBill.get("currency.id"), loanBill.get("drawamount"), loanBill.get("bizdate"), loanBill.get("loanrate"), loanBill.get("expiredate"), loanBill.get("repayamount"), loanBill.get("notrepayamount"), extendamount, renewalExpireDate, isRenewal, expiredateBeforeRenewal, firstAdjustDate});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("loanbilllist", vs);
                model.endInit();
                this.getView().updateView("loanbilllist");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("referencerate".equals(key) || "lreferencerate".equals(key)) {
            RateHelper.referenceRateF7Evt((BeforeF7SelectEvent)e, (IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("cfm_contractextend_bo".equals(this.getView().getEntityId()) && this.getView().getFormShowParameter().getCustomParam("biztype") == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contractbillno"});
        }
        this.setRateAdjustDateLock();
        this.setRateAdjustLock();
        this.getModel().setDataChanged(false);
    }

    private void setRateAdjustDateLock() {
        boolean isAdjustRate = (Boolean)this.getModel().getValue("isadjustinterestrate");
        int entryRowCount = this.getModel().getEntryRowCount("loanbilllist");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject loanBill = this.getLoanBill(i);
            if (LoanTypeEnum.isBond((String)loanBill.getString("loantype"))) continue;
            boolean isRenewal = (Boolean)this.getModel().getValue("isrenewal", i);
            boolean isCycle = RateAdjustStyleEnum.isCycle((String)loanBill.getString("rateadjuststyle"));
            this.getView().setEnable(Boolean.valueOf(isAdjustRate && isRenewal && isCycle), i, new String[]{"exrateadjustdate"});
        }
    }

    private void setRateAdjustLock() {
        Long contractId = (Long)this.getModel().getValue("sourcebillid");
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)contractId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("issofrrate", "=", (Object)true).and("iscallcompint", "=", (Object)true).and(new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()}));
        boolean isSofrLoan = QueryServiceHelper.exists((String)"cfm_loanbill", (QFilter[])qFilter.toArray());
        qFilter = new QFilter("id", "=", (Object)contractId).and("issofrrate", "=", (Object)true).and("iscallcompint", "=", (Object)true);
        boolean isSofrContract = QueryServiceHelper.exists((String)"cfm_loancontractbill", (QFilter[])qFilter.toArray());
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        qFilter = new QFilter("loancontractbill", "=", contractBill.getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("currency", "!=", currency.getPkValue()));
        boolean isDiffCurrency = TmcDataServiceHelper.exists((String)"cfm_loanbill", (QFilter[])qFilter.toArray());
        this.getView().setEnable(Boolean.valueOf(!isSofrLoan && !isSofrContract && !isDiffCurrency), new String[]{"isadjustinterestrate"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newVal = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String propName = e.getProperty().getName();
        if ("isrenewal".equals(propName)) {
            this.setRateAdjustDate((Boolean)newVal, rowIndex);
        } else if ("isadjustinterestrate".equals(propName)) {
            this.setRateAdjustDateLock();
        }
    }

    private void setRateAdjustDate(boolean isRenewal, int index) {
        DynamicObject loanBill = this.getLoanBill(index);
        if (!LoanTypeEnum.isBond((String)loanBill.getString("loantype"))) {
            boolean isAdjustRate = (Boolean)this.getModel().getValue("isadjustinterestrate");
            boolean isCycle = RateAdjustStyleEnum.isCycle((String)loanBill.getString("rateadjuststyle"));
            if (isAdjustRate && isRenewal && isCycle) {
                Date preRenewalExpireDate = (Date)this.getModel().getValue("e_prevrenewalexpiredate", index);
                this.getModel().setValue("exrateadjustdate", (Object)preRenewalExpireDate, index);
            }
            this.getView().setEnable(Boolean.valueOf(isAdjustRate && isRenewal && isCycle), index, new String[]{"exrateadjustdate"});
        }
    }

    private DynamicObject getLoanBill(int index) {
        Long loanBillId = (Long)this.getModel().getValue("drawbillid", index);
        return QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"id, rateadjuststyle, loantype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)loanBillId)});
    }

    private DynamicObject[] getLoanBills(Long contractId) {
        QFilter contractFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter drawStatusFilter = new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()});
        DynamicObject[] loadBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)String.join((CharSequence)",", LOANBILL_PROPS), (QFilter[])new QFilter[]{contractFilter, statusFilter, drawStatusFilter});
        return loadBills;
    }
}

