/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.extendbill;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ExtendBillLoanBillEntryEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((EntryGrid)this.getControl("loanbilllist")).addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"drawbillno")) {
            DynamicObject row = this.getModel().getEntryRowEntity("loanbilllist", evt.getRowIndex());
            Long loanBillId = row.getLong("drawbillid");
            String formId = FormParameterHelper.getLoanBillFormByBizType((IFormView)this.getView());
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formId);
            showParameter.setPkId((Object)loanBillId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        Object propValue = valSet[0].getNewValue();
        switch (key) {
            case "renewalexpiredate": {
                this.changeRenewalDate(propValue);
                break;
            }
            case "isadjustinterestrate": {
                this.setRateAdjustDate();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void changeRenewalDate(Object propValue) {
        DynamicObjectCollection drawList = this.getModel().getEntryEntity("loanbilllist");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)drawList)) {
            for (DynamicObject drawBill : drawList) {
                if (!drawBill.getBoolean("isrenewal")) continue;
                this.getModel().setValue("lrenewalexpiredate", propValue, drawBill.getInt("seq") - 1);
            }
        }
    }

    private void setRateAdjustDate() {
        Long contractId = (Long)this.getModel().getValue("sourcebillid");
        QFilter qFilter = new QFilter("loancontractbill.id", "=", (Object)contractId);
        qFilter.and("rateadjuststyle", "=", (Object)RateAdjustStyleEnum.CYCLE.getValue());
        DynamicObjectCollection loans = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id", (QFilter[])qFilter.toArray());
        List loanIds = loans.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        int entryRowCount = this.getModel().getEntryRowCount("loanbilllist");
        for (int i = 0; i < entryRowCount; ++i) {
            Long loanBill = (Long)this.getModel().getValue("drawbillid", i);
            if (!loanIds.contains(loanBill)) continue;
            Date prevRenewalExpireDate = (Date)this.getModel().getValue("e_prevrenewalexpiredate", i);
            this.getModel().setValue("exrateadjustdate", (Object)prevRenewalExpireDate, i);
        }
    }
}

