/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.feeshare;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fbp.common.bean.CostShareInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.helper.CostShareServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeShareEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"clearlab"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultVal();
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            this.createEntryDatas();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "calculation": {
                this.createEntryDatas();
                break;
            }
            case "unaudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "audit": {
                this.setDefaultVal();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("calculation".equals(op.getOperateKey())) {
            op.getOption().setVariableValue("isedit", "1");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("clearlab".equals(((Control)evt.getSource()).getKey())) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            boolean isAdjust = false;
            for (int i = 0; i < entryRowCount; ++i) {
                BigDecimal adjustAmt = (BigDecimal)this.getModel().getValue("e_adjustmentamount", i);
                if (!EmptyUtil.isNoEmpty((BigDecimal)adjustAmt)) continue;
                isAdjust = true;
                break;
            }
            if (isAdjust) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u6e05\u7a7a\u6240\u6709\u7684\u644a\u9500\u8c03\u6574\u3002", (String)"FeeShareEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("clearlab", (IFormPlugin)this));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u644a\u9500\u8c03\u6574\u3002", (String)"FeeShareEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("clearlab".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            this.getModel().beginInit();
            for (int i = 0; i < entryRowCount; ++i) {
                BigDecimal adjustAmt = (BigDecimal)this.getModel().getValue("e_adjustmentamount", i);
                if (!EmptyUtil.isNoEmpty((BigDecimal)adjustAmt)) continue;
                this.getModel().setValue("e_adjustmentamount", (Object)0, i);
                this.getModel().setValue("e_actualamount", this.getModel().getValue("e_shareamount", i), i);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        switch (prop = e.getProperty().getName()) {
            case "e_adjustmentamount": {
                this.adjustAmount();
                break;
            }
            case "sharefrequency": {
                this.createEntryDatas();
                break;
            }
            case "adjustmentamount": {
                this.headAdjustmentamount();
                break;
            }
        }
    }

    private void headAdjustmentamount() {
        BigDecimal shareAmt = (BigDecimal)this.getModel().getValue("shareamount");
        BigDecimal adjustAmt = (BigDecimal)this.getModel().getValue("adjustmentamount");
        this.getModel().setValue("actualamount", (Object)shareAmt.add(adjustAmt));
    }

    private void adjustAmount() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        BigDecimal shareAmt = (BigDecimal)this.getModel().getValue("e_shareamount", entryCurrentRowIndex);
        BigDecimal adjustAmt = (BigDecimal)this.getModel().getValue("e_adjustmentamount", entryCurrentRowIndex);
        this.getModel().setValue("e_actualamount", (Object)shareAmt.add(adjustAmt), entryCurrentRowIndex);
    }

    private void createEntryDatas() {
        DynamicObjectCollection rateJustEntrys;
        Long loandId = (Long)this.getModel().getValue("sourcebillid");
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loandId, (String)"cfm_loanbill", (String)"productfactory,bizdate,rateadjust_entry.ra_yearrate");
        DynamicObject factory = loanBill.getDynamicObject("productfactory");
        Date startDate = (Date)this.getModel().getValue("bizdate");
        Date endDate = (Date)this.getModel().getValue("expiredate");
        List dateList = CostShareServiceHelper.getDateList((DynamicObject)factory, (Date)startDate, (Date)endDate, (String)((String)this.getModel().getValue("sharefrequency")));
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        BigDecimal initCcbAmt = CostShareServiceHelper.getFeeAmount((Long)((Long)this.getModel().getValue("sourcebillid")), (Long)org.getLong("id"), (Long)currency.getLong("id"), (String)"cfm");
        String shareType = this.getShareType(loandId);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"feeamount", (Object)initCcbAmt);
        String interestType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(rateJustEntrys = loanBill.getDynamicObjectCollection("rateadjust_entry")))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loanrate", (Object)((DynamicObject)rateJustEntrys.get(0)).getBigDecimal("ra_yearrate"));
        }
        BigDecimal loanRate = ((BigDecimal)this.getModel().getValue("loanrate")).divide(Constants.ONE_HUNDRED);
        BasisEnum basisEnum = BasisEnum.getEnum((String)((String)this.getModel().getValue("basis")));
        List costShareInfoList = null;
        try {
            if (ShareTypeEnum.isStraight((String)shareType)) {
                amount = initCcbAmt;
            }
            costShareInfoList = CostShareServiceHelper.getCostShareList((List)dateList, (BigDecimal)amount, (BigDecimal)amount.subtract(initCcbAmt), (BigDecimal)loanRate, (BasisEnum)basisEnum, (int)currency.getInt("amtprecision"), (String)shareType);
            CostShareServiceHelper.dealCurrencyTailDiff((List)costShareInfoList, (BigDecimal)initCcbAmt, (int)currency.getInt("amtprecision"));
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        this.batchCreateEntrys(costShareInfoList);
    }

    private void batchCreateEntrys(List<CostShareInfo> costShareInfoList) {
        if (EmptyUtil.isEmpty(costShareInfoList)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = model.getDataChanged();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("e_period", new Object[0]);
        vs.addField("e_startdate", new Object[0]);
        vs.addField("e_enddate", new Object[0]);
        vs.addField("e_day", new Object[0]);
        vs.addField("e_accrualinterest", new Object[0]);
        vs.addField("e_payinterest", new Object[0]);
        vs.addField("e_shareamount", new Object[0]);
        vs.addField("e_actualamount", new Object[0]);
        BigDecimal ytm = BigDecimal.ZERO;
        for (CostShareInfo info : costShareInfoList) {
            ytm = info.getYtm();
            String startDateStr = DateUtils.formatString((Date)info.getStartDate(), (String)"yyyy-MM-dd");
            String endDateStr = DateUtils.formatString((Date)info.getEndDate(), (String)"yyyy-MM-dd");
            Object[] rowData = new Object[]{startDateStr + "-" + endDateStr, info.getStartDate(), info.getEndDate(), info.getDays(), info.getEiInterestAmt(), info.getAiInterestAmt(), info.getAmAmt(), info.getAmAmt()};
            vs.addRow(rowData);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        model.setValue("irr", (Object)ytm.multiply(Constants.ONE_HUNDRED));
        this.getModel().setDataChanged(dataChanged);
    }

    private void setDefaultVal() {
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().setValue("hsharefrequency", this.getModel().getValue("sharefrequency"));
        this.getModel().setValue("hirr", this.getModel().getValue("irr"));
        this.getModel().setValue("hfeeamount", this.getModel().getValue("feeamount"));
        this.getModel().setValue("hfreesharetype", this.getModel().getValue("freesharetype"));
        this.getModel().setDataChanged(dataChanged);
    }

    private String getShareType(Long srcId) {
        DynamicObjectCollection feeBills = CostShareServiceHelper.getFeeBills(Collections.singleton(srcId));
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)feeBills)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"freesharetype", (Object)((DynamicObject)feeBills.get(0)).getString("sharetype"));
        }
        return (String)this.getModel().getValue("freesharetype");
    }
}

