/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.financingvarieties;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.FinSourceEnum;
import kd.tmc.cfm.common.enums.TypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinancingVarTreeList
extends AbstractTreeListPlugin {
    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        ITreeModel treeModel = this.getTreeListView().getTreeModel();
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("fl".equals(appId)) {
            treeModel.getTreeFilter().add(new QFilter("biztype", "=", (Object)"cfm"));
            return;
        }
        if ("bdim".equals(appId)) {
            treeModel.getTreeFilter().add(new QFilter("id", "in", this.getFinVarIDs(true)));
        } else {
            treeModel.getTreeFilter().add(new QFilter("id", "in", this.getFinVarIDs(false)));
        }
        this.addFilter(treeModel);
    }

    private void addFilter(ITreeModel treeModel) {
        QFilter prdFilter = new QFilter("servicecategory", "!=", (Object)"B");
        List ifmIds = QueryServiceHelper.queryPrimaryKeys((String)"ifm_ldproduct", (QFilter[])new QFilter[]{prdFilter}, (String)"", (int)-1);
        if (EmptyUtil.isNoEmpty((Object)ifmIds)) {
            treeModel.getTreeFilter().add(new QFilter("id", "not in", (Object)ifmIds));
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean lookUp = listShowParameter.isLookUp();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!lookUp || "gm".equals(appId)) {
            treeModel.getTreeFilter().add(new QFilter("type", "=", (Object)TypeEnum.getValue((String)appId)));
            treeModel.getTreeFilter().add(new QFilter("biztype", "=", (Object)"cfm"));
        }
    }

    private Set<Long> getFinVarIDs(boolean isBond) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (isBond) {
            qFilter.and("finsource", "=", (Object)FinSourceEnum.BOND.getValue());
        }
        DynamicObjectCollection fininvestvarieties = QueryServiceHelper.query((String)"cfm_financingvarieties", (String)"id", (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> fininvestvarietiesIds = new HashSet<Long>();
        fininvestvarieties.stream().forEach(item -> fininvestvarietiesIds.add(item.getLong("id")));
        fininvestvarietiesIds.remove(0L);
        return fininvestvarietiesIds;
    }
}

