/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.financingvarieties;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.FinSourceEnum;
import kd.tmc.cfm.common.enums.TypeEnum;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.formplugin.helper.ResManagerHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinancingVarietiesEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        BasedataEdit parentControl = (BasedataEdit)this.getControl("parent");
        parentControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshCreditTypeStatus();
        this.setCreditTypeDefVal();
        this.setFinSourceByAppId();
        this.setTypeByAppId();
        if ("gm".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setFormTitle(new LocaleString(TypeEnum.GUAVARIETY.getName().getDescription()));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        this.setIswtdkByAppId(appId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "parent": {
                this.setCreditTypeDefVal();
                break;
            }
            case "name": {
                String newName = this.getModel().getValue("name").toString();
                boolean boo = this.checkName(newName);
                if (!boo) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FinancingVarietiesEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "parent": {
                this.setFinSourceTypeByAppId(e);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(true);
    }

    private boolean checkName(String newName) {
        QFilter FnewName;
        QFilter[] filters;
        DynamicObjectCollection list;
        boolean boo = false;
        ORM orm = ORM.create();
        if (EmptyUtil.isNotEmpty((CharSequence)newName) && (list = orm.query("cfm_financingvarieties", filters = new QFilter[]{FnewName = new QFilter("name", "=", (Object)newName)})) != null && list.size() > 0) {
            this.getModel().setValue("name", null);
            boo = true;
        }
        return boo;
    }

    private void refreshCreditTypeStatus() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (pkValue != null && Long.parseLong(pkValue.toString()) != 0L) {
            boolean isUsed = CfmFinVarietyHelper.isFinVarietyUsed((Long)((Long)pkValue));
            this.getView().setEnable(Boolean.valueOf(!isUsed), new String[]{"credittype"});
        }
    }

    private void setCreditTypeDefVal() {
        DynamicObject parentCreditType;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (OperationStatus.ADDNEW.equals((Object)status) && parent != null && this.getModel().getValue("credittype") == null && (parentCreditType = parent.getDynamicObject("credittype")) != null) {
            this.getModel().setValue("credittype", parentCreditType.getPkValue());
        }
    }

    private void setFinSourceByAppId() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isEmpty((String)appId)) {
            appId = "bdim";
        }
        switch (appId) {
            case "bdim": {
                String finSource = (String)this.getModel().getValue("finsource");
                if (EmptyUtil.isNoEmpty((String)finSource) && !FinSourceEnum.BOND.getValue().equals(finSource)) {
                    return;
                }
                ComboEdit finSourceCombo = (ComboEdit)this.getControl("finsource");
                ArrayList<ComboItem> list = new ArrayList<ComboItem>(1);
                LocaleString description = ResManagerHelper.getLocalString(ResManager.getLocaleString((String)FinSourceEnum.BOND.getName().getDescription(), (String)"FinSourceEnum_1", (String)"tmc-cfm-common"), new Object[0]);
                list.add(new ComboItem(description, FinSourceEnum.BOND.getValue()));
                finSourceCombo.setComboItems(list);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"finsource", (Object)FinSourceEnum.BOND.getValue());
                break;
            }
        }
    }

    private void setTypeByAppId() {
        String appId = this.getView().getFormShowParameter().getAppId();
        String typeValue = (String)this.getModel().getValue("type");
        if (EmptyUtil.isEmpty((String)typeValue)) {
            String mapVal = TypeEnum.getValue((String)appId);
            typeValue = EmptyUtil.isEmpty((String)mapVal) ? TypeEnum.FINVARIETY.getValue() : mapVal;
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"type", (Object)typeValue);
        }
    }

    private void setIswtdkByAppId(String appId) {
        this.getView().setVisible(Boolean.valueOf(!"gm".equals(appId)), new String[]{"iswtdk"});
    }

    private void setFinSourceTypeByAppId(BeforeF7SelectEvent e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isEmpty((String)appId)) {
            appId = "bdim";
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        switch (appId) {
            case "bdim": {
                this.setTypeByAppId(qFilters);
                this.setFinSourceByAppId(qFilters, e);
                break;
            }
            case "cfm": 
            case "fl": {
                this.setTypeByAppId(qFilters);
            }
            case "gm": {
                this.setTypeByAppId(qFilters);
                showParameter.setCaption(TypeEnum.GUAVARIETY.getName().getDescription());
            }
        }
    }

    private void setFinSourceByAppId(List<QFilter> qFilters, BeforeF7SelectEvent evt) {
        if (this.getModel().getProperty("finsource") != null && EmptyUtil.isEmpty((Object)this.getModel().getValue("finsource"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u878d\u8d44\u6765\u6e90\u201d\u3002", (String)"FinancingVarietiesEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        qFilters.add(new QFilter("finsource", "=", this.getModel().getValue("finsource")));
    }

    private void setTypeByAppId(List<QFilter> qFilters) {
        qFilters.add(new QFilter("type", "=", this.getModel().getValue("type")));
    }
}

