/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.helper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmFormHelper {
    public static final Log logger = LogFactory.getLog(CfmFormHelper.class);

    public static void showPayBillList(HyperLinkClickArgs args, IFormView view) {
        args.setCancel(true);
        Object selectedId = CfmFormHelper.getSelectedRowId(args);
        if (null == selectedId) {
            return;
        }
        QFilter filter = new QFilter("entry.e_sourcebillid", "=", selectedId);
        List payIds = QueryServiceHelper.queryPrimaryKeys((String)"cas_paybill", (QFilter[])new QFilter[]{filter}, (String)"createtime desc", (int)-1);
        CfmFormHelper.showTargetBills(view, payIds.stream().distinct().collect(Collectors.toList()));
    }

    private static Object getSelectedRowId(HyperLinkClickArgs args) {
        int rowIndex = args.getRowIndex();
        HyperLinkClickEvent event = args.getHyperLinkClickEvent();
        BillList billList = (BillList)event.getSource();
        ListSelectedRowCollection currentSelectedRowInfo = billList.getSelectedRows();
        if (EmptyUtil.isEmpty((Collection)currentSelectedRowInfo)) {
            return null;
        }
        List selectedIds = currentSelectedRowInfo.stream().filter(r -> rowIndex == r.getRowKey()).map(r -> r.getPrimaryKeyValue()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(selectedIds)) {
            return null;
        }
        return selectedIds.get(0);
    }

    private static void showTargetBills(IFormView view, List<Object> payIds) {
        if (EmptyUtil.isNoEmpty(payIds) && payIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(payIds.get(0));
            showParameter.setFormId("cas_paybill");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            view.showForm((FormShowParameter)showParameter);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("cas_paybill");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", payIds));
        parameter.setCustomParam("isTrack", (Object)true);
        view.showForm((FormShowParameter)parameter);
    }

    public static void setUnlockPayAmt(IDataModel model, String amoutProp) {
        if (!model.getDataEntity().containsProperty("unlockpayamt")) {
            return;
        }
        BigDecimal payAmt = Optional.ofNullable((BigDecimal)model.getValue(amoutProp)).orElse(BigDecimal.ZERO);
        BigDecimal lockPayAmt = Optional.ofNullable((BigDecimal)model.getValue("lockpayamt")).orElse(BigDecimal.ZERO);
        BigDecimal unlockAmt = payAmt.subtract(lockPayAmt);
        String entityName = model.getDataEntityType().getName();
        if ("cfm_repaymentbill".equals(entityName) && !((Boolean)model.getValue("isrelcash")).booleanValue()) {
            unlockAmt = BigDecimal.ZERO;
        }
        if ("cfm_interestbill".equals(entityName) && (((Boolean)model.getValue("combineinst")).booleanValue() || !((Boolean)model.getValue("isrelcash")).booleanValue() || InterestbillctgEnum.isPrePayint((String)((String)model.getValue("instbillctg"))))) {
            unlockAmt = BigDecimal.ZERO;
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"unlockpayamt", (Object)(unlockAmt.compareTo(BigDecimal.ZERO) > 0 ? unlockAmt : BigDecimal.ZERO));
    }
}

