/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AutoFinancingCardPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_refresh", "autorepay", "autointerest", "autopreinterest"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_refresh".equals(key)) {
            this.loadAutoDataAndDrawPieChart();
            this.drawHistogramChart();
        } else if ("autorepay".equals(key)) {
            this.getAutoList(key);
        } else if ("autopreinterest".equals(key)) {
            this.getAutoList(key);
        } else if ("autointerest".equals(key)) {
            this.getAutoList(key);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.loadAutoDataAndDrawPieChart();
        this.drawHistogramChart();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("choosebank".equals(formOperate.getOperateKey())) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("cfm_homeset");
            DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)"cfm_homeset", (String)"id", (QFilter[])new QFilter[0]);
            if (baseData != null) {
                showParameter.setPkId(baseData.getPkValue());
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cfm_homeset"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey = e.getProperty().getName();
        if ("currency".equals(propKey)) {
            this.drawHistogramChart();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.drawHistogramChart();
    }

    private void setXNames(DynamicObjectCollection banks, List<String> xNames, List<Long> bankIdList) {
        for (DynamicObject bank : banks) {
            xNames.add(bank.getDynamicObject("fbasedataid").getString("name"));
            bankIdList.add(bank.getDynamicObject("fbasedataid").getLong("id"));
        }
    }

    private void setYValues(List<Long> bankIdList, DynamicObject currency, List<BigDecimal> yValues) {
        QFilter qFilter = new QFilter("auto", "=", (Object)true);
        qFilter.and("currency", "=", currency.getPkValue());
        qFilter.and("creditortype", "=", (Object)"bank");
        qFilter.and(this.getCreateTime());
        DataSet repayDataSet = QueryServiceHelper.queryDataSet((String)"cfm_repaymentbill", (String)"cfm_repaymentbill", (String)"id,creditor,amount as amt", (QFilter[])qFilter.toArray(), null);
        DataSet interestDataSet = QueryServiceHelper.queryDataSet((String)"cfm_interestbill", (String)"cfm_interestbill", (String)"id,creditor,actualinstamt as amt", (QFilter[])qFilter.toArray(), null);
        DataSet preinterestDataSet = QueryServiceHelper.queryDataSet((String)"cfm_preinterestbill", (String)"cfm_preinterestbill", (String)"id,creditor,actpreinstamt as amt", (QFilter[])qFilter.toArray(), null);
        DataSet dataSet = repayDataSet.union(new DataSet[]{interestDataSet, preinterestDataSet});
        HashSet creditorId = new HashSet();
        dataSet.copy().forEach(row -> creditorId.add(row.getLong("creditor")));
        DataSet finorgDataSet = QueryServiceHelper.queryDataSet((String)"bankoffinorginfo", (String)"bd_finorginfo", (String)"id as finid,bank_cate", (QFilter[])new QFilter[]{new QFilter("id", "in", creditorId)}, null);
        DataSet joinDataSet = dataSet.leftJoin(finorgDataSet).on("creditor", "finid").select(new String[]{"bank_cate", "amt"}).finish();
        DataSet groupbyDataSet = joinDataSet.copy().groupBy(new String[]{"bank_cate"}).sum("amt").finish();
        HashMap amtOfBank = new HashMap(16);
        groupbyDataSet.forEach(row -> amtOfBank.put(row.getLong("bank_cate"), row.getBigDecimal("amt")));
        bankIdList.forEach(b -> yValues.add((BigDecimal)amtOfBank.get(b)));
    }

    private void drawHistogramChart() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)"cfm_homeset", (String)"id,bank", (QFilter[])new QFilter[0]);
        if (EmptyUtil.isNoEmpty((DynamicObject)baseData) && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            DynamicObjectCollection banks = baseData.getDynamicObjectCollection("bank");
            ArrayList<String> xNames = new ArrayList<String>(10);
            ArrayList<Long> bankIdList = new ArrayList<Long>(10);
            ArrayList<BigDecimal> yValues = new ArrayList<BigDecimal>(10);
            this.setXNames(banks, xNames, bankIdList);
            this.setYValues(bankIdList, currency, yValues);
            Chart customChart = (Chart)this.getControl("histogramchartap");
            customChart.clearData();
            customChart.setDraggable(true);
            customChart.setShowTooltip(true);
            customChart.setTitleAlign(XAlign.left, YAlign.top);
            customChart.setMargin(Position.left, "10px");
            customChart.setMargin(Position.right, "10px");
            BarSeries barSeries = customChart.createBarSeries(ResManager.loadKDString((String)"\u91d1\u989d", (String)"AutoFinancingCardPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            if (xNames.size() < 6) {
                barSeries.setBarWidth("100");
            } else if (xNames.size() < 10) {
                barSeries.setBarWidth("40");
            }
            Axis xAxis = customChart.createXAxis("", AxisType.category);
            xAxis.setCategorys(xNames);
            Axis yAxis = customChart.createYAxis(ResManager.loadKDString((String)"\u91d1\u989d", (String)"AutoFinancingCardPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), AxisType.value);
            barSeries.setColor("#276FF5");
            for (BigDecimal amount : yValues) {
                barSeries.addData((Number)amount);
            }
            this.setLineColor(xAxis, "#666666");
            this.setLineColor(yAxis, "#666666");
            customChart.refresh();
        }
    }

    private void loadAutoDataAndDrawPieChart() {
        DataSet repayDataSet = QueryServiceHelper.queryDataSet((String)"autorepay", (String)"cfm_repaymentbill", (String)"id,auto", (QFilter[])this.getCreateTime().toArray(), null);
        DataSet preinterestDataSet = QueryServiceHelper.queryDataSet((String)"autopreinterest", (String)"cfm_preinterestbill", (String)"id,auto", (QFilter[])this.getCreateTime().toArray(), null);
        DataSet interestDataSet = QueryServiceHelper.queryDataSet((String)"autointerest", (String)"cfm_interestbill", (String)"id,auto", (QFilter[])this.getCreateTime().toArray(), null);
        int autoRepay = repayDataSet.copy().filter("auto = true").count("id", false);
        int autoPreinterest = preinterestDataSet.copy().filter("auto = true").count("id", false);
        int autoInterest = interestDataSet.copy().filter("auto = true").count("id", false);
        Label autoRepayLabel = (Label)this.getView().getControl("autorepay");
        Label autoPreinterestLabel = (Label)this.getView().getControl("autopreinterest");
        Label autoInterestLabel = (Label)this.getView().getControl("autointerest");
        autoRepayLabel.setText(String.valueOf(autoRepay));
        autoPreinterestLabel.setText(String.valueOf(autoPreinterest));
        autoInterestLabel.setText(String.valueOf(autoInterest));
        int totalRepay = repayDataSet.copy().count("id", false);
        int totalPreinterest = preinterestDataSet.copy().count("id", false);
        int totalInterest = interestDataSet.copy().count("id", false);
        this.drawPieChart(totalRepay, autoRepay, "repay");
        this.drawPieChart(totalPreinterest, autoPreinterest, "preinterest");
        this.drawPieChart(totalInterest, autoInterest, "interest");
    }

    private void drawPieChart(int total, int auto, String pieKey) {
        PieChart pieChart = (PieChart)this.getControl(pieKey + "pie");
        pieChart.createSeries("auto" + pieKey);
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(false);
        int noauto = total - auto;
        long rate = total == 0 ? 0L : BigDecimal.valueOf(auto).divide(BigDecimal.valueOf(total), 3, 4).movePointRight(2).setScale(0, 1).longValue();
        pieChart.setTitlePropValue("text", (Object)(rate + "%"));
        pieChart.setTitlePropValue("top", (Object)"center");
        pieChart.setTitlePropValue("left", (Object)"center");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("color", "#000000");
        map.put("fontSize", 40);
        map.put("fontWeight", "normal");
        pieChart.setTitlePropValue("textStyle", map);
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c\u7387", (String)"AutoFinancingCardPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        ItemValue[] data = new ItemValue[2];
        ItemValue data1 = new ItemValue(ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c\u5355\u636e\u6570", (String)"AutoFinancingCardPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), (Number)auto, "#77c404");
        ItemValue data2 = new ItemValue(ResManager.loadKDString((String)"\u975e\u81ea\u52a8\u6267\u5355\u636e\u884c\u6570", (String)"AutoFinancingCardPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), (Number)noauto, "#f2f2f2");
        data[0] = data1;
        data[1] = data2;
        HashMap<String, Boolean> label = new HashMap<String, Boolean>(4);
        label.put("show", false);
        series.setPropValue("label", label);
        series.setRadius("50%", "70%");
        series.setCenter("50%", "50%");
        series.setData(data);
        pieChart.refresh();
        this.getModel().setValue(pieKey + "text", (Object)this.getPieLabelName(pieKey));
        this.getView().updateView(pieKey + "text");
    }

    private String getPieLabelName(String pieKey) {
        switch (pieKey) {
            case "repay": {
                return ResManager.loadKDString((String)"\u8fd8\u6b3e\u81ea\u52a8\u6267\u884c\u7387", (String)"AutoFinancingCardPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            }
            case "interest": {
                return ResManager.loadKDString((String)"\u4ed8\u606f\u81ea\u52a8\u6267\u884c\u7387", (String)"AutoFinancingCardPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            }
            case "preinterest": {
                return ResManager.loadKDString((String)"\u9884\u63d0\u81ea\u52a8\u6267\u884c\u7387", (String)"AutoFinancingCardPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            }
        }
        return pieKey;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private QFilter getCreateTime() {
        Date now = new Date();
        QFilter qFilter = new QFilter("createtime", "<=", (Object)now);
        qFilter.and("createtime", ">=", (Object)DateUtils.getFirstDayOfMonth((Date)now));
        return qFilter;
    }

    private void getAutoList(String autoType) {
        ListShowParameter para = new ListShowParameter();
        switch (autoType) {
            case "autorepay": {
                para.setBillFormId("cfm_repaymentbill");
                break;
            }
            case "autopreinterest": {
                para.setBillFormId("cfm_preinterestbill");
                break;
            }
            case "autointerest": {
                para.setBillFormId("cfm_interestbill");
            }
        }
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filter = this.getCreateTime();
        filter.and("auto", "=", (Object)true);
        para.getListFilterParameter().getQFilters().add(filter);
        this.getView().showForm((FormShowParameter)para);
    }
}

