/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.home;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import org.apache.commons.lang3.StringUtils;

public class LoanCardPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    public void initialize() {
        super.initialize();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"drawingnum", "drawednum", "partpaymentnum"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ((ProgressBar)this.getControl("progressbarap")).start();
        this.setLoanNumValue();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        String key = srcControl.getKey();
        if ("drawingnum".equals(key)) {
            this.goLoanBillList(DrawTypeEnum.DRAWING.getValue());
        } else if ("drawednum".equals(key)) {
            this.goLoanBillList(DrawTypeEnum.DRAWED.getValue());
        } else if ("partpaymentnum".equals(key)) {
            this.goLoanBillList(DrawTypeEnum.PARTPAYMENT.getValue());
        }
    }

    private void goLoanBillList(String drawType) {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cfm_loanbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filter = new QFilter("drawtype", "=", (Object)drawType);
        para.setCustomParam("filter", (Object)filter.toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }

    private void setLoanNumValue() {
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cfm_loanbill", (String)"47150e89000000ac");
        filters.add(new QFilter("org", "in", (Object)authorizedAccountLegalOrgId));
        filters.add(new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue()));
        String selectFields = "drawtype";
        int drawingnum = 0;
        int drawednum = 0;
        int partpaymentnum = 0;
        try (DataSet loanDataSet = QueryServiceHelper.queryDataSet((String)"setLoanNumValue()", (String)"cfm_loanbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupByData = loanDataSet.groupBy(new String[]{"drawtype"});
            groupByData.count();
            DataSet loanCountDataSet = groupByData.finish();
            for (Row row : loanCountDataSet) {
                Integer newCount = row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count");
                String drawType = row.getString("drawtype");
                if (StringUtils.equals((CharSequence)drawType, (CharSequence)DrawTypeEnum.DRAWING.getValue())) {
                    drawingnum = newCount;
                    continue;
                }
                if (StringUtils.equals((CharSequence)drawType, (CharSequence)DrawTypeEnum.DRAWED.getValue())) {
                    drawednum = newCount;
                    continue;
                }
                if (!StringUtils.equals((CharSequence)drawType, (CharSequence)DrawTypeEnum.PARTPAYMENT.getValue())) continue;
                partpaymentnum = newCount;
            }
            loanCountDataSet.close();
        }
        ((Label)this.getView().getControl("drawingnum")).setText(String.valueOf(drawingnum));
        ((Label)this.getView().getControl("drawednum")).setText(String.valueOf(drawednum));
        ((Label)this.getView().getControl("partpaymentnum")).setText(String.valueOf(partpaymentnum));
    }

    public void onProgress(ProgressEvent event) {
        this.setLoanNumValue();
        event.setProgress(10);
    }
}

