/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.home;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;

public class RepayAInterestCardPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    public void initialize() {
        super.initialize();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"repayingnum", "payinterestingnum"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ((ProgressBar)this.getControl("progressbarap")).start();
        this.setPageValue();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        String key = srcControl.getKey();
        if ("repayingnum".equals(key)) {
            this.goRepaymentBillList();
        } else if ("payinterestingnum".equals(key)) {
            this.goInterestBillList();
        }
    }

    private void goRepaymentBillList() {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cfm_repaymentbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()});
        para.setCustomParam("filter", (Object)filter.toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }

    private void goInterestBillList() {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cfm_interestbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()});
        para.setCustomParam("filter", (Object)filter.toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }

    private void setPageValue() {
        this.setRepayNumValue();
        this.setInterestNumValue();
    }

    private void setRepayNumValue() {
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cfm_repaymentbill", (String)"47150e89000000ac");
        filters.add(new QFilter("org", "in", (Object)authorizedAccountLegalOrgId));
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()}));
        String selectFields = "billstatus";
        int repayingnum = 0;
        try (DataSet loanDataSet = QueryServiceHelper.queryDataSet((String)"setRepayNumValue()", (String)"cfm_repaymentbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupByData = loanDataSet.groupBy(new String[0]);
            groupByData.count();
            DataSet loanCountDataSet = groupByData.finish();
            for (Row row : loanCountDataSet) {
                repayingnum = row.getInteger("count") == null ? 0 : row.getInteger("count");
            }
            loanCountDataSet.close();
        }
        ((Label)this.getView().getControl("repayingnum")).setText(String.valueOf(repayingnum));
    }

    private void setInterestNumValue() {
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cfm_interestbill", (String)"47150e89000000ac");
        filters.add(new QFilter("org", "in", (Object)authorizedAccountLegalOrgId));
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()}));
        String selectFields = "billstatus";
        int payinterestingnum = 0;
        try (DataSet loanDataSet = QueryServiceHelper.queryDataSet((String)"setInterestNumValue()", (String)"cfm_interestbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupByData = loanDataSet.groupBy(new String[0]);
            groupByData.count();
            DataSet loanCountDataSet = groupByData.finish();
            for (Row row : loanCountDataSet) {
                payinterestingnum = row.getInteger("count") == null ? 0 : row.getInteger("count");
            }
            loanCountDataSet.close();
        }
        ((Label)this.getView().getControl("payinterestingnum")).setText(String.valueOf(payinterestingnum));
    }

    public void onProgress(ProgressEvent event) {
        this.setPageValue();
        event.setProgress(10);
    }
}

