/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.InitBillCreditLinkGmHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class InitBillBankCreditLimitEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String MANAGE_BANK = "MB";

    public void afterBindData(EventObject e) {
        this.enableManageBank();
        this.controlCreditLimit();
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("banksyndicate_entry".equals(e.getEntryProp().getName())) {
            for (int rowIndex : e.getRowIndexs()) {
                if (!MANAGE_BANK.equals(this.getModel().getValue("e_bankrole", rowIndex))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u884c\u3002", (String)"InitBillBankCreditLimitEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
        if ("gmsubentry".equals(e.getEntryProp().getName())) {
            if ("yes".equals(this.getView().getPageCache().get("isDeleteGuaranteeEntry"))) {
                this.getView().getPageCache().put("isDeleteGuaranteeEntry", "no");
                return;
            }
            for (int rowIndex : e.getRowIndexs()) {
                if (!((Boolean)this.getModel().getValue("gcreditguarantee", rowIndex)).booleanValue()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u643a\u5e26\u8fc7\u6765\u7684\u62c5\u4fdd\u4fe1\u606f\u4e0d\u53ef\u4ee5\u5220\u9664\u3002", (String)"InitBillLoanCreditLimitPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "loantype": {
                if (BizTypeEnum.SL.getValue().equals(this.getModel().getValue("loantype"))) {
                    for (int i = 0; i < this.getModel().getEntryRowCount("loanentry"); ++i) {
                        this.getModel().setValue("creditamount", (Object)BigDecimal.ZERO, i);
                        this.getModel().setValue("creditlimit", null, i);
                    }
                    this.setManageBankInfo();
                    break;
                }
                this.getModel().deleteEntryData("banksyndicate_entry");
                break;
            }
            case "creditortype": 
            case "creditor": {
                if (!BizTypeEnum.SL.getValue().equals(this.getModel().getValue("loantype"))) break;
                this.setManageBankInfo();
                break;
            }
            case "e_bank": 
            case "e_shareamount": {
                this.getModel().setValue("e_creditlimit", null);
                break;
            }
            case "e_creditlimit": {
                InitBillCreditLinkGmHelper.dealInitGmContract(this.getView(), this.getModel(), this.getPageCache(), newValue, oldValue, rowIndex);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit creditLimit = (BasedataEdit)this.getControl("e_creditlimit");
        creditLimit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        if ("e_creditlimit".equals(key)) {
            String sourceMethod = event.getSourceMethod();
            if ("getLookUpList".equals(sourceMethod) || "setItemByNumber".equals(sourceMethod)) {
                this.getView().showTipNotification(CfmFormResourceEnum.InitBillCreditLimitEdit_0.loadKDString());
                event.setCancel(true);
                this.getModel().setValue(key, null);
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("banksyndicate_entry");
            String message = this.creditLimitParamsCheck(rowIndex);
            if (EmptyUtil.isNoEmpty((String)message)) {
                this.getView().showTipNotification(message);
                event.setCancel(true);
                return;
            }
            CreditLimitUseBean useBean = new CreditLimitUseBean();
            Long loanContractId = (Long)this.getModel().getValue("loancontractid");
            if (EmptyUtil.isEmpty((Long)loanContractId)) {
                loanContractId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cfm_loancontractbill").getAlias());
                this.getModel().setValue("loancontractid", (Object)loanContractId);
            }
            useBean.setPkId(loanContractId);
            Long entryId = (Long)this.getModel().getValue("bankentryid");
            if (EmptyUtil.isEmpty((Long)entryId)) {
                entryId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cfm_loancontractbill").getAlias());
                this.getModel().setValue("bankentryid", (Object)entryId);
            }
            useBean.setSourceBillEntryId(entryId);
            DynamicObject company = (DynamicObject)this.getModel().getValue("org");
            Long orgId = EmptyUtil.isNoEmpty((DynamicObject)company) ? (Long)company.getPkValue() : 0L;
            useBean.setEntityName("cfm_loancontractbill");
            useBean.setOrgId(orgId);
            useBean.setFinOrgId(Long.valueOf(((DynamicObject)this.getModel().getValue("e_bank")).getLong("id")));
            useBean.setCurrencyId((Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue());
            DynamicObject financingType = (DynamicObject)this.getModel().getValue("finproduct");
            useBean.setCreditTypeId(CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)((Long)financingType.getPkValue())));
            useBean.setCreditVariety(financingType.getString("name"));
            useBean.setBizAmt((BigDecimal)this.getModel().getValue("e_shareamount", rowIndex));
            useBean.setMaxAmt((BigDecimal)this.getModel().getValue("e_shareamount", rowIndex));
            useBean.setStartDate((Date)this.getModel().getValue("startdate", rowIndex));
            useBean.setEndDate((Date)this.getModel().getValue("enddate", rowIndex));
            useBean.setPreOccupy(Boolean.valueOf(false));
            ListShowParameter sp = (ListShowParameter)event.getFormShowParameter();
            sp.setMultiSelect(false);
            sp.setCustomParam("KEY_F7PARAM", (Object)useBean);
            sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, event.getProperty().getName()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"e_creditlimit", (CharSequence)actionId) && returnData instanceof String) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("banksyndicate_entry");
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
            this.getPageCache().put("cache_usebean" + rowIndex, (String)returnData);
            this.getModel().setValue("e_creditlimit", (Object)res.getCreditLimitId(), rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_creditamt", (Object)res.getExchangeAmt(), (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_creditcurrency", (Object)res.getTargetCurrencyId(), (int)rowIndex);
        }
    }

    private String creditLimitParamsCheck(int rowIndex) {
        StringBuilder message = new StringBuilder();
        DynamicObject bizBill = this.getModel().getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("finproduct"))) {
            message.append(bizResource.getCbFinancingTypeNotNull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("e_bank"))) {
            message.append(ResManager.loadKDString((String)"\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitBillBankCreditLimitEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("currency"))) {
            message.append(bizResource.getCbCurrencyNotNull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("startdate"))) {
            message.append(bizResource.getInbStartdateNotNull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("enddate"))) {
            message.append(bizResource.getInbEnddateNotNull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("e_shareamount", rowIndex))) {
            message.append(bizResource.getLbCreditamountCheckNull());
        }
        return message.toString();
    }

    private void setManageBankInfo() {
        if (this.getModel().getEntryRowCount("banksyndicate_entry") == 0) {
            this.getModel().createNewEntryRow("banksyndicate_entry");
        }
        for (int rowIndex = 0; rowIndex < this.getModel().getEntryRowCount("banksyndicate_entry"); ++rowIndex) {
            if (!MANAGE_BANK.equals(this.getModel().getValue("e_bankrole", rowIndex))) continue;
            this.getModel().setValue("e_bank", this.getModel().getValue("creditor"), rowIndex);
            this.enableManageBank();
            return;
        }
        this.getModel().setValue("e_bankrole", (Object)MANAGE_BANK, 0);
        this.getModel().setValue("e_bank", this.getModel().getValue("creditor"), 0);
        this.enableManageBank();
    }

    private void enableManageBank() {
        if (BizTypeEnum.SL.getValue().equals(this.getModel().getValue("loantype"))) {
            for (int rowIndex = 0; rowIndex < this.getModel().getEntryRowCount("banksyndicate_entry"); ++rowIndex) {
                if (!MANAGE_BANK.equals(this.getModel().getValue("e_bankrole", rowIndex))) continue;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"e_bankrole", "e_bank"});
                break;
            }
        }
    }

    private void controlCreditLimit() {
        Long loanContractId = (Long)this.getModel().getValue("loancontractid");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("banksyndicate_entry");
        if (!BizTypeEnum.SL.getValue().equals(this.getModel().getValue("loantype")) || EmptyUtil.isEmpty((Long)loanContractId) || EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        DynamicObject[] creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"id,realamt,creditratio,currency,sourcebillid,sourcebillentryid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)loanContractId), new QFilter("sourcetype", "=", (Object)"cfm_loancontractbill")});
        int loanEntryCount = this.getModel().getEntryRowCount("banksyndicate_entry");
        HashMap<Long, Integer> rowMap = new HashMap<Long, Integer>();
        for (int i = 0; i < loanEntryCount; ++i) {
            if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("e_creditlimit", i))) continue;
            rowMap.put((Long)this.getModel().getValue("bankentryid", i), i);
        }
        for (DynamicObject creditUs : creditUses) {
            long billId = creditUs.getLong("sourcebillentryid");
            Integer rowIndex = (Integer)rowMap.get(billId);
            if (rowIndex == null) continue;
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_creditamt", (Object)creditUs.getBigDecimal("realamt"), (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_creditcurrency", (Object)creditUs.getDynamicObject("currency"), (int)rowIndex);
        }
    }
}

