/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class InitBillCreditLimitEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit creditLimit = (BasedataEdit)this.getControl("creditlimit");
        BasedataEdit creditLimitFlat = (BasedataEdit)this.getControl("basedatafield1");
        creditLimit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        creditLimitFlat.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (BizTypeEnum.SL.getValue().equals(this.getModel().getValue("loantype"))) {
            return;
        }
        DynamicObjectCollection loanEntrys = this.getModel().getEntryEntity("loanentry");
        Set loanBillIds = loanEntrys.parallelStream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("creditlimit"))).map(o -> o.getLong("loanbillid")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(loanBillIds)) {
            DynamicObject[] creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"id,realamt,creditratio,currency,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", loanBillIds), new QFilter("sourcetype", "=", (Object)"cfm_loanbill")});
            int loanEntryCount = this.getModel().getEntryRowCount("loanentry");
            HashMap<Long, Integer> rowMap = new HashMap<Long, Integer>();
            for (int i = 0; i < loanEntryCount; ++i) {
                if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("creditlimit", i))) continue;
                rowMap.put((Long)this.getModel().getValue("loanbillid", i), i);
            }
            for (DynamicObject creditUs : creditUses) {
                long billId = creditUs.getLong("sourcebillid");
                Integer rowIdex = (Integer)rowMap.get(billId);
                if (rowIdex == null) continue;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"discreditamount", (Object)creditUs.getBigDecimal("realamt"), (int)rowIdex);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"creditcurrency", (Object)creditUs.getDynamicObject("currency"), (int)rowIdex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        if ("creditlimit".equals(key) || "creditlimitflat".equals(key)) {
            String sourceMethod = event.getSourceMethod();
            if ("getLookUpList".equals(sourceMethod) || "setItemByNumber".equals(sourceMethod)) {
                this.getView().showTipNotification(CfmFormResourceEnum.InitBillCreditLimitEdit_0.loadKDString());
                event.setCancel(true);
                this.getModel().setValue(key, null);
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            String message = this.creditlimitParamsCheck(rowIndex);
            if (EmptyUtil.isNoEmpty((String)message)) {
                this.getView().showTipNotification(message);
                event.setCancel(true);
                return;
            }
            CreditLimitUseBean useBean = new CreditLimitUseBean();
            Long loanBillId = (Long)this.getModel().getValue("loanbillid", rowIndex);
            DynamicObject company = (DynamicObject)this.getModel().getValue("org");
            Long orgId = 0L;
            if (!EmptyUtil.isEmpty((DynamicObject)company)) {
                orgId = (Long)company.getPkValue();
            }
            if (loanBillId == null || loanBillId.equals(0L)) {
                loanBillId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill").getAlias());
                this.getModel().setValue("loanbillid", (Object)loanBillId, rowIndex);
            }
            useBean.setPkId(loanBillId);
            useBean.setEntityName("cfm_loanbill");
            useBean.setOrgId(orgId);
            useBean.setFinOrgId((Long)this.getModel().getValue("creditor"));
            DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimit", rowIndex);
            useBean.setCreditLimitId(creditLimit != null ? Long.valueOf(creditLimit.getLong("id")) : null);
            useBean.setCurrencyId((Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue());
            DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
            useBean.setCreditTypeId(CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)((Long)finProduct.getPkValue())));
            useBean.setCreditVariety(finProduct.getString("name"));
            BigDecimal drawAmt = (BigDecimal)this.getModel().getValue("drawamount", rowIndex);
            useBean.setMaxAmt(drawAmt);
            useBean.setBizAmt(drawAmt);
            useBean.setCreditRatio(finProduct.getBigDecimal("creditratio"));
            useBean.setStartDate((Date)this.getModel().getValue("loaddate", rowIndex));
            useBean.setEndDate((Date)this.getModel().getValue("expiredate", rowIndex));
            useBean.setPreOccupy(Boolean.FALSE);
            useBean.setCreditFinType(this.creditType());
            ListShowParameter sp = (ListShowParameter)event.getFormShowParameter();
            sp.setMultiSelect(false);
            sp.setCustomParam("KEY_F7PARAM", (Object)useBean);
            sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "KEY_CREDITLIMIT"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"KEY_CREDITLIMIT", (CharSequence)actionId) && returnData instanceof String) {
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
            this.getPageCache().put("cache_usebean", (String)returnData);
            int rowIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            DynamicObject creditLimit = TmcDataServiceHelper.loadSingleFromCache((Object)res.getCreditLimitId(), (String)"cfm_creditlimit", (String)"id,number");
            this.getModel().setValue("creditlimit", (Object)creditLimit, rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"discreditamount", (Object)res.getExchangeAmt(), (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"creditcurrency", (Object)res.getTargetCurrencyId(), (int)rowIndex);
        }
    }

    private String creditlimitParamsCheck(int rowIndex) {
        StringBuilder message = new StringBuilder();
        DynamicObject bizBill = this.getModel().getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("finproduct"))) {
            message.append(bizResource.getCbFinancingTypeNotNull());
        }
        if (StringUtils.equals((CharSequence)((String)this.getModel().getValue("lendernature")), (CharSequence)LenderNatureEnum.OUTGROUP.getValue()) && EmptyUtil.isEmpty((Object)this.getModel().getValue("creditor")) || StringUtils.equals((CharSequence)((String)this.getModel().getValue("lendernature")), (CharSequence)LenderNatureEnum.INGROUP.getValue()) && EmptyUtil.isEmpty((Object)this.getModel().getValue("creditorg"))) {
            message.append(bizResource.getCbLoanorgNotNull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("currency"))) {
            message.append(bizResource.getCbCurrencyNotNull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("drawamount", rowIndex)) || ((BigDecimal)this.getModel().getValue("drawamount", rowIndex)).compareTo(BigDecimal.ZERO) == 0) {
            message.append(bizResource.getLbDrawamountCheckNull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("loaddate", rowIndex))) {
            message.append(bizResource.getLbBizdateCheckNull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("expiredate", rowIndex))) {
            message.append(bizResource.getLbExpiredateCheckNull());
        }
        return message.toString();
    }

    protected String creditType() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) || LoanTypeEnum.LINKLEND.getValue().equals(loanType)) {
            return CreditFinTypeEnum.ORG.getValue();
        }
        return null;
    }
}

