/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawWayEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.RepayStateEnum;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.common.helper.RateHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class InitBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    protected final String[] GCPROPS = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate", "gsrcbillid", "gsrcbilltype", "gdebtbalance"};
    private static String[] BEFOREF7_PROPS = new String[]{"accountbank", "loaneracctbank", "referencerate", "exreferencerate", "loan_referencerate", "finproduct", "loadacctbank"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initControlEvt();
        EntryGrid loanEntryGrid = (EntryGrid)this.getControl("loanentry");
        if (loanEntryGrid != null) {
            loanEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
        for (String prop : BEFOREF7_PROPS) {
            BasedataEdit control = (BasedataEdit)this.getControl(prop);
            if (control == null) continue;
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "accountbank": 
            case "loaneracctbank": 
            case "loadacctbank": {
                this.acctBankF7Evt(evt, key);
                break;
            }
            case "referencerate": 
            case "loan_referencerate": 
            case "exreferencerate": {
                RateHelper.referenceRateF7Evt((BeforeF7SelectEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "finproduct": {
                this.finproductF7Evt(evt);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.defaultCurrency();
        this.creditorTypeChgEvt();
        if ("cfm_initbill_bond".equals(this.getModel().getDataEntityType().getName())) {
            this.getModel().setValue("datasource", (Object)DataSourceEnum.BOND.getValue());
            this.getModel().setValue("loantype", (Object)LoanTypeEnum.BOND.getValue());
            this.getModel().setValue("bondtype", (Object)"fixedratebond");
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        } else if ("cim_invest_initbill".equals(this.getView().getFormShowParameter().getFormId())) {
            this.getModel().setValue("datasource", (Object)DataSourceEnum.INVEST.getValue());
            String defLoanType = (String)this.getModel().getValue("loantype");
            if (EmptyUtil.isEmpty((String)defLoanType)) {
                defLoanType = BizTypeEnum.EC.getValue();
            }
            this.getModel().setValue("loantype", (Object)defLoanType);
            this.getModel().setValue("debtortype", (Object)CreditorTypeEnum.CUSTOM.getValue());
        } else if ("cfm_initbill".equals(this.getModel().getDataEntityType().getName())) {
            this.getModel().setValue("datasource", (Object)DataSourceEnum.CFM.getValue());
            String defLoanType = (String)this.getModel().getValue("loantype");
            if (EmptyUtil.isEmpty((String)defLoanType)) {
                Set biztypes = FormParameterHelper.getBizTypes((IFormView)this.getView());
                if (biztypes.contains(BizTypeEnum.LOAN.getValue()) || biztypes.contains(BizTypeEnum.SL.getValue())) {
                    defLoanType = BizTypeEnum.LOAN.getValue();
                } else if (biztypes.contains(BizTypeEnum.EC.getValue()) || biztypes.contains(BizTypeEnum.ENTRUST.getValue())) {
                    defLoanType = BizTypeEnum.EC.getValue();
                }
            }
            this.getModel().setValue("loantype", (Object)defLoanType);
            if (BizTypeEnum.LOAN.getValue().equals(defLoanType) || BizTypeEnum.SL.getValue().equals(defLoanType)) {
                this.getModel().setValue("creditortype", (Object)CreditorTypeEnum.BANK.getValue());
            }
            if (BizTypeEnum.EC.getValue().equals(defLoanType) || BizTypeEnum.ENTRUST.getValue().equals(defLoanType)) {
                this.getModel().setValue("creditortype", (Object)CreditorTypeEnum.INNERUNIT.getValue());
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        String interestType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.isAgree((String)interestType)) {
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW != opStatus && "cfm_initbill".equals(this.getModel().getDataEntityType().getName())) {
            String loanType = (String)this.getModel().getValue("loantype");
            this.initLoanTypeCombo();
            if (this.isECLoan() && LoanTypeEnum.isBankLoan((String)loanType)) {
                loanType = LoanTypeEnum.LINKLEND.getValue();
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loantype", (Object)loanType);
            this.initCreditorTypeCombo();
        }
        if (!BizTypeEnum.BOND.getValue().equals(this.getModel().getValue("loantype"))) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"interesttype", "basis", "repaymentway"});
            this.registerMustInputByInterestType();
            this.registerMustInputByAdustStyle();
            this.registerMustInputByRepaymentway();
        }
        this.initPayWayComb();
        this.setCanEditByRepayState();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getModel().getEntryEntity("loanentry").size() > 0) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            this.showSubEntrySummary(rowIndex);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_rp"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_gc"});
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (key = e.getProperty().getName()) {
            case "loantype": {
                this.loanTypeChgEvt();
                break;
            }
            case "interesttype": {
                this.registerMustInputByInterestType();
                if (((Boolean)this.getModel().getValue("isextend")).booleanValue()) {
                    this.getModel().setValue("renewalinteresttype", this.getModel().getValue("interesttype"));
                }
                this.setContractInterestRate();
                break;
            }
            case "repaymentway": {
                this.repaymentwayChgEvt();
                break;
            }
            case "rateadjuststyle": {
                this.registerMustInputByAdustStyle();
                break;
            }
            case "term": 
            case "loanterm": {
                this.termChgEvt(rowIndex);
                break;
            }
            case "enddate": 
            case "expiredate": {
                this.endDateChgEvt(rowIndex);
                break;
            }
            case "startdate": {
                this.startDateChgEvt(rowIndex);
                this.setContractInterestRate();
                break;
            }
            case "startinstdate": {
                this.startDateChgEvt(rowIndex);
                this.setContractInterestRate();
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("receivedate"))) break;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"receivedate", (Object)newVal, (int)rowIndex);
                break;
            }
            case "currency": {
                this.changeCurrency();
                break;
            }
            case "renewalexpiredate": {
                this.changeRenewalDate(newVal);
                break;
            }
            case "islimitclause": {
                Boolean isLimitClause = (Boolean)newVal;
                if (isLimitClause.booleanValue()) break;
                this.getModel().setValue("limitclauseexplain", (Object)"");
                break;
            }
            case "drawamount": {
                this.clearCredit(rowIndex);
                break;
            }
            case "creditamount": {
                this.clearCredit(rowIndex);
                break;
            }
            case "loaddate": {
                this.showSubEntrySummary(rowIndex);
                break;
            }
            case "receivedate": {
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("startinstdate"))) break;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"startinstdate", (Object)newVal, (int)rowIndex);
                break;
            }
            case "creditlimit": {
                DynamicObject creditLimit = (DynamicObject)newVal;
                if (EmptyUtil.isEmpty((DynamicObject)creditLimit)) {
                    this.clearCredit(rowIndex);
                    this.removeAutoShowSubRow(rowIndex);
                    return;
                }
                this.setGmEntry(creditLimit, rowIndex);
                break;
            }
            case "isloanextend": {
                Boolean isLoanExtend = (Boolean)newVal;
                if (isLoanExtend.booleanValue()) {
                    this.getModel().setValue("loanexpiredate", this.getModel().getValue("renewalexpiredate"), rowIndex);
                    break;
                }
                this.getModel().setValue("loanexpiredate", null, rowIndex);
                break;
            }
            case "isextend": {
                this.setDefaultIsExtend((Boolean)newVal);
                break;
            }
            case "creditortype": {
                this.creditorTypeChgEvt();
                break;
            }
            case "creditor": {
                this.creditorChgEvt();
                break;
            }
            case "debtor": {
                this.debtorChgEvt();
                break;
            }
            case "loanrateadjuststyle": {
                this.loanRateAdjustStyleEvt(rowIndex);
                break;
            }
            case "interestrate": {
                this.initPayWayComb();
                boolean isNot0Rate = BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("interestrate")) != 0;
                LoanBillFormHelper.setInterestSettledPlan(this.getModel(), this.getView(), isNot0Rate);
                if (isNot0Rate) break;
                this.getModel().setValue("floatingratio", null);
                this.getModel().setValue("overrate", null);
                break;
            }
            case "accountbank": {
                this.acctbankChgEvt();
                break;
            }
            case "loaneracctbank": {
                this.acctbankChgEvt();
                break;
            }
            case "settleintmode": {
                this.settlementChangeEvent();
                break;
            }
            case "referencerate": 
            case "ratefloatpoint": 
            case "ratesign": {
                this.setContractInterestRate();
                break;
            }
            case "overratetype": {
                String overRateType = (String)newVal;
                if ("percent".equals(overRateType)) {
                    this.getModel().setValue("overrate", null);
                    break;
                }
                this.getModel().setValue("floatingratio", null);
                break;
            }
        }
    }

    private void settlementChangeEvent() {
        String settleMode = (String)this.getModel().getValue("settleintmode");
        boolean isGdpljx = SettleIntModeEnum.isGdpljx((String)settleMode);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isGdpljx, (String[])new String[]{"interestsettledplan"});
        if (!isGdpljx) {
            this.getModel().setValue("interestsettledplan", null);
        }
    }

    private void setDefaultIsExtend(boolean isExtend) {
        int entryRowCount = this.getModel().getEntryRowCount("loanentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue("isloanextend", (Object)isExtend, i);
        }
        this.getModel().setValue("renewalinteresttype", this.getModel().getValue("interesttype"));
    }

    private void loanRateAdjustStyleEvt(int rowIndex) {
        this.getModel().setValue("loanrateadjustdate", null, rowIndex);
        this.getModel().setValue("loanrateadjusttype", null, rowIndex);
        this.getModel().setValue("loanrateadjustcycle", null, rowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"beforegenrepayplan")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            if (rowIndex < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e00\u884c\u63d0\u6b3e/\u653e\u6b3e/\u53d1\u884c\u4fe1\u606f\u3002", (String)"InitBillEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject currRowInfo = this.getModel().getEntryRowEntity("loanentry", rowIndex);
            String selectSeq = currRowInfo.get("seq") + "";
            DynamicObjectCollection repayPlans = currRowInfo.getDynamicObjectCollection("repaysubentry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)repayPlans)) {
                String entityName = this.getModel().getDataEntityType().getName();
                String msg = "ifm_initbill".equals(entityName) ? ResManager.loadKDString((String)"\u5c06\u8986\u76d6\u5df2\u6709\u672c\u91d1\u6536\u56de\u8ba1\u5212\u91cd\u65b0\u751f\u6210\uff0c\u786e\u5b9a\u7ee7\u7eed\u64cd\u4f5c\u5417\uff1f", (String)"InitBillEdit_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5c06\u8986\u76d6\u5df2\u6709\u8fd8\u6b3e\u8ba1\u5212\u91cd\u65b0\u751f\u6210\uff0c\u786e\u5b9a\u7ee7\u7eed\u64cd\u4f5c\u5417\uff1f", (String)"InitBillEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirm_genrepayplan_callback"), new HashMap(), selectSeq);
            } else {
                this.doGenRepayPlanOp(selectSeq);
            }
        }
    }

    private void doGenRepayPlanOp(String selectSeq) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("chooseParentEntrySeq", selectSeq);
        this.getView().invokeOperation("genrepayplan", option);
        this.setCanEditByRepayState();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && callBackId.equals("confirm_genrepayplan_callback")) {
            String selectSeq = messageBoxClosedEvent.getCustomVaule();
            this.doGenRepayPlanOp(selectSeq);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"newentry")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            this.getModel().setValue("loaddate", this.getModel().getValue("startdate"), rowIndex);
            this.getModel().setValue("startinstdate", this.getModel().getValue("startdate"), rowIndex);
            if (StringUtils.equals((CharSequence)((String)this.getModel().getValue("drawway")), (CharSequence)DrawWayEnum.ONCE.getValue())) {
                this.getModel().setValue("drawamount", this.getModel().getValue("amount"), rowIndex);
            }
            this.getModel().setValue("expiredate", this.getModel().getValue("enddate"), rowIndex);
            this.getModel().setValue("loanrate", this.getModel().getValue("interestrate"), rowIndex);
            Boolean isExtend = (Boolean)this.getModel().getValue("isextend");
            this.getModel().setValue("isloanextend", (Object)isExtend, rowIndex);
            if (isExtend.booleanValue()) {
                this.getModel().setValue("loanexpiredate", this.getModel().getValue("renewalexpiredate"), rowIndex);
            }
            if (!"cfm_initbill_bond".equals(this.getModel().getDataEntityType().getName())) {
                if (InterestTypeEnum.FLOAT.getValue().equals(this.getModel().getValue("interesttype"))) {
                    this.getModel().setValue("loanratesign", this.getModel().getValue("ratesign"), rowIndex);
                    this.getModel().setValue("loanratefloatpoint", this.getModel().getValue("ratefloatpoint"), rowIndex);
                } else {
                    this.getModel().setValue("loanrate", this.getModel().getValue("interestrate"), rowIndex);
                }
            }
            if ("cim_invest_initbill".equals(this.getView().getFormShowParameter().getFormId())) {
                this.getModel().setValue("loadacctbank", this.getModel().getValue("loaneracctbank"), rowIndex);
            } else {
                this.getModel().setValue("loadacctbank", this.getModel().getValue("accountbank"), rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"newsentry")) {
            int entryIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            int rowIndex = this.getModel().getEntryCurrentRowIndex("repaysubentry");
            if (rowIndex == 0 && StringUtils.equals((CharSequence)((String)this.getModel().getValue("drawway")), (CharSequence)DrawWayEnum.ONCE.getValue())) {
                this.getModel().setValue("exrepaymentdate", this.getModel().getValue("expiredate", entryIndex), rowIndex);
                this.getModel().setValue("exdrawamount", this.getModel().getValue("drawamount", entryIndex), rowIndex);
            }
        }
        if ("save".equals(opKey) && args.getOperationResult().getValidateResult().isSuccess()) {
            this.getView().updateView("repaysubentry");
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObjectCollection loanEntry;
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)startDate, (Date)endDate));
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(loanEntry = this.getModel().getEntryEntity("loanentry")))) {
            return;
        }
        String loanType = (String)this.getModel().getValue("loantype");
        boolean isSloan = LoanTypeEnum.isBanksLoan((String)loanType);
        DynamicObjectCollection slEntry = this.getModel().getEntryEntity("banksyndicate_entry");
        for (int i = 0; i < loanEntry.size(); ++i) {
            DynamicObject parentRow = (DynamicObject)loanEntry.get(i);
            Date lstartDate = parentRow.getDate("startinstdate");
            Date lendDate = parentRow.getDate("expiredate");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{lstartDate, lendDate})) {
                parentRow.set("loanterm", (Object)DateUtils.getDiff_ymd((Date)lstartDate, (Date)lendDate));
            }
            this.dealGmEntryAutoShow(isSloan, slEntry, parentRow, i);
            this.dealGmEntryImport(parentRow);
        }
    }

    private void dealGmEntryAutoShow(boolean isSloan, DynamicObjectCollection slEntry, DynamicObject parentRow, int i) {
        if (isSloan) {
            this.setGmSubEntryWhenImportSloan(slEntry, i);
            return;
        }
        DynamicObject creditLimit = parentRow.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)creditLimit)) {
            return;
        }
        this.setGmEntry(creditLimit, i);
    }

    private void dealGmEntryImport(DynamicObject parentRow) {
        DynamicObjectCollection gmSubEntry = parentRow.getDynamicObjectCollection("gmsubentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gmSubEntry)) {
            return;
        }
        BigDecimal drawAmt = parentRow.getBigDecimal("drawamount");
        for (DynamicObject subRow : gmSubEntry) {
            DynamicObject gmContract;
            if (subRow.getBoolean("gcreditguarantee") || EmptyUtil.isEmpty((DynamicObject)(gmContract = subRow.getDynamicObject("gcontract")))) continue;
            BigDecimal gamount = subRow.getBigDecimal("gamount");
            BigDecimal grate = subRow.getBigDecimal("gratio");
            if (EmptyUtil.isNoEmpty((BigDecimal)gamount)) {
                subRow.set("gratio", (Object)drawAmt.multiply(new BigDecimal("100")).divide(gamount, 10, 4));
            } else if (EmptyUtil.isNoEmpty((BigDecimal)grate)) {
                subRow.set("gamount", (Object)drawAmt.multiply(grate).divide(new BigDecimal("100"), 10, 4));
            }
            DynamicObject gmCurrency = gmContract.getDynamicObject("currency");
            subRow.set("gcontractcurrency", (Object)gmCurrency);
            subRow.set("gcontractamount", (Object)gmContract.getBigDecimal("amount"));
            DynamicObject bizCurrency = (DynamicObject)this.getModel().getValue("currency");
            BigDecimal exchangeRate = BigDecimal.ONE;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{org, gmCurrency, bizCurrency}) && bizCurrency.getLong("id") != gmCurrency.getLong("id")) {
                exchangeRate = TmcBusinessBaseHelper.getExchangeRate((long)bizCurrency.getLong("id"), (long)gmCurrency.getLong("id"), (long)org.getLong("id"), (Date)DateUtils.getCurrentDate());
            }
            subRow.set("gexchrate", (Object)exchangeRate);
        }
    }

    private void setGmSubEntryWhenImportSloan(DynamicObjectCollection slEntry, int index) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)slEntry)) {
            return;
        }
        for (DynamicObject slRow : slEntry) {
            Object[] useBills;
            DynamicObject creditLimit = slRow.getDynamicObject("e_creditlimit");
            if (EmptyUtil.isEmpty((DynamicObject)creditLimit) || EmptyUtil.isEmpty((Object[])(useBills = this.getGuaranteeUseBills(creditLimit)))) continue;
            this.setSubGmEntry((DynamicObject[])useBills, index, true, slRow);
        }
    }

    private DynamicObject[] getGuaranteeUseBills(DynamicObject creditLimit) {
        QFilter idFilter = new QFilter("gsrcbillid", "=", creditLimit.getPkValue());
        return TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", this.GCPROPS), (QFilter[])new QFilter[]{idFilter}, (String)"id");
    }

    private void setSubGmEntry(DynamicObject[] gcBills, int rowIndex, boolean isSloan, DynamicObject slRow) {
        BigDecimal creditRatio = BigDecimal.ONE;
        String useBeanStr = this.getPageCache().get("cache_usebean");
        if (EmptyUtil.isNoEmpty((String)useBeanStr)) {
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)useBeanStr, CreditLimitF7ResBean.class);
            creditRatio = res.getCreditRatio().divide(Constants.ONE_HUNDRED);
        }
        BigDecimal ratioTotal = Arrays.stream(gcBills).map(r -> r.getBigDecimal("gratio")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        ratioTotal = ratioTotal.multiply(creditRatio);
        BigDecimal gAmountTotal = BigDecimal.ZERO;
        DynamicObject entryRow = this.getModel().getEntryRowEntity("loanentry", rowIndex);
        BigDecimal entryDrawAmt = isSloan ? slRow.getBigDecimal("e_shareamount") : entryRow.getBigDecimal("drawamount");
        String creditorType = (String)this.getModel().getValue("creditortype");
        Long creditor = (Long)this.getModel().getValue("creditor");
        String creditorText = (String)this.getModel().getValue("textcreditor");
        DynamicObjectCollection gmSubEntry = entryRow.getDynamicObjectCollection("gmsubentry");
        for (int i = 0; i < gcBills.length; ++i) {
            Long gCcyId;
            Long bizCcyId;
            DynamicObject gcEntry = gmSubEntry.addNew();
            DynamicObject row = gcBills[i];
            gcEntry.set("gcontract", (Object)row.getDynamicObject("gcontract"));
            if (Constants.ONE_HUNDRED.compareTo(ratioTotal) == 0 && i == gcBills.length - 1) {
                gcEntry.set("gamount", (Object)entryDrawAmt.subtract(gAmountTotal));
            } else {
                BigDecimal rowGamt = entryDrawAmt.multiply(row.getBigDecimal("gratio").multiply(creditRatio).divide(Constants.ONE_HUNDRED));
                gcEntry.set("gamount", (Object)rowGamt);
                gAmountTotal = gAmountTotal.add(rowGamt);
            }
            gcEntry.set("gratio", (Object)row.getBigDecimal("gratio").multiply(creditRatio));
            gcEntry.set("gcontractamount", row.get("gcontract.amount"));
            DynamicObject gCcyDyn = row.getDynamicObject("gcontract.currency");
            gcEntry.set("gcontractcurrency", (Object)gCcyDyn);
            gcEntry.set("gcomment", row.get("gcomment"));
            BigDecimal rate = BigDecimal.ONE;
            DynamicObject bizCcyDyn = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject bizOrgDyn = (DynamicObject)this.getModel().getValue("org");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizOrgDyn, bizCcyDyn, gCcyDyn}) && !(bizCcyId = Long.valueOf(bizCcyDyn.getLong("id"))).equals(gCcyId = Long.valueOf(gCcyDyn.getLong("id")))) {
                rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCcyId, (long)gCcyId, (long)bizOrgDyn.getLong("id"), (Date)DateUtils.getCurrentDate());
            }
            gcEntry.set("gexchrate", (Object)rate);
            this.setCreditGuarantee(row, gcEntry);
            gcEntry.set("gautoshow", (Object)Boolean.TRUE);
            gcEntry.set("gcreditortype", (Object)creditorType);
            gcEntry.set("gcreditor", (Object)creditor);
            gcEntry.set("gcreditortext", (Object)creditorText);
        }
    }

    private void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                return;
            }
            case "loanterm": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key, e.getRowIndex());
                return;
            }
            case "enddate": {
                if (value == null) {
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("startdate");
                if (startDate == null) {
                    return;
                }
                String fmtStr = ((DateEdit)this.getControl("enddate")).getFormatString();
                Date endDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
                if (!startDate.after(endDate)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u5f00\u59cb\u65e5\u671f\u3002", (String)"InitBillEdit_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
                break;
            }
        }
    }

    private void loanTypeChgEvt() {
        this.getModel().setValue("finproduct", null);
        String loanType = (String)this.getModel().getValue("loantype");
        if (BizTypeEnum.ENTRUST.getValue().equals(loanType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"clientorg"});
            this.getModel().setValue("isclientloan", (Object)"1");
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"clientorg"});
            this.getModel().setValue("isclientloan", (Object)"0");
        }
        this.registerLoanerAcctbankMustInput();
    }

    private void repaymentwayChgEvt() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (BizTypeEnum.BOND.getValue().equals(loanType)) {
            return;
        }
        this.getModel().setValue("interestsettledplan", null);
        this.getModel().setValue("stageplan", null);
        this.registerMustInputByRepaymentway();
        this.setSettleIntModeByRepayWay();
    }

    private void setSettleIntModeByRepayWay() {
        String repayWay = (String)this.getModel().getValue("repaymentway");
        HashSet<String> repayWayLSBQ = new HashSet<String>(5);
        repayWayLSBQ.add(RepaymentWayEnum.bqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debj.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dbdx.getValue());
        HashSet<String> repayWayFIX = new HashSet<String>(2);
        repayWayFIX.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWayFIX.add(RepaymentWayEnum.bqhbdqhx.getValue());
        if (repayWayLSBQ.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.lsbq.getValue());
        } else if (repayWayFIX.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        }
    }

    private void initControlEvt() {
        ((EntryGrid)this.getControl("loanentry")).addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                EntryGrid source = (EntryGrid)evt.getSource();
                int[] rows = source.getSelectRows();
                if (rows == null || rows.length == 0) {
                    InitBillEdit.this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_rp"});
                    InitBillEdit.this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_gc"});
                    InitBillEdit.this.getView().setVisible(Boolean.valueOf(false), new String[]{"loan_feedetailap"});
                    InitBillEdit.this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_uw"});
                    return;
                }
                int rowIndex = rows[0];
                InitBillEdit.this.showSubEntrySummary(rowIndex);
            }
        });
    }

    private void defaultCurrency() {
        DynamicObject currency;
        String billFormId = this.getView().getFormShowParameter().getFormId();
        DynamicObject org = null;
        if ("cim_invest_initbill".equals(billFormId)) {
            if (this.getModel().getProperty("currency") != null && this.getModel().getProperty("creditorg") != null) {
                org = (DynamicObject)this.getModel().getValue("creditorg");
            }
        } else if (this.getModel().getProperty("currency") != null && this.getModel().getProperty("org") != null) {
            org = (DynamicObject)this.getModel().getValue("org");
        }
        if (org != null && EmptyUtil.isNoEmpty((DynamicObject)(currency = TmcBusinessBaseHelper.getBaseCurrency((long)org.getLong("id"))))) {
            this.getModel().setValue("currency", currency.getPkValue());
        }
    }

    private void changeCurrency() {
        DynamicObject currency;
        if (EmptyUtil.isNoEmpty((Object)this.getControl("referencerate"))) {
            this.getModel().setValue("referencerate", (Object)0L);
        }
        if (EmptyUtil.isNoEmpty((Object)this.getControl("exreferencerate"))) {
            this.getModel().setValue("exreferencerate", (Object)0L);
        }
        if (EmptyUtil.isEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency")))) {
            this.setLoanAcctBank(null);
            return;
        }
        DynamicObjectCollection loanBills = this.getModel().getEntryEntity("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanBills)) {
            return;
        }
        List<Long> acctIds = this.acctCurrency(Boolean.FALSE);
        for (DynamicObject loanBill : loanBills) {
            DynamicObject accBank = loanBill.getDynamicObject("loadacctbank");
            if (!EmptyUtil.isNoEmpty((DynamicObject)accBank) || acctIds.contains(accBank.getPkValue())) continue;
            this.getModel().setValue("loadacctbank", null, loanBill.getInt("seq") - 1);
        }
    }

    private void setLoanAcctBank(Object value) {
        DynamicObjectCollection loanBills = this.getModel().getEntryEntity("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanBills)) {
            return;
        }
        for (DynamicObject loanBill : loanBills) {
            this.getModel().setValue("loadacctbank", value, loanBill.getInt("seq") - 1);
        }
    }

    private List<Long> acctCurrency(Boolean bankFlag) {
        Object[] accts;
        ArrayList<Long> acctCurrId = new ArrayList<Long>();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            return acctCurrId;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            return acctCurrId;
        }
        QFilter acctFilters = new QFilter("company", "=", company.getPkValue()).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        if (bankFlag.booleanValue()) {
            Boolean isClientLoan = (Boolean)this.getModel().getValue("isclientloan");
            DynamicObject bank = isClientLoan != false ? (DynamicObject)this.getModel().getValue("clientorg") : (DynamicObject)this.getModel().getValue("creditor");
            acctFilters.and("bank", "=", bank == null ? Integer.valueOf(0) : bank.getPkValue());
        }
        if (!EmptyUtil.isEmpty((Object[])(accts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{acctFilters})))) {
            for (Object acct : accts) {
                acctCurrId.add((Long)acct.getPkValue());
            }
        }
        return acctCurrId;
    }

    private void showSubEntrySummary(int rowIndex) {
        String loanDate = "";
        if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("loaddate", rowIndex))) {
            loanDate = DateUtils.formatString((Date)((Date)this.getModel().getValue("loaddate", rowIndex)), (String)"yyyy-MM-dd");
        }
        String titleStr = ResManager.loadKDString((String)"\u653e\u6b3e", (String)"InitBillEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
        if ("cfm_initbill_bond".equals(this.getModel().getDataEntityType().getName())) {
            titleStr = ResManager.loadKDString((String)"\u53d1\u884c", (String)"InitBillEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            ((Label)this.getControl("uw_summary")).setText(loanDate + titleStr);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fs_uw"});
        }
        ((Label)this.getControl("rp_summary")).setText(loanDate + titleStr);
        ((Label)this.getControl("gc_summary")).setText(loanDate + titleStr);
        ((Label)this.getControl("fee_summary")).setText(loanDate + titleStr);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"fs_rp"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"fs_gc"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"loan_feedetailap"});
    }

    private void creditorTypeChgEvt() {
        this.registerLoanerAcctbankMustInput();
    }

    private void registerLoanerAcctbankMustInput() {
        if (this.getView().getFormShowParameter().getFormId().equals("cfm_initbill_e")) {
            String creditorType = (String)this.getModel().getValue("creditortype");
            String loanType = (String)this.getModel().getValue("loantype");
            boolean isMustInput = CreditorTypeEnum.INNERUNIT.getValue().equals(creditorType) && LoanTypeEnum.isLinklend((String)loanType);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"loaneracctbank"});
        }
    }

    private void creditorChgEvt() {
        Long creditorid = (Long)this.getModel().getValue("creditor");
        if (this.isInnerUnit()) {
            this.getModel().setValue("creditorg", (Object)creditorid);
        } else {
            this.getModel().setValue("creditorg", (Object)0L);
        }
        this.getModel().setValue("loaneracctbank", (Object)0L);
    }

    private void debtorChgEvt() {
        Long debtorId = (Long)this.getModel().getValue("debtor");
        String debtorType = (String)this.getModel().getValue("debtortype");
        if (this.getView().getFormShowParameter().getFormId().equals("cim_invest_initbill")) {
            if (!CreditorTypeEnum.OTHER.getValue().equals(debtorType)) {
                this.getModel().setValue("org", (Object)debtorId);
            }
            this.getModel().setValue("accountbank", (Object)0L);
        }
    }

    private boolean isInnerUnit() {
        String creditorType = (String)this.getModel().getValue("creditortype");
        return CreditorTypeEnum.INNERUNIT.getValue().equals(creditorType) || CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType);
    }

    private void changeRenewalDate(Object propValue) {
        DynamicObjectCollection drawList = this.getModel().getEntryEntity("loanentry");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)drawList)) {
            for (DynamicObject drawBill : drawList) {
                if (!drawBill.getBoolean("isloanextend")) continue;
                this.getModel().setValue("loanexpiredate", propValue, drawBill.getInt("seq") - 1);
            }
        }
    }

    private void clearCredit(int rowIndex) {
        this.getModel().setValue("creditlimit", null, rowIndex);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"discreditamount", null, (int)rowIndex);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"creditcurrency", null, (int)rowIndex);
    }

    private void endDateChgEvt(int rowIndex) {
        if (rowIndex >= 0) {
            DynamicObject loanRowBill = this.getModel().getEntryRowEntity("loanentry", rowIndex);
            Date startInstaDate = loanRowBill.getDate("startinstdate");
            Date expireDateDate = loanRowBill.getDate("expiredate");
            if (startInstaDate != null && expireDateDate != null) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"loanterm", (Object)DateUtils.getDiff_ymd((Date)startInstaDate, (Date)expireDateDate), (int)rowIndex);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"loanterm", null, (int)rowIndex);
            }
        } else {
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            if (startDate != null && endDate != null) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)startDate, (Date)endDate));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
            }
        }
    }

    private void termChgEvt(int rowIndex) {
        if (rowIndex >= 0) {
            DynamicObject loanRowBill = this.getModel().getEntryRowEntity("loanentry", rowIndex);
            String term = loanRowBill.getString("loanterm");
            if (!TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", null, (int)rowIndex);
            } else {
                Date startInstDate = loanRowBill.getDate("startinstdate");
                if (term != null && startInstDate != null) {
                    Date expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startInstDate);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate, (int)rowIndex);
                }
            }
        } else {
            String term = (String)this.getModel().getValue("term");
            if (!TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", null);
            } else {
                Date startDate = (Date)this.getModel().getValue("startdate");
                if (term != null && startDate != null) {
                    Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
                }
            }
        }
    }

    private void startDateChgEvt(int rowIndex) {
        if (rowIndex >= 0) {
            DynamicObject loanRowBill = this.getModel().getEntryRowEntity("loanentry", rowIndex);
            Date startInstDate = loanRowBill.getDate("startinstdate");
            Date expireDate = loanRowBill.getDate("expiredate");
            if (EmptyUtil.isNoEmpty((Object)startInstDate) && EmptyUtil.isNoEmpty((Object)expireDate)) {
                String loanTerm = DateUtils.getDiff_ymd((Date)startInstDate, (Date)expireDate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"loanterm", (Object)loanTerm, (int)rowIndex);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"loanterm", null, (int)rowIndex);
            }
        } else {
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (startDate == null) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", null);
            } else {
                String term = (String)this.getModel().getValue("term");
                if (term != null) {
                    Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
                }
            }
        }
    }

    private void finproductF7Evt(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        QFilter specQF = this.getFinProductF7QF(evt);
        if (evt.isCancel()) {
            return;
        }
        if (specQF != null) {
            sp.getListFilterParameter().getQFilters().add(specQF);
        }
    }

    private QFilter getFinProductF7QF(BeforeF7SelectEvent evt) {
        QFilter qFilter = null;
        Object loanType = this.getModel().getValue("loantype");
        if (EmptyUtil.isEmpty((Object)loanType)) {
            evt.setCancel(true);
            IDataEntityProperty loanTypeProp = this.getModel().getProperty("loantype");
            LocaleString loanTypePropDislayName = loanTypeProp.getDisplayName();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"ContractBaseEdit_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), loanTypePropDislayName.toString()));
            return null;
        }
        if ("ifm_initbill".equals(this.getModel().getDataEntityType().getName())) {
            return qFilter;
        }
        qFilter = BizTypeEnum.BOND.getValue().equals(loanType) ? new QFilter("finsource", "=", (Object)"bond") : new QFilter("finsource", "!=", (Object)"bond");
        return qFilter;
    }

    private void acctBankF7Evt(BeforeF7SelectEvent evt, String key) {
        String dataSource = (String)this.getModel().getValue("datasource");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        boolean isInvestInit = "cim_invest_initbill".equals(this.getView().getFormShowParameter().getFormId());
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            evt.setCancel(true);
            this.getView().showTipNotification(isInvestInit ? bizResource.getLbLoanCurrencyNotNull() : bizResource.getLbCurrencyNotNull());
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if ("loaneracctbank".equals(key) || "loadacctbank".equals(key) && isInvestInit) {
            org = (DynamicObject)this.getModel().getValue("creditorg");
        }
        long orgId = org == null ? 0L : Long.parseLong(org.getPkValue().toString());
        QFilter accountBankFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
        QFilter acctStatusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        QFilter qFilter = accountBankFilter == null ? acctStatusFilter : accountBankFilter.and(acctStatusFilter);
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            qFilter.and(new QFilter("acctclassify", "=", (Object)"I"));
        } else {
            qFilter.and(new QFilter("acctclassify", "!=", (Object)"I"));
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void registerMustInputByRepaymentway() {
        String repayWay = (String)this.getModel().getValue("repaymentway");
        String settleMode = (String)this.getModel().getValue("settleintmode");
        HashSet<String> repayWaysShowIntSettlePlan = new HashSet<String>(16);
        repayWaysShowIntSettlePlan.add(RepaymentWayEnum.bqhbdqhx.getValue());
        repayWaysShowIntSettlePlan.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWaysShowIntSettlePlan.add(RepaymentWayEnum.zdyhk.getValue());
        HashSet<String> repayWaysShowStageplan = new HashSet<String>(16);
        repayWaysShowStageplan.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.debx.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.debj.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.dbdx.getValue());
        if (repayWaysShowIntSettlePlan.contains(repayWay)) {
            BigDecimal interestRate = (BigDecimal)this.getModel().getValue("interestrate");
            if (interestRate.compareTo(BigDecimal.ZERO) == 0) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"interestsettledplan"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)SettleIntModeEnum.gdpljx.getValue().equals(settleMode), (String[])new String[]{"interestsettledplan"});
            }
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"interestsettledplan"});
        }
        if (repayWaysShowStageplan.contains(repayWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"stageplan"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"stageplan"});
        }
    }

    private void registerMustInputByInterestType() {
        if (!BizTypeEnum.BOND.getValue().equals(this.getModel().getValue("loantype"))) {
            String intRateType = (String)this.getModel().getValue("interesttype");
            if (InterestTypeEnum.FIXED.getValue().equals(intRateType) || InterestTypeEnum.AGREE.getValue().equals(intRateType)) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"interestrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"referencerate", "loanrateadjuststyle", "rateadjuststyle"});
            } else if (InterestTypeEnum.FLOAT.getValue().equals(intRateType)) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"referencerate", "loanrateadjuststyle", "rateadjuststyle"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"interestrate"});
            }
            this.registerMustInputByAdustStyle();
            this.initPayWayComb();
        }
    }

    private void registerMustInputByAdustStyle() {
        String intRateType = (String)this.getModel().getValue("interesttype");
        String adjustStyle = (String)this.getModel().getValue("rateadjuststyle");
        if (RateAdjustStyleEnum.CYCLE.getValue().equals(adjustStyle) && InterestTypeEnum.FLOAT.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"rateadjustcycletype", "rateadjustcycle", "rateadjustdate"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"rateadjustcycletype", "rateadjustcycle", "rateadjustdate"});
        }
    }

    private void initLoanTypeCombo() {
        List<Object> comboItemValues = new ArrayList(10);
        if (this.isBankLoan()) {
            comboItemValues = Arrays.asList(LoanTypeEnum.BANKLOAN.getValue(), LoanTypeEnum.BANKSLOAN.getValue());
        } else if (this.isECLoan()) {
            comboItemValues = Arrays.asList(LoanTypeEnum.LINKLEND.getValue(), LoanTypeEnum.ENTRUSTLOAN.getValue());
        }
        if (comboItemValues.size() > 0) {
            TmcViewInputHelper.resetComboItems(comboItemValues, (String)"loantype", (IFormView)this.getView());
        }
    }

    private void initCreditorTypeCombo() {
        String creditType = (String)this.getModel().getValue("creditortype");
        ArrayList<String> comboItemValues = new ArrayList<String>(10);
        if (this.isBankLoan()) {
            comboItemValues.addAll(Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue(), CreditorTypeEnum.SETTLECENTER.getValue()));
        }
        if (this.isECLoan()) {
            comboItemValues.addAll(Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue()));
        }
        if (comboItemValues.size() > 0) {
            TmcViewInputHelper.resetComboItems(comboItemValues, (String)"creditortype", (IFormView)this.getView());
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"creditortype", (Object)creditType);
    }

    private void initPayWayComb() {
        BigDecimal interestRate = (BigDecimal)this.getModel().getValue("interestrate");
        ComboEdit rePaymentWayComb = (ComboEdit)this.getControl("repaymentway");
        String interestType = (String)this.getModel().getValue("interesttype");
        if (EmptyUtil.isEmpty((Object)rePaymentWayComb)) {
            return;
        }
        ArrayList<String> comboItemValues = new ArrayList<String>(10);
        comboItemValues.add(RepaymentWayEnum.bqhblsbq.getValue());
        comboItemValues.add(RepaymentWayEnum.dqhblsbq.getValue());
        comboItemValues.add(RepaymentWayEnum.zdyhk.getValue());
        if (EmptyUtil.isEmpty((String)interestType) || StringUtils.equals((CharSequence)interestType, (CharSequence)InterestTypeEnum.FLOAT.getValue()) || EmptyUtil.isNoEmpty((BigDecimal)interestRate)) {
            comboItemValues.add(RepaymentWayEnum.bqhbdqhx.getValue());
            comboItemValues.add(RepaymentWayEnum.dqhbdqhx.getValue());
        }
        TmcViewInputHelper.resetComboItems(comboItemValues, (String)"repaymentway", (IFormView)this.getView());
        String rePaymentWay = (String)this.getModel().getValue("repaymentway");
        if (!comboItemValues.contains(RepaymentWayEnum.bqhbdqhx.getValue()) && (RepaymentWayEnum.isBqhbdqhx((String)rePaymentWay) || RepaymentWayEnum.isDqhbdqhx((String)rePaymentWay))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"repaymentway", (Object)RepaymentWayEnum.bqhblsbq.getValue());
        }
    }

    private boolean isBankLoan() {
        Set biztypes = FormParameterHelper.getBizTypes((IFormView)this.getView());
        return biztypes.contains(BizTypeEnum.LOAN.getValue()) || biztypes.contains(BizTypeEnum.SL.getValue());
    }

    private boolean isECLoan() {
        Set biztypes = FormParameterHelper.getBizTypes((IFormView)this.getView());
        return biztypes.contains(BizTypeEnum.EC.getValue()) || biztypes.contains(BizTypeEnum.ENTRUST.getValue());
    }

    private void setCreditGuarantee(DynamicObject row, DynamicObject gcEntry) {
        Optional<DynamicObject> guaOptional = Optional.ofNullable(row.getDynamicObject("gcontract")).map(r -> r.getDynamicObject("guaranteevarieties"));
        if (!guaOptional.isPresent()) {
            return;
        }
        DynamicObject guaranteeVarietie = TmcDataServiceHelper.loadSingle((String)"gm_guaranteevarieties", (String)"creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "=", guaOptional.get().getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)guaranteeVarietie)) {
            return;
        }
        gcEntry.set("gcreditguarantee", (Object)guaranteeVarietie.getBoolean("creditguarantee"));
    }

    private void setGmEntry(DynamicObject creditLimit, int rowIndex) {
        Object[] gcBills = this.getGuaranteeUseBills(creditLimit);
        if (EmptyUtil.isEmpty((Object[])gcBills)) {
            return;
        }
        this.removeAutoShowSubRow(rowIndex);
        this.setSubGmEntry((DynamicObject[])gcBills, rowIndex, false, null);
        this.getView().updateView("loanentry");
    }

    private void removeAutoShowSubRow(int rowIndex) {
        DynamicObject curParentRow = this.getModel().getEntryRowEntity("loanentry", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)curParentRow)) {
            return;
        }
        DynamicObjectCollection subEntry = curParentRow.getDynamicObjectCollection("gmsubentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)subEntry)) {
            return;
        }
        List rows = subEntry.stream().filter(r -> !r.getBoolean("gautoshow")).collect(Collectors.toList());
        subEntry.clear();
        subEntry.addAll(rows);
        this.getView().updateView("loanentry");
    }

    private void acctbankChgEvt() {
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObject accountbank = (DynamicObject)this.getModel().getValue("accountbank");
        if (!EmptyUtil.isEmpty((DynamicObject)accountbank)) {
            DynamicObject company;
            if ("ifm_initbill".equals(this.getModel().getDataEntityType().getName()) && EmptyUtil.isEmpty((DynamicObject)(company = (DynamicObject)this.getModel().getValue("org")))) {
                DynamicObject openorg = accountbank.getDynamicObject("openorg");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"org", (Object)openorg);
            }
            if ("cfm_initbill_b".equals(formId)) {
                DynamicObject creditorg = (DynamicObject)this.getModel().getValue("creditorg");
                String creditText = (String)this.getModel().getValue("textcreditor");
                if (EmptyUtil.isEmpty((DynamicObject)creditorg) && EmptyUtil.isEmpty((String)creditText)) {
                    DynamicObject bank = accountbank.getDynamicObject("bank");
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditor", (Object)bank.getLong("id"));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"textcreditor", (Object)bank.getString("name"));
                }
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control ce = (Control)evt.getSource();
        if (ce.getKey().equals("loanentry")) {
            this.setCanEditByRepayState();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("repaysubentry".equals(entryName)) {
            int entryIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            Date repayDate = (Date)this.getModel().getValue("repaydate", entryIndex);
            if (repayDate == null) {
                return;
            }
            for (int index : e.getRowIndexs()) {
                boolean isPayed;
                Date exRepayDate = (Date)this.getModel().getValue("exrepaymentdate", index);
                String repayDesc = (String)this.getModel().getValue("repaymentdesc", index);
                boolean bl = isPayed = RepayStateEnum.PAYED.getName().equals(repayDesc) && repayDate.compareTo(exRepayDate) == 0;
                if (!isPayed) continue;
                this.getView().showTipNotification(CfmFormResourceEnum.InitBillEdit_7.loadKDString());
                e.setCancel(true);
            }
        }
    }

    private void setCanEditByRepayState() {
        int loanEntryIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
        Date repayDate = (Date)this.getModel().getValue("repaydate", loanEntryIndex);
        if (repayDate == null) {
            return;
        }
        DynamicObjectCollection loanEntry = this.getModel().getEntryEntity("loanentry");
        DynamicObject loanBill = (DynamicObject)loanEntry.get(loanEntryIndex);
        DynamicObjectCollection entrys = loanBill.getDynamicObjectCollection("repaysubentry");
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject repayPlan = (DynamicObject)entrys.get(i);
            boolean isPayed = RepayStateEnum.PAYED.getName().equals(repayPlan.getString("repaymentdesc"));
            if (!isPayed || repayPlan.getDate("exrepaymentdate").compareTo(repayDate) != 0) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"exrepaymentdate", "exdrawamount", "repaymentdesc", "repaystate"});
        }
    }

    private void setContractInterestRate() {
        String interestType = (String)this.getModel().getValue("interesttype");
        if (!InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            return;
        }
        this.getModel().setValue("interestrate", (Object)this.getRate());
    }

    private BigDecimal getRate() {
        DynamicObject referenceRate = (DynamicObject)this.getModel().getValue("referencerate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        BigDecimal rateFloatPoint = (BigDecimal)this.getModel().getValue("ratefloatpoint");
        String rateSign = (String)this.getModel().getValue("ratesign");
        if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate) && EmptyUtil.isNoEmpty((Object)startDate)) {
            BigDecimal rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)startDate, (boolean)false);
            if (EmptyUtil.isEmpty((BigDecimal)rate)) {
                return BigDecimal.ZERO;
            }
            BigDecimal rateFloat = new BigDecimal(BigInteger.ZERO);
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
            }
            return rate.add(rateFloat);
        }
        return BigDecimal.ZERO;
    }
}

