/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBondCreditRatingEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initRatingScale();
    }

    private void initRatingScale() {
        TextEdit debtRatingEntryText;
        TextEdit ratingEntryText = (TextEdit)this.getControl("loan_ratingscale");
        if (ratingEntryText != null) {
            ratingEntryText.addButtonClickListener((ClickListener)this);
        }
        if ((debtRatingEntryText = (TextEdit)this.getControl("loan_debtratingscale")) != null) {
            debtRatingEntryText.addButtonClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control src = (Control)evt.getSource();
        switch (key = src.getKey()) {
            case "loan_ratingscale": {
                this.showRatingSelectForm("loan_ratingscale");
                break;
            }
            case "loan_debtratingscale": {
                this.showRatingSelectForm("loan_debtratingscale");
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent e) {
        String key;
        super.click((EventObject)e);
        Control src = (Control)e.getSource();
        switch (key = src.getKey()) {
            case "loan_ratingscale": 
            case "loan_debtratingscale": {
                DynamicObject currRowInfo = this.getCurrRowInfo();
                DynamicObject ratingAgency = currRowInfo.getDynamicObject("loan_ratingagency");
                if (!EmptyUtil.isEmpty((DynamicObject)ratingAgency)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bc4\u7ea7\u673a\u6784\u3002", (String)"BondCreditRatingEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private void showRatingSelectForm(String actionId) {
        DynamicObject currRowInfo = this.getCurrRowInfo();
        DynamicObject ratingAgency = currRowInfo.getDynamicObject("loan_ratingagency");
        if (EmptyUtil.isEmpty((DynamicObject)ratingAgency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bc4\u7ea7\u673a\u6784\u3002", (String)"BondCreditRatingEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"tbd_ratingscale", (boolean)Boolean.FALSE);
        showParameter.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        QFilter qFilter = new QFilter("ratingagency.id", "=", ratingAgency.getPkValue());
        QFilter qFilter_enable = new QFilter("enable", "=", (Object)"1");
        showParameter.getListFilterParameter().setFilter(qFilter.and(qFilter_enable));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject getCurrRowInfo() {
        return this.getModel().getEntryRowEntity("loanentry", this.getModel().getEntryCurrentRowIndex("loanentry"));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String action;
        super.closedCallBack(event);
        switch (action = event.getActionId()) {
            case "loan_ratingscale": 
            case "loan_debtratingscale": {
                this.setRatingScale(event, action);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "loan_ratingagency": {
                this.getModel().setValue("loan_ratingscale", null, rowIndex);
                this.getModel().setValue("loan_debtratingscale", null, rowIndex);
            }
        }
    }

    private void setRatingScale(ClosedCallBackEvent event, String field) {
        ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)event.getReturnData();
        if (EmptyUtil.isNoEmpty((Object)selectedRowCol)) {
            ListSelectedRow selectedRow = selectedRowCol.get(0);
            Object entryId = selectedRow.getEntryPrimaryKeyValue();
            this.setRatingScaleByEntryId(entryId, field);
        }
    }

    protected void setRatingScaleByEntryId(Object entryId, String field) {
        if (EmptyUtil.isEmpty((Object)entryId)) {
            return;
        }
        QFilter qFilter = new QFilter("entrys.id", "=", entryId);
        DynamicObject data = TmcDataServiceHelper.loadSingleFromCache((String)"tbd_ratingscale", (String)"entrys.grade,entrys.desc", (QFilter[])qFilter.toArray());
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
        int row = this.getModel().getEntryCurrentRowIndex("loanentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (!entry.getPkValue().toString().equals(entryId.toString())) continue;
            this.getModel().setValue(field, entry.get("grade"), row);
            break;
        }
    }
}

