/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.constant.CfmBizConstant;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillBatchWriteOffPlugin
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(IntBillBatchWriteOffPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.loadPreIntBill();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("actualinstamt".equals(property)) {
            BigDecimal actPreIntAmt = (BigDecimal)this.getModel().getValue("actpreinstamt");
            BigDecimal intBillActAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
            BigDecimal afterChargeInstAmt = actPreIntAmt.subtract(intBillActAmt);
            this.getModel().setValue("afterchargeinstamt", (Object)(afterChargeInstAmt.compareTo(BigDecimal.ZERO) > 0 ? afterChargeInstAmt : BigDecimal.ZERO));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!this.getPageCache().getAll().containsKey(CfmBizConstant.PREINTBILLIDS)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u51b2\u9500\u7684\u9884\u63d0\u5355\u8bb0\u5f55\u3002", (String)"IntBillBatchWriteOffPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        BigDecimal intBillActAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
        if (EmptyUtil.isEmpty((BigDecimal)intBillActAmt)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u51b2\u9500\u91d1\u989d\u4e3a\u96f6\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"IntBillBatchWriteOffPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("ok".equals(args.getOperateKey())) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            List intBillIds = (List)this.getView().getFormShowParameter().getCustomParams().get(CfmBizConstant.INTBILLIDS);
            returnData.put(CfmBizConstant.INTBILLIDS, intBillIds);
            returnData.put(CfmBizConstant.PREINTBILLIDS, this.getPageCache().get(CfmBizConstant.PREINTBILLIDS));
            BigDecimal intBillActAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
            BigDecimal actPreIntAmt = (BigDecimal)this.getModel().getValue("actpreinstamt");
            BigDecimal writeOffAmt = intBillActAmt.compareTo(actPreIntAmt) > 0 ? actPreIntAmt : intBillActAmt;
            returnData.put("writeoffamt", writeOffAmt);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void loadPreIntBill() {
        DynamicObject[] preIntBills;
        String biz_writeOff = (String)this.getView().getFormShowParameter().getCustomParams().get(CfmBizConstant.BIZ_WRITEOFF);
        List ids = (List)this.getView().getFormShowParameter().getCustomParams().get(CfmBizConstant.INTBILLIDS);
        QFilter filter = new QFilter("id", "in", (Object)ids);
        DynamicObject[] interestBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)"id,loanbillno,thischargeinstamt,bechargeinstamt,actualinstamt,convertintamt,afterchargeinstamt,currency,loancurrency,batchnoid", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> groupByPreInt = null;
        if ("writeoff".equals(biz_writeOff)) {
            preIntBills = IntBillWriteOffHelper.getPreIntBills((DynamicObject[])interestBills, null);
        } else {
            DynamicObjectCollection relations = IntBillWriteOffHelper.getWriteOffRelations((DynamicObject[])interestBills);
            groupByPreInt = relations.stream().collect(Collectors.groupingBy(v -> v.getLong("preinstbillid")));
            DynamicObject[] keys = groupByPreInt.keySet();
            Long[] preIntIds = keys.toArray(new Long[keys.size()]);
            preIntBills = IntBillWriteOffHelper.getWriteOffPreIntBills((Object)preIntIds);
        }
        if (preIntBills.length > 0) {
            ArrayList billList = new ArrayList(preIntBills.length);
            for (DynamicObject preIntBill : preIntBills) {
                HashMap<String, Object> bill = new HashMap<String, Object>(preIntBills.length);
                long id = preIntBill.getLong("id");
                bill.put("id", id);
                bill.put("billno", preIntBill.get("billno"));
                bill.put("org", preIntBill.get("org"));
                bill.put("currency", preIntBill.get("currency"));
                bill.put("recordstatus", preIntBill.get("recordstatus"));
                bill.put("textcreditor", preIntBill.get("textcreditor"));
                bill.put("prestartdate", preIntBill.get("prestartdate"));
                bill.put("prestenddate", preIntBill.get("prestenddate"));
                bill.put("nowriteoffamt", preIntBill.get("nowriteoffamt"));
                if (groupByPreInt != null) {
                    BigDecimal writeOffAmt = groupByPreInt.get(id).get(0).getBigDecimal("amount");
                    bill.put("nowriteoffamt", writeOffAmt);
                }
                billList.add(bill);
            }
            TmcViewInputHelper.batchFillEntity((String)"entrys", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), billList);
        }
        DynamicObject interestBill = interestBills[0];
        this.getModel().setValue("inst_currency", (Object)interestBill.getDynamicObject("loancurrency"));
        if ("unwriteoff".equals(biz_writeOff)) {
            BigDecimal intBillActAmt = Arrays.stream(interestBills).map(v -> v.getBigDecimal("thischargeinstamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().setValue("actualinstamt", (Object)intBillActAmt);
            BigDecimal noWriteOffAmt = interestBill.getBigDecimal("bechargeinstamt");
            this.getModel().setValue("actpreinstamt", (Object)noWriteOffAmt);
            BigDecimal afterChargeInstAmt = interestBill.getBigDecimal("afterchargeinstamt");
            this.getModel().setValue("afterchargeinstamt", (Object)afterChargeInstAmt);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"actualinstamt"});
        } else {
            BigDecimal noWriteOffAmt = IntBillWriteOffHelper.getTotalPreIntBillAmt((DynamicObject[])preIntBills);
            this.getModel().setValue("actpreinstamt", (Object)noWriteOffAmt);
            BigDecimal intBillActAmt = Arrays.stream(interestBills).map(v -> v.getBigDecimal("convertintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            intBillActAmt = noWriteOffAmt.compareTo(intBillActAmt) > 0 ? intBillActAmt : noWriteOffAmt;
            DynamicObject loanBill = IntBillWriteOffHelper.getLoanBill((DynamicObject[])interestBills);
            if (EmptyUtil.isEmpty((BigDecimal)loanBill.getBigDecimal("notrepayamount"))) {
                intBillActAmt = noWriteOffAmt;
            }
            this.getModel().setValue("actualinstamt", (Object)intBillActAmt);
            BigDecimal afterChargeInstAmt = noWriteOffAmt.subtract(intBillActAmt);
            this.getModel().setValue("afterchargeinstamt", (Object)afterChargeInstAmt);
        }
        if (preIntBills.length > 0) {
            Set preIntBillIds = Arrays.stream(preIntBills).map(v -> v.getLong("id")).collect(Collectors.toSet());
            this.getPageCache().put(CfmBizConstant.PREINTBILLIDS, JSON.toJSONString(preIntBillIds));
        }
    }
}

