/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        Map variables = this.getOption().getVariables();
        String instfilterStr = (String)variables.get("instBillfilter");
        QFilter loanFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("productfactory", "=", (Object)0).or(new QFilter("productfactory.iscallint", "=", (Object)"1")));
        if (EmptyUtil.isNoEmpty((String)instfilterStr)) {
            loanFilter.and(QFilter.fromSerializedString((String)instfilterStr));
        }
        e.setPlugFilter(loanFilter);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().getName());
        Map variables = this.getOption().getVariables();
        String repayFlag = (String)variables.get("repaymentFlag");
        if (EmptyUtil.isNotEmpty((CharSequence)repayFlag) && "true".equals(repayFlag)) {
            return;
        }
        Set loanBillIds = Arrays.stream(entitys).map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        Map loanBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"cfm_loanbill", loanBillIds);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject interestBill = entity.getDataEntity();
            interestBill.set("predictinstamt", null);
            interestBill.set("actualinstamt", null);
            interestBill.set("bizdate", (Object)DateUtils.getCurrentDate());
            interestBill.set("endinstdate", (Object)DateUtils.getLastDay((Date)DateUtils.getCurrentDate(), (int)1));
            Long sourcebillid = interestBill.getLong("sourcebillid");
            DynamicObject loanbill = (DynamicObject)loanBillMap.get(sourcebillid);
            Date lastEndinstdate = loanbill.getDate("endinstdate");
            if (EmptyUtil.isNoEmpty((Object)lastEndinstdate)) {
                interestBill.set("startinstdate", (Object)DateUtils.getNextDay((Date)lastEndinstdate, (int)1));
            } else {
                interestBill.set("startinstdate", (Object)loanbill.getDate("startintdate"));
            }
            DynamicObject payIntAccount = LoanBillHelper.getPayIntAccountFromPlan((DynamicObject)loanbill);
            if (payIntAccount != null) {
                interestBill.set("instbankacct", (Object)payIntAccount);
            }
            this.autoInterest(loanbill, interestBill);
            String creditortype = interestBill.getString("creditortype");
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditortype) && InterestbillctgEnum.PAYPRINANDINTE.getValue().equals(interestBill.getString("instbillctg")) && interestBill.getDataEntityType().getName().startsWith("cfm")) {
                interestBill.set("settlestatus", (Object)"hide");
            }
            this.seSlEntryDetail(interestBill);
        }
    }

    private void seSlEntryDetail(DynamicObject interest) {
        if (!LoanTypeEnum.isBanksLoan((String)interest.getString("loantype"))) {
            return;
        }
        DynamicObjectCollection slBankEntrys = interest.getDynamicObjectCollection("slentryentity");
        List slBankEntryList = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).collect(Collectors.toList());
        BatchIntBillHelper.setSlBankEntryAmount(slBankEntryList, (BigDecimal)interest.getBigDecimal("actualinstamt"), (String)"s_repayinst", (DynamicObject)interest.getDynamicObject("currency"), (boolean)true);
    }

    private void autoInterest(DynamicObject loanbill, DynamicObject interestBill) {
        boolean isAuto = this.getOption().getVariables().containsKey("auto");
        Date beginDate = interestBill.getDate("startinstdate");
        Date enddate = interestBill.getDate("bizdate");
        enddate = InterestCalcHelper.getEndIntDate((DynamicObject)loanbill, (Date)enddate);
        boolean containsDebx = RepaymentWayEnum.isHbfx((String)loanbill.getString("repaymentway"));
        IntBillExtInfo intBill = this.reCalIntInfo(loanbill, beginDate, enddate, containsDebx);
        if (isAuto) {
            interestBill.set("auto", (Object)"1");
        }
        if (isAuto && loanbill.getBoolean("handinstplan")) {
            Date lastEndIntDate = loanbill.getDate("endinstdate");
            DynamicObjectCollection interestEntrys = loanbill.getDynamicObjectCollection("interest_entry");
            List instBills = EmptyUtil.isEmpty((Object)lastEndIntDate) ? interestEntrys.stream().filter(o -> o.getDate("interesdate").compareTo(DateUtils.getCurrentDate()) <= 0 && "0".equals(o.getString("intstate"))).collect(Collectors.toList()) : interestEntrys.stream().filter(o -> o.getDate("interesdate").compareTo(DateUtils.getCurrentDate()) <= 0 && o.getDate("interesdate").compareTo(DateUtils.getNextDay((Date)lastEndIntDate, (int)1)) > 0 && "0".equals(o.getString("intstate"))).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(instBills)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u81ea\u52a8\u7ed3\u606f\u7684\u6570\u636e\u3002", (String)"InterestBillConvertPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject interestPlan = (DynamicObject)instBills.get(instBills.size() - 1);
            BigDecimal instAmt = instBills.stream().map(o -> o.getBigDecimal("interestcalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            Date interestDate = interestPlan.getDate("interesdate");
            interestBill.set("bizdate", (Object)interestDate);
            interestBill.set("endinstdate", (Object)DateUtils.getLastDay((Date)interestDate, (int)1));
            interestBill.set("actualinstamt", (Object)instAmt);
            interestBill.set("convertintamt", (Object)instAmt);
            if (null != intBill) {
                interestBill.set("predictinstamt", (Object)intBill.getAmount());
                DynamicObjectCollection entrys = interestBill.getDynamicObjectCollection("entrys");
                InterestCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getExtDetails(), (DynamicObject)loanbill);
            }
        } else if (null != intBill) {
            interestBill.set("bizdate", (Object)enddate);
            interestBill.set("endinstdate", (Object)DateUtils.getLastDay((Date)enddate, (int)1));
            interestBill.set("actualinstamt", (Object)intBill.getAmount());
            interestBill.set("convertintamt", (Object)intBill.getAmount());
            interestBill.set("predictinstamt", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = interestBill.getDynamicObjectCollection("entrys");
            InterestCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getExtDetails(), (DynamicObject)loanbill);
        }
    }

    private IntBillExtInfo reCalIntInfo(DynamicObject loanbill, Date beginDate, Date enddate, boolean containsDebx) {
        if (EmptyUtil.isNoEmpty((Object)beginDate) && EmptyUtil.isNoEmpty((Object)enddate) && enddate.compareTo(beginDate) > 0 && !containsDebx) {
            return InterestCalcHelper.callInt((InterestCalcRequest)InterestCalcRequest.build((DynamicObject)loanbill, (Date)beginDate, (Date)enddate));
        }
        return null;
    }
}

