/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill.batch;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractNavAddNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AbstractNavAddNewPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit settleCenter = (BasedataEdit)this.getControl("settlecenter");
        settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"contractbill", "contractnum", "loanbill", "next"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFilterView();
        this.initLoanBillInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "settlecenter": 
            case "settlecenterloan": 
            case "company": 
            case "currency": {
                this.clearFilterValue();
                break;
            }
            case "contractbill": 
            case "contractnum": {
                this.contractChgEvt(propName);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            if (!this.verifyInput()) {
                return;
            }
            TextEdit text = (TextEdit)evt.getSource();
            if (Arrays.asList("contractbill", "contractnum").contains(text.getKey())) {
                this.showContractBillF7(text.getKey());
            } else if ("loanbill".equals(text.getKey())) {
                this.showLoanBillF7();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)evt.getReturnData();
        if (EmptyUtil.isEmpty((Collection)selectedRow)) {
            return;
        }
        String actionId = evt.getActionId();
        List billIds = selectedRow.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
        if (Arrays.asList("contractbill", "loanbill").contains(actionId)) {
            List billnos = selectedRow.stream().map(row -> row.getBillNo()).collect(Collectors.toList());
            this.getModel().setValue(actionId, (Object)String.join((CharSequence)";", billnos));
            this.getPageCache().put(actionId, SerializationUtils.toJsonString(billIds));
        } else if (StringUtils.equals((CharSequence)"contractnum", (CharSequence)actionId)) {
            this.getPageCache().put("contractbill", SerializationUtils.toJsonString(billIds));
            DynamicObject[] loancontractbills = TmcDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_loancontractbill"));
            List contractnos = Arrays.stream(loancontractbills).map(v -> v.getString("contractno")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            this.getModel().setValue(actionId, (Object)String.join((CharSequence)",", contractnos));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property;
        switch (property = evt.getProperty().getName()) {
            case "settlecenter": {
                this.initSettleCenterFilter(evt);
                break;
            }
            case "company": {
                this.initCompanyFilter(evt);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("next")) {
            Map<Object, IntBillExtInfo> calcInterests = this.calcInterest();
            this.validateIntInfo(args, calcInterests);
            if (!args.isCancel()) {
                this.getPageCache().put("calcIntResult", JSON.toJSONString(calcInterests));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evtArgs) {
        if (StringUtils.equals((CharSequence)"next", (CharSequence)evtArgs.getOperateKey()) && evtArgs.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent(this.getNavFilterMap());
            this.getView().close();
        }
    }

    protected String getParentFormId() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        return EmptyUtil.isNoEmpty(param.get("formid")) ? param.get("formid").toString() : "";
    }

    private DynamicObject[] getIntCallLoans() {
        QFilter filter = this.getLoanBillFilter();
        if (this.getPageCache().getAll().containsKey("contractbill")) {
            String idJson = this.getPageCache().get("contractbill");
            filter.and(new QFilter("loancontractbill.id", "in", SerializationUtils.fromJsonString((String)idJson, List.class)));
        }
        return TmcDataServiceHelper.load((String)"ifm_loanbill", (String)"id,org,billno,currency,endinstdate,endpreinstdate,startintdate,lastrepaydate,repaymentway,loancontractbill", (QFilter[])filter.toArray());
    }

    private boolean verifyInput() {
        String parentFormId = this.getParentFormId();
        if (EmptyUtil.isEmpty((String)parentFormId) || !parentFormId.startsWith("ifm")) {
            return true;
        }
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        if (EmptyUtil.isEmpty((DynamicObject)settleCenter)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"AbstractNavAddNewPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showContractBillF7(String fieldName) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"ifm_loancontractbill", (boolean)true, (int)0, (boolean)true);
        BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        parameter.setBillFormId(batchIntViewInfo.getContractFormId());
        parameter.setCustomParam("biztype", BatchIntBillHelper.getContractViewInfo((BatchIntViewInfoEnum)batchIntViewInfo).getLeft());
        parameter.getListFilterParameter().getQFilters().add(this.getContractBillFilter());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldName));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private QFilter getContractBillFilter() {
        DynamicObjectCollection companys;
        DynamicObjectCollection currency;
        DynamicObject settleCenter;
        QFilter filter = new QFilter("contractstatus", "=", (Object)LoanContractStatusEnum.EXECUTING.getValue());
        String loanType = this.getBatchIntViewInfo().getLoanType();
        if (StringUtils.equals((CharSequence)loanType, (CharSequence)"loan")) {
            boolean settlecenterLoan = (Boolean)this.getModel().getValue("settlecenterloan");
            filter.and(new QFilter("creditortype", settlecenterLoan ? "=" : "!=", (Object)"settlecenter"));
        }
        if (!StringUtils.equals((CharSequence)loanType, (CharSequence)"bond")) {
            filter.and(new QFilter("interestrate", ">", (Object)0));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(settleCenter = (DynamicObject)this.getModel().getValue("settlecenter")))) {
            filter.and(new QFilter("settlecenter.id", "=", (Object)settleCenter.getLong("id")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currency = (DynamicObjectCollection)this.getModel().getValue("currency")))) {
            Set ids = currency.stream().map(c -> c.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            filter.and(new QFilter("currency.id", "in", ids));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(companys = (DynamicObjectCollection)this.getModel().getValue("company")))) {
            Set ids = companys.stream().map(c -> c.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            filter.and(new QFilter(this.getMainOrgFeild(), "in", ids));
        }
        this.addAuthorizedOrgQfiler(filter);
        logger.info("getContractBillFilter():{}", (Object)filter.toString());
        return filter;
    }

    private void showLoanBillF7() {
        BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        String loanBillFormId = batchIntViewInfo.getLoanBillFormId();
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)loanBillFormId, (boolean)true, (int)0, (boolean)true);
        parameter.getListFilterParameter().getQFilters().add(this.getLoanBillFilter());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "loanbill"));
        parameter.setCustomParam("biztype", BatchIntBillHelper.getLoanBillViewInfo((BatchIntViewInfoEnum)batchIntViewInfo).getLeft());
        this.getView().showForm((FormShowParameter)parameter);
    }

    public QFilter getLoanBillFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        filter.and(new QFilter("interesttype", "=", (Object)"float").or(new QFilter("interesttype", "!=", (Object)"float").and(new QFilter("loanrate", ">", (Object)0))));
        filter.and(new QFilter("productfactory", "=", (Object)0).or(new QFilter("productfactory", ">", (Object)0).and(new QFilter("productfactory.iscallint", "=", (Object)true))));
        filter.and(new QFilter("repaymentway", "not in", Arrays.asList("debj", "debx", "dbdx")));
        BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        if (!StringUtils.equals((CharSequence)BatchIntBillHelper.getDatasource((BatchIntViewInfoEnum)batchIntViewInfo), (CharSequence)"ifm")) {
            if (StringUtils.equals((CharSequence)batchIntViewInfo.getLoanType(), (CharSequence)"loan")) {
                boolean settlecenterLoan = (Boolean)this.getModel().getValue("settlecenterloan");
                filter.and(new QFilter("creditortype", settlecenterLoan ? "=" : "!=", (Object)"settlecenter"));
            } else {
                filter.and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            }
        }
        if (this.getPageCache().getAll().containsKey("contractbill")) {
            String contractBillCache = this.getPageCache().get("contractbill");
            List contractBillIds = (List)SerializationUtils.fromJsonString((String)contractBillCache, List.class);
            filter = filter.and(new QFilter("loancontractbill.id", "in", (Object)contractBillIds));
        } else {
            DynamicObjectCollection currency;
            DynamicObjectCollection company;
            List companyIds;
            DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
            if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter)) {
                filter = filter.and("settlecenter.id", "=", (Object)settleCenter.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty(companyIds = (company = (DynamicObjectCollection)this.getModel().getValue("company")).stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()))) {
                filter.and(new QFilter(this.getMainOrgFeild(), "in", companyIds));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currency = (DynamicObjectCollection)this.getModel().getValue("currency")))) {
                Set ids = currency.stream().map(c -> c.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                filter.and(new QFilter("currency.id", "in", ids));
            }
        }
        this.addExclusiveFilter(filter);
        this.addAuthorizedOrgQfiler(filter);
        logger.info("getLoanBillFilter():{}", (Object)filter.toString());
        return filter;
    }

    private Map<String, Object> getNavFilterMap() {
        DynamicObjectCollection currency;
        DynamicObjectCollection company;
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        DynamicObject settlecenter = (DynamicObject)this.getModel().getValue("settlecenter");
        if (EmptyUtil.isNoEmpty((DynamicObject)settlecenter)) {
            valMap.put("settlecenter", DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{settlecenter}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(company = (DynamicObjectCollection)this.getModel().getValue("company")))) {
            valMap.put("company", company);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currency = (DynamicObjectCollection)this.getModel().getValue("currency")))) {
            valMap.put("currency", currency);
        }
        Date endDate = (Date)this.getModel().getValue("endintdate");
        valMap.put("endintdate", DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
        valMap.put("calcIntResult", this.getPageCache().get("calcIntResult"));
        valMap.put("operatetype", this.getBatchIntViewInfo().getOperateType());
        valMap.put("formid", this.getParentFormId());
        valMap.put("calcOverInt", String.valueOf(this.getModel().getValue("calcOverInt")));
        if (EmptyUtil.isNoEmpty((String)this.getPageCache().get("loanbill"))) {
            List loanBillIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("loanbill"), List.class);
            valMap.put("loanbill", loanBillIds);
        }
        if (!this.isPreInt()) {
            valMap.put("payplan", String.valueOf(this.getModel().getValue("payplan")));
        }
        return valMap;
    }

    private void initSettleCenterFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String appid = this.getView().getFormShowParameter().getAppId();
        String entity = this.getView().getFormShowParameter().getCustomParams().get("entity").toString();
        Set bankIds = SettleCenterHelper.hasPermissionSettleCenter((String)appid, (String)entity, (String)"47156aff000000ac");
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)bankIds));
    }

    private void initCompanyFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List<Long> authOrgIds = this.getAuthOrgIds();
        if (EmptyUtil.isEmpty(authOrgIds)) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0));
        } else {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", authOrgIds));
        }
    }

    private Map<Object, IntBillExtInfo> calcInterest() {
        List loanBillIds;
        HashMap<Object, IntBillExtInfo> loanInt = new HashMap<Object, IntBillExtInfo>(16);
        if (this.getPageCache().getAll().containsKey("loanbill")) {
            loanBillIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("loanbill"), List.class);
        } else {
            DynamicObject[] intCallLoans = this.getIntCallLoans();
            loanBillIds = Arrays.stream(intCallLoans).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)loanBillIds)) {
            return loanInt;
        }
        Date endIntDate = (Date)this.getModel().getValue("endintdate");
        boolean isPreInt = this.isPreInt();
        boolean isCalcOverInt = (Boolean)this.getModel().getValue("calcOverInt");
        DynamicObject[] loanBills = "ifm_intbill_batch_loan".equals(this.getParentFormId()) ? TmcDataServiceHelper.load((Object[])loanBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_loanbill")) : TmcDataServiceHelper.load((Object[])loanBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill"));
        for (DynamicObject loanBill : loanBills) {
            InterestCalcRequest request;
            IntBillExtInfo callInt;
            Date beginDate = this.getStartDate(loanBill);
            Date newEndIntDate = InterestCalcHelper.getEndIntDate((DynamicObject)loanBill, (Date)endIntDate);
            if (!EmptyUtil.isEmpty((Object)beginDate) && newEndIntDate.compareTo(beginDate) <= 0 || !EmptyUtil.isNoEmpty((Object)(callInt = InterestCalcHelper.callInt((InterestCalcRequest)(request = InterestCalcRequest.build((DynamicObject)loanBill, (Date)beginDate, (Date)newEndIntDate, (boolean)isPreInt).setCalcOverInt(isCalcOverInt))))) || !EmptyUtil.isNoEmpty((BigDecimal)callInt.getAmount())) continue;
            loanInt.put(loanBill.getPkValue(), callInt);
        }
        return loanInt;
    }

    private void initLoanBillInfo() {
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        if (customParam.containsKey("loanbill")) {
            String dJson = (String)customParam.get("loanbill");
            Object[] loanBills = DynamicObjectSerializeUtil.deserialize((String)dJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_loanbill"));
            List billIds = Arrays.stream(loanBills).map(v -> (DynamicObject)v).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] loanBillArr = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"contractno,org,creditorg,billno,currency,loancontractbill", (QFilter[])new QFilter("id", "in", billIds).toArray());
            List<DynamicObject> loanBillList = Arrays.asList(loanBillArr);
            this.getPageCache().put("loanbill", SerializationUtils.toJsonString(billIds));
            List billnos = Arrays.stream(loanBills).map(v -> ((DynamicObject)v).getString("billno")).collect(Collectors.toList());
            String billno = org.apache.commons.lang3.StringUtils.join(billnos, (String)";");
            this.getModel().setValue("loanbill", (Object)billno);
            this.getView().updateView("loanbill");
            List<DynamicObject> currencys = loanBillList.stream().map(row -> row.getDynamicObject("currency")).collect(Collectors.toList());
            DynamicObjectCollection currencyColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"currency", (DynamicObject[])currencys.toArray(new DynamicObject[0]));
            this.getModel().setValue("currency", (Object)currencyColls);
            this.getView().updateView("currency");
            List<DynamicObject> orgs = loanBillList.stream().map(row -> row.getDynamicObject(this.getMainOrgFeild())).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(orgs)) {
                DynamicObjectCollection companyColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"company", (DynamicObject[])orgs.toArray(new DynamicObject[0]));
                this.getModel().setValue("company", (Object)companyColls);
                this.getView().updateView("company");
            }
            List contractnos = loanBillList.stream().map(v -> v.getString("contractno")).collect(Collectors.toList());
            this.getModel().setValue("contractnum", (Object)String.join((CharSequence)",", contractnos));
            this.getView().updateView("contractnum");
            List loancontractbills = loanBillList.stream().map(row -> row.getDynamicObject("loancontractbill")).filter(EmptyUtil::isNoEmpty).map(v -> v.getString("number")).collect(Collectors.toList());
            this.getModel().setValue("contractbill", (Object)String.join((CharSequence)",", loancontractbills));
            this.getView().updateView("contractbill");
        }
        if (customParam.containsKey("fromLoanBill")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"payplan", "settlecenter", "company", "currency", "contractbill", "contractnum", "loanbill", "settlecenterloan", "payintdaterange"});
        }
    }

    public void initFilterView() {
        BatchIntViewInfoEnum batchIntViewInfo;
        String dataSource;
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        Object settleCenter = customParam.get("settlecenter");
        if (EmptyUtil.isNoEmpty(settleCenter)) {
            this.getModel().setValue("settlecenter", settleCenter);
            this.getView().updateView("settlecenter");
        }
        if (StringUtils.equals((CharSequence)(dataSource = BatchIntBillHelper.getDatasource((BatchIntViewInfoEnum)(batchIntViewInfo = this.getBatchIntViewInfo()))), (CharSequence)"ifm")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"contractbill", "contractnum", "settlecenter"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"settlecenterloan"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"settlecenter"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"loanbill"});
        } else if (StringUtils.equals((CharSequence)dataSource, (CharSequence)"cim")) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"loanbill"});
        } else {
            this.getView().setVisible(Boolean.valueOf(StringUtils.equals((CharSequence)batchIntViewInfo.getLoanType(), (CharSequence)"loan")), new String[]{"settlecenterloan"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"contractnum", "settlecenter"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"loanbill"});
        }
        TextEdit loanBillEdit = (TextEdit)this.getControl("loanbill");
        loanBillEdit.setCaption(new LocaleString((String)BatchIntBillHelper.getLoanBillViewInfo((BatchIntViewInfoEnum)batchIntViewInfo).getRight()));
        TextEdit contractEdit = (TextEdit)this.getControl("contractbill");
        contractEdit.setCaption(new LocaleString((String)BatchIntBillHelper.getContractViewInfo((BatchIntViewInfoEnum)batchIntViewInfo).getRight()));
        Object initParams = customParam.get("initParams");
        if (EmptyUtil.isNoEmpty(initParams)) {
            Map params = (Map)initParams;
            if (params.containsKey("settlecenterloan")) {
                this.getModel().setValue("settlecenterloan", params.get("settlecenterloan"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"settlecenterloan"});
                this.getView().updateView("settlecenterloan");
            }
            if (params.containsKey("payplan") && !this.isPreInt()) {
                boolean isPayIntByPlan = (Boolean)params.get("payplan");
                this.getModel().setValue("payplan", (Object)isPayIntByPlan);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"payplan"});
                this.getView().setVisible(Boolean.valueOf(isPayIntByPlan), new String[]{"payintdaterange"});
                this.getView().setVisible(Boolean.valueOf(!isPayIntByPlan), new String[]{"endintdate"});
                this.getView().updateView("payplan");
            }
            if (params.containsKey("settlecenter")) {
                this.getModel().setValue("settlecenter", params.get("settlecenter"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"settlecenter"});
                this.getView().updateView("settlecenter");
            }
            if (params.containsKey("calcOverInt")) {
                this.getModel().setValue("calcoverint", params.get("calcOverInt"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"calcoverint"});
                this.getView().updateView("calcoverint");
            }
            if (params.containsKey("endintdate")) {
                this.getModel().setValue("endintdate", (Object)DateUtils.stringToDate((String)((String)params.get("endintdate")), (String)"yyyy-MM-dd"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"endintdate"});
                this.getView().updateView("endintdate");
            }
            if (params.containsKey("orgs")) {
                Set orgs = (Set)SerializationUtils.fromJsonString((String)params.get("orgs").toString(), Set.class);
                this.getModel().setValue("company", (Object)orgs.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("company");
            }
            if (params.containsKey("currencys")) {
                Set currencys = (Set)SerializationUtils.fromJsonString((String)params.get("currencys").toString(), Set.class);
                this.getModel().setValue("currency", (Object)currencys.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("currency");
            }
        }
    }

    private List<Long> getAuthOrgIds() {
        String appid = this.getView().getFormShowParameter().getAppId();
        BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        String entityId = batchIntViewInfo.getEntityId();
        String permissionId = batchIntViewInfo.getPermissionId();
        long currUserId = RequestContext.get().getCurrUserId();
        List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appid, (String)entityId, (String)permissionId);
        return authorizedBankOrgId;
    }

    private void clearFilterValue() {
        this.getModel().setValue("intobject", null);
        this.getModel().setValue("contractbill", null);
        this.getModel().setValue("loanbill", null);
        this.getModel().setValue("contractnum", null);
    }

    private void contractChgEvt(String propName) {
        Object newValue = this.getModel().getValue(propName);
        if (EmptyUtil.isEmpty((Object)newValue)) {
            this.getPageCache().remove("contractbill");
        }
        this.getModel().setValue("loanbill", null);
    }

    private void addAuthorizedOrgQfiler(QFilter qfilter) {
        if (StringUtils.equals((CharSequence)BatchIntBillHelper.getDatasource((BatchIntViewInfoEnum)this.getBatchIntViewInfo()), (CharSequence)"ifm")) {
            return;
        }
        List<Long> authOrgIds = this.getAuthOrgIds();
        if (EmptyUtil.isEmpty(authOrgIds)) {
            qfilter.and(new QFilter(this.getMainOrgFeild(), "=", (Object)0));
        } else {
            qfilter.and(new QFilter(this.getMainOrgFeild(), "in", authOrgIds));
        }
    }

    private void validateIntInfo(BeforeDoOperationEventArgs args, Map<Object, IntBillExtInfo> calcInterests) {
        boolean isPayIntByPlan = false;
        if (!this.isPreInt()) {
            isPayIntByPlan = (Boolean)this.getModel().getValue("payplan");
        }
        if (!(null != calcInterests && calcInterests.size() != 0 || isPayIntByPlan)) {
            this.getView().showErrorNotification(this.getNonIntDataTip());
            args.setCancel(true);
            return;
        }
        this.validateOnWayBill(args, calcInterests);
    }

    protected void validateOnWayBill(BeforeDoOperationEventArgs args, Map<Object, IntBillExtInfo> calcInterests) {
        Set loanBillIds = calcInterests.keySet().stream().map(d -> (Long)d).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("entry.loanbillid", "in", loanBillIds));
        String bizType = this.isPreInt() ? "preint" : "loan";
        qfilter.and(new QFilter("biztype", "=", (Object)bizType));
        DynamicObjectCollection batchBills = QueryServiceHelper.query((String)"cfm_intbill_batch_pre", (String)"billno,entry,entry.loanbillid", (QFilter[])qfilter.toArray());
        HashSet<Long> illegalBillIds = new HashSet<Long>(10);
        ArrayList<String> illbatchNo = new ArrayList<String>(10);
        for (DynamicObject batchBill : batchBills) {
            if (!calcInterests.containsKey(batchBill.get("entry.loanbillid"))) continue;
            illegalBillIds.add(batchBill.getLong("entry.loanbillid"));
            illbatchNo.add(batchBill.getString("billno"));
        }
        if (EmptyUtil.isNoEmpty(illegalBillIds)) {
            DynamicObjectCollection loanBills = LoanBillRepository.queryLoanBillByIds(illegalBillIds, (String)"billno");
            String billnos = loanBills.stream().map(d -> d.getString("billno")).collect(Collectors.joining(","));
            args.setCancel(true);
            this.getView().showErrorNotification(this.getExistOnWayDataTip(billnos, String.join((CharSequence)",", illbatchNo)));
            return;
        }
        DynamicObjectCollection details = LoanBillRepository.queryLoanBillByIds(loanBillIds, (String)"id, billno, lastrepaydate,drawtype");
        if (!this.isPreInt() && EmptyUtil.isNoEmpty((DynamicObjectCollection)details)) {
            Date endIntDate = (Date)this.getModel().getValue("endintdate");
            for (DynamicObject detail : details) {
                Date lastRepayDate = detail.getDate("lastrepaydate");
                String drawType = detail.getString("drawtype");
                if (!EmptyUtil.isNoEmpty((Object)endIntDate) || !EmptyUtil.isNoEmpty((Object)lastRepayDate) || this.isPayIntByPlan() || DateUtils.getDataFormat((Date)endIntDate, (boolean)true).compareTo(DateUtils.getDataFormat((Date)lastRepayDate, (boolean)true)) >= 0 || DrawTypeEnum.isAllpayment((String)drawType)) continue;
                args.setCancel(true);
                this.getView().showErrorNotification(this.getEndIntDateTip());
            }
        }
    }

    protected BatchIntViewInfoEnum getBatchIntViewInfo() {
        return BatchIntViewInfoEnum.getInfoEnumByFormId((String)this.getParentFormId());
    }

    private String getMainOrgFeild() {
        String loanType = this.getBatchIntViewInfo().getLoanType();
        String orgFilterField = StringUtils.equals((CharSequence)loanType, (CharSequence)"ec") ? "creditorg" : "org";
        return orgFilterField;
    }

    public abstract boolean isPreInt();

    public abstract boolean isPayIntByPlan();

    public abstract Date getStartDate(DynamicObject var1);

    public abstract String getNonIntDataTip();

    public abstract String getExistOnWayDataTip(String var1, String var2);

    public abstract String getEndIntDateTip();

    public abstract void addExclusiveFilter(QFilter var1);
}

