/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill.batch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntbillSofrDetailEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loanIntDetailInfo();
    }

    private void loanIntDetailInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object currency = customParams.get("currency");
        String callIntStr = (String)customParams.get("intdetail");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillExtInfo intBillInfo = (IntBillExtInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillExtInfo.class);
        List details = intBillInfo.getExtDetails();
        details.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailExtInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("startdate", intDetail.getBeginDate());
            data.put("enddate", intDetail.getEndDate());
            data.put("intdays", intDetail.getDays());
            data.put("principle", intDetail.getPrinciple());
            data.put("rate", intDetail.getRate().subtract(intDetail.getFloatRate()));
            data.put("intdate", intDetail.getBeginDate());
            data.put("currency", currency);
            data.put("interestamt", intDetail.getBenchmarkInt());
            data.put("basis", intDetail.getBasisDay());
            data.put("intcategory", intDetail.getIntType().getValue());
            data.put("floatint", intDetail.getFloatInt());
            data.put("floatrate", intDetail.getFloatRate());
            data.put("lasttotalint", intDetail.getLastTotalInt());
            data.put("curtotalint", intDetail.getCurTotalInt());
            Date beginConfirmDate = intDetail.getBeginConfirmDate();
            Date endConfirmDate = intDetail.getEndConfirmDate();
            if (beginConfirmDate != null && endConfirmDate != null) {
                intDetail.setObserveOffsetDay(1);
                int lookDays = intDetail.getConfirmDays();
                data.put("lookdays", lookDays);
            }
            data.put("confirmratedate", beginConfirmDate);
            data.put("totalint", intDetail.getTotalInt());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
        this.getView().updateView("entry");
    }
}

