/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.tmc.cfm.common.enums.AdjustDirectEnum;
import kd.tmc.cfm.common.enums.RateAdjustCycleTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.helper.IntcalMethodChgHelper;

public class BondLoanBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(BondLoanBillEdit.class);
    private static final Map<String, List<String>> entryOpPropMap = new HashMap<String, List<String>>(16);
    private static final Map<String, String> isSetCondEntryMap;
    private static final Map<String, String> isSparkEntryMap;

    public String getOccupybondlimitCtrlName() {
        return "occupybondlimit";
    }

    public String getDrawAmountCtrlName() {
        return "drawamount";
    }

    public String showDrawAmountEmptyTip() {
        return ResManager.loadKDString((String)"\u53d1\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
    }

    public String getSelfSubscribeAmtCtrlName() {
        return "selfsubscribeamt";
    }

    public String getLoanRateCtrlName() {
        return "loanrate";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit occupyBondLimit = (BasedataEdit)this.getControl(this.getOccupybondlimitCtrlName());
        occupyBondLimit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (this.getOccupybondlimitCtrlName().equals(name)) {
            this.filterOccupyBondLimit(event);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "deletealler": {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6d6e\u52a8\u5229\u7387\u4e0b\u5c06\u6e05\u7a7a\u52a0\u70b9\u6570\u5217\uff0c\u5176\u5b83\u60c5\u51b5\u4e0b\u5c06\u6e05\u7a7a\u5206\u5f55\u6240\u6709\u6570\u636e\u3002", (String)"BondLoanBillEdit_16", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CONFIRM_CALLBACK_DELETEALLER", (IFormPlugin)this));
                break;
            }
            case "quickbuilder": {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5c06\u6e05\u7a7a\u73b0\u6709\u7684\u5168\u90e8\u5229\u7387\u52a0\u70b9\u6570\u4fe1\u606f\uff0c\u518d\u91cd\u65b0\u751f\u6210\u3002", (String)"BondLoanBillEdit_17", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CONFIRM_CALLBACK_QUICKBUILDER", (IFormPlugin)this));
                break;
            }
            case "deleteentryer": {
                this.getView().setEnable(Boolean.FALSE, 0, new String[]{"effectdate_er"});
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (evt.getResult() == MessageBoxResult.Yes) {
            switch (callBackId) {
                case "CONFIRM_CALLBACK_DELETEALLER": {
                    String interestType = (String)this.getModel().getValue("interesttype");
                    if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)interestType)) {
                        this.getModel().getEntryEntity("condition_entry_er").forEach(r -> r.set("pluspoint_er", null));
                    } else {
                        this.getModel().deleteEntryData("condition_entry_er");
                        CfmRateAdjustHelper.buildOneRow((DynamicObject)this.getModel().getDataEntity(true), (DynamicObjectCollection)this.getModel().getEntryEntity("condition_entry_er"));
                        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"effectdate_er"});
                    }
                    this.getView().updateView("condition_entry_er");
                    break;
                }
                case "CONFIRM_CALLBACK_QUICKBUILDER": {
                    this.quickFillResetConditionEntry();
                }
            }
        }
    }

    private void filterOccupyBondLimit(BeforeF7SelectEvent event) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Date bizDate = (Date)this.getModel().getValue(this.getBizDatePropName());
        BigDecimal drawAmount = (BigDecimal)this.getModel().getValue(this.getDrawAmountCtrlName());
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_11", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)finProduct)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u503a\u5238\u54c1\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_13", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_14", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((Object)bizDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_15", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((BigDecimal)drawAmount)) {
            this.getView().showTipNotification(this.showDrawAmountEmptyTip());
            event.setCancel(true);
            return;
        }
        ListFilterParameter listFilterParameter = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(BondLimitHelper.getBondlimitFilter((Long)org.getLong("id"), (Long)currency.getLong("id"), (Long)finProduct.getLong("id"), (Date)bizDate));
        event.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getOccupybondlimitCtrlName()));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(event);
        String key = event.getActionId();
        if (this.getOccupybondlimitCtrlName().equals(key) && EmptyUtil.isNoEmpty((Object)(selectedRows = (ListSelectedRowCollection)event.getReturnData())) && selectedRows.size() > 0) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject limit = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdim_bond_limit", (String)"availamt");
            BigDecimal drawAmount = (BigDecimal)this.getModel().getValue(this.getDrawAmountCtrlName());
            if (drawAmount.compareTo(limit.getBigDecimal("availamt")) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u6ce8\u518c\u989d\u5ea6\u3002", (String)"BondLoanBillEdit_30", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue(this.getOccupybondlimitCtrlName(), primaryKeyValue);
            }
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject contractBillF7;
        super.afterBindData(e);
        this.setNoLastRowAmtFiledEnable();
        this.setEffectDateMaxLimit();
        this.setEffectDateMinLimit();
        if (((Boolean)this.getModel().getValue("issetpluspoint")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"effectdate_er"});
        }
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue() && (contractBillF7 = (DynamicObject)this.getModel().getValue("loancontractbill")) != null) {
            this.getModel().setValue("guaranteeway", contractBillF7.get("guarantee"));
        }
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus")) && pkValue == 0L) {
            this.intcalMethodChgEvt();
        }
        this.setInterestType();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (propName = e.getProperty().getName()) {
            case "issetcond_s": 
            case "issetcond_b": 
            case "issetcond_t": {
                this.delEntryDataAndSetEnableByCond((Boolean)newVal, propName, true);
                break;
            }
            case "isspark_s": 
            case "isspark_b": 
            case "isspark_t": {
                this.delEntryDataAndSetEnableByCond((Boolean)newVal, propName, false);
                break;
            }
            case "recamt_es": {
                this.calAndSetRemaitAmt("condition_entry_s", propName, "remaitamt_es");
                break;
            }
            case "recamt_eb": {
                this.calAndSetRemaitAmt("condition_entry_b", propName, "remaitamt_eb");
                break;
            }
            case "drawamount": {
                this.clearEntryData("condition_entry_s", "condition_entry_b");
                break;
            }
            case "loanrate": {
                this.clearEntryData("condition_entry_t");
                break;
            }
            case "afteradjustinterdate_et": {
                this.validDeaLAdjustInterDate((Date)newVal, rowIndex);
                break;
            }
            case "exercisedate_es": 
            case "exercisedate_eb": {
                String entryName = e.getChangeSet()[0].getDataEntity().getDynamicObjectType().getName();
                this.validAndDealExerciseDate((Date)newVal, rowIndex, entryName, propName);
                break;
            }
            case "exercisedate_et": {
                this.validAndDealExerciseDateET((Date)newVal, rowIndex);
                break;
            }
            case "adjustdir_et": 
            case "adjustpoint_et": 
            case "afteradjustrate_et": {
                this.calAndSetAfterAdjustRate(rowIndex, propName);
                break;
            }
            case "org": 
            case "currency": 
            case "finproduct": {
                this.getModel().setValue(this.getOccupybondlimitCtrlName(), null);
                break;
            }
            case "issetpluspoint": {
                this.setResetConditionFlex();
                break;
            }
            case "startintdate": {
                this.setEffectDateMinLimit();
                this.reBuildPlusEntry();
                break;
            }
            case "bizdate": {
                this.reBuildPlusEntry();
                break;
            }
            case "expiredate": 
            case "term": {
                this.setEffectDateMaxLimit();
                break;
            }
            case "rateadjustcycletype": {
                if (!this.isSetValueWhenChanged()) break;
                this.getModel().setValue("ratejumpcyclekey", this.getModel().getValue("rateadjustcycletype"));
                break;
            }
            case "rateadjustcycle": {
                if (!this.isSetValueWhenChanged()) break;
                this.getModel().setValue("ratejumpcycleval", this.getModel().getValue("rateadjustcycle"));
                break;
            }
            case "e_investamount": 
            case "e_isselfsubscribe": {
                this.calSelfSubscribeAmount();
                break;
            }
            case "intcalmethod": {
                this.intcalMethodChgEvt();
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String fieldName = source.getKey();
        if (StringUtils.equals((CharSequence)"effectdate_er", (CharSequence)fieldName) && this.isPepertualAndAgree()) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity("condition_entry_er");
            Set effectDateSet = rows.stream().map(r -> r.getDate("effectdate_er")).collect(Collectors.toSet());
            Object value = e.getValue();
            if (EmptyUtil.isNoEmpty((Object)value) && effectDateSet.contains(DateUtils.stringToDate((String)((String)value), (String)"yyyy-MM-dd"))) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u751f\u6548\u65e5\u671f\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BondLoanBillEdit_31", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("effectdate_er", e.getRowIndex());
            }
        }
    }

    protected void clearEntryData(String ... entryProps) {
        for (String entryProp : entryProps) {
            this.getModel().deleteEntryData(entryProp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String entryName = (String)formOperate.getParameter().get("entryId");
        switch (operateKey) {
            case "newentrys": 
            case "newentryb": 
            case "newentryt": {
                this.validLastRowMustInput(entryName, args);
                break;
            }
            case "deleteentrys": 
            case "deleteentryb": 
            case "deleteentryt": {
                this.validOnlyDelLastRow(entryName, args);
                break;
            }
            case "quickbuilder": {
                this.validateForQuickBuild(args);
                break;
            }
            case "deleteentryer": {
                this.validatePlusEntryFirstRow(args);
                break;
            }
            case "save": {
                this.setVariForSaveOp(formOperate);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        block5: {
            String entryName;
            block4: {
                super.afterAddRow(e);
                EntryProp entryProp = e.getEntryProp();
                entryName = entryProp.getName();
                if (!"condition_entry_s".equals(entryName) && !"condition_entry_b".equals(entryName)) break block4;
                for (RowDataEntity row : e.getRowDataEntities()) {
                    int index = row.getRowIndex();
                    if (index <= 0) continue;
                    if ("condition_entry_s".equals(entryName)) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exercisedate_es", null, (int)index);
                        continue;
                    }
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exercisedate_eb", null, (int)index);
                }
                break block5;
            }
            if (!"condition_entry_t".equals(entryName)) break block5;
            this.setNoLastRowAmtFiledEnable();
            BigDecimal loanRate = (BigDecimal)this.getModel().getValue(this.getLoanRateCtrlName());
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index == 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"beforeadjustrate_et", (Object)loanRate, (int)index);
                    continue;
                }
                if (index <= 0) continue;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exercisedate_et", null, (int)index);
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("condition_entry_t", index - 1);
                BigDecimal afterAdjustRate = entryRowEntity.getBigDecimal("afteradjustrate_et");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"beforeadjustrate_et", (Object)afterAdjustRate, (int)index);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("condition_entry_t".equals(entryName)) {
            this.setNoLastRowAmtFiledEnable();
        } else if ("investor_entry".equals(entryName)) {
            this.calSelfSubscribeAmount();
        }
    }

    protected void delEntryDataAndSetEnableByCond(boolean newVal, String propName, boolean isSetCond) {
        Map<String, String> map = isSetCond ? isSetCondEntryMap : isSparkEntryMap;
        String entryProp = map.get(propName);
        List<String> opEntryFlags = entryOpPropMap.get(entryProp);
        for (String opEntryFlag : opEntryFlags) {
            if (isSetCond) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{opEntryFlag});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(newVal), new String[]{opEntryFlag});
        }
        if (!newVal) {
            this.getModel().deleteEntryData(entryProp);
        }
    }

    protected void calAndSetRemaitAmt(String entryName, String propName, String tagPropName) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(entryName);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            for (int i = 0; i < entrys.size(); ++i) {
                BigDecimal currRowRemaitAmt = this.getCurrRowRemaitAmt(entrys, propName, i + 1);
                if (BigDecimal.ZERO.compareTo(currRowRemaitAmt) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5269\u4f59\u503a\u5238\u672c\u91d1\u503c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"BondLoanBillEdit_12", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)BigDecimal.ZERO, (int)i);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)tagPropName, (Object)BigDecimal.ZERO, (int)i);
                    continue;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)tagPropName, (Object)currRowRemaitAmt, (int)i);
            }
        }
    }

    protected void calAndSetAfterAdjustRate(int rowIndex, String propName) {
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("condition_entry_t", rowIndex);
        BigDecimal beforeAdjRate = rowInfo.getBigDecimal("beforeadjustrate_et");
        logger.info("\u8c03\u6574\u524d\u5229\u7387\u4e3a:" + beforeAdjRate);
        if ("adjustpoint_et".equals(propName) || "adjustdir_et".equals(propName)) {
            BigDecimal adjPoint = rowInfo.getBigDecimal("adjustpoint_et");
            if ("adjustdir_et".equals(propName) && EmptyUtil.isEmpty((BigDecimal)adjPoint)) {
                return;
            }
            String adjDir = rowInfo.getString("adjustdir_et");
            BigDecimal amtFlag = BigDecimal.ONE;
            if (AdjustDirectEnum.DOWN.getValue().equals(adjDir)) {
                amtFlag = amtFlag.negate();
            }
            BigDecimal calAfterAdjRate = beforeAdjRate.add(amtFlag.multiply(adjPoint).divide(new BigDecimal("100").setScale(6, RoundingMode.HALF_UP)));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"afteradjustrate_et", (Object)calAfterAdjRate, (int)rowIndex);
        } else if ("afteradjustrate_et".equals(propName)) {
            BigDecimal aftAdjRate = rowInfo.getBigDecimal("afteradjustrate_et");
            if (beforeAdjRate.compareTo(aftAdjRate) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u7968\u9762\u5229\u7387(%)\u4e0d\u80fd\u548c\u8c03\u6574\u524d\u5229\u7387(%)\u76f8\u7b49,\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BondLoanBillEdit_7", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(propName, (Object)BigDecimal.ZERO, rowIndex);
                return;
            }
            BigDecimal calAdjustPoint = aftAdjRate.subtract(beforeAdjRate).multiply(new BigDecimal("100"));
            String calAdjustDir = AdjustDirectEnum.UP.getValue();
            if (BigDecimal.ZERO.compareTo(calAdjustPoint) > 0) {
                calAdjustDir = AdjustDirectEnum.DOWN.getValue();
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"adjustpoint_et", (Object)calAdjustPoint.abs(), (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"adjustdir_et", (Object)calAdjustDir, (int)rowIndex);
        }
    }

    private BigDecimal getCurrRowRemaitAmt(DynamicObjectCollection entrys, String recAmtFiled, int rowIndex) {
        BigDecimal publishAmt = (BigDecimal)this.getModel().getValue(this.getDrawAmountCtrlName());
        BigDecimal recAmt = entrys.stream().limit(rowIndex).map(o -> o.getBigDecimal(recAmtFiled)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return publishAmt.subtract(recAmt);
    }

    protected void validOnlyDelLastRow(String entryName, BeforeDoOperationEventArgs args) {
        int entryRowCount = this.getModel().getEntryRowCount(entryName);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u591a\u884c\u5220\u9664\u3002", (String)"BondLoanBillEdit_25", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (entryRowCount > 0 && selectRows[0] != entryRowCount - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u6700\u540e\u4e00\u884c\u5206\u5f55\u3002", (String)"BondLoanBillEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected void validLastRowMustInput(String entryName, BeforeDoOperationEventArgs args) {
        DynamicObject lastRowInfo;
        int entryRowCount = this.getModel().getEntryRowCount(entryName);
        BigDecimal publishAmt = (BigDecimal)this.getModel().getValue(this.getDrawAmountCtrlName());
        if (EmptyUtil.isEmpty((BigDecimal)publishAmt)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (entryRowCount >= 1 && "condition_entry_t".equals(entryName) && EmptyUtil.isEmpty((Object)(lastRowInfo = this.getModel().getEntryRowEntity(entryName, entryRowCount - 1)).get("afteradjustrate_et"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4e00\u884c\u7684\u8c03\u6574\u540e\u7968\u9762\u5229\u7387(%)\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected void validDeaLAdjustInterDate(Date newVal, int rowIndex) {
        DynamicObject nextRowInfo;
        Date nextExcDate;
        int entryRowCount = this.getModel().getEntryRowCount("condition_entry_t");
        DynamicObject thisRowInfo = this.getModel().getEntryRowEntity("condition_entry_t", rowIndex);
        Date exerciseDate = thisRowInfo.getDate("exercisedate_et");
        if (EmptyUtil.isEmpty((Object)exerciseDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u884c\u6743\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"afteradjustinterdate_et", null, (int)rowIndex);
            return;
        }
        if (EmptyUtil.isNoEmpty((Object)newVal) && newVal.compareTo(exerciseDate) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u8c03\u6574\u540e\u8d77\u606f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u884c\u6743\u65e5\u671f\u3002", (String)"BondLoanBillEdit_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"afteradjustinterdate_et", null, (int)rowIndex);
        }
        if (EmptyUtil.isNoEmpty((Object)newVal) && rowIndex != entryRowCount - 1 && EmptyUtil.isNoEmpty((Object)(nextExcDate = (nextRowInfo = this.getModel().getEntryRowEntity("condition_entry_t", rowIndex + 1)).getDate("exercisedate_et"))) && newVal.compareTo(nextExcDate) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u8c03\u6574\u540e\u8d77\u606f\u65e5\u5fc5\u987b\u5c0f\u4e8e\u4e0b\u4e00\u884c\u7684\u884c\u6743\u65e5\u671f\u3002", (String)"BondLoanBillEdit_9", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"afteradjustinterdate_et", null, (int)rowIndex);
        }
    }

    protected void validAndDealExerciseDateET(Date currRowexcDate, int rowIndex) {
        DynamicObject nextRowInfo;
        Date nextExcDate;
        DynamicObject lastRowInfo;
        Date lastExcDate;
        int entryRowCount = this.getModel().getEntryRowCount("condition_entry_t");
        if (EmptyUtil.isNoEmpty((Object)currRowexcDate) && entryRowCount > 1 && rowIndex > 0 && EmptyUtil.isNoEmpty((Object)(lastExcDate = (lastRowInfo = this.getModel().getEntryRowEntity("condition_entry_t", rowIndex - 1)).getDate("afteradjustinterdate_et"))) && currRowexcDate.compareTo(lastExcDate) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u884c\u6743\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u884c\u7684\u8c03\u6574\u540e\u8d77\u606f\u65e5\u3002", (String)"BondLoanBillEdit_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exercisedate_et", null, (int)rowIndex);
        }
        if (EmptyUtil.isNoEmpty((Object)currRowexcDate) && rowIndex != entryRowCount - 1 && EmptyUtil.isNoEmpty((Object)(nextExcDate = (nextRowInfo = this.getModel().getEntryRowEntity("condition_entry_t", rowIndex + 1)).getDate("exercisedate_et"))) && currRowexcDate.compareTo(nextExcDate) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u884c\u6743\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u4e0b\u4e00\u884c\u7684\u884c\u6743\u65e5\u671f\u3002", (String)"BondLoanBillEdit_8", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exercisedate_et", null, (int)rowIndex);
        }
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("condition_entry_t", rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"afteradjustinterdate_et", (Object)rowInfo.getDate("exercisedate_et"), (int)rowIndex);
    }

    protected void validAndDealExerciseDate(Date currRowexcDate, int rowIndex, String entryName, String exerciseDateField) {
        DynamicObject nextRowInfo;
        Date nextExcdate;
        DynamicObject lastRowInfo;
        Date lastExcDate;
        int entryRowCount = this.getModel().getEntryRowCount(entryName);
        if (EmptyUtil.isNoEmpty((Object)currRowexcDate) && entryRowCount > 1 && rowIndex > 0 && EmptyUtil.isNoEmpty((Object)(lastExcDate = (lastRowInfo = this.getModel().getEntryRowEntity(entryName, rowIndex - 1)).getDate(exerciseDateField))) && currRowexcDate.compareTo(lastExcDate) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u884c\u6743\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u884c\u7684\u884c\u6743\u65e5\u671f\u3002", (String)"BondLoanBillEdit_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)exerciseDateField, null, (int)rowIndex);
        }
        if (EmptyUtil.isNoEmpty((Object)currRowexcDate) && rowIndex != entryRowCount - 1 && EmptyUtil.isNoEmpty((Object)(nextExcdate = (nextRowInfo = this.getModel().getEntryRowEntity(entryName, rowIndex + 1)).getDate(exerciseDateField))) && currRowexcDate.compareTo(nextExcdate) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u884c\u6743\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u4e0b\u4e00\u884c\u7684\u884c\u6743\u65e5\u671f\u3002", (String)"BondLoanBillEdit_8", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)exerciseDateField, null, (int)rowIndex);
        }
    }

    protected void setNoLastRowAmtFiledEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("condition_entry_t");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
            int rowNum = entryEntity.size();
            this.getView().setEnable(Boolean.valueOf(true), rowNum - 1, new String[]{"adjustdir_et", "adjustpoint_et", "afteradjustrate_et"});
            if (rowNum > 1) {
                for (int i = entryEntity.size() - 2; i >= 0; --i) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"adjustdir_et", "adjustpoint_et", "afteradjustrate_et"});
                }
            }
        }
    }

    protected void setResetConditionFlex() {
        boolean isSetPlusPoint = (Boolean)this.getModel().getValue("issetpluspoint");
        if (!isSetPlusPoint) {
            this.getModel().setValue("ratejumpcyclekey", null);
            this.getModel().setValue("ratejumpcycleval", null);
            this.getModel().setValue("ratejumpperpoint", null);
            this.getModel().deleteEntryData("condition_entry_er");
        } else {
            String interestType = (String)this.getModel().getValue("interesttype");
            if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)interestType)) {
                String rateAdjustType = (String)this.getModel().getValue("rateadjuststyle");
                if (StringUtils.equals((CharSequence)RateAdjustStyleEnum.CYCLE.getValue(), (CharSequence)rateAdjustType)) {
                    this.getModel().setValue("ratejumpcyclekey", this.getModel().getValue("rateadjustcycletype"));
                    this.getModel().setValue("ratejumpcycleval", this.getModel().getValue("rateadjustcycle"));
                }
            } else {
                this.getModel().setValue("ratejumpcyclekey", (Object)RateAdjustCycleTypeEnum.M.getValue());
            }
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            Date startIntDate = (Date)this.getModel().getValue("startintdate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizDate, startIntDate})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u53d1\u884c\u65e5\u671f\u548c\u8d77\u606f\u65e5\u671f\u3002", (String)"BondLoanBillEdit_26", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
            CfmRateAdjustHelper.autoFillResetConditionEntry((DynamicObject)this.getModel().getDataEntity(true));
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"effectdate_er"});
            this.getView().updateView("condition_entry_er");
        }
    }

    private void quickFillResetConditionEntry() {
        List dateRange;
        String interestType = (String)this.getModel().getValue("interesttype");
        if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)interestType)) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity("condition_entry_er");
            dateRange = entry.stream().map(r -> r.getDate("effectdate_er")).collect(Collectors.toList());
        } else {
            dateRange = CfmRateAdjustHelper.getDateRange((IDataModel)this.getModel());
        }
        List entryList = CfmRateAdjustHelper.buildEntryFields((IDataModel)this.getModel(), (List)dateRange);
        TmcViewInputHelper.batchFillEntity((String)"condition_entry_er", (AbstractFormDataModel)((BillModel)this.getModel()), (List)entryList);
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"effectdate_er"});
        this.getView().updateView("condition_entry_er");
    }

    protected void validateForQuickBuild(BeforeDoOperationEventArgs evt) {
        BigDecimal rateJumpPoint;
        Integer rateJumpVal;
        String rateJumpKey;
        DynamicObjectCollection rateAdjustEntry = this.getModel().getEntryEntity("rateadjust_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)rateAdjustEntry) && InterestTypeEnum.FLOAT.getValue().equals(this.getModel().getValue("interesttype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u8bbe\u7f6e\u91cd\u7f6e\u6761\u6b3e\u3002", (String)"BondLoanBillEdit_21", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rateJumpKey = (String)this.getModel().getValue("ratejumpcyclekey"), rateJumpVal = (Integer)this.getModel().getValue("ratejumpcycleval"), rateJumpPoint = (BigDecimal)this.getModel().getValue("ratejumpperpoint")})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8df3\u5347\u5468\u671f\u4e0e\u6bcf\u6b21\u8df3\u5347\u70b9\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_22", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        LoanBillFormHelper.validateRateRangeLimit(evt, this.getView(), this.getModel());
    }

    protected void setEffectDateMaxLimit() {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (EmptyUtil.isNoEmpty((Object)expireDate)) {
            Optional.ofNullable((DateEdit)this.getControl("effectdate_er")).ifPresent(r -> r.setMaxDate(expireDate));
        } else {
            Optional.ofNullable((DateEdit)this.getControl("effectdate_er")).ifPresent(r -> r.setMaxDate(DateUtils.getCommonMaxDate()));
        }
    }

    protected void setEffectDateMinLimit() {
        Date intStartDate = (Date)this.getModel().getValue("startintdate");
        if (EmptyUtil.isNoEmpty((Object)intStartDate)) {
            String interestType = (String)this.getModel().getValue("interesttype");
            if (EmptyUtil.isNoEmpty((String)interestType) && StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)interestType)) {
                Optional.ofNullable((DateEdit)this.getControl("effectdate_er")).ifPresent(r -> r.setMinDate(intStartDate));
            } else {
                Date bizDate = (Date)this.getModel().getValue("bizdate");
                if (EmptyUtil.isNoEmpty((Object)bizDate) && bizDate.before(intStartDate)) {
                    Optional.ofNullable((DateEdit)this.getControl("effectdate_er")).ifPresent(r -> r.setMinDate(DateUtils.getNextDay((Date)bizDate, (int)1)));
                } else {
                    Optional.ofNullable((DateEdit)this.getControl("effectdate_er")).ifPresent(r -> r.setMinDate(DateUtils.getNextDay((Date)intStartDate, (int)1)));
                }
            }
        }
    }

    protected boolean isPepertualAndAgree() {
        String intestType = (String)this.getModel().getValue("interesttype");
        boolean isPerpetual = (Boolean)this.getModel().getValue("issetpluspoint");
        return isPerpetual && (InterestTypeEnum.isFixed((String)intestType) || InterestTypeEnum.isAgree((String)intestType));
    }

    protected void reBuildPlusEntry() {
        if (this.isPepertualAndAgree()) {
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            Date startIntDate = (Date)this.getModel().getValue("startintdate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizDate, startIntDate})) {
                return;
            }
            List dateRange = CfmRateAdjustHelper.getDateRange((IDataModel)this.getModel());
            List entryList = CfmRateAdjustHelper.buildEntryFields((IDataModel)this.getModel(), (List)dateRange);
            TmcViewInputHelper.batchFillEntity((String)"condition_entry_er", (AbstractFormDataModel)((BillModel)this.getModel()), (List)entryList);
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"effectdate_er"});
            this.getView().updateView("condition_entry_er");
        }
    }

    protected void setVariForSaveOp(FormOperate formOperate) {
        if (this.getModel().getProperty("issetpluspoint") == null) {
            return;
        }
        boolean isPerpetual = (Boolean)this.getModel().getValue("issetpluspoint");
        if (isPerpetual && LoanBillFormHelper.judgeDataIsChanged(this.getModel())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5229\u7387\u91cd\u7f6e\u5206\u5f55\u5df2\u53d8\u66f4\uff0c\u5229\u7387\u52a0\u70b9\u6570\u5206\u5f55\u7684\u52a0\u70b9\u6570\u5c06\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"BondLoanBillEdit_23", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            formOperate.getOption().setVariableValue("IS_UPDATE_OPERATE", "Y");
        }
    }

    protected void validatePlusEntryFirstRow(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("condition_entry_er");
        int[] selectRows = entryGrid.getSelectRows();
        long count = Arrays.stream(selectRows).filter(r -> r == 0).count();
        if (count >= 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5229\u7387\u52a0\u70b9\u6570\u5206\u5f55\u7b2c\u4e00\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BondLoanBillEdit_28", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected boolean isSetValueWhenChanged() {
        Boolean isPerpetual = Optional.ofNullable((DynamicObject)this.getModel().getValue("finproduct")).map(r -> r.getBoolean("perpetualbond")).orElse(Boolean.FALSE);
        boolean isSetPoint = (Boolean)this.getModel().getValue("issetpluspoint");
        return isPerpetual != false && isSetPoint;
    }

    protected void calSelfSubscribeAmount() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("investor_entry");
        BigDecimal selfSubscribeAmt = BigDecimal.ZERO;
        for (DynamicObject rowInfo : entryEntity) {
            boolean isSelfSubscribe = rowInfo.getBoolean("e_isselfsubscribe");
            BigDecimal investAmount = rowInfo.getBigDecimal("e_investamount");
            selfSubscribeAmt = isSelfSubscribe ? selfSubscribeAmt.add(investAmount) : selfSubscribeAmt;
        }
        this.getModel().setValue(this.getSelfSubscribeAmtCtrlName(), (Object)selfSubscribeAmt);
    }

    private void intcalMethodChgEvt() {
        String intcalMethod = (String)this.getModel().getValue("intcalmethod");
        String billStatus = (String)this.getModel().getValue("billstatus");
        ComboEdit basis = (ComboEdit)this.getControl("basis");
        if (basis == null || EmptyUtil.isEmpty((String)intcalMethod)) {
            return;
        }
        List comboItems = IntcalMethodChgHelper.getBasisComboItem((String)intcalMethod, (String)billStatus);
        basis.setComboItems(comboItems);
        if (EmptyUtil.isNoEmpty((Object)comboItems)) {
            this.getModel().setValue("basis", (Object)((ComboItem)comboItems.get(0)).getValue());
        }
    }

    private void setInterestType() {
        String bondType = (String)this.getModel().getValue("bondtype");
        ComboEdit intType = (ComboEdit)this.getControl("interesttype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if (StringUtils.equals((CharSequence)"floatratebond", (CharSequence)bondType)) {
            ComboItem comboItem0 = new ComboItem();
            comboItem0.setCaption(new LocaleString(InterestTypeEnum.getName((String)InterestTypeEnum.FLOAT.getValue())));
            comboItem0.setValue(InterestTypeEnum.FLOAT.getValue());
            comboItems.add(comboItem0);
        } else {
            ComboItem comboItem0 = new ComboItem();
            comboItem0.setCaption(new LocaleString(InterestTypeEnum.getName((String)InterestTypeEnum.FIXED.getValue())));
            comboItem0.setValue(InterestTypeEnum.FIXED.getValue());
            comboItems.add(comboItem0);
            if (BillStatusEnum.AUDIT.getValue().equals(this.getModel().getValue("billstatus"))) {
                ComboItem comboItem1 = new ComboItem();
                comboItem1.setCaption(new LocaleString(InterestTypeEnum.getName((String)InterestTypeEnum.AGREE.getValue())));
                comboItem1.setValue(InterestTypeEnum.AGREE.getValue());
                comboItems.add(comboItem1);
            }
        }
        intType.setComboItems(comboItems);
        if (StringUtils.equals((CharSequence)"floatratebond", (CharSequence)bondType)) {
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FLOAT.getValue());
        }
        this.getView().setEnable(Boolean.valueOf(!StringUtils.equals((CharSequence)"floatratebond", (CharSequence)bondType)), new String[]{"interesttype"});
    }

    protected String getBizDatePropName() {
        return "bizdate";
    }

    static {
        entryOpPropMap.put("condition_entry_s", Arrays.asList("newentrys", "deleteentrys"));
        entryOpPropMap.put("condition_entry_b", Arrays.asList("newentryb", "deleteentryb"));
        entryOpPropMap.put("condition_entry_t", Arrays.asList("newentryt", "deleteentryt"));
        isSetCondEntryMap = new HashMap<String, String>(16);
        isSetCondEntryMap.put("issetcond_s", "condition_entry_s");
        isSetCondEntryMap.put("issetcond_b", "condition_entry_b");
        isSetCondEntryMap.put("issetcond_t", "condition_entry_t");
        isSparkEntryMap = new HashMap<String, String>(16);
        isSparkEntryMap.put("isspark_s", "condition_entry_s");
        isSparkEntryMap.put("isspark_b", "condition_entry_b");
        isSparkEntryMap.put("isspark_t", "condition_entry_t");
    }
}

