/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.InschemeEnum;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestPlanTabPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit intAccount = (BasedataEdit)this.getControl("intaccount");
        intAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isDataChange = this.getModel().getDataChanged();
        this.getView().setVisible(Boolean.valueOf(CfmRateAdjustHelper.isCanRateAdjustOp((DynamicObject)this.getModel().getDataEntity())), new String[]{"bar_adjustinterest"});
        this.getModel().setDataChanged(isDataChange);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getProperty().getName()) {
            case "intaccount": {
                this.setIntAccountFilter(evt);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "rateadjust": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("formId", "cfm_rateadjust");
                param.put("formPrimId", this.getModel().getDataEntity().getPkValue());
                param.put("fromEntityBill", ((BillShowParameter)this.getView().getFormShowParameter()).getFormId());
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cfm_rateadjust_callback"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    private void setIntAccountFilter(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{org, currency})) {
            QFilter qFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
            QFilter acctFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
            qFilter.and(acctFilter);
            qFilter.and("currency.fbasedataid", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "interestsettledplan": {
                this.customSettleSchemeHandle();
                break;
            }
        }
    }

    private void customSettleSchemeHandle() {
        DynamicObject settlePlan = (DynamicObject)this.getModel().getValue("interestsettledplan");
        boolean isCustom = settlePlan != null && InschemeEnum.isCustom((String)settlePlan.getString("intereststpd"));
        this.getView().setEnable(Boolean.valueOf(!isCustom), new String[]{"handinstplan"});
        this.getModel().setValue("handinstplan", (Object)isCustom);
    }
}

