/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class LoanBillBatchList
extends AbstractTmcBillBaseList {
    private static final String LOAN_BILL_PROPS = String.join((CharSequence)",", "id", "datasource", "billstatus", "drawtype", "confirmstatus", "productfactory", "creditortype", String.join((CharSequence)".", "productfactory", "iscallint"), "repaymentway");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"pushtointerestbill", (CharSequence)operateKey)) {
            this.checkPush2interestBill(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"pushtointerestbill", (CharSequence)operateKey) && args.getOperationResult().isSuccess()) {
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            String srcFormId = parameter.getBillFormId();
            this.openIntBatchEdit(srcFormId);
        }
    }

    private void checkPush2interestBill(BeforeDoOperationEventArgs args) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        DynamicObjectCollection loanBillDos = QueryServiceHelper.query((String)"cfm_loanbill", (String)LOAN_BILL_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
        for (DynamicObject loanBillDO : loanBillDos) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBillDO.getString("datasource"));
            String billstatus = loanBillDO.getString("billstatus");
            String drawtype = loanBillDO.getString("drawtype");
            Long productFactory = loanBillDO.getLong("productfactory");
            if (EmptyUtil.isNoEmpty((Long)productFactory) && !loanBillDO.getBoolean(String.join((CharSequence)".", "productfactory", "iscallint"))) {
                this.getView().showTipNotification(bizResource.getProductIsCallint());
                args.setCancel(true);
                return;
            }
            if (!CfmBillCommonHelper.pushOpConfirmStatusValid((DynamicObject)loanBillDO)) {
                this.getView().showTipNotification(bizResource.getConfirmStatusError());
                args.setCancel(true);
                return;
            }
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                if (StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.CLOSEOUT.getValue()) || StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.DRAWING.getValue())) {
                    this.getView().showErrorNotification(bizResource.getLbLoanbillPushInterestBillError());
                    args.setCancel(true);
                    return;
                }
            } else {
                this.getView().showErrorNotification(bizResource.getLbPushInterestBillError());
                args.setCancel(true);
                return;
            }
            String repaymentWay = loanBillDO.getString("repaymentway");
            ArrayList repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.dbdx.getValue()});
            if (!repayWays.contains(repaymentWay)) continue;
            this.getView().showErrorNotification(bizResource.getLbDedxPushInterestBillError());
            args.setCancel(true);
        }
        this.checkBankLoan(args, loanBillDos);
    }

    private boolean checkBankLoan(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills) {
        boolean isSettleCenterLoan;
        return !StringUtils.equals((CharSequence)"cfm_loanbill_b_l", (CharSequence)this.getFormId()) || this.isSettleCenterLoan(args, loanBills, isSettleCenterLoan = LoanBillBatchList.isAllSettleCenterLoan(loanBills));
    }

    private boolean isSettleCenterLoan(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills, boolean isSettleCenterLoan) {
        if (!isSettleCenterLoan && !loanBills.stream().noneMatch(d -> StringUtils.equals((CharSequence)d.getString("creditortype"), (CharSequence)CreditorTypeEnum.SETTLECENTER.getValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u503a\u6743\u4eba\u9700\u540c\u65f6\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u6216\u975e\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"LoanBillBatchList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private static boolean isAllSettleCenterLoan(DynamicObjectCollection loanBills) {
        return loanBills.stream().allMatch(d -> StringUtils.equals((CharSequence)d.getString("creditortype"), (CharSequence)CreditorTypeEnum.SETTLECENTER.getValue()));
    }

    private String getFormId() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getBillFormId();
    }

    protected void openIntBatchEdit(String srcFormId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("cfm_navigate_addnew");
        Object[] loanBills = this.getLoanBills();
        String dJson = DynamicObjectSerializeUtil.serialize((Object[])loanBills, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_loanbill"));
        boolean isPayIntByPlan = this.isPayIntByPlan((DynamicObject[])loanBills, srcFormId);
        parameter.setCustomParam("loanbill", (Object)dJson);
        parameter.setCustomParam("loanInt", (Object)true);
        parameter.setCustomParam("fromLoanBill", (Object)true);
        parameter.setCustomParam("isPayIntByPlan", (Object)isPayIntByPlan);
        this.configBatchIntViewParam(parameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_FILTER"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss sc = new StyleCss();
        sc.setHeight("340px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        this.getView().showForm(parameter);
    }

    private void configBatchIntViewParam(FormShowParameter parameter) {
        BillList billList = (BillList)this.getControl("billlistap");
        String formId = billList.getBillFormId();
        BatchIntViewInfoEnum batchIntViewInfo = BatchIntViewInfoEnum.getInfoEnum((String)formId, (String)"loan");
        parameter.setCustomParam("formid", (Object)batchIntViewInfo.getFormId());
    }

    private boolean isPayIntByPlan(DynamicObject[] loanBills, String srcFormId) {
        ArrayList<Long> ids = new ArrayList<Long>(loanBills.length);
        for (DynamicObject loanBill : loanBills) {
            boolean isPayIntByPlan = CfmContractBillHelper.isPayIntByPlan((DynamicObject)loanBill);
            if (!isPayIntByPlan) continue;
            ids.add(loanBill.getLong("id"));
        }
        if (ids.size() > 0 && ids.size() < loanBills.length) {
            String message = String.format(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e%s\u7ec4\u7ec7\u7684\u6309\u4ed8\u606f\u8ba1\u5212\u4ed8\u606f\u7684\u53c2\u6570\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u6279\u91cf\u4ed8\u606f/\u6536\u606f\u3002", (String)"LoanBillBatchList_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), this.getOrgName(srcFormId));
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{message});
        }
        return ids.size() == loanBills.length;
    }

    private String getOrgName(String srcFormId) {
        switch (srcFormId) {
            case "cim_invest_loanbill": {
                return ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"LoanBillBatchList_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            }
            case "cfm_loanbill_bond": {
                return ResManager.loadKDString((String)"\u53d1\u884c\u4eba", (String)"LoanBillBatchList_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            }
            case "ifm_loanbill": {
                return ResManager.loadKDString((String)"\u501f\u6b3e\u5355\u4f4d", (String)"LoanBillBatchList_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u501f\u6b3e\u4eba", (String)"LoanBillBatchList_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
    }

    protected DynamicObject[] getLoanBills() {
        DynamicObject[] loanBills = LoanBillRepository.getLoanBillsByPayInt((Object[])this.getSelectedIdList().toArray());
        if (loanBills.length <= 0) {
            String message = ResManager.loadKDString((String)"\u5df2\u653e\u6b3e\u6216\u5df2\u90e8\u5206\u6536\u56de\u6216\u5df2\u8fd8\u6e05\u7684\u653e\u6b3e\u5355\u53ef\u4ee5\u64cd\u4f5c\u7ed3\u606f\u3002", (String)"LoanBillBatchList_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{message});
        }
        return loanBills;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            this.initShowParameter((FormShowParameter)parameter);
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_EXIST"));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_EXIST", (CharSequence)evt.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private void initShowParameter(FormShowParameter parameter) {
        String formId;
        switch (formId = CfmBillCommonHelper.getFormIdByShowParameter((IFormView)this.getView())) {
            case "cfm_loanbill_b_l": {
                parameter.setFormId("cfm_intbill_batch_b");
                parameter.setCustomParam("formid", (Object)"cfm_intbill_batch_b");
                break;
            }
            case "cfm_loanbill_e_l": {
                parameter.setFormId("cfm_intbill_batch_e");
                parameter.setCustomParam("formid", (Object)"cfm_intbill_batch_e");
                break;
            }
            case "cim_invest_loanbill": {
                parameter.setFormId("cfm_intbill_batch_invest");
                parameter.setCustomParam("formid", (Object)"cfm_intbill_batch_invest");
                break;
            }
            case "cfm_loanbill_bond": {
                parameter.setFormId("cfm_intbill_batch_bond");
                parameter.setCustomParam("formid", (Object)"cfm_intbill_batch_bond");
                break;
            }
            case "ifm_loanbill": {
                parameter.setFormId("ifm_intbill_batch_loan");
                parameter.setCustomParam("formid", (Object)"ifm_intbill_batch_loan");
                break;
            }
        }
    }
}

