/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.helper.LoanBillApplyHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RateHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.CfmPush2PayFormOrListHelper;
import kd.tmc.cfm.formplugin.common.CommonBillFormHelper;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String AFTER_CONFIRM_LOANRATE = "afterConfirmLoanRate";
    private static final String CONFIRM_LOANRATE_CALLBACK = "confirmLoanRateCallback";
    private static String[] BEFOREF7_PROPS = new String[]{"accountbank", "loaneracctbank", "referencerate", "lenddraccount", "lendcraccount", "loandraccount", "loancraccount", "currency"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)false);
    }

    public void registerListener(EventObject e) {
        TextEdit loanContractNumber = (TextEdit)this.getControl("contractbillno");
        loanContractNumber.addClickListener((ClickListener)this);
        for (String prop : BEFOREF7_PROPS) {
            BasedataEdit control = (BasedataEdit)this.getControl(prop);
            if (control == null) continue;
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", null);
        this.getModel().setValue("creditorg", null);
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "contractbillno": {
                    this.drawContractBill();
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        CfmPush2PayFormOrListHelper.formPush2PayForwardValid(args, this.getView());
        switch (operateKey) {
            case "pushtorepaymentbill": {
                this.checkPushToRepaymentBill(args);
                this.isOnWayApply(args);
                break;
            }
            case "save": {
                this.updateNotDrawAmount();
                this.checkFixedRepayAmount(args);
                this.checkLoanRate(args);
                this.checkExpireDate(args);
                break;
            }
            case "submit": {
                this.updateNotDrawAmount();
                this.checkFixedRepayAmount(args);
                this.checkLoanRate(args);
                this.checkSubmitMustInput(args);
                this.checkExpireDate(args);
                break;
            }
            case "pushtointerestbill": {
                this.isOnWayApply(args);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!BillStatusEnum.SAVE.getValue().equals(billStatus) || billShowParameter.getStatus() == OperationStatus.VIEW) {
            e.setCheckDataChange(false);
        }
    }

    private void checkSubmitMustInput(BeforeDoOperationEventArgs args) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("contractbillno"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5408\u540c\u5355\u3002", (String)"LoanBillEdit_19", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkExpireDate(BeforeDoOperationEventArgs args) {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (bizDate != null && expireDate != null && expireDate.compareTo(bizDate) <= 0) {
            String dataSource = (String)this.getModel().getValue("datasource");
            if (DataSourceEnum.isBond((String)dataSource)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u53d1\u884c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LoanBillEdit_20", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u653e\u6b3e\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LoanBillEdit_21", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            args.setCancel(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "accountbank": 
            case "loaneracctbank": {
                this.acctBankF7Evt(evt);
                break;
            }
            case "referencerate": {
                RateHelper.referenceRateF7Evt((BeforeF7SelectEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"startintdate");
                break;
            }
            case "lenddraccount": 
            case "lendcraccount": 
            case "loandraccount": 
            case "loancraccount": {
                CommonBillFormHelper.setAccountF7Evt(evt, this.getModel(), this.getView());
                break;
            }
            case "currency": {
                LoanBillFormHelper.currencyF7Evt(evt, this.getModel(), this.getView());
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.registerMustInputByInterestType();
        this.registerMustInputByAdustStyle();
        this.registerMustInputByPoint();
        this.registerAcctbankMustInput();
        this.initDateEnable();
        this.initRateEnable();
        LoanBillFormHelper.initEnableMustInputBySofr(this.getModel(), this.getView());
        this.setPlanBotnVisible();
        this.setCreditLimitEditEnable();
        boolean isDataChange = this.getModel().getDataChanged();
        DynamicObject loanContract = (DynamicObject)this.getModel().getValue("loancontractbill");
        this.getModel().setValue("contractbillno", EmptyUtil.isEmpty((DynamicObject)loanContract) ? null : loanContract.getString("number"));
        this.updateNotDrawAmount();
        this.getModel().setDataChanged(isDataChange);
        this.noCalInstConditionFiledProp();
        this.setInterestSettledPlan();
        BigDecimal bindStartLoanRate = (BigDecimal)this.getModel().getValue("startloanrate");
        if (EmptyUtil.isEmpty((BigDecimal)bindStartLoanRate)) {
            this.setContractInterestRate();
        }
        this.setLatestRate();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_RATEADJUST_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            String customValue = messageBoxClosedEvent.getCustomVaule();
            Map paramMap = (Map)JSON.parseObject((String)customValue, Map.class);
            if (EmptyUtil.isNoEmpty((Object)paramMap)) {
                Long selectedId = (Long)paramMap.get("selectedId");
                Long rateAdjustId = (Long)paramMap.get("rateAdjustId");
                CfmRateAdjustHelper.showRateAdjustForm((Long)rateAdjustId, (Long)selectedId, (IFormView)this.getView());
            }
        } else if (StringUtils.equals((CharSequence)id, (CharSequence)CONFIRM_LOANRATE_CALLBACK) && MessageBoxResult.Yes.equals((Object)res)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(AFTER_CONFIRM_LOANRATE, "1");
            this.getView().invokeOperation("submit", option);
        }
    }

    protected void calcFirstRedeemDate(AbstractBizResource bizResource) {
        if (!"cfm_loanbill_bond".equals(this.getView().getFormShowParameter().getFormId())) {
            return;
        }
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        String firstRedeemTerm = (String)this.getModel().getValue("firstredeemterm");
        Date bizDate = (Date)this.getModel().getValue("startintdate");
        if (EmptyUtil.isEmpty((Object)bizDate)) {
            this.getView().showErrorNotification(bizResource.getValidContractIsNotNull());
            return;
        }
        Date firstRedeemDate = TermHelper.getDateByBaseDate4ymd((String)firstRedeemTerm, (Date)bizDate);
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((String)firstRedeemTerm)) {
            String loanExpireRule = AdjustMethodEnum.no_adjust.getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
                loanExpireRule = productFactory.getString("loanexpireadjustrule");
            }
            firstRedeemDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)firstRedeemDate, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)loanExpireRule));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"firstredeemdate", (Object)firstRedeemDate);
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"firstredeemdate"});
        }
    }

    private void calcFirstRedeemTerm(AbstractBizResource bizResource) {
        if (!"cfm_loanbill_bond".equals(this.getView().getFormShowParameter().getFormId())) {
            return;
        }
        DynamicObject loanContract = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)loanContract)) {
            this.getView().showErrorNotification(bizResource.getValidContractIsNotNull());
            return;
        }
        Date firstRedeemDate = (Date)this.getModel().getValue("firstredeemdate");
        Date bizDate = (Date)this.getModel().getValue("startintdate");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)firstRedeemDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"firstredeemterm", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)firstRedeemDate));
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"firstredeemterm"});
        }
    }

    private void setPlanBotnVisible() {
        if (DrawTypeEnum.CLOSEOUT.getValue().equals(this.getModel().getValue("drawtype"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_updateinstplan", "bar_repaymentsc"});
            return;
        }
        String repaymentWay = (String)this.getModel().getValue("repaymentway");
        if (RepaymentWayEnum.isHbfx((String)repaymentWay)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_updateinstplan", "bar_repaymentsc"});
            return;
        }
        CfmBillCommonHelper.setRepayIntPlanBotnVisable((IFormView)this.getView());
    }

    private void setCreditLimitEditEnable() {
        DynamicObject contractBillF7 = (DynamicObject)this.getModel().getValue("loancontractbill");
        String loanType = (String)this.getModel().getValue("loantype");
        String creditType = (String)this.getModel().getValue("creditortype");
        String dataSource = (String)this.getModel().getValue("datasource");
        if (DataSourceEnum.INVEST.getValue().equals(dataSource) && !CreditorTypeEnum.isInnerUnit((String)(creditType = (String)this.getModel().getValue("debtortype")))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlimit"});
            return;
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)contractBillF7) && CfmContractBillHelper.creditLoanType((String)loanType, (String)creditType)) {
            DynamicObject pfDO = (DynamicObject)this.getModel().getValue("productfactory");
            boolean isCreditLimit = false;
            if (EmptyUtil.isNoEmpty((DynamicObject)pfDO)) {
                isCreditLimit = pfDO.getBoolean("iscreditlimit");
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)contractBillF7.getDynamicObject("creditlimit")) || LoanTypeEnum.isBanksLoan((String)loanType)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlimit"});
            } else if (isCreditLimit) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"creditlimit"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"creditlimit"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"creditlimit"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlimit"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "pushtorepaymentbill": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                if (EmptyUtil.isNoEmpty((Object)this.getPageCache())) {
                    this.getPageCache().put("operationKey", operateKey);
                }
                Long loanId = (Long)this.getModel().getValue("id");
                LoanBillFormHelper.pushRepaymentbill(this.getView(), loanId);
                break;
            }
            case "rateadjustop": {
                if (!args.getOperationResult().isSuccess()) break;
                this.showRateAdjust();
            }
        }
        HashSet<String> refButtons = new HashSet<String>(16);
        refButtons.add("audit");
        refButtons.add("unaudit");
        refButtons.add("save");
        refButtons.add("submit");
        refButtons.add("rateadjust");
        if (refButtons.contains(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setSettleIntModeByRepayWay() {
        String repayWay = (String)this.getModel().getValue("repaymentway");
        HashSet<String> repayWayLSBQ = new HashSet<String>(5);
        repayWayLSBQ.add(RepaymentWayEnum.bqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debj.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dbdx.getValue());
        HashSet<String> repayWayFIX = new HashSet<String>(2);
        repayWayFIX.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWayFIX.add(RepaymentWayEnum.bqhbdqhx.getValue());
        if (repayWayLSBQ.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.lsbq.getValue());
        } else if (repayWayFIX.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "startintdate": {
                if (this.validSEDate(e, key, value)) {
                    return;
                }
                String timeFormStr = ((DateEdit)this.getControl("startintdate")).getFormatString();
                Date startInstDate = DateUtils.stringToDate((String)value.toString(), (String)timeFormStr);
                this.validateFirstRedeemDate(e, key, null, startInstDate, null);
                this.validateFirstRedeemTerm(e, key, null, startInstDate);
                this.validateLoanFirstRateDate(e, key, startInstDate);
                Date expireDate = (Date)this.getModel().getValue("expiredate");
                if (EmptyUtil.isEmpty((Object)expireDate)) {
                    return;
                }
                this.instDateValidAndClear(e, key, startInstDate, expireDate);
                break;
            }
            case "bizdate": {
                if (this.validSEDate(e, key, value)) {
                    return;
                }
                String fmtStr = ((DateEdit)this.getControl("bizdate")).getFormatString();
                Date startDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
                this.validateFirstRedeemDate(e, key, null, null, startDate);
                Date endDate = (Date)this.getModel().getValue("expiredate");
                if (EmptyUtil.isEmpty((Object)endDate)) {
                    return;
                }
                this.expireDateValidAndClear(e, key, startDate, endDate);
                break;
            }
            case "expiredate": {
                Date startInstDate2 = (Date)this.getModel().getValue("startintdate");
                Date startDate2 = (Date)this.getModel().getValue("bizdate");
                if (EmptyUtil.isEmpty((Object)startDate2) && EmptyUtil.isEmpty((Object)startInstDate2)) {
                    return;
                }
                boolean isNotNeedValidateExpireDate = LoanBillFormHelper.isLoanBillBondAndPerpetual(this.getView(), this.getModel());
                if (isNotNeedValidateExpireDate) {
                    return;
                }
                if (this.validSEDate(e, key, value)) {
                    return;
                }
                String fmtStr2 = ((DateEdit)this.getControl("expiredate")).getFormatString();
                Date endDate2 = DateUtils.stringToDate((String)value.toString(), (String)fmtStr2);
                this.expireDateValidAndClear(e, key, startDate2, endDate2);
                this.instDateValidAndClear(e, key, startDate2, endDate2);
                break;
            }
            case "firstredeemdate": {
                String dateFormat = ((DateEdit)this.getControl("firstredeemdate")).getFormatString();
                if (EmptyUtil.isEmpty((Object)value)) {
                    return;
                }
                Date firstRedeemDate = DateUtils.stringToDate((String)value.toString(), (String)dateFormat);
                this.validateFirstRedeemDate(e, key, firstRedeemDate, null, null);
                break;
            }
            case "firstredeemterm": {
                if (EmptyUtil.isEmpty((Object)value)) {
                    return;
                }
                this.validateFirstRedeemTerm(e, key, value.toString(), null);
                break;
            }
            case "rateadjustdate": {
                if (EmptyUtil.isEmpty((Object)value)) {
                    return;
                }
                this.validateFirstRateAdjustDate(e, key, value.toString());
                break;
            }
            case "rateresetdays": {
                if (EmptyUtil.isEmpty((Object)value)) break;
                Integer rateResetDays = Integer.valueOf((String)value);
                if (rateResetDays > 365) {
                    e.setCancel(true);
                    this.getModel().setValue("rateresetdays", (Object)365);
                    this.getView().updateView(key);
                }
                if (rateResetDays >= 0) break;
                e.setCancel(true);
                this.getModel().setValue("rateresetdays", (Object)0);
                this.getView().updateView(key);
            }
        }
    }

    public boolean validSEDate(BeforeFieldPostBackEvent e, String key, Object value) {
        if (EmptyUtil.isEmpty((Object)value)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanBillEdit_8", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
            return true;
        }
        return false;
    }

    private void expireDateValidAndClear(BeforeFieldPostBackEvent e, String key, Date startDate, Date endDate) {
        DynamicObject contractBill;
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource((String)this.getModel().getValue("datasource"));
        Date reExpireDate = (Date)this.getModel().getValue("renewalexpiredate");
        if (startDate.after(endDate) && EmptyUtil.isEmpty((Object)reExpireDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(bizResource.getStartDateAfterEndDate());
            this.getView().updateView(key);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(contractBill = (DynamicObject)this.getModel().getValue("loancontractbill")))) {
            Date contractEndDate = contractBill.getDate("enddate");
            Date contractExpireDate = contractBill.getDate("renewalexpiredate");
            if (EmptyUtil.isNoEmpty((Object)contractEndDate) && startDate.after(contractEndDate) && EmptyUtil.isEmpty((Object)contractExpireDate)) {
                e.setCancel(true);
                this.getView().showTipNotification(bizResource.getLoanDateAfterEndDate());
                this.getView().updateView(key);
            } else if (EmptyUtil.isNoEmpty((Object)contractExpireDate) && startDate.after(contractExpireDate)) {
                e.setCancel(true);
                this.getView().showTipNotification(bizResource.getStartDateExtendEndDate());
                this.getView().updateView(key);
            }
        }
    }

    private void instDateValidAndClear(BeforeFieldPostBackEvent e, String key, Date startDate, Date endDate) {
        Date reExpireDate = (Date)this.getModel().getValue("renewalexpiredate");
        if (startDate.after(endDate) && EmptyUtil.isEmpty((Object)reExpireDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u665a\u4e8e\u5230\u671f\u65e5\u3002", (String)"LoanBillEdit_9", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        } else if (EmptyUtil.isNoEmpty((Object)reExpireDate) && startDate.after(reExpireDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u665a\u4e8e\u5c55\u671f\u540e\u5230\u671f\u65e5\u3002", (String)"LoanBillEdit_11", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        Object newVal = e.getChangeSet()[0].getNewValue();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource((String)this.getModel().getValue("datasource"));
        switch (propName = e.getProperty().getName()) {
            case "loancontractbill": {
                this.initDateEnable();
                this.removeCreditLimit();
                this.setCreditLimitEditEnable();
                break;
            }
            case "drawamount": {
                this.removeCreditLimit();
                this.amountChgEvt(bizResource);
                this.setConvertDrawAmount();
                break;
            }
            case "interesttype": {
                this.registerMustInputByInterestType();
                this.setInterestSettledPlan();
                break;
            }
            case "ratefloatpoint": {
                this.registerMustInputByPoint();
                this.setContractInterestRate();
                break;
            }
            case "startintdate": {
                this.getModel().deleteEntryData("rateadjust_entry");
                this.getModel().deleteEntryData("interest_entry");
                this.callTerm(bizResource);
                this.setContractInterestRate();
                this.calcFirstRedeemDate(bizResource);
                LoanBillFormHelper.resetRateResetCycleDate(this.getModel(), "startintdate");
                this.isNofixedTermChgEvt();
                break;
            }
            case "term": {
                this.callExprieDate(bizResource);
                break;
            }
            case "expiredate": {
                this.callTerm(bizResource);
                break;
            }
            case "debtor": {
                if (!EmptyUtil.isNoEmpty((Object)newVal)) break;
                this.getModel().setValue("textdebtor", (Object)((DynamicObject)newVal).getString("name"));
                break;
            }
            case "rateadjuststyle": {
                this.registerMustInputByAdustStyle();
                LoanBillFormHelper.resetRateResetCycleDate(this.getModel(), "startintdate");
                break;
            }
            case "repaymentway": {
                this.setSettleIntModeByRepayWay();
                break;
            }
            case "referencerate": 
            case "ratesign": {
                this.setContractInterestRate();
                break;
            }
            case "startloanrate": {
                this.setInterestRate();
                this.setInterestSettledPlan();
                break;
            }
            case "accountbank": {
                this.acctBackChg((DynamicObject)newVal);
                break;
            }
            case "firstredeemdate": {
                this.calcFirstRedeemTerm(bizResource);
                break;
            }
            case "firstredeemterm": {
                this.calcFirstRedeemDate(bizResource);
                break;
            }
            case "currency": {
                this.loanCurrencyChg(e);
                break;
            }
            case "convertrate": {
                this.convertRateChg(e);
                this.setConvertDrawAmount();
                break;
            }
            case "rateadjustdate": {
                LoanBillFormHelper.rateAdjustDateChgEvt(this.getModel(), "startintdate");
                break;
            }
            case "isnofixedterm": {
                this.isNofixedTermChgEvt();
                break;
            }
            case "settleintmode": {
                this.setInterestSettledPlan();
                break;
            }
            case "rateresetdays": {
                this.setContractInterestRate();
                break;
            }
            case "issofrrate": {
                LoanBillFormHelper.isSofrRateChgEvt(this.getModel(), this.getView());
                break;
            }
            case "iscallcompint": {
                LoanBillFormHelper.isCallCompIntEvt(this.getModel(), this.getView());
                break;
            }
            case "rateresetadjustrule": {
                LoanBillFormHelper.rateResetAdjustRule(this.getModel(), this.getView());
                break;
            }
        }
    }

    private void isNofixedTermChgEvt() {
        IDataModel model = this.getModel();
        boolean isNofixedTerm = (Boolean)model.getValue("isnofixedterm");
        if (isNofixedTerm) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"term", (Object)"1y");
            Date startDate = (Date)model.getValue("startintdate");
            if (EmptyUtil.isNoEmpty((Object)startDate)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"expiredate", (Object)DateUtils.getNextYear((Date)startDate, (int)1));
            }
        }
    }

    private void validateLoanFirstRateDate(BeforeFieldPostBackEvent e, String key, Date startInstDate) {
        Date rateAdjustDate = (Date)this.getModel().getValue("rateadjustdate");
        if (LoanBillFormHelper.isSofr(this.getModel()) && EmptyUtil.isNoEmpty((Object)rateAdjustDate) && rateAdjustDate.compareTo(startInstDate) > 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u3002", (String)"LoanBillEdit_18", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        }
    }

    private void validateFirstRateAdjustDate(BeforeFieldPostBackEvent e, String key, String value) {
        DynamicObject contractBillF7 = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBillF7)) {
            return;
        }
        if (!LoanBillFormHelper.isSofr(this.getModel())) {
            return;
        }
        String timeFormStr = ((DateEdit)this.getControl("rateadjustdate")).getFormatString();
        Date rateAdjustDate = DateUtils.stringToDate((String)value, (String)timeFormStr);
        Date startIntDate = (Date)this.getModel().getValue("startintdate");
        if (EmptyUtil.isNoEmpty((Object)startIntDate) && rateAdjustDate.compareTo(startIntDate) > 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u4e0d\u80fd\u5927\u4e8e\u8d77\u606f\u65e5\u3002", (String)"LoanBillEdit_17", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
            return;
        }
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendar)) {
            return;
        }
        if (!WorkCalendarHelper.isWorkDay((DynamicObjectCollection)workCalendar, (Date)rateAdjustDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u65e5\u5386\u4e0d\u4e3a\u7a7a\u7684\u60c5\u51b5\u4e0b,\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u5fc5\u987b\u662f\u5de5\u4f5c\u65e5,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LoanBillEdit_16", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        }
    }

    private void convertRateChg(PropertyChangedArgs e) {
        BigDecimal newRate = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (newRate.compareTo(BigDecimal.ZERO) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LoanBillEdit_14", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        int scale = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 6;
        BigDecimal notDrawAmount = LoanBillHelper.getNotDrawAmount((long)((Long)contractBill.getPkValue()), (BigDecimal)newRate, (int)scale);
        this.getModel().setValue("notdrawamount", (Object)notDrawAmount);
    }

    private void setConvertDrawAmount() {
        BigDecimal convertRate = (BigDecimal)this.getModel().getValue("convertrate");
        if (convertRate.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal drawAmount = (BigDecimal)this.getModel().getValue("drawamount");
            this.getModel().setValue("convertdrawamt", (Object)drawAmount.multiply(convertRate));
            BigDecimal notDrawAmt = (BigDecimal)this.getModel().getValue("notdrawamount");
            if (notDrawAmt.compareTo(drawAmount) == 0) {
                DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
                if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
                    return;
                }
                DynamicObject currency = (DynamicObject)this.getModel().getValue("contractcny");
                int scale = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 6;
                BigDecimal notDrawAmount = LoanBillHelper.getNotDrawAmount((long)((Long)contractBill.getPkValue()), (BigDecimal)BigDecimal.ONE, (int)scale);
                this.getModel().setValue("convertdrawamt", (Object)notDrawAmount);
            }
        }
    }

    private void loanCurrencyChg(PropertyChangedArgs e) {
        BigDecimal rate;
        boolean isDiffCurrency;
        DynamicObject currency = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldCurrency = (DynamicObject)e.getChangeSet()[0].getOldValue();
        DynamicObject contractcny = (DynamicObject)this.getModel().getValue("contractcny");
        boolean bl = isDiffCurrency = currency != null && contractcny != null && oldCurrency != null && !currency.getPkValue().equals(oldCurrency.getPkValue());
        if (isDiffCurrency) {
            DynamicObject company = (DynamicObject)this.getModel().getValue("org");
            String datasource = (String)this.getModel().getValue("datasource");
            if (DataSourceEnum.INVEST.getValue().equals(datasource)) {
                company = (DynamicObject)this.getModel().getValue("creditorg");
            }
            if (currency.getPkValue().equals(contractcny.getPkValue())) {
                rate = BigDecimal.ONE;
                this.getView().setEnable(Boolean.FALSE, new String[]{"convertrate"});
            } else {
                rate = TmcBusinessBaseHelper.getExchangeRateNew((long)currency.getLong("id"), (long)contractcny.getLong("id"), (long)company.getLong("id"), (Date)DateUtils.getCurrentDate());
                if (rate == null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4%1$s%2$s\u5151%3$s\u6c47\u7387\u3002", (String)"LoanBillEdit_15", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), company.getString("name"), contractcny.getString("name"), currency.getString("name")));
                    return;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"convertrate"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"referencerate"});
            this.getModel().setValue("referencerate", null);
            if (!DataSourceEnum.IFM.getValue().equals(datasource)) {
                this.getModel().setValue("accountbank", null);
                this.getModel().setValue("loaneracctbank", null);
            }
        } else {
            rate = BigDecimal.ONE;
            this.getView().setEnable(Boolean.FALSE, new String[]{"convertrate"});
        }
        this.getModel().setValue("convertrate", (Object)rate);
    }

    private void acctBackChg(DynamicObject newVal) {
        if (EmptyUtil.isEmpty((DynamicObject)newVal)) {
            return;
        }
        DynamicObjectCollection repayEntrys = this.getModel().getEntryEntity("repayplan_entry");
        for (int i = 0; i < repayEntrys.size(); ++i) {
            this.getModel().setValue("repayaccount", (Object)newVal.getLong("id"), i);
        }
        DynamicObjectCollection intEntrys = this.getModel().getEntryEntity("interest_entry");
        for (int i = 0; i < intEntrys.size(); ++i) {
            this.getModel().setValue("intaccount", (Object)newVal.getLong("id"), i);
        }
    }

    private void noCalInstConditionFiledProp() {
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory) && !productFactory.getBoolean("iscallint")) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"interesttype", "referencerate", "startloanrate", "rateadjuststyle", "basis", "interestsettledplan", "settleintmode"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"interesttype", "basis", "settleintmode"});
        }
    }

    private void initDateEnable() {
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill) && BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizdate", "startintdate", "expiredate", "term"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bizdate", "startintdate", "expiredate", "term"});
        }
    }

    private void initRateEnable() {
        boolean isDiffCurrency;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject contractcny = (DynamicObject)this.getModel().getValue("contractcny");
        boolean bl = isDiffCurrency = currency != null && contractcny != null && !currency.getPkValue().equals(contractcny.getPkValue());
        if (isDiffCurrency) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"convertrate"});
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"convertrate", (Object)BigDecimal.ONE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"convertrate"});
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"convertrate", "convertdrawamt"});
    }

    private void registerMustInputByInterestType() {
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory) && !productFactory.getBoolean("iscallint")) {
            return;
        }
        String intRateType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.FIXED.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"startloanrate"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"referencerate", "rateadjuststyle"});
        } else if (InterestTypeEnum.FLOAT.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"referencerate", "rateadjuststyle"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"startloanrate"});
        }
        this.registerMustInputByAdustStyle();
    }

    private void registerMustInputByPoint() {
        String intRateType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.FLOAT.getValue().equals(intRateType) && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("ratefloatpoint"))) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"ratesign"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"ratesign"});
        }
    }

    private void registerMustInputByAdustStyle() {
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory) && !productFactory.getBoolean("iscallint")) {
            return;
        }
        String intRateType = (String)this.getModel().getValue("interesttype");
        String adjustStyle = (String)this.getModel().getValue("rateadjuststyle");
        if (RateAdjustStyleEnum.CYCLE.getValue().equals(adjustStyle) && InterestTypeEnum.FLOAT.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"rateadjustcycletype", "rateadjustcycle", "rateadjustdate"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"rateadjustcycletype", "rateadjustcycle", "rateadjustdate"});
        }
    }

    private void drawContractBill() {
        OperateOption option = OperateOption.create();
        String operation = this.getDrawOeration();
        if (EmptyUtil.isNoEmpty((String)operation)) {
            this.getView().invokeOperation(operation, option);
        }
    }

    protected String getDrawOeration() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cfm_loanbill_b_l".equals(formId)) {
            return "drawbank";
        }
        if ("cfm_loanbill_e_l".equals(formId)) {
            return "draworg";
        }
        if ("cfm_loanbill_bond".equals(formId)) {
            return "drawbond";
        }
        if ("cim_invest_loanbill".equals(formId)) {
            return "drawinvest";
        }
        if ("fl_receiptbill".equals(formId)) {
            return "drawreceipt";
        }
        return "drawbank";
    }

    private void acctBankF7Evt(BeforeF7SelectEvent evt) {
        String[] temp = new String[]{"normal", "freeze"};
        QFilter qFilter = new QFilter("acctstatus", "in", (Object)temp);
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(this.getModel().getDataEntity().getString("creditortype"))) {
            DynamicObject currency;
            Long creditorId = this.getModel().getDataEntity().getLong("creditor");
            if (EmptyUtil.isNoEmpty((Long)creditorId)) {
                qFilter.and(new QFilter("bank.id", "=", (Object)creditorId));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency")))) {
                qFilter.and("currency.fbasedataid", "=", currency.getPkValue());
            }
        } else {
            qFilter.and(new QFilter("acctclassify", "!=", (Object)"I"));
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    protected void callExprieDate(AbstractBizResource bizResource) {
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        Date bizDate = (Date)this.getModel().getValue("startintdate");
        String term = (String)this.getModel().getValue("term");
        if (EmptyUtil.isEmpty((Object)bizDate)) {
            this.getView().showErrorNotification(bizResource.getValidContractIsNotNull());
            return;
        }
        Date expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)bizDate);
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((String)term)) {
            String loanExpireRule = AdjustMethodEnum.no_adjust.getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
                loanExpireRule = productFactory.getString("loanexpireadjustrule");
            }
            expireDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)expireDate, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)loanExpireRule));
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate);
    }

    private void callTerm(AbstractBizResource bizResource) {
        DynamicObject loanContract = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)loanContract)) {
            this.getView().showErrorNotification(bizResource.getValidContractIsNotNull());
            return;
        }
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        Date bizDate = (Date)this.getModel().getValue("startintdate");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)expireDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)expireDate));
        }
    }

    private void amountChgEvt(AbstractBizResource bizResource) {
        BigDecimal drawamount = (BigDecimal)this.getModel().getValue("drawamount");
        BigDecimal notDrawAmount = BigDecimal.ZERO;
        Long sourceBillId = (Long)this.getModel().getValue("sourcebillid");
        if (sourceBillId != null && sourceBillId.intValue() != 0 && BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            BigDecimal convertRate = (BigDecimal)this.getModel().getValue("convertrate");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            int scale = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 6;
            notDrawAmount = LoanBillHelper.getNotDrawAmount((long)sourceBillId, (BigDecimal)convertRate, (int)scale);
            this.getModel().setValue("notdrawamount", (Object)notDrawAmount);
        }
        if (drawamount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(bizResource.getLbDrawamountZeroChecksum());
        }
        if (drawamount.compareTo(notDrawAmount) > 0) {
            this.getView().showTipNotification(bizResource.getLbLessThanNotDrawAmountCheck());
        }
    }

    private void checkPushToRepaymentBill(BeforeDoOperationEventArgs args) {
        DynamicObject loanBillDO = TmcDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"cfm_loanbill", (String)"billstatus,drawtype,notrepayamount");
        String billstatus = loanBillDO.getString("billstatus");
        String drawtype = loanBillDO.getString("drawtype");
        DynamicObject bizBill = this.getModel().getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
        if (!CfmBillCommonHelper.pushOpConfirmStatusValid((DynamicObject)this.getModel().getDataEntity())) {
            this.getView().showTipNotification(bizResource.getConfirmStatusError());
            args.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((BigDecimal)loanBillDO.getBigDecimal("notrepayamount"))) {
            this.getView().showTipNotification(bizResource.getUnRepayAmtIsNotNull());
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            if (StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.CLOSEOUT.getValue()) || StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.DRAWING.getValue())) {
                this.getView().showErrorNotification(bizResource.getLbPushrepaymentbillError());
                args.setCancel(true);
            }
        } else {
            this.getView().showErrorNotification(bizResource.getLbLoanbillPushRepaymentbillError());
            args.setCancel(true);
        }
    }

    private void isOnWayApply(BeforeDoOperationEventArgs args) {
        Long loanBillId = (Long)this.getModel().getDataEntity().getPkValue();
        DynamicObject onWayApply = LoanBillApplyHelper.queryOnWayApply((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayApply)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u6216\u975e\u5df2\u529e\u7406\u7684\u53d8\u66f4\u5355\u636e%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_2", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayApply.getString("billno")}));
            args.setCancel(true);
        }
    }

    private void removeCreditLimit() {
        if (this.getPageCache().get("creditLimit") == null) {
            this.getModel().setValue("creditlimit", null);
        }
    }

    private void showRateAdjust() {
        DynamicObject loanContract = (DynamicObject)this.getModel().getValue("loancontractbill");
        QFilter adjustFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("loancontractbill", "=", loanContract.getPkValue()));
        Object[] rateAdjustBills = TmcDataServiceHelper.load((String)"cfm_rateadjustbill", (String)"id,loancontractbill", (QFilter[])new QFilter[]{adjustFilter});
        if (EmptyUtil.isNoEmpty((Object[])rateAdjustBills)) {
            Long rateAdjustId = rateAdjustBills[0].getLong("id");
            HashMap<String, Long> paramMap = new HashMap<String, Long>();
            paramMap.put("selectedId", loanContract.getLong("id"));
            paramMap.put("rateAdjustId", rateAdjustId);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u6709\u672a\u5ba1\u6838\u7684\u5229\u7387\u8c03\u6574\u5355\uff0c\u662f\u5426\u8fdb\u884c\u7f16\u8f91\u8be5\u5355\u636e\uff1f", (String)"ContractRateAdjustTabEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_RATEADJUST_CALLBACK"), new HashMap(), JSON.toJSONString(paramMap));
        } else {
            CfmRateAdjustHelper.showRateAdjustForm(null, (Long)loanContract.getLong("id"), (IFormView)this.getView());
        }
    }

    private void addBeforeF7Select(BasedataEdit basedataEdit) {
        if (EmptyUtil.isNoEmpty((Object)basedataEdit)) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void checkFixedRepayAmount(BeforeDoOperationEventArgs args) {
        BigDecimal drawAmount = (BigDecimal)this.getModel().getValue("drawamount");
        BigDecimal fixedRepayAmount = (BigDecimal)this.getModel().getValue("fixedRepayAmount");
        if (fixedRepayAmount.compareTo(drawAmount) > 0) {
            DynamicObject bizBill = this.getModel().getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
            this.getView().showTipNotification(bizResource.checkFixedRepayAmount());
            args.setCancel(true);
        }
    }

    private void updateNotDrawAmount() {
        Long sourceBillId = (Long)this.getModel().getValue("sourcebillid");
        if (sourceBillId != null && sourceBillId.intValue() != 0) {
            this.setNotDrawAmount(sourceBillId);
        }
    }

    private void setNotDrawAmount(long sourceBillId) {
        if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            BigDecimal convertRate = (BigDecimal)this.getModel().getValue("convertrate");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            int scale = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 6;
            BigDecimal notDrawAmount = LoanBillHelper.getNotDrawAmount((long)sourceBillId, (BigDecimal)convertRate, (int)scale);
            this.getModel().setValue("notdrawamount", (Object)notDrawAmount);
            this.setSlBankEntryNotDrawamount(sourceBillId);
        } else {
            DynamicObject contract;
            String billno = (String)this.getModel().getValue("billno");
            QFilter filter = new QFilter("billno", "=", (Object)billno);
            DynamicObject loanBill = BusinessDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)"notdrawamount", (QFilter[])filter.toArray());
            if (loanBill.getBigDecimal("notdrawamount").compareTo(BigDecimal.ZERO) == 0 && EmptyUtil.isNoEmpty((DynamicObject)(contract = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"cfm_loancontractbill", (String)"notdrawamount")))) {
                this.getModel().setValue("notdrawamount", (Object)contract.getBigDecimal("notdrawamount"));
            }
        }
    }

    private void setSlBankEntryNotDrawamount(long sourceBillId) {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.isBanksLoan((String)loanType)) {
            BigDecimal drawAmount = (BigDecimal)this.getModel().getValue("drawamount");
            Map slBankNotdrawamount = LoanBillHelper.getSlBankNotdrawamount((long)sourceBillId, (long)0L);
            int entryRowCount = this.getModel().getEntryRowCount("banksyndicate_entry");
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("banksyndicate_entry", i);
                DynamicObject bank = rowEntity.getDynamicObject("e_bank");
                if (EmptyUtil.isEmpty((DynamicObject)bank)) continue;
                BigDecimal bankNotDrawamount = slBankNotdrawamount.getOrDefault(bank.getLong("id"), BigDecimal.ZERO);
                this.getModel().setValue("e_notdrawamount", (Object)bankNotDrawamount, i);
                if (!EmptyUtil.isEmpty((BigDecimal)drawAmount)) continue;
                this.getModel().setValue("e_shareamount", (Object)BigDecimal.ZERO, i);
            }
        }
    }

    private void checkLoanRate(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        String opKey = op.getOperateKey();
        String interestType = (String)this.getModel().getValue("interesttype");
        if (!"submit".equals(opKey) || InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            return;
        }
        Map variables = op.getOption().getVariables();
        if (variables.containsKey(AFTER_CONFIRM_LOANRATE) || variables.containsKey("is_showing_confirm_loanrate_view") || variables.containsKey("saveConfirmFlag") || variables.containsKey("afterConfirm")) {
            return;
        }
        BigDecimal loanRate = (BigDecimal)this.getModel().getValue("startloanrate");
        if (EmptyUtil.isEmpty((BigDecimal)loanRate)) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CONFIRM_LOANRATE_CALLBACK, (IFormPlugin)this);
            String confirmMsg = ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u5229\u7387\u4e3a0\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"LoanBillEdit_12", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            op.getOption().setVariableValue("is_showing_confirm_loanrate_view", Boolean.TRUE.toString());
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
            args.setCancel(true);
        }
    }

    private void setContractInterestRate() {
        String interestType = (String)this.getModel().getValue("interesttype");
        if (!InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            return;
        }
        DynamicObject referenceRate = (DynamicObject)this.getModel().getValue("referencerate");
        Date startDate = (Date)this.getModel().getValue("startintdate");
        BigDecimal rateFloatPoint = (BigDecimal)this.getModel().getValue("ratefloatpoint");
        String rateSign = (String)this.getModel().getValue("ratesign");
        if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate) && EmptyUtil.isNoEmpty((Object)startDate)) {
            BigDecimal rate;
            if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("rateresetdays"))) {
                Integer rateResetDays = (Integer)this.getModel().getValue("rateresetdays");
                startDate = DateUtils.getLastDay((Date)startDate, (int)rateResetDays);
            }
            if (EmptyUtil.isEmpty((BigDecimal)(rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)startDate, (boolean)false)))) {
                this.getModel().setValue("startloanrate", (Object)BigDecimal.ZERO);
                return;
            }
            BigDecimal rateFloat = new BigDecimal(BigInteger.ZERO);
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"startloanrate", (Object)rate.add(rateFloat));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"startloanrate", (Object)BigDecimal.ZERO);
        }
    }

    private boolean validateFirstRedeemDate(BeforeFieldPostBackEvent e, String key, Date newfirstRedeemDate, Date newStartIntDate, Date newBizDate) {
        if (!"cfm_loanbill_bond".equals(this.getView().getFormShowParameter().getFormId())) {
            return true;
        }
        Date startintdate = newStartIntDate != null ? newStartIntDate : (Date)this.getModel().getValue("startintdate");
        Date bizdate = newBizDate != null ? newBizDate : (Date)this.getModel().getValue("bizdate");
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        if (EmptyUtil.isNoEmpty((DynamicObject)finProduct)) {
            Date firstRedeemDate = newfirstRedeemDate != null ? newfirstRedeemDate : (Date)this.getModel().getValue("firstredeemdate");
            boolean isPerpetual = finProduct.getBoolean("perpetualbond");
            if (!(!isPerpetual || EmptyUtil.isEmpty((Object)firstRedeemDate) || EmptyUtil.isEmpty((Object)startintdate) || EmptyUtil.isEmpty((Object)bizdate) || firstRedeemDate.after(startintdate) && firstRedeemDate.after(bizdate))) {
                e.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9996\u6b21\u8d4e\u56de\u65e5\u671f\u9700\u8981\u5927\u4e8e\u8d77\u606f\u65e5\u671f\u548c\u53d1\u884c\u65e5\u671f\u3002", (String)"LoanBillEdit_13", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
                return false;
            }
        }
        return true;
    }

    private boolean validateFirstRedeemTerm(BeforeFieldPostBackEvent e, String key, String firstRedeemTerm, Date startintdate) {
        if (!"cfm_loanbill_bond".equals(this.getView().getFormShowParameter().getFormId())) {
            return true;
        }
        Object firstRedeemTermValue = this.getModel().getValue("firstredeemterm");
        if (EmptyUtil.isEmpty((String)firstRedeemTerm) && EmptyUtil.isEmpty((Object)firstRedeemTermValue)) {
            return true;
        }
        firstRedeemTerm = EmptyUtil.isNoEmpty((String)firstRedeemTerm) ? firstRedeemTerm : (String)firstRedeemTermValue;
        startintdate = startintdate != null ? startintdate : (Date)this.getModel().getValue("startintdate");
        Date firstRedeemDate = TermHelper.getDateByBaseDate4ymd((String)firstRedeemTerm, (Date)startintdate);
        return this.validateFirstRedeemDate(e, key, firstRedeemDate, null, null);
    }

    public void setInterestRate() {
        this.getModel().setValue("loanrate", this.getModel().getValue("startloanrate"));
    }

    public void setLatestRate() {
        Long id = (Long)this.getModel().getValue("id");
        QFilter qfilter = new QFilter("id", "=", (Object)id).and("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue()).and("rateadjust_entry.ra_effectdate", "<=", (Object)DateUtils.getCurrentDate());
        DynamicObjectCollection queryDatas = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,rateadjust_entry.ra_effectdate,rateadjust_entry.ra_yearrate", (QFilter[])qfilter.toArray());
        Map idObjMap = queryDatas.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (a, b) -> a.getDate("rateadjust_entry.ra_effectdate").compareTo(b.getDate("rateadjust_entry.ra_effectdate")) >= 0 ? a : b));
        DynamicObject rateObj = (DynamicObject)idObjMap.get(id);
        if (EmptyUtil.isNoEmpty((DynamicObject)rateObj)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"latestrate", (Object)rateObj.getBigDecimal("rateadjust_entry.ra_yearrate"));
        } else {
            Map<Long, DynamicObject> closeoutLatestRate = this.getCloseoutLatestRate(id);
            DynamicObject closeoutRateObj = closeoutLatestRate.get(id);
            if (EmptyUtil.isNoEmpty((DynamicObject)closeoutRateObj)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"latestrate", (Object)closeoutRateObj.getBigDecimal("rateadjust_entry.ra_yearrate"));
            }
        }
    }

    private Map<Long, DynamicObject> getCloseoutLatestRate(Long id) {
        QFilter closeoutfilter = new QFilter("id", "=", (Object)id).and("drawtype", "=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
        DynamicObjectCollection closeoutQueryDatas = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,rateadjust_entry.ra_effectdate,rateadjust_entry.ra_yearrate,drawtype,cleardate", (QFilter[])closeoutfilter.toArray());
        Map<Long, DynamicObject> closeoutRateData = closeoutQueryDatas.stream().filter(o -> o.getDate("rateadjust_entry.ra_effectdate") != null && o.getDate("cleardate") != null && o.getDate("rateadjust_entry.ra_effectdate").compareTo(o.getDate("cleardate")) <= 0).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (a, b) -> a.getDate("rateadjust_entry.ra_effectdate").compareTo(b.getDate("rateadjust_entry.ra_effectdate")) >= 0 ? a : b));
        return closeoutRateData;
    }

    private void registerAcctbankMustInput() {
        String formId = this.getView().getFormShowParameter().getFormId();
        HashSet<String> forms = new HashSet<String>();
        forms.add("cfm_loanbill_b_l");
        forms.add("cfm_loanbill_e_l");
        if (forms.contains(formId)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"accountbank"});
        }
    }

    private void setInterestSettledPlan() {
        boolean isNot0Rate = BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("startloanrate")) != 0 || BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("loanrate")) != 0;
        LoanBillFormHelper.setInterestSettledPlan(this.getModel(), this.getView(), isNot0Rate);
    }
}

