/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.BondTypeEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.ProductFactoryCcyRuleEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillFormHelper {
    private static final Log logger = LogFactory.getLog(LoanBillFormHelper.class);

    public static String getVolidRepayDateResult(IDataModel model, Date inputRepayDate) {
        Date loanDate = (Date)model.getValue("bizdate");
        if (inputRepayDate.compareTo(loanDate) < 0) {
            LocaleString loanDateProp = CfmBillCommonHelper.getDisPlayPropName((IDataModel)model, (String)"bizdate");
            return CfmFormResourceEnum.LoanBillFormHelper_0.loadKDString(loanDateProp, DateUtils.formatString((Date)loanDate, (String)"yyyy-MM-dd"));
        }
        Date extendDate = (Date)model.getValue("renewalexpiredate");
        Date expireDate = (Date)model.getValue("expiredate");
        if (EmptyUtil.isNoEmpty((Object)extendDate) && inputRepayDate.compareTo(extendDate) > 0) {
            LocaleString dateProp = CfmBillCommonHelper.getDisPlayPropName((IDataModel)model, (String)"renewalexpiredate");
            return CfmFormResourceEnum.LoanBillFormHelper_1.loadKDString(dateProp, DateUtils.formatString((Date)extendDate, (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isEmpty((Object)extendDate) && inputRepayDate.compareTo(expireDate) > 0) {
            LocaleString dateProp = CfmBillCommonHelper.getDisPlayPropName((IDataModel)model, (String)"expiredate");
            return CfmFormResourceEnum.LoanBillFormHelper_1.loadKDString(dateProp, DateUtils.formatString((Date)expireDate, (String)"yyyy-MM-dd"));
        }
        return "";
    }

    public static String checkForYkx(IDataModel model, Date repaymentDate) {
        DynamicObject loanBill = model.getDataEntity();
        if (!LoanBillHelper.isYkx((DynamicObject)loanBill)) {
            return "";
        }
        Date endIntDate = loanBill.getDate("endinstdate");
        if (endIntDate != null && endIntDate.after(repaymentDate)) {
            LocaleString endIntDateProp = CfmBillCommonHelper.getDisPlayPropName((IDataModel)model, (String)"endinstdate");
            return CfmFormResourceEnum.LoanInstPlanModifyPlugin_08.loadKDString(endIntDateProp, DateUtils.formatString((Date)endIntDate, (String)"yyyy-MM-dd"));
        }
        Date expireDate = loanBill.getDate("expiredate");
        if (expireDate != null && expireDate.compareTo(repaymentDate) >= 0) {
            LocaleString expireDateProp = CfmBillCommonHelper.getDisPlayPropName((IDataModel)model, (String)"expiredate");
            return CfmFormResourceEnum.LoanInstPlanModifyPlugin_08.loadKDString(expireDateProp, DateUtils.formatString((Date)expireDate, (String)"yyyy-MM-dd"));
        }
        return "";
    }

    public static void currencyF7Evt(BeforeF7SelectEvent evt, IDataModel model, IFormView view) {
        DynamicObject pf = (DynamicObject)model.getValue("productfactory");
        LoanBillFormHelper.currencyF7Evt(evt, model, view, pf);
    }

    public static void currencyF7Evt(BeforeF7SelectEvent evt, IDataModel model, IFormView view, DynamicObject pf) {
        if (EmptyUtil.isEmpty((DynamicObject)pf)) {
            return;
        }
        pf = TmcDataServiceHelper.loadSingle((Object)pf.getPkValue(), (String)pf.getDynamicObjectType().getName());
        String currencyRule = pf.getString("currencyrule");
        QFilter qf = null;
        switch (currencyRule) {
            case "assigncurrency": {
                DynamicObjectCollection currencCol = pf.getDynamicObjectCollection("currency");
                List curIds = currencCol.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
                qf = new QFilter("id", "in", curIds);
                break;
            }
            case "foreigncurrency": {
                DynamicObject currency = LoanBillFormHelper.getCasBaseCurrency(model);
                if (currency != null) {
                    qf = new QFilter("id", "!=", currency.getPkValue());
                    break;
                }
                evt.setCancel(true);
                String orgName = ((DynamicObject)model.getValue(model.getDataEntityType().getMainOrg())).getString("name");
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\uff0c\u8bf7\u5728\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\u3002", (String)"LoanBillHelper_5", (String)"tmc-cfm-common", (Object[])new Object[0]), orgName));
                return;
            }
            case "basecurrency": {
                DynamicObject baseCurrency = LoanBillFormHelper.getCasBaseCurrency(model);
                if (baseCurrency != null) {
                    qf = new QFilter("id", "=", baseCurrency.getPkValue());
                    break;
                }
                evt.setCancel(true);
                String orgName = ((DynamicObject)model.getValue(model.getDataEntityType().getMainOrg())).getString("name");
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\uff0c\u8bf7\u5728\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\u3002", (String)"LoanBillHelper_5", (String)"tmc-cfm-common", (Object[])new Object[0]), orgName));
                return;
            }
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().setFilter(qf);
    }

    public static void productFactoryF7Evt(BeforeF7SelectEvent evt, IDataModel model, IFormView view) {
        String creditorType;
        if (LoanBillFormHelper.isEmpty(evt, model, view)) {
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        String loantype = (String)model.getValue("loantype");
        QFilter qf = new QFilter("biztype", "=", (Object)loantype);
        DynamicObject finproduct = (DynamicObject)model.getValue("finproduct");
        if (EmptyUtil.isNoEmpty((DynamicObject)finproduct)) {
            QFilter fpQFilter = new QFilter("finproduct", "=", finproduct.getPkValue());
            fpQFilter.or(new QFilter("finproduct", "=", (Object)0));
            qf.and(fpQFilter);
        }
        String rateType = (String)model.getValue("interesttype");
        qf.and(new QFilter("ratetype", "=", (Object)rateType));
        if (BizTypeEnum.BOND.getValue().equals(loantype)) {
            String bondtype = (String)model.getValue("bondtype");
            if (BondTypeEnum.FIXEDRATEBOND.getValue().equals(bondtype)) {
                qf.and(new QFilter("ratetype", "in", (Object)new String[]{InterestTypeEnum.FIXED.getValue(), InterestTypeEnum.AGREE.getValue()}));
            }
            if (BondTypeEnum.FLOATRATEBOND.getValue().equals(bondtype)) {
                qf.and(new QFilter("ratetype", "=", (Object)InterestTypeEnum.FLOAT.getValue()));
            }
        }
        if (EmptyUtil.isNoEmpty((String)(creditorType = (String)model.getValue("creditortype")))) {
            qf.and(new QFilter("creditortype", "=", (Object)creditorType));
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject baseCurrency = LoanBillFormHelper.getCasBaseCurrency(model);
        QFilter cnyQF = new QFilter("currencyrule", "=", (Object)ProductFactoryCcyRuleEnum.NOCURRENCY.getValue());
        cnyQF.or(new QFilter("currencyrule", "=", (Object)ProductFactoryCcyRuleEnum.ASSIGNCURRENCY.getValue()).and(new QFilter("currency.fbasedataid", "=", currency.getPkValue())));
        if (baseCurrency != null && currency.getPkValue().equals(baseCurrency.getPkValue())) {
            cnyQF.or(new QFilter("currencyrule", "=", (Object)ProductFactoryCcyRuleEnum.BASECURRENCY.getValue()));
        }
        if (baseCurrency != null && !currency.getPkValue().equals(baseCurrency.getPkValue())) {
            cnyQF.or(new QFilter("currencyrule", "=", (Object)ProductFactoryCcyRuleEnum.FOREGINCURRENCY.getValue()));
        }
        qf.and(cnyQF);
        logger.info("\u878d\u8d44\u6a21\u578b\u7684\u8fc7\u6ee4\u6761\u4ef6qf={}", (Object)qf.toString());
        sp.getListFilterParameter().setFilter(qf);
    }

    private static boolean isEmpty(BeforeF7SelectEvent evt, IDataModel model, IFormView view) {
        String loantype = (String)model.getValue("loantype");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (EmptyUtil.isEmpty((String)loantype) || EmptyUtil.isEmpty((DynamicObject)currency)) {
            evt.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"ContractBaseEdit_04", (String)"tmc-cfm-formplugin", (Object[])new Object[]{CfmBillCommonHelper.getPropLocalDisplayName((IFormView)view, (String)(EmptyUtil.isEmpty((String)loantype) ? "loantype" : "currency"))}));
            return true;
        }
        return false;
    }

    private static DynamicObject getCasBaseCurrency(IDataModel model) {
        String mainOrgPropName = model.getDataEntityType().getMainOrg();
        DynamicObject cp = (DynamicObject)model.getValue(mainOrgPropName);
        Long cpId = (Long)cp.getPkValue();
        return TmcBusinessBaseHelper.getCasBaseCurrency((long)cpId);
    }

    public static void pushRepaymentbill(IFormView view, Long loanId) {
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanId, (String)"cfm_loanbill", (String)"id,loantype,loancontractbill");
        String srcEntityNumber = "cfm_loanbill";
        String srcLayoutFormId = CfmBillCommonHelper.getFormIdByShowParameter((IFormView)view);
        String targetEntityNumber = "cfm_repaymentbill";
        String targetLayoutFormId = "cfm_repaymentbill_b_l";
        String biztype = loanBill.getString("loantype");
        if (srcLayoutFormId.startsWith("cim")) {
            srcEntityNumber = "cim_invest_loanbill";
            targetEntityNumber = "cim_invest_repaybill";
            targetLayoutFormId = "cim_invest_repaybill";
        } else if (srcLayoutFormId.startsWith("ifm")) {
            srcEntityNumber = "ifm_loanbill";
            targetEntityNumber = "ifm_repaymentbill";
            targetLayoutFormId = "ifm_repaymentbill";
        } else if (BizTypeEnum.BOND.getValue().equals(biztype)) {
            srcEntityNumber = "cfm_loanbill_bond";
            targetEntityNumber = "cfm_repaymentbill";
            targetLayoutFormId = "cfm_repaymentbill_bond";
        } else if (BizTypeEnum.ENTRUST.getValue().equals(biztype) || BizTypeEnum.EC.getValue().equals(biztype)) {
            targetLayoutFormId = "cfm_repaymentbill_e_l";
        }
        TmcBotpHelper.doPush((IFormView)view, (Long)loanId, (String)srcEntityNumber, (String)targetEntityNumber, (String)srcLayoutFormId, (String)targetLayoutFormId);
    }

    public static boolean isLoanBillBondAndPerpetual(IFormView view, IDataModel model) {
        DynamicObject finProduct = (DynamicObject)model.getValue("finproduct");
        if (EmptyUtil.isEmpty((DynamicObject)finProduct)) {
            return false;
        }
        return StringUtils.equals((CharSequence)"cfm_loanbill_bond", (CharSequence)view.getFormShowParameter().getFormId()) && finProduct.getBoolean("perpetualbond");
    }

    public static boolean judgeDataIsChanged(IDataModel model) {
        DynamicObject bondBill = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill_bond", (String)"bizdate,startintdate,expiredate,rateadjustdate,rateadjustcycletype,rateadjustcycle,interesttype", (QFilter[])new QFilter[]{new QFilter("id", "=", model.getDataEntity().getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)bondBill)) {
            return false;
        }
        if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)bondBill.getString("interesttype"))) {
            int newAdjustCycleVal;
            Date oldIntDate = bondBill.getDate("startintdate");
            Date newIntDate = (Date)model.getValue("startintdate");
            if (EmptyUtil.isNoEmpty((Object)oldIntDate) && EmptyUtil.isNoEmpty((Object)newIntDate) && oldIntDate.compareTo(newIntDate) != 0) {
                return true;
            }
            Date oldExpireDate = bondBill.getDate("expiredate");
            Date newExpireDate = (Date)model.getValue("expiredate");
            if (EmptyUtil.isNoEmpty((Object)oldExpireDate) && EmptyUtil.isNoEmpty((Object)newExpireDate) && oldExpireDate.compareTo(newExpireDate) != 0) {
                return true;
            }
            Date oldRateAdjustDate = bondBill.getDate("rateadjustdate");
            Date newRateAdjustDate = (Date)model.getValue("rateadjustdate");
            if (EmptyUtil.isNoEmpty((Object)oldRateAdjustDate) && EmptyUtil.isNoEmpty((Object)newRateAdjustDate) && oldRateAdjustDate.compareTo(newRateAdjustDate) != 0) {
                return true;
            }
            String oldAdjustCycleKey = bondBill.getString("rateadjustcycletype");
            String newAdjustCycleKey = (String)model.getValue("rateadjustcycletype");
            if (EmptyUtil.isNoEmpty((String)oldAdjustCycleKey) && EmptyUtil.isNoEmpty((String)newAdjustCycleKey) && !oldAdjustCycleKey.equals(newAdjustCycleKey)) {
                return true;
            }
            int oldAdjustCycleVal = bondBill.getInt("rateadjustcycle");
            if (oldAdjustCycleVal != (newAdjustCycleVal = ((Integer)model.getValue("rateadjustcycle")).intValue())) {
                return true;
            }
        } else {
            Date newMin;
            Date newBizDate;
            Date newIntDate;
            Date oldIntDate;
            Date oldBizDate = bondBill.getDate("bizdate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{oldBizDate, oldIntDate = bondBill.getDate("startintdate"), newIntDate = (Date)model.getValue("startintdate"), newBizDate = (Date)model.getValue("bizdate")})) {
                return false;
            }
            Date oldMin = oldBizDate.compareTo(oldIntDate) <= 0 ? oldBizDate : oldIntDate;
            Date date = newMin = newBizDate.compareTo(newIntDate) <= 0 ? newBizDate : newIntDate;
            if (oldMin.compareTo(newMin) != 0) {
                return true;
            }
        }
        return false;
    }

    public static void pushInterestBill(IFormView view, Long loanId) {
        String srcLayoutFormId = CfmBillCommonHelper.getFormIdByShowParameter((IFormView)view);
        String targetLayoutFormId = "cfm_interestbill";
        String targetEntityNumber = "cfm_interestbill";
        String srcEntityNumber = "cfm_loanbill";
        if ("cfm_loanbill_b_l".equals(srcLayoutFormId)) {
            targetLayoutFormId = "cfm_interestbill_b";
        } else if ("cfm_loanbill_e_l".equals(srcLayoutFormId)) {
            targetLayoutFormId = "cfm_interestbill_e";
        } else if ("cfm_loanbill_bond".equals(srcLayoutFormId)) {
            srcEntityNumber = "cfm_loanbill_bond";
            targetLayoutFormId = "cfm_interestbill_bond";
        } else if ("cim_invest_loanbill".equals(srcLayoutFormId)) {
            srcEntityNumber = "cim_invest_loanbill";
            targetLayoutFormId = "cim_invest_interestbill";
            targetEntityNumber = "cim_invest_interestbill";
        } else if ("ifm_loanbill".equals(srcLayoutFormId)) {
            srcEntityNumber = "ifm_loanbill";
            targetLayoutFormId = "ifm_interestbill";
            targetEntityNumber = "ifm_interestbill";
        }
        TmcBotpHelper.doPush((IFormView)view, (Long)loanId, (String)srcEntityNumber, (String)targetEntityNumber, (String)srcLayoutFormId, (String)targetLayoutFormId);
    }

    public static boolean isLoanBillBondAndExpireDateNull(IFormView view, IDataModel model) {
        DynamicObject finProduct = (DynamicObject)model.getValue("finproduct");
        if (EmptyUtil.isEmpty((DynamicObject)finProduct)) {
            return false;
        }
        return StringUtils.equals((CharSequence)"cfm_loanbill_bond", (CharSequence)view.getFormShowParameter().getFormId()) && finProduct.getBoolean("perpetualbond") && EmptyUtil.isEmpty((Object)model.getValue("expiredate"));
    }

    public static void validateRateRangeLimit(BeforeDoOperationEventArgs evt, IFormView view, IDataModel model) {
        BigDecimal loanRate;
        BigDecimal rateFloor;
        BigDecimal rateCeil = (BigDecimal)model.getValue("rateceil");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rateCeil, rateFloor = (BigDecimal)model.getValue("ratefloor")}) && rateCeil.compareTo(rateFloor) <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5229\u7387\u4e0a\u9650\u9700\u5927\u4e8e\u5229\u7387\u4e0b\u9650\u3002", (String)"LoanBillHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if (EmptyUtil.isEmpty((BigDecimal)(loanRate = (BigDecimal)model.getValue("loanrate")))) {
            return;
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)rateCeil) && rateCeil.compareTo(loanRate) < 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5229\u7387\u4e0a\u9650\u9700\u5927\u4e8e\u7b49\u4e8e\u56fa\u5b9a\u606f\u7968\u7387\u3002", (String)"LoanBillHelper_3", (String)"tmc-cfm-common", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)rateFloor) && rateFloor.compareTo(loanRate) < 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5229\u7387\u4e0b\u9650\u9700\u5927\u4e8e\u7b49\u4e8e\u56fa\u5b9a\u606f\u7968\u7387\u3002", (String)"LoanBillHelper_4", (String)"tmc-cfm-common", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public static void setInterestSettledPlan(IDataModel model, IFormView view, boolean isNot0Rate) {
        String repaymentWay = (String)model.getValue("repaymentway");
        RepaymentWayEnum repaywayEnum = RepaymentWayEnum.getByValue((String)repaymentWay);
        String settleIntMode = (String)model.getValue("settleintmode");
        boolean isMustInputByRepayWay = repaywayEnum == RepaymentWayEnum.bqhbdqhx || repaywayEnum == RepaymentWayEnum.dqhbdqhx || repaywayEnum == RepaymentWayEnum.zdyhk && SettleIntModeEnum.gdpljx.getValue().equals(settleIntMode);
        String interestType = (String)model.getValue("interesttype");
        if (isMustInputByRepayWay) {
            if (InterestTypeEnum.isFloat((String)interestType) || !InterestTypeEnum.isFloat((String)interestType) && isNot0Rate) {
                TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)Boolean.TRUE, (String[])new String[]{"interestsettledplan"});
            } else {
                model.setValue("interestsettledplan", null);
                TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)Boolean.FALSE, (String[])new String[]{"interestsettledplan"});
            }
        } else {
            model.setValue("interestsettledplan", null);
            TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)Boolean.FALSE, (String[])new String[]{"interestsettledplan"});
        }
    }

    public static void initIntCalBox(IDataModel model, IFormView view) {
        String loanType = (String)model.getValue("loantype");
        if (!BizTypeEnum.isBond((String)loanType)) {
            ArrayList<String> comboItemValues = new ArrayList<String>(10);
            if (LoanBillFormHelper.isSofr(model)) {
                comboItemValues.add(IntCalMethodEnum.compcallint.getValue());
                model.setValue("intcalmethod", (Object)IntCalMethodEnum.compcallint.getValue());
                TmcViewInputHelper.resetComboItems(comboItemValues, (String)"intcalmethod", (IFormView)view);
                return;
            }
            comboItemValues.add(IntCalMethodEnum.onecallint.getValue());
            comboItemValues.add(IntCalMethodEnum.periodcallint.getValue());
            comboItemValues.add(IntCalMethodEnum.totalcallint.getValue());
            model.setValue("intcalmethod", (Object)IntCalMethodEnum.totalcallint.getValue());
            TmcViewInputHelper.resetComboItems(comboItemValues, (String)"intcalmethod", (IFormView)view);
        }
    }

    public static void resetRateResetCycleDate(IDataModel model, String propName) {
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)model.getValue("workcalendar");
        Date startDate = (Date)model.getValue(propName);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendar) || EmptyUtil.isEmpty((Object)startDate) || !LoanBillFormHelper.isSofr(model)) {
            return;
        }
        int resetDays = (Integer)model.getValue("rateresetdays");
        Date rateResetCycleDate = CfmBillCommonHelper.getLastDayByWorkCalendar((DynamicObjectCollection)workCalendar, (int)resetDays, (Date)startDate, (int)1);
        model.setValue("rateadjustdate", (Object)rateResetCycleDate);
    }

    public static void rateAdjustDateChgEvt(IDataModel model, String propName) {
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)model.getValue("workcalendar");
        Date startDate = (Date)model.getValue(propName);
        Date rateAdjustDate = (Date)model.getValue("rateadjustdate");
        if (!LoanBillFormHelper.isSofr(model) || EmptyUtil.isEmpty((DynamicObjectCollection)workCalendar) || EmptyUtil.isEmpty((Object)startDate) || EmptyUtil.isEmpty((Object)rateAdjustDate)) {
            return;
        }
        Long[] wcIds = workCalendar.stream().map(w -> w.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()).toArray(new Long[1]);
        model.setValue("rateresetdays", (Object)CfmBillCommonHelper.getWorkDayCount((Long[])wcIds, (Date)rateAdjustDate, (Date)startDate));
    }

    public static void initEnableMustInputBySofr(IDataModel model, IFormView view) {
        if (LoanBillFormHelper.isSofr(model)) {
            view.setEnable(Boolean.FALSE, new String[]{"ratesign"});
            model.setValue("ratesign", (Object)RateSignEnum.ADD.getValue());
            String rateResetAdjustRule = (String)model.getValue("rateresetadjustrule");
            TmcViewInputHelper.registerMustInput((IFormView)view, (!AdjustMethodEnum.isNoAdjust((String)rateResetAdjustRule) ? 1 : 0) != 0, (String[])new String[]{"workcalendar"});
        }
    }

    public static void isSofrRateChgEvt(IDataModel model, IFormView view) {
        model.setValue("iscallcompint", (Object)Boolean.FALSE);
        LoanBillFormHelper.initIntCalBox(model, view);
    }

    public static void isCallCompIntEvt(IDataModel model, IFormView view) {
        boolean isCallCompInt = (Boolean)model.getValue("iscallcompint");
        if (isCallCompInt) {
            model.setValue("ratesign", (Object)RateSignEnum.ADD.getValue());
        }
        view.setEnable(Boolean.valueOf(!isCallCompInt), new String[]{"ratesign"});
        LoanBillFormHelper.initIntCalBox(model, view);
    }

    public static void rateResetAdjustRule(IDataModel model, IFormView view) {
        String rateResetAdjustRule = (String)model.getValue("rateresetadjustrule");
        TmcViewInputHelper.registerMustInput((IFormView)view, (!AdjustMethodEnum.isNoAdjust((String)rateResetAdjustRule) ? 1 : 0) != 0, (String[])new String[]{"workcalendar"});
    }

    public static boolean isSofr(IDataModel model) {
        boolean isSofrRate = (Boolean)model.getValue("issofrrate");
        boolean isCallCompInt = (Boolean)model.getValue("iscallcompint");
        return isSofrRate && isCallCompInt;
    }

    public static void validateIsDrawByPlan(DynamicObject contractBill, BeforeDoOperationEventArgs evtArgs, IFormView view) {
        DynamicObjectCollection drawPlans = contractBill.getDynamicObjectCollection("drawdownplan_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)drawPlans)) {
            return;
        }
        QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue());
        QFilter confirmFilter = new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"billno", (QFilter[])new QFilter[]{qFilter, confirmFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanBills)) {
            String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)contractBill.getString("datasource"));
            view.showTipNotification(CfmBusinessResourceEnum.ContractAutoDrawValidator_3.loadKDString(new Object[]{loanName, ((DynamicObject)loanBills.get(0)).getString("billno")}));
            evtArgs.setCancel(true);
            return;
        }
        QFilter applyFilter = new QFilter("loancontractbill", "=", contractBill.getPkValue());
        QFilter businessFilter = new QFilter("businessstatus", "in", Arrays.asList(ApplyBusinessStatusEnum.APPLY.getValue(), ApplyBusinessStatusEnum.HANDING.getValue(), ApplyBusinessStatusEnum.NOTHAND.getValue()));
        DynamicObjectCollection drawApplyBills = QueryServiceHelper.query((String)"cfm_draw_apply", (String)"billno", (QFilter[])new QFilter[]{applyFilter, businessFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)drawApplyBills)) {
            view.showTipNotification(CfmBusinessResourceEnum.ContractAutoDrawValidator_4.loadKDString(new Object[]{((DynamicObject)drawApplyBills.get(0)).getString("billno")}));
            evtArgs.setCancel(true);
        }
    }
}

