/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.GuaranteeEntryHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillGuaranteePlugin
extends AbstractBillPlugIn {
    private final String[] GUARANTEE_USE_PROPS = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate", "gsrcbilltype", "gsrcbillid", "gcreditortype", "gcreditor", "gcreditortext"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String parentViewFormId = this.getParentViewFormId();
        if (!("cfm_loancontract_bl_l".equals(parentViewFormId) || "cfm_loancontract_ic_l".equals(parentViewFormId) || "cim_invest_contract".equals(parentViewFormId) || "ifm_loancontractbill".equals(parentViewFormId) || "cim_invest_loanbill".equals(parentViewFormId) || "cfm_loanbill_b_l".equals(parentViewFormId) || "cfm_loanbill_e_l".equals(parentViewFormId) || "cfm_loancontract_bo".equals(parentViewFormId) || "cfm_loanbill_bond".equals(parentViewFormId) || "ifm_loanbill".equals(parentViewFormId) || "fl_leasecontractbill".equals(parentViewFormId))) {
            return;
        }
        int operationStatus = this.getView().getFormShowParameter().getStatus().getValue();
        if (OperationStatus.ADDNEW.getValue() == operationStatus) {
            this.buildGuaranteeEntry();
            GuaranteeEntryHelper.setCreditGuarantee((IDataModel)this.getModel());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "contractbillno": {
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    this.buildGuaranteeEntry();
                    break;
                }
                if ("cfm_loanbill".equals(this.getModel().getDataEntityType().getName())) {
                    this.getModel().deleteEntryData("banksyndicate_entry");
                } else if ("cfm_loanbill_bond".equals(this.getModel().getDataEntityType().getName())) {
                    this.getModel().deleteEntryData("investor_entry");
                }
                this.getModel().deleteEntryData("entry_gcontract");
                break;
            }
            case "e_shareamount": {
                this.setGuaranteeEntry(rowIndex);
                break;
            }
        }
    }

    private void setGuaranteeEntry(int rowIdx) {
        int i;
        DynamicObject loanContractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        DynamicObjectCollection gcs = this.getModel().getEntryEntity("entry_gcontract");
        if (EmptyUtil.isEmpty((DynamicObject)loanContractBill) || EmptyUtil.isEmpty((DynamicObjectCollection)gcs)) {
            return;
        }
        Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)this.getModel().getDataEntityType().getName(), (IDataModel)this.getModel(), (int)rowIdx);
        if (bizAmountMap.isEmpty()) {
            return;
        }
        String curCreditorType = (String)bizAmountMap.get("gcreditortype");
        Long curCreditor = (Long)bizAmountMap.get("gcreditor");
        BigDecimal bizAmount = (BigDecimal)bizAmountMap.get("gsrcbizamount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        List gcsList = gcs.stream().filter(f -> EmptyUtil.isNoEmpty((String)f.getString("gcreditortype")) && EmptyUtil.isNoEmpty((Long)f.getLong("gcreditor")) && curCreditorType.equals(f.getString("gcreditortype")) && curCreditor.equals(f.getLong("gcreditor"))).collect(Collectors.toList());
        BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumAmount = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> gAmountMap = new HashMap<Long, BigDecimal>(gcsList.size());
        for (i = 0; i < gcsList.size(); ++i) {
            BigDecimal gAmount;
            if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == gcsList.size() - 1) {
                gAmount = bizAmount.subtract(sumAmount);
            } else {
                BigDecimal gRatio = ((DynamicObject)gcsList.get(i)).getBigDecimal("gratio");
                gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                sumAmount = sumAmount.add(gAmount);
            }
            gAmountMap.put(((DynamicObject)gcsList.get(i)).getDynamicObject("gcontract").getLong("id"), gAmount);
        }
        for (i = 0; i < gcs.size(); ++i) {
            Long gContractId = ((DynamicObject)gcs.get(i)).getDynamicObject("gcontract").getLong("id");
            String creditorType = ((DynamicObject)gcs.get(i)).getString("gcreditortype");
            Long creditor = ((DynamicObject)gcs.get(i)).getLong("gcreditor");
            if (EmptyUtil.isEmpty((String)creditorType) || EmptyUtil.isEmpty((Long)creditor) || !creditorType.equals(bizAmountMap.get("gcreditortype")) || !creditor.equals(bizAmountMap.get("gcreditor"))) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", gAmountMap.get(gContractId), (int)i);
        }
    }

    private void buildGuaranteeEntry() {
        DynamicObject contractBillF7 = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBillF7)) {
            return;
        }
        QFilter idFilter = new QFilter("gsrcbillid", "=", contractBillF7.getPkValue());
        DynamicObjectCollection gcs = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", this.GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{idFilter}, (String)"id");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gcs)) {
            return;
        }
        Map<Long, Boolean> creditMap = this.getCreditGuarantee(gcs.stream().map(a -> a.getLong("gcontract")).collect(Collectors.toSet()));
        TreeMap<String, ArrayList<DynamicObject>> sumGcMap = new TreeMap<String, ArrayList<DynamicObject>>();
        for (DynamicObject gc : gcs) {
            if (BigDecimal.ZERO.compareTo(gc.getBigDecimal("gratio")) == 0) continue;
            String creditorType = gc.getString("gcreditortype");
            Long creditor = gc.getLong("gcreditor");
            ArrayList<DynamicObject> gcTemp = (ArrayList<DynamicObject>)sumGcMap.get(creditorType + creditor);
            if (gcTemp == null) {
                gcTemp = new ArrayList<DynamicObject>(gcs.size());
            }
            gcTemp.add(gc);
            sumGcMap.put(creditorType + creditor, gcTemp);
        }
        BigDecimal bizAmount = (BigDecimal)this.getModel().getValue("drawamount");
        Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)this.getModel().getDataEntityType().getName(), (IDataModel)this.getModel());
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        ArrayList<Map<String, Object>> gcEntryList = new ArrayList<Map<String, Object>>(gcs.size());
        for (Map.Entry entry : sumGcMap.entrySet()) {
            List gcsList = (List)entry.getValue();
            if (EmptyUtil.isEmpty((Collection)gcsList)) continue;
            bizAmount = bizAmountMap.containsKey(entry.getKey()) ? (BigDecimal)bizAmountMap.get(entry.getKey()) : bizAmount;
            BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (int i = 0; i < gcsList.size(); ++i) {
                BigDecimal gAmount;
                DynamicObject gc = (DynamicObject)gcsList.get(i);
                if (!"fl_receiptbill".equals(this.getModel().getDataEntityType().getName()) && creditMap.get(gc.getLong("gcontract")).booleanValue() && !bizAmountMap.containsKey(entry.getKey())) continue;
                if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == gcsList.size() - 1) {
                    gAmount = bizAmount.subtract(sumAmount);
                } else {
                    BigDecimal gRatio = gc.getBigDecimal("gratio");
                    gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    sumAmount = sumAmount.add(gAmount);
                }
                Map<String, Object> gcEntry = this.genRowMap(gc, gAmount);
                gcEntryList.add(gcEntry);
            }
        }
        TmcViewInputHelper.batchFillEntity((String)"entry_gcontract", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), gcEntryList);
    }

    private Map<Long, Boolean> getCreditGuarantee(Set<Long> gContractIdSet) {
        DynamicObject[] guaranteeVarArr = BusinessDataServiceHelper.load((String)"gm_guaranteecontract", (String)"id,guarantee,guarantee.creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "in", gContractIdSet)});
        return Arrays.stream(guaranteeVarArr).collect(Collectors.toMap(k -> k.getLong("id"), e -> e.getBoolean("guarantee.creditguarantee")));
    }

    private String getParentViewFormId() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView instanceof BillView) {
            return ((BillView)parentView).getFormId();
        }
        if (parentView instanceof ListView) {
            return ((ListView)parentView).getBillFormId();
        }
        return null;
    }

    private Map<String, Object> genRowMap(DynamicObject guaranteeUseBill, BigDecimal gAmount) {
        HashMap<String, Object> gcEntry = new HashMap<String, Object>(16);
        gcEntry.put("gcontract", guaranteeUseBill.get("gcontract"));
        gcEntry.put("gamount", gAmount);
        gcEntry.put("gratio", guaranteeUseBill.get("gratio"));
        gcEntry.put("gcontractamount", guaranteeUseBill.get("gcontract.amount"));
        gcEntry.put("gcontractcurrency", guaranteeUseBill.get("gcontract.currency"));
        gcEntry.put("gexchrate", guaranteeUseBill.get("gexchrate"));
        gcEntry.put("gcomment", guaranteeUseBill.get("gcomment"));
        gcEntry.put("gsrcbilltype", guaranteeUseBill.get("gsrcbilltype"));
        gcEntry.put("gsrcbillid", guaranteeUseBill.get("gsrcbillid"));
        if (!Arrays.asList("fl_leasecontractbill", "fl_receiptbill").contains(this.getModel().getDataEntityType().getName())) {
            gcEntry.put("gcreditortype", guaranteeUseBill.getString("gcreditortype"));
            gcEntry.put("gcreditor", guaranteeUseBill.getLong("gcreditor"));
            gcEntry.put("gcreditortext", guaranteeUseBill.getString("gcreditortext"));
        }
        return gcEntry;
    }
}

