/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.helper.LoanBillApplyHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.helper.IfmBizDealHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.CfmPush2PayFormOrListHelper;
import kd.tmc.cfm.formplugin.common.CommonBillFormHelper;
import kd.tmc.cfm.formplugin.common.LoanBillApplyFormHelper;
import kd.tmc.cfm.formplugin.helper.CfmFormHelper;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class LoanBillList
extends AbstractTmcBillBaseList {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("cfm_financingvarieties".equals(args.getRefEntityId())) {
            List<String> bizTypes = CommonBillFormHelper.getBizTypes(this.getView());
            if (bizTypes.contains("loan") || bizTypes.contains("sl")) {
                args.getQfilters().add(new QFilter("finsource", "=", (Object)"bank"));
            } else if (bizTypes.contains("bond")) {
                args.getQfilters().add(new QFilter("finsource", "=", (Object)"bond"));
            }
            args.getQfilters().add(new QFilter("isleaf", "=", (Object)"1"));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)true);
        this.dealDefaultSelectEntryView(e);
    }

    private void dealDefaultSelectEntryView(PreOpenFormEventArgs e) {
        ListShowParameter fsp = (ListShowParameter)e.getFormShowParameter();
        if (EmptyUtil.isNoEmpty((Object)fsp)) {
            String billFormId = fsp.getBillFormId();
            if ("cfm_loanbill_b_l".equals(billFormId) || "cfm_loanbill_e_l".equals(billFormId)) {
                billFormId = "cfm_loanbill";
            }
            fsp.setSelectedEntity(billFormId);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String isquerydefault;
        CommonFilterColumn bizDateFilterCol;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterFastList = args.getFilterContainerInitEvent().getFastFilterColumns();
        String loanbills = (String)formShowParameter.getCustomParam("loanbills");
        if (StringUtils.isNotBlank((CharSequence)loanbills)) {
            Object[] fastValues = loanbills.split(",");
            for (FilterColumn filterColumn : filterFastList) {
                if (!filterColumn.getFieldName().equals("billno")) continue;
                filterColumn.setDefaultValues(fastValues);
            }
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Object param = formShowParameter.getCustomParam("filter");
        if (null != param) {
            QFilter qfilter = QFilter.fromSerializedString((String)param.toString());
            String property = qfilter.getProperty();
            Object value = qfilter.getValue();
            for (FilterColumn filterColumn : filterColumnList) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (commonFilter.getFieldName().equals(property)) {
                    commonFilter.setDefaultValue(value == null ? "" : value.toString());
                    continue;
                }
                commonFilter.setDefaultValue(null);
            }
        }
        if ((bizDateFilterCol = (CommonFilterColumn)filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"bizdate")).findFirst().orElse(null)) != null && null != (isquerydefault = (String)formShowParameter.getCustomParam("isquerydefault")) && isquerydefault.equals("no")) {
            bizDateFilterCol.setDefaultValue("");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CfmBillCommonHelper.setRepayIntPlanBotnVisable((IFormView)this.getView());
        this.setVisible();
    }

    public void setVisible() {
        if (!"cfm_loanbill_bond".equals(this.getBillFormId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblbuyback"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if (!StringUtils.equals((CharSequence)formId, (CharSequence)"fl_receiptbill")) {
            String bizType;
            Object[] bizTypes;
            FormShowParameter parameter = this.getView().getFormShowParameter();
            if (parameter.getCustomParams().containsKey("biztype") && EmptyUtil.isNoEmpty((Object[])(bizTypes = (bizType = (String)parameter.getCustomParam("biztype")).split(",")))) {
                e.getQFilters().add(new QFilter("loantype", "in", (Object)bizTypes));
            }
            if (formId.startsWith("ifm_")) {
                QFilter qFilter = new QFilter("settlestatus", "in", Arrays.asList("addnew", "accept"));
                qFilter.and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
                e.getQFilters().add(qFilter);
            } else if (formId.startsWith("cfm_") || formId.startsWith("cim_")) {
                e.getQFilters().add(new QFilter("settlestatus", "!=", (Object)"addnew"));
                if (!CfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue())) {
                    e.getQFilters().add(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
                }
            }
            e.getQFilters().add(new QFilter("loantype", "!=", (Object)LoanTypeEnum.FINLEASE.getValue()));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            e.getParameter().getCustomParams().put("biztype", bizType);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        CfmPush2PayFormOrListHelper.listPush2PayForwardValid(args, this.getView());
        switch (operateKey) {
            case "pushtorepaymentbill": {
                this.checkPush2repaymentBill(args);
                break;
            }
            case "buyback": {
                this.checkBuyback(args);
                break;
            }
            case "repaymentsc": 
            case "updateinstplan": {
                Long loanBillId = this.getSelectedId();
                if (EmptyUtil.isEmpty((Long)loanBillId)) {
                    args.setCancel(true);
                    return;
                }
                DynamicObject loanBill = LoanBillRepository.getLoanBillBySelectId((Long)loanBillId);
                if (this.volidRepayInstPlanOp(args, operateKey, loanBill)) {
                    return;
                }
                String dataSource = loanBill.getString("datasource");
                if (DataSourceEnum.isBond((String)dataSource) || DataSourceEnum.isFl((String)dataSource)) {
                    return;
                }
                LoanBillApplyFormHelper.validateCfmPlanParam(args, this.getView(), loanBill);
                break;
            }
            case "pushbizdealbill": {
                this.validatePush2SettleCenter(args);
                break;
            }
            case "feeshare": {
                Long loanBillId = this.getSelectedId();
                if (!EmptyUtil.isEmpty((Long)loanBillId)) break;
                args.setCancel(true);
                return;
            }
            case "change": {
                if (LoanBillApplyFormHelper.isOpenApplyForm(this.getView(), this.getSelectedId())) break;
                args.setCancel(true);
                return;
            }
            case "pushtointerestbill": {
                this.isOnWayApply(args);
                break;
            }
        }
    }

    private void checkBuyback(BeforeDoOperationEventArgs args) {
        if (!this.checkBuyBack(args)) {
            return;
        }
        this.checkPush2repaymentBill(args);
    }

    private boolean checkBuyBack(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            args.setCancel(true);
            return false;
        }
        boolean exists = QueryServiceHelper.exists((String)"cfm_loanbill_bond", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectedId).and("investor_entry", "is not null", null)});
        if (!exists) {
            this.getView().showErrorNotification(new BizResourceFactory().getBizResource("").getInvestIsnullForbidBuyBack());
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "repaymentsc": 
            case "updateinstplan": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.repayInstPlanShowForm("repaymentsc".equals(operateKey));
                break;
            }
            case "rateadjust": {
                DynamicObject loanBillDo;
                List errorList;
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                HashMap<String, Object> param = new HashMap<String, Object>();
                Long selectedId = this.getSelectedId();
                if (selectedId == null) {
                    return;
                }
                String entityName = "cfm_loanbill";
                if ("ifm_loanbill".equals(this.getDataEntityName())) {
                    entityName = "ifm_loanbill";
                }
                if (EmptyUtil.isEmpty((Collection)(errorList = CfmRateAdjustHelper.validCanRateAdjustOp((DynamicObject)(loanBillDo = TmcDataServiceHelper.loadSingle((Object)selectedId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName))))))) {
                    param.put("formPrimId", selectedId);
                    param.put("formId", "cfm_rateadjust");
                    param.put("fromEntityBill", ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
                    FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showParameter);
                    break;
                }
                this.showErrorMsg(errorList);
                break;
            }
            case "pushtorepaymentbill": 
            case "buyback": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                Long loanId = this.getSelectedId();
                if (EmptyUtil.isNoEmpty((Object)this.getPageCache())) {
                    this.getPageCache().put("operationKey", operateKey);
                }
                LoanBillFormHelper.pushRepaymentbill(this.getView(), loanId);
                break;
            }
            case "feeshare": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("pushfeeshare");
                break;
            }
            case "change": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                LoanBillApplyFormHelper.openApplyForm(this.getView(), formId, this.getSelectedId());
                break;
            }
            case "pushandsave2pay": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void showErrorMsg(List<String> errMsgList) {
        String str = String.join((CharSequence)",", errMsgList);
        this.getView().showErrorNotification(str);
    }

    private boolean volidRepayInstPlanOp(BeforeDoOperationEventArgs args, String operateKey, DynamicObject loanBill) {
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
        if (RepaymentWayEnum.isHbfx((String)loanBill.getString("repaymentway"))) {
            this.getView().showTipNotification(bizResource.getLbRepaymentplan_OpError());
            args.setCancel(true);
            return true;
        }
        if (DrawTypeEnum.CLOSEOUT.getValue().equals(loanBill.getString("drawtype"))) {
            this.getView().showTipNotification(CfmFormResourceEnum.LoanBillList_01.loadKDString());
            args.setCancel(true);
            return true;
        }
        if ("updateinstplan".equals(operateKey)) {
            DynamicObject productDO = loanBill.getDynamicObject("productfactory");
            if (EmptyUtil.isNoEmpty((DynamicObject)productDO) && !productDO.getBoolean("iscallint")) {
                this.getView().showTipNotification(CfmFormResourceEnum.RepaymentPlanTabPlugin_04.loadKDString());
                args.setCancel(true);
                return true;
            }
            if (!InterestTypeEnum.FLOAT.getValue().equals(loanBill.getString("interesttype")) && EmptyUtil.isEmpty((Object)loanBill.get("loanrate"))) {
                String tips = CfmFormResourceEnum.RepaymentPlanTabPlugin_03.loadKDString();
                if (LoanTypeEnum.BOND.getValue().equals(loanBill.getString("loantype"))) {
                    tips = CfmFormResourceEnum.RepaymentPlanTabPlugin_05.loadKDString();
                }
                this.getView().showTipNotification(tips);
                args.setCancel(true);
                return true;
            }
        }
        return false;
    }

    private void checkPush2repaymentBill(BeforeDoOperationEventArgs args) {
        Long loanBillId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)loanBillId)) {
            args.setCancel(true);
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject loanBillDO = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill");
        String billstatus = loanBillDO.getString("billstatus");
        String drawtype = loanBillDO.getString("drawtype");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBillDO.getString("datasource"));
        if (!StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            this.getView().showErrorNotification(bizResource.getLbLoanbillPushRepaymentbillError());
            args.setCancel(true);
            return;
        }
        if (!CfmBillCommonHelper.pushOpConfirmStatusValid((DynamicObject)loanBillDO)) {
            this.getView().showTipNotification(bizResource.getConfirmStatusError());
            args.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((BigDecimal)loanBillDO.getBigDecimal("notrepayamount"))) {
            this.getView().showTipNotification(bizResource.getUnRepayAmtIsNotNull());
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.CLOSEOUT.getValue()) || StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.DRAWING.getValue())) {
            if ("buyback".equals(operateKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u4e1a\u52a1\u72b6\u6001\u4e3a\u53d1\u884c\u4e2d/\u5df2\u7ed3\u6e05\u7684\u503a\u5238\u53d1\u884c\u5355\u4e0d\u80fd\u8fdb\u884c\u56de\u552e\u3002", (String)"LoanBillList_15", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(bizResource.getLbPushrepaymentbillError());
            }
            args.setCancel(true);
            return;
        }
        DynamicObject onWayApply = LoanBillApplyHelper.queryOnWayApply((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayApply)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u6216\u975e\u5df2\u529e\u7406\u7684\u53d8\u66f4\u5355\u636e%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_2", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayApply.getString("billno")}));
            args.setCancel(true);
        }
    }

    private void isOnWayApply(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection onWayApplys = LoanBillApplyHelper.queryOnWayApplyByIds((Collection)this.getSelectedIdList());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)onWayApplys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u6216\u975e\u5df2\u529e\u7406\u7684\u53d8\u66f4\u5355\u636e%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_2", (String)"tmc-cfm-formplugin", (Object[])new Object[]{((DynamicObject)onWayApplys.get(0)).getString("billno")}));
            args.setCancel(true);
        }
    }

    private void repayInstPlanShowForm(boolean isRepay) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        BillShowParameter param = new BillShowParameter();
        param.setPkId(selectedRows.get(0).getPrimaryKeyValue());
        param.setFormId(CfmBillCommonHelper.getRePayInstPlanView((IFormView)this.getView(), (boolean)isRepay));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)param);
    }

    private void validatePush2SettleCenter(BeforeDoOperationEventArgs args) {
        Long loanId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)loanId)) {
            return;
        }
        IfmBizDealHelper.validatePush2SettleCenter((IFormView)this.getView(), (String)"cfm_loanbill", Collections.singletonList(loanId), (BeforeDoOperationEventArgs)args);
    }

    private void rateAdjust() {
        Long loanBillId = this.getSelectedId();
        DynamicObject loancontractBill = QueryServiceHelper.queryOne((String)"cfm_loanbill_bond", (String)"loancontractbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)loanBillId)});
        if (Objects.isNull(loancontractBill)) {
            return;
        }
        Long loancontractId = loancontractBill.getLong("loancontractbill");
        QFilter adjustFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("loancontractbill", "=", (Object)loancontractId));
        Object[] rateAdjustBills = TmcDataServiceHelper.load((String)"cfm_rateadjustbill", (String)"id,loancontractbill", (QFilter[])new QFilter[]{adjustFilter});
        if (EmptyUtil.isNoEmpty((Object[])rateAdjustBills)) {
            Long rateAdjustId = rateAdjustBills[0].getLong("id");
            HashMap<String, Long> paramMap = new HashMap<String, Long>();
            paramMap.put("selectedId", loancontractId);
            paramMap.put("rateAdjustId", rateAdjustId);
            this.getView().showConfirm(CfmFormResourceEnum.ContractBaseList_01.loadKDString(), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_RATEADJUST_CALLBACK"), new HashMap(), JSON.toJSONString(paramMap));
        } else {
            CfmRateAdjustHelper.showRateAdjustForm(null, (Long)loancontractId, (IFormView)this.getView());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "paybill_number": {
                CfmFormHelper.showPayBillList(args, this.getView());
                break;
            }
        }
    }
}

