/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class LoanBillPreInterestList
extends AbstractTmcBillBaseList {
    private static final String CLOSE_BACK_PRE_FILTER = "CLOSE_BACK_PRE_FILTER";
    private static final List<String> PRE_APPROVAL_LIST = new ArrayList<String>();
    private static final String LOAN_BILL_PROP = String.join((CharSequence)",", "id", "billno", "confirmstatus", "datasource", "billstatus", "org", "creditorg", "endpreinstdate", "cleardate", "endinstdate", "drawtype", "creditor", "repaymentway", "creditortype");

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!PRE_APPROVAL_LIST.contains(this.getFormId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblpreinterest"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "preinterest": {
                this.checkPreInterest(args);
                break;
            }
        }
    }

    private void checkPreInterest(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)LOAN_BILL_PROP, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIdList())});
        if (!this.checkRepeyWay(args, loanBills)) {
            return;
        }
        if (!this.checkConfirmStatus(args, loanBills)) {
            return;
        }
        if (!this.checkLastPreDate(args, loanBills)) {
            return;
        }
        if (!this.checkBankLoan(args, loanBills)) {
            return;
        }
        this.checkIfmLoan(args, loanBills);
    }

    private boolean checkLastPreDate(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills) {
        List illegalLoanNos = loanBills.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.getDate("endpreinstdate"))).filter(d -> EmptyUtil.isNoEmpty((Object)d.getDate("cleardate"))).filter(i -> EmptyUtil.isNoEmpty((Object)i.getDate("endinstdate"))).filter(o -> o.getDate("endpreinstdate").compareTo(o.getDate("endinstdate")) >= 0).map(d -> d.getString("billno")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(illegalLoanNos)) {
            AbstractBizResource bizBillResource = new BizResourceFactory().getBizResourceByFormId(this.getFormId());
            this.getView().showTipNotification(bizBillResource.getIllegalPreDate((Object)String.join((CharSequence)"\u3001", illegalLoanNos)));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean checkConfirmStatus(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills) {
        List illegalBizStatus = loanBills.stream().filter(d -> !StringUtils.equals((CharSequence)d.getString("confirmstatus"), (CharSequence)ConfirmStatusEnum.YETCONFIRM.getValue())).map(d -> d.getString("billno")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(illegalBizStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5355\u636e\u975e\u5df2\u786e\u8ba4\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u9884\u63d0\u64cd\u4f5c\u3002", (String)"LoanBillPreInterestList_01", (String)"tmc-cfm-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", illegalBizStatus)}));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean checkBankLoan(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills) {
        if (StringUtils.equals((CharSequence)"cfm_loanbill_b_l", (CharSequence)this.getFormId())) {
            boolean isSettleCenterLoan = LoanBillPreInterestList.isAllSettleCenterLoan(loanBills);
            if (!this.isSettleCenterLoan(args, loanBills, isSettleCenterLoan)) {
                return false;
            }
            if (!this.checkIsSetterCenterLaunch(args, loanBills, isSettleCenterLoan)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isAllSettleCenterLoan(DynamicObjectCollection loanBills) {
        return loanBills.stream().allMatch(d -> StringUtils.equals((CharSequence)d.getString("creditortype"), (CharSequence)CreditorTypeEnum.SETTLECENTER.getValue()));
    }

    private static boolean isSameSettleCenterLoan(DynamicObjectCollection loanBills) {
        return loanBills.stream().map(d -> d.getLong("creditor")).distinct().count() > 1L;
    }

    private boolean isSettleCenterLoan(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills, boolean isSettleCenterLoan) {
        if (!isSettleCenterLoan && !loanBills.stream().noneMatch(d -> StringUtils.equals((CharSequence)d.getString("creditortype"), (CharSequence)CreditorTypeEnum.SETTLECENTER.getValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5904\u7406\u503a\u6743\u4eba\u9700\u540c\u65f6\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u6216\u975e\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"LoanBillPreInterestList_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean checkIsSetterCenterLaunch(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills, boolean isSettleCenterLoan) {
        if (!isSettleCenterLoan) {
            return true;
        }
        ArrayList<String> illegalBankLaunchList = new ArrayList<String>(loanBills.size());
        for (DynamicObject loanBill : loanBills) {
            if (!TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CFM.getId(), (long)loanBill.getLong(EntityMetadataCache.getDataEntityType((String)this.getDataEntityName()).getMainOrg()), (String)"cfm003")) continue;
            illegalBankLaunchList.add(loanBill.getString("billno"));
        }
        if (EmptyUtil.isNoEmpty(illegalBankLaunchList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5355\u636e\u53c2\u6570\u63a7\u5236\u9700\u5728\u7ed3\u7b97\u4e2d\u5fc3\u8fdb\u884c\u9884\u63d0\uff0c\u4e0d\u80fd\u5728\u94f6\u884c\u63d0\u6b3e\u5904\u7406\u9875\u9762\u76f4\u63a5\u53d1\u8d77\u9884\u63d0\u3002", (String)"LoanBillPreInterestList_03", (String)"tmc-cfm-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", illegalBankLaunchList)}));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean checkIfmLoan(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills) {
        if (StringUtils.equals((CharSequence)"ifm_loanbill", (CharSequence)this.getFormId()) && LoanBillPreInterestList.isSameSettleCenterLoan(loanBills)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c\u9884\u63d0\u65f6\u7ed3\u7b97\u4e2d\u5fc3\u9700\u4e3a\u540c\u4e00\u4e2a\u3002", (String)"LoanBillPreInterestList_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean checkRepeyWay(BeforeDoOperationEventArgs args, DynamicObjectCollection loanBills) {
        List illegalBizStatus = loanBills.stream().filter(d -> RepaymentWayEnum.isHbfx((String)d.getString("repaymentway"))).map(d -> d.getString("billno")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(illegalBizStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5355\u636e\u8fd8\u6b3e\u65b9\u5f0f\u4e3a\u7b49\u989d\u672c\u606f\u6216\u7b49\u989d\u672c\u91d1\u6216\u7b49\u672c\u7b49\u606f\uff0c\u4e0d\u80fd\u8fdb\u884c\u9884\u63d0\u64cd\u4f5c\u3002", (String)"LoanBillPreInterestList_05", (String)"tmc-cfm-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", illegalBizStatus)}));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "preinterest": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.openAddNewNavigateForm();
                break;
            }
        }
    }

    private void openAddNewNavigateForm() {
        FormShowParameter showParameter = new FormShowParameter();
        this.setIfmInfo(showParameter);
        showParameter.setFormId("cfm_navigate_pre_addnew");
        showParameter.getCustomParams().put("entity", "cfm_intbill_batch_pre");
        showParameter.getCustomParams().put("formid", BatchIntViewInfoEnum.getInfoEnumByLoanIdAndOpType((String)this.getFormId(), (String)"preint").getFormId());
        showParameter.getCustomParams().put("fromLoanBill", "true");
        ListSelectedRowCollection selectedRowCollection = this.getSelectedRows().getBillListSelectedRowCollection();
        List collect = selectedRowCollection.stream().map(ListSelectedRow::getBillNo).collect(Collectors.toList());
        showParameter.getCustomParams().put("loanBillNos", String.join((CharSequence)";", collect));
        showParameter.getCustomParams().put("loanBillIds", this.getSelectedIdList());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_BACK_PRE_FILTER));
        StyleCss sc = new StyleCss();
        sc.setHeight("300px");
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        this.getView().showForm(showParameter);
    }

    private void setIfmInfo(FormShowParameter showParameter) {
        if (this.getFormId().equals("ifm_loanbill")) {
            DynamicObjectCollection ifmLoanBill = QueryServiceHelper.query((String)"ifm_loanbill", (String)"settlecenter", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIdList())});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)ifmLoanBill)) {
                return;
            }
            showParameter.getCustomParams().put("settlecenter", ((DynamicObject)ifmLoanBill.get(0)).get("settlecenter"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)CLOSE_BACK_PRE_FILTER, (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            this.initShowParameter(parameter);
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void initShowParameter(BillShowParameter parameter) {
        if ("ifm_loanbill".equals(this.getFormId())) {
            parameter.setFormId("ifm_preintbill_batch_l");
        } else {
            BatchIntViewInfoEnum viewInfo = BatchIntViewInfoEnum.getInfoEnumByLoanIdAndOpType((String)this.getFormId(), (String)"preint");
            parameter.setFormId(viewInfo.getFormId());
        }
    }

    private String getFormId() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getBillFormId();
    }

    static {
        PRE_APPROVAL_LIST.add("cfm_loanbill_b_l");
        PRE_APPROVAL_LIST.add("cfm_loanbill_bond");
        PRE_APPROVAL_LIST.add("cfm_loanbill_e_l");
        PRE_APPROVAL_LIST.add("cim_invest_loanbill");
        PRE_APPROVAL_LIST.add("ifm_loanbill");
    }
}

