/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BillTypeEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class LoanBillPush2InstNoBatchList
extends AbstractTmcBillBaseList {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "push2instnobatch": {
                this.push2interestBill(args);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "push2instnobatch": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                Long loanId = this.getSelectedId();
                LoanBillFormHelper.pushInterestBill(this.getView(), loanId);
            }
        }
    }

    private void push2interestBill(BeforeDoOperationEventArgs args) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        if (selectedRows.getPrimaryKeyValues().length > 1) {
            this.getView().showErrorNotification(new BizResourceFactory().getBizResource("").getLbBatcherror());
            args.setCancel(true);
        } else {
            DynamicObject[] batchInstBills;
            DynamicObject loanBillDO = TmcDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"cfm_loanbill", (String)"datasource,billstatus,drawtype,confirmstatus");
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBillDO.getString("datasource"));
            String billstatus = loanBillDO.getString("billstatus");
            String drawtype = loanBillDO.getString("drawtype");
            if (!CfmBillCommonHelper.pushOpConfirmStatusValid((DynamicObject)loanBillDO)) {
                this.getView().showTipNotification(bizResource.getConfirmStatusError());
                args.setCancel(true);
                return;
            }
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                if (StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.CLOSEOUT.getValue()) || StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.DRAWING.getValue())) {
                    this.getView().showErrorNotification(bizResource.getLbLoanbillPushInterestBillError());
                    args.setCancel(true);
                }
            } else {
                this.getView().showErrorNotification(bizResource.getLbPushInterestBillError());
                args.setCancel(true);
            }
            QFilter batchInstQFilter = new QFilter("entry.loanbillid", "=", (Object)loanBillDO.getLong("id")).and(new QFilter("biztype", "=", (Object)BillTypeEnum.LOAN.getValue())).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            for (DynamicObject batchInstBill : batchInstBills = TmcDataServiceHelper.load((String)"cfm_intbill_batch_loan", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{batchInstQFilter})) {
                this.getView().showErrorNotification(String.format(bizResource.checkBatchInstBillsConfirmStatus(), batchInstBill.getString("billno")));
            }
        }
    }
}

