/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoanBillRateList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(LoanBillRateList.class);
    public static final String ENTRY_RA_EFFECTDATE = "rateadjust_entry.ra_effectdate";

    public void packageData(PackageDataEvent e) {
        this.packageUnifyData(e.getRowData());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final BillList billList = (BillList)args.getSource();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dataList = super.getData(start, limit);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                long t1 = System.currentTimeMillis();
                String entityName = this.getEntityType().getName();
                LoanBillRateList.addUnifyListProps(billList, dataList);
                DataEntityPropertyCollection properties = ((DynamicObject)dataList.get(0)).getDynamicObjectType().getProperties();
                Map latestRateMap = null;
                boolean containLastRateProp = properties.containsKey((Object)"latestrate");
                if (containLastRateProp) {
                    latestRateMap = LoanBillRateList.this.getLatestRateMap(dataList);
                }
                boolean containNoFixTermProp = properties.containsKey((Object)"isnofixedterm");
                boolean isPerpBond = StringUtils.equals((CharSequence)"cfm_loanbill_bond", (CharSequence)entityName) && properties.containsKey((Object)"finproduct");
                for (DynamicObject v : dataList) {
                    if (containNoFixTermProp && v.getBoolean("isnofixedterm")) {
                        if (properties.containsKey((Object)"expiredate")) {
                            v.set("expiredate", null);
                        }
                        if (properties.containsKey((Object)"term")) {
                            v.set("term", (Object)" ");
                        }
                    }
                    if (containLastRateProp) {
                        LoanBillRateList.this.setLatestRate(latestRateMap, v);
                    }
                    if (!isPerpBond) continue;
                    LoanBillRateList.hideExpireDateWhenPerpBond(entityName, v, properties);
                }
                long t2 = System.currentTimeMillis();
                logger.info("\u5217\u8868\u8d4b\u503c\u5904\u7406\u7528\u65f6\uff1a {} ms", (Object)(t2 - t1));
                return dataList;
            }
        });
    }

    private void setLatestRate(Map<Long, DynamicObject> latestRateMap, DynamicObject v) {
        DynamicObject rateObj = latestRateMap.get(v.getLong("id"));
        if (EmptyUtil.isNoEmpty((DynamicObject)rateObj)) {
            v.set("latestrate", (Object)rateObj.getBigDecimal("rateadjust_entry.ra_yearrate"));
        } else {
            v.set("latestrate", (Object)BigDecimal.ZERO);
        }
    }

    private static void hideExpireDateWhenPerpBond(String entityName, DynamicObject v, DataEntityPropertyCollection properties) {
        Boolean isPerpetual = Optional.ofNullable(v.getDynamicObject("finproduct")).map(r -> r.getBoolean("perpetualbond")).orElse(Boolean.FALSE);
        if (!isPerpetual.booleanValue()) {
            return;
        }
        if (properties.containsKey((Object)"term")) {
            v.set("term", null);
        }
        if (properties.containsKey((Object)"expiredate")) {
            v.set("expiredate", null);
        }
    }

    private static void addListProps(DynamicObjectCollection dataList, String prop) {
        DynamicSimpleProperty addProp = new DynamicSimpleProperty();
        addProp.setName(prop);
        addProp.setDisplayName(new LocaleString(prop));
        dataList.getDynamicObjectType().getProperties().add((Object)addProp);
    }

    private static void addUnifyListProps(BillList billList, DynamicObjectCollection dataList) {
        if (StringUtils.equals((CharSequence)"cfm_loanbill_unifyreturn", (CharSequence)billList.getBillFormId())) {
            LoanBillRateList.addListProps(dataList, "unifyloanuse_entry.u_payamt");
            LoanBillRateList.addListProps(dataList, "unifyloanuse_entry.u_useloanamt");
            LoanBillRateList.addListProps(dataList, "unifyloanuse_entry.u_payint");
            LoanBillRateList.addListProps(dataList, "unifyloanuse_entry.u_notpayint");
        }
    }

    private void packageUnifyData(DynamicObject rowData) {
        String formId = ((ListView)this.getView()).getBillFormId();
        if (!StringUtils.equals((CharSequence)"cfm_loanbill_unifyreturn", (CharSequence)formId)) {
            return;
        }
        DataEntityPropertyCollection properties = rowData.getDynamicObjectType().getProperties();
        if (!properties.containsKey((Object)"unifyloanuse_entry.u_useamt")) {
            return;
        }
        BigDecimal useAmt = rowData.getBigDecimal("unifyloanuse_entry.u_useamt");
        DynamicObject loanBill = rowData.getDynamicObject("unifyloanuse_entry.u_loanbillid");
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            return;
        }
        BigDecimal drawAmt = loanBill.getBigDecimal("drawamount");
        int scale = Optional.ofNullable(rowData.getDynamicObject("currency")).map(r -> r.getInt("amtprecision")).orElse(10);
        BigDecimal repayPart = loanBill.getBigDecimal("repayamount").multiply(useAmt).divide(drawAmt, scale, 4);
        rowData.set("unifyloanuse_entry.u_payamt", (Object)repayPart);
        rowData.set("unifyloanuse_entry.u_useloanamt", (Object)useAmt.subtract(repayPart));
        BigDecimal intPart = loanBill.getBigDecimal("payinterestamount").multiply(useAmt).divide(drawAmt, scale, 4);
        rowData.set("unifyloanuse_entry.u_payint", (Object)intPart);
        BigDecimal futureIntPart = loanBill.getBigDecimal("calculaterateamount").multiply(useAmt).divide(drawAmt, scale, 4);
        rowData.set("unifyloanuse_entry.u_notpayint", (Object)futureIntPart);
    }

    private Map<Long, DynamicObject> getLatestRateMap(DynamicObjectCollection dataList) {
        List idList = dataList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        Date currentDate = DateUtils.getCurrentDate();
        String selectFields = "id,rateadjust_entry.ra_effectdate,rateadjust_entry.ra_yearrate";
        QFilter qFilter = new QFilter("id", "in", idList);
        QFilter dateFilter1 = QFilter.isNull((String)"cleardate").and(ENTRY_RA_EFFECTDATE, "<=", (Object)currentDate);
        QFilter dateFilter2 = QFilter.isNotNull((String)"cleardate").and(QFilter.sqlExpress((String)ENTRY_RA_EFFECTDATE, (String)"<=", (String)"fcleardate"));
        qFilter.and(dateFilter1.or(dateFilter2));
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)selectFields, (QFilter[])qFilter.toArray());
        return loanBills.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (a, b) -> a.getDate(ENTRY_RA_EFFECTDATE).compareTo(b.getDate(ENTRY_RA_EFFECTDATE)) >= 0 ? a : b));
    }
}

