/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.helper.IntcalMethodChgHelper;

public class LoanProductFactoryEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit productFactory = (BasedataEdit)this.getControl("productfactory");
        if (EmptyUtil.isNoEmpty((Object)productFactory)) {
            productFactory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "productfactory": {
                LoanBillFormHelper.productFactoryF7Evt(evt, this.getModel(), this.getView());
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.intcalMethodChgEvt(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("productfactory".equals(propName)) {
            this.productFactoryChgEvt();
            this.resetRateResetCycleDate();
        }
        switch (propName) {
            case "productfactory": {
                this.productFactoryChgEvt();
                this.resetRateResetCycleDate();
                break;
            }
            case "intcalmethod": {
                this.intcalMethodChgEvt(true);
                break;
            }
        }
    }

    private void intcalMethodChgEvt(boolean isChgEvt) {
        String intcalMethod = (String)this.getModel().getValue("intcalmethod");
        String billStatus = (String)this.getModel().getValue("billstatus");
        ComboEdit basis = (ComboEdit)this.getControl("basis");
        if (basis == null || EmptyUtil.isEmpty((String)intcalMethod)) {
            return;
        }
        List comboItems = IntcalMethodChgHelper.getBasisComboItem((String)intcalMethod, (String)billStatus);
        basis.setComboItems(comboItems);
        if (isChgEvt && EmptyUtil.isNoEmpty((Object)comboItems)) {
            this.getModel().setValue("basis", (Object)((ComboItem)comboItems.get(0)).getValue());
        }
    }

    private void productFactoryChgEvt() {
        DynamicObject loanContract = (DynamicObject)this.getModel().getValue("loancontractbill");
        DynamicObject pf = loanContract.getDynamicObject("productfactory");
        DynamicObject newPf = (DynamicObject)this.getModel().getValue("productfactory");
        if (newPf == null || pf != null && pf.getLong("id") == newPf.getLong("id")) {
            this.revertValue();
        } else {
            newPf = TmcDataServiceHelper.loadSingle((Object)newPf.getPkValue(), (String)newPf.getDynamicObjectType().getName());
            this.getModel().setValue("repaymentway", (Object)newPf.getString("repaymentmode"));
            if (newPf.getBoolean("iscallint")) {
                this.getModel().setValue("settleintmode", (Object)newPf.getString("settleintmode"));
                this.getModel().setValue("basis", (Object)newPf.getString("basis"));
                String rateAdjustMethod = newPf.getString("rateadjustmethod");
                this.getModel().setValue("rateadjuststyle", (Object)rateAdjustMethod);
                if (RateAdjustStyleEnum.isCycle((String)rateAdjustMethod) || RateAdjustStyleEnum.isAfterint((String)rateAdjustMethod)) {
                    this.getModel().setValue("rateresetdays", (Object)newPf.getInt("rateresetdays"));
                }
                this.getModel().setValue("rateresetadjustrule", (Object)newPf.getString("rateresetadjustrule"));
                this.getModel().setValue("intcalmethod", (Object)newPf.getString("intcalmethod"));
                this.getModel().setValue("issofrrate", (Object)newPf.getString("issofrrate"));
                this.getModel().setValue("iscallcompint", (Object)newPf.getString("iscallcompint"));
            } else {
                this.getModel().setValue("basis", null);
                this.getModel().setValue("rateadjuststyle", null);
            }
        }
        if (this.isSofr()) {
            this.getModel().setValue("ratesign", (Object)RateSignEnum.ADD.getValue());
        }
        this.getView().setEnable(Boolean.valueOf(!this.isSofr()), new String[]{"ratesign"});
    }

    private void revertValue() {
        DynamicObject loanContract = (DynamicObject)this.getModel().getValue("loancontractbill");
        String bizType = (String)this.getModel().getValue("loantype");
        if (!BizTypeEnum.isBond((String)bizType)) {
            this.setValue(loanContract.getString("repaymentway"), loanContract.getString("settleintmode"), loanContract.getString("basis"), loanContract.getString("rateadjuststyle"), loanContract.getInt("rateresetdays"), loanContract.getBoolean("issofrrate"), loanContract.getBoolean("iscallcompint"));
            return;
        }
        DynamicObject productFactory = loanContract.getDynamicObject("productfactory");
        if (EmptyUtil.isEmpty((DynamicObject)productFactory)) {
            this.setValue(RepaymentWayEnum.bqhbdqhx.getValue(), SettleIntModeEnum.gdpljx.getValue(), BasisEnum.Actual_360.getValue(), RateAdjustStyleEnum.CYCLE.getValue(), 0, false, false);
        }
    }

    private void setValue(String repaymentWay, String settelIntMode, String basis, String rateAdjustMethod, int rateResetDays, boolean isSofrRate, boolean isCallCompInt) {
        this.getModel().setValue("repaymentway", (Object)repaymentWay);
        this.getModel().setValue("settleintmode", (Object)settelIntMode);
        this.getModel().setValue("basis", (Object)basis);
        this.getModel().setValue("rateadjuststyle", (Object)rateAdjustMethod);
        this.getModel().setValue("issofrrate", (Object)isSofrRate);
        this.getModel().setValue("iscallcompint", (Object)isCallCompInt);
        if (RateAdjustStyleEnum.isCycle((String)rateAdjustMethod) || RateAdjustStyleEnum.isAfterint((String)rateAdjustMethod)) {
            this.getModel().setValue("rateresetdays", (Object)rateResetDays);
        }
    }

    private void resetRateResetCycleDate() {
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        Date startDate = (Date)this.getModel().getValue("startintdate");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendar) || EmptyUtil.isEmpty((Object)startDate) || !this.isSofr()) {
            return;
        }
        int resetDays = (Integer)this.getModel().getValue("rateresetdays");
        Date rateResetCycleDate = CfmBillCommonHelper.getLastDayByWorkCalendar((DynamicObjectCollection)workCalendar, (int)resetDays, (Date)startDate, (int)1);
        this.getModel().setValue("rateadjustdate", (Object)rateResetCycleDate);
    }

    private boolean isSofr() {
        return LoanBillFormHelper.isSofr(this.getModel());
    }
}

