/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanUnderwriterEdit
extends AbstractBasePlugIn {
    public void afterBindData(EventObject e) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"e_underwritertype", "e_underwriter", "e_underwriteratio", "e_underwriteamount"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if ("underwriter_entry".equals(entryProp.getName())) {
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            if (rowIndex == 0) {
                this.getModel().setValue("e_underwritertype", (Object)"lead", rowIndex);
                this.getModel().setValue("e_isbookrunner", (Object)true, rowIndex);
            } else {
                this.getModel().setValue("e_underwritertype", (Object)"joint", rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentryw": {
                BigDecimal publishAmt = (BigDecimal)this.getModel().getValue("drawamount");
                if (!EmptyUtil.isEmpty((BigDecimal)publishAmt)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "e_underwriteratio": 
            case "e_underwriteamount": 
            case "e_isbookrunner": {
                this.underwriteChgEvt(e);
                break;
            }
            case "drawamount": {
                this.amountChgEvt(e);
                break;
            }
        }
    }

    private void amountChgEvt(PropertyChangedArgs e) {
        int row = this.getModel().getEntryRowCount("underwriter_entry");
        this.getModel().beginInit();
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("drawamount");
        for (int rowIndex = 0; rowIndex < row; ++rowIndex) {
            BigDecimal ratio = (BigDecimal)this.getModel().getValue("e_underwriteratio", rowIndex);
            this.getModel().setValue("e_underwriteamount", (Object)ratio.multiply(totalAmt).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("underwriter_entry");
    }

    private void underwriteChgEvt(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("drawamount");
        block5 : switch (key) {
            case "e_underwriteratio": {
                if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteamount", (Object)BigDecimal.ZERO, (int)rowIndex);
                    break;
                }
                BigDecimal underwriteAmt = totalAmt.multiply((BigDecimal)newValue).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteamount", (Object)underwriteAmt, (int)rowIndex);
                break;
            }
            case "e_underwriteamount": {
                BigDecimal underwriteRatio;
                if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteratio", (Object)BigDecimal.ZERO, (int)rowIndex);
                    return;
                }
                BigDecimal underWriteAmount = (BigDecimal)newValue;
                EntryGrid entryGrid = (EntryGrid)this.getControl("underwriter_entry");
                BigDecimal sum_underWriteAmount = entryGrid.getSum("e_underwriteamount").subtract(underWriteAmount);
                if (underWriteAmount.compareTo(totalAmt.subtract(sum_underWriteAmount)) == 0) {
                    BigDecimal rowIndexRatio = (BigDecimal)this.getModel().getValue("e_underwriteratio", rowIndex);
                    BigDecimal sum_underWriteRatio = entryGrid.getSum("e_underwriteratio").subtract(rowIndexRatio);
                    underwriteRatio = new BigDecimal("100").subtract(sum_underWriteRatio);
                } else {
                    underwriteRatio = underWriteAmount.divide(totalAmt, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteratio", (Object)underwriteRatio, (int)rowIndex);
                break;
            }
            case "e_isbookrunner": {
                boolean isBookrunner = (Boolean)newValue;
                if (!isBookrunner) break;
                int rc = this.getModel().getEntryRowCount("underwriter_entry");
                for (int i = 0; i < rc; ++i) {
                    boolean _isbookrunner = (Boolean)this.getModel().getValue("e_isbookrunner", i);
                    if (!_isbookrunner || i == rowIndex) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_isbookrunner", (Object)Boolean.FALSE, (int)i);
                    break block5;
                }
                break;
            }
        }
    }
}

