/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.formplugin.common.CommonBillFormHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentInfoTabPlugin
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        this.repaymentbillnoClick();
        this.payinterestbillnoClick();
        this.initDrawPayInterestTab();
        EntryGrid rateHisEntry = (EntryGrid)this.getControl("ratehistory_entry");
        rateHisEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex;
        String fieldName = evt.getFieldName();
        if ("rh_rateadjno".equals(fieldName) && (rowIndex = evt.getRowIndex()) > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("ratehistory_entry", rowIndex);
            String rateAdjNumb = entryRowEntity.getString("rh_rateadjno");
            if (EmptyUtil.isNoEmpty((String)rateAdjNumb)) {
                DynamicObject rateAdjObj = TmcDataServiceHelper.loadSingle((String)"cfm_rateadjustbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)rateAdjNumb)});
                if (EmptyUtil.isEmpty((DynamicObject)rateAdjObj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RepaymentInfoTabPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(CfmRateAdjustHelper.getFormEntityFromLoanBill((IFormView)this.getView()));
                parameter.setPkId((Object)rateAdjObj.getLong("id"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RepaymentInfoTabPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.initDrawPayInterestTab();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)"cfm_loanbill", (CharSequence)formId) || StringUtils.equals((CharSequence)"cfm_loanbill_b_l", (CharSequence)formId) || StringUtils.equals((CharSequence)"cfm_loanbill_e_l", (CharSequence)formId) || StringUtils.equals((CharSequence)"cfm_loanbill_bond", (CharSequence)formId) || StringUtils.equals((CharSequence)"cim_invest_loanbill", (CharSequence)formId)) {
            this.initSumtab();
        }
    }

    private void initDrawPayInterestTab() {
        Long loanBillId = (Long)this.getModel().getValue("id");
        QFilter sourcebillidFilter = new QFilter("sourcebillid", "=", (Object)loanBillId);
        QFilter billListFilter = CommonBillFormHelper.getBillListFilter(this.getView());
        if (billListFilter != null) {
            sourcebillidFilter.and(billListFilter);
        }
        if (this.getControl("interestbilllistap") != null) {
            BillList interestbillList = (BillList)this.getControl("interestbilllistap");
            interestbillList.addSetFilterListener(evt -> {
                sourcebillidFilter.and(new QFilter("settlestatus", "!=", (Object)"hide"));
                evt.getQFilters().add(sourcebillidFilter);
            });
        }
        if (this.getControl("drawbilllistap") != null) {
            BillList drawbilllist = (BillList)this.getControl("drawbilllistap");
            drawbilllist.addSetFilterListener(evt -> {
                QFilter sourceIdFilter = new QFilter("loans.e_loanbill", "=", (Object)loanBillId);
                if (loanBillId == 0L) {
                    sourceIdFilter.and(new QFilter("datasource", "=", (Object)"0"));
                }
                evt.getQFilters().add(sourceIdFilter);
            });
        }
    }

    private void initSumtab() {
        boolean isDataChange = this.getModel().getDataChanged();
        BigDecimal notrepayamount = (BigDecimal)this.getModel().getValue("notrepayamount");
        Date renewalexpiredate = (Date)this.getModel().getValue("renewalexpiredate");
        Date expiredate = (Date)this.getModel().getValue("expiredate");
        Date currentDate = DateUtils.getCurrentDate();
        String drawtype = (String)this.getModel().getValue("drawtype");
        int overduedate = 0;
        if (notrepayamount.compareTo(BigDecimal.ZERO) > 0 && !StringUtils.equals((CharSequence)drawtype, (CharSequence)DrawTypeEnum.CLOSEOUT.getValue())) {
            if (EmptyUtil.isNoEmpty((Object)renewalexpiredate) && currentDate.after(renewalexpiredate)) {
                overduedate = DateUtils.getDiffDays((Date)renewalexpiredate, (Date)DateUtils.getCurrentDate()) - 1;
            } else if (EmptyUtil.isEmpty((Object)renewalexpiredate) && currentDate.after(expiredate)) {
                overduedate = DateUtils.getDiffDays((Date)expiredate, (Date)DateUtils.getCurrentDate()) - 1;
            }
        }
        this.getModel().setValue("overduedate", (Object)overduedate);
        this.getModel().setDataChanged(isDataChange);
    }

    private void repaymentbillnoClick() {
        BillList drawbilllist = (BillList)this.getControl("drawbilllistap");
        if (EmptyUtil.isNoEmpty((Object)drawbilllist)) {
            drawbilllist.addHyperClickListener(evt -> {
                String fieldName = evt.getFieldName();
                BillList billList = (BillList)evt.getSource();
                if (StringUtils.equals((CharSequence)"billno", (CharSequence)fieldName)) {
                    Long focusRowPkId = (Long)billList.getFocusRowPkId();
                    this.openRepaymentbillPage(focusRowPkId);
                } else if (StringUtils.equals((CharSequence)"payeebillno", (CharSequence)fieldName)) {
                    Long focusRowPkId = (Long)billList.getFocusRowPkId();
                    TmcBotpHelper.showBillParamter((String)"cfm_repaymentbill", (Long)focusRowPkId, (IFormView)this.getView(), (String)"cas_paybill");
                } else if (StringUtils.equals((CharSequence)"recbillno", (CharSequence)fieldName)) {
                    Long focusRowPkId = (Long)billList.getFocusRowPkId();
                    TmcBotpHelper.showBillParamter((String)"cim_invest_repaybill", (Long)focusRowPkId, (IFormView)this.getView(), (String)"cas_recbill");
                }
            });
        }
    }

    private void payinterestbillnoClick() {
        BillList interestbilllist = (BillList)this.getControl("interestbilllistap");
        if (EmptyUtil.isNoEmpty((Object)interestbilllist)) {
            interestbilllist.addHyperClickListener(evt -> {
                String fieldName = evt.getFieldName();
                BillList billList = (BillList)evt.getSource();
                Long focusRowPkId = (Long)billList.getFocusRowPkId();
                if (StringUtils.equals((CharSequence)"billno", (CharSequence)fieldName)) {
                    this.openInterestbillPage(focusRowPkId);
                } else if (StringUtils.equals((CharSequence)"payeebillno", (CharSequence)fieldName)) {
                    TmcBotpHelper.showBillParamter((String)"cfm_interestbill", (Long)focusRowPkId, (IFormView)this.getView(), (String)"cas_paybill");
                } else if (StringUtils.equals((CharSequence)"recbillno", (CharSequence)fieldName)) {
                    TmcBotpHelper.showBillParamter((String)"cim_invest_interestbill", (Long)focusRowPkId, (IFormView)this.getView(), (String)"cas_recbill");
                }
            });
        }
    }

    private void openRepaymentbillPage(Long repaymentId) {
        BillShowParameter param = new BillShowParameter();
        param.setPkId((Object)repaymentId);
        param.setFormId(FormParameterHelper.getRepayBillFormByBizType((IFormView)this.getView()));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)param);
    }

    private void openInterestbillPage(Long interestId) {
        BillShowParameter param = new BillShowParameter();
        param.setPkId((Object)interestId);
        param.setFormId(FormParameterHelper.getInterestBillFormByBizType((IFormView)this.getView()));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }
}

