/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.LoanBillApplyFormHelper;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentPlanTabPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit repayAccount = (BasedataEdit)this.getControl("repayaccount");
        repayAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (Boolean.TRUE.toString().equals(formOperate.getOption().getVariables().get("stop_beforeDoOperation"))) {
            return;
        }
        if (args.isCancel()) {
            return;
        }
        switch (operateKey = formOperate.getOperateKey()) {
            case "submit": {
                this.validateWhenPepertual(args);
                break;
            }
            case "repaymentsc": 
            case "updateinstplan": {
                this.volidRepayInstPlanOp(args, operateKey);
                DynamicObject loanBill = this.getModel().getDataEntity();
                String dataSource = loanBill.getString("datasource");
                if (DataSourceEnum.isBond((String)dataSource) || DataSourceEnum.isFl((String)dataSource)) {
                    return;
                }
                LoanBillApplyFormHelper.validateCfmPlanParam(args, this.getView(), loanBill);
                break;
            }
            case "change": {
                if (LoanBillApplyFormHelper.isOpenApplyForm(this.getView(), this.getModel().getDataEntity().getLong("id"))) break;
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.validateRepaymentWay();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getProperty().getName()) {
            case "repayaccount": {
                this.setRepayAccountFilter(evt);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "repaymentway": {
                this.validateRepaymentWay();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "repaymentsc": 
            case "updateinstplan": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.repayInstPlanShowForm("repaymentsc".equals(operateKey));
                break;
            }
            case "checkinterest": {
                this.checkinterestShowForm();
                break;
            }
            case "change": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                LoanBillApplyFormHelper.openApplyForm(this.getView(), this.getView().getFormShowParameter().getFormId(), this.getModel().getDataEntity().getPkValue());
                break;
            }
        }
    }

    private void volidRepayInstPlanOp(BeforeDoOperationEventArgs args, String operateKey) {
        String repaymentWay = (String)this.getModel().getValue("repaymentway");
        ArrayList noOpPlanWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue()});
        if (noOpPlanWays.contains(repaymentWay)) {
            String dataSource = (String)this.getModel().getValue("datasource");
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            this.getView().showTipNotification(bizResource.getLbRepaymentplan_OpError());
            args.setCancel(true);
            return;
        }
        if ("updateinstplan".equals(operateKey)) {
            if (DrawTypeEnum.CLOSEOUT.getValue().equals(this.getModel().getValue("drawtype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u4e1a\u52a1\u72b6\u6001\u4e3a\u5df2\u7ed3\u6e05,\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"LoanBillList_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject productDO = (DynamicObject)this.getModel().getValue("productfactory");
            if (EmptyUtil.isNoEmpty((DynamicObject)productDO) && !productDO.getBoolean("iscallint")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u578b\u4e3a\u4e0d\u8ba1\u606f,\u4e0d\u80fd\u7ef4\u62a4\u4ed8/\u6536\u606f\u8ba1\u5212\u3002", (String)"RepaymentPlanTabPlugin_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!InterestTypeEnum.FLOAT.getValue().equals(this.getModel().getValue("interesttype")) && EmptyUtil.isEmpty((Object)this.getModel().getValue("loanrate"))) {
                String tips = ResManager.loadKDString((String)"\u5229\u7387\u4e3a0,\u4e0d\u80fd\u7ef4\u62a4\u4ed8/\u6536\u606f\u8ba1\u5212\u3002", (String)"RepaymentPlanTabPlugin_03", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
                if (LoanTypeEnum.BOND.getValue().equals(this.getModel().getValue("loantype"))) {
                    tips = ResManager.loadKDString((String)"\u56fa\u5b9a\u606f\u7968\u7387\u4e3a0,\u4e0d\u80fd\u7ef4\u62a4\u4ed8\u606f\u8ba1\u5212\u3002", (String)"RepaymentPlanTabPlugin_05", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
                }
                this.getView().showTipNotification(tips);
                args.setCancel(true);
            }
        }
    }

    private void validateRepaymentWay() {
        DynamicObject loanBill = this.getModel().getDataEntity();
        String repaymentWay = loanBill.getString("repaymentway");
        ArrayList repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue()});
        if (repayWays.contains(repaymentWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"stageplan"});
        }
        if (!RepaymentWayEnum.debx.getValue().equals(repaymentWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"exdrawamount"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"repaymentsc", (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        } else if ("cfm_rateadjust_callback".equals(e.getActionId()) && EmptyUtil.isNoEmpty((Object)returnData)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void checkinterestShowForm() {
        IDataModel model = this.getModel();
        DynamicObject interest_entry = (DynamicObject)model.getEntryEntity("interest_entry").get(model.getEntryCurrentRowIndex("interest_entry"));
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (this.getModel().getDataEntity().getBoolean("issofrrate")) {
            param.put("formId", "cfm_intcaldetailsofrcard");
        } else {
            param.put("formId", "cfm_intcaldetailcard");
        }
        param.put("loanBillId", this.getModel().getDataEntity().getPkValue());
        param.put("interestEntryId", interest_entry.getPkValue());
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void repayInstPlanShowForm(boolean isRepay) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "repaymentsc");
        BillShowParameter param = new BillShowParameter();
        param.setPkId(this.getModel().getDataEntity().getPkValue());
        param.setFormId(CfmBillCommonHelper.getRePayInstPlanView((IFormView)this.getView(), (boolean)isRepay));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)param);
    }

    private void setRepayAccountFilter(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{org, currency})) {
            QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
            qFilter.and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
            qFilter.and("currency.fbasedataid", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void validateWhenPepertual(BeforeDoOperationEventArgs args) {
        if (StringUtils.equals((CharSequence)"cfm_loanbill_bond", (CharSequence)this.getView().getFormShowParameter().getFormId())) {
            LoanBillFormHelper.validateRateRangeLimit(args, this.getView(), this.getModel());
            if (args.isCancel()) {
                return;
            }
            boolean isPerpetual = (Boolean)this.getModel().getValue("issetpluspoint");
            if (isPerpetual) {
                DynamicObjectCollection plusPointEntry = this.getModel().getEntryEntity("condition_entry_er");
                long notNullNum = plusPointEntry.stream().filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("pluspoint_er"))).count();
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)plusPointEntry) && plusPointEntry.size() > 1 && notNullNum == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5229\u7387\u52a0\u70b9\u6570\u5206\u5f55\u7684\u52a0\u70b9\u6570\u672a\u5f55\u5165\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"BondLoanBillEdit_24", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.setVariForSubmitOp(args);
            }
        }
    }

    private void setVariForSubmitOp(BeforeDoOperationEventArgs args) {
        boolean isPerpetual = (Boolean)this.getModel().getValue("issetpluspoint");
        if (isPerpetual && LoanBillFormHelper.judgeDataIsChanged(this.getModel())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5229\u7387\u91cd\u7f6e\u5206\u5f55\u5c06\u53d8\u66f4\uff0c\u5229\u7387\u52a0\u70b9\u6570\u5206\u5f55\u7684\u52a0\u70b9\u6570\u4e5f\u5c06\u6e05\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u91cd\u65b0\u5f55\u5165\u52a0\u70b9\u6570\u3002", (String)"BondLoanBillEdit_29", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

