/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbillapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanBillRepayPlanHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LoanBillApplyEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(LoanBillApplyEdit.class);
    private static final Set<String> propList = new HashSet<String>(32);
    private static final String props;
    private static final String repayPlanProps;
    private static final String interestEntryProps;
    private static final String interestSubEntryProps;
    public static final String SELECT_LOAN_BILL_CALLBACK = "selectLoanBillCallBack";

    public void registerListener(EventObject e) {
        BasedataEdit intAccount;
        super.registerListener(e);
        TextEdit loanBillTextF7 = (TextEdit)this.getControl("loanbillno");
        loanBillTextF7.addClickListener((ClickListener)this);
        BasedataEdit rePayAccount = (BasedataEdit)this.getControl("repayaccount");
        if (EmptyUtil.isNoEmpty((Object)rePayAccount)) {
            rePayAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(intAccount = (BasedataEdit)this.getControl("intaccount")))) {
            intAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object loanBillId = this.getView().getFormShowParameter().getCustomParam("loanbill");
        if (EmptyUtil.isNoEmpty((Object)loanBillId)) {
            this.initByLoanBill(loanBillId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCanEditByIntState();
        this.setCanEditByRepayState();
        this.initDateEnable();
        this.setLockByRepayWay();
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "loanbillno": {
                    this.openLoanBill();
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"repayaccount") || StringUtils.equals((CharSequence)propName, (CharSequence)"intaccount")) {
            QFilter qFilter = new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
            String creditorType = (String)this.getModel().getValue("creditortype");
            String acctClassify = StringUtils.equals((CharSequence)creditorType, (CharSequence)CreditorTypeEnum.SETTLECENTER.getValue()) ? "I" : "B";
            qFilter.and(new QFilter("acctclassify", "=", (Object)acctClassify));
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
                DynamicObject currency;
                Long creditorId = this.getModel().getDataEntity().getLong("creditor");
                if (EmptyUtil.isNoEmpty((Long)creditorId)) {
                    qFilter.and(new QFilter("bank.id", "=", (Object)creditorId));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency")))) {
                    qFilter.and("currency.fbasedataid", "=", currency.getPkValue());
                }
            } else {
                qFilter.and(new QFilter("acctclassify", "!=", (Object)"I"));
            }
            ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        String error = this.checkLoanBillNotEmpty();
        if (EmptyUtil.isNoEmpty((String)error)) {
            args.setCancel(true);
            this.getView().showTipNotification(error);
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "calinstplan": {
                if (this.isExRepaymentDateNull()) {
                    args.setCancel(true);
                    return;
                }
                Boolean isHandinstPlan = (Boolean)this.getModel().getValue("handinstplan");
                if ("true".equals(formOperate.getOption().getVariableValue("ispassVoid", "")) || isHandinstPlan.booleanValue()) break;
                this.showConfirmTip(operateKey);
                args.setCancel(true);
                break;
            }
            case "submit": {
                this.updatePlanEntry();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "save": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "calinstplan": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.reCalInstPlanAndSetVal((Boolean)this.getModel().getValue("handinstplan"));
                this.setCanEditByIntState();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection data;
        super.closedCallBack(event);
        if (event.getActionId().equals(SELECT_LOAN_BILL_CALLBACK) && EmptyUtil.isNoEmpty((Object)(data = (ListSelectedRowCollection)event.getReturnData()))) {
            Object loanBillId = data.get(0).getPrimaryKeyValue();
            this.initByLoanBill(loanBillId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "handInstPlan_callBackId_calinstplan": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ispassVoid", "true");
                this.getView().invokeOperation("calinstplan", option);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        switch (key) {
            case "startintdate": {
                this.startIntDateBeforePost(e, key, value);
                break;
            }
            case "exrepaymentdate": {
                this.expaymentDateBeforePost(e, key, rowIndex, value);
                break;
            }
            case "exdrawamount": {
                this.exdrawAmountBeforePost(e, key, rowIndex, value);
                break;
            }
            case "interesdate": {
                this.interestBeforePost(e, rowIndex, value);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (propName) {
            case "term": {
                String error = this.checkLoanBillNotEmpty();
                if (EmptyUtil.isNoEmpty((String)error)) {
                    this.getView().showTipNotification(error);
                    return;
                }
                this.callExprieDate();
                this.callTerm();
                this.updatePlanByDate();
                break;
            }
            case "expiredate": 
            case "startintdate": {
                this.callTerm();
                this.updatePlanByDate();
                break;
            }
            case "handinstplan": {
                ChangeData[] changeSet = e.getChangeSet();
                this.isHandinstPlanChgEvt((Boolean)changeSet[0].getNewValue());
                break;
            }
            case "exdrawamount": {
                int rowCount = this.getModel().getEntryRowCount("repayplan_entry");
                if (changeData.getRowIndex() == rowCount - 1) break;
                this.calLastRowAmtVal();
                break;
            }
            case "exrepaymentdate": 
            case "repaymentdesc": {
                if (!EmptyUtil.isNoEmpty((Object)changeData.getNewValue()) || changeData.getNewValue().equals(changeData.getOldValue())) break;
                this.setUpdateRowInfo(changeData.getRowIndex());
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("repayplan_entry".equals(entryName) || "interest_entry".equals(entryName)) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index < 0) continue;
                this.newScheduleEntry(index, entryName);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        int[] rowIndexs = e.getRowIndexs();
        switch (entryName) {
            case "interest_entry": {
                for (int index : rowIndexs) {
                    String payIntState = (String)this.getModel().getValue("intstate", index);
                    if ("1".equals(payIntState)) {
                        String ispayIntStatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"intstate");
                        this.getView().showTipNotification(CfmFormResourceEnum.LoanInstPlanModifyPlugin_05.loadKDString(ispayIntStatePropName));
                        e.setCancel(true);
                        return;
                    }
                    DynamicObject loanBill = this.getModel().getDataEntity(false);
                    String intWay = (String)this.getModel().getValue("intway", index);
                    if (!LoanBillHelper.isYkx((DynamicObject)loanBill) || index != 0 || !LoanBillHelper.isPrePayint((String)intWay)) continue;
                    this.getView().showTipNotification(CfmFormResourceEnum.LoanInstPlanModifyPlugin_07.loadKDString());
                    e.setCancel(true);
                }
                break;
            }
            case "repayplan_entry": {
                for (int row : rowIndexs) {
                    if (!"1".equals(this.getModel().getValue("repaystate", row))) continue;
                    String repayStatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"repaystate");
                    this.getView().showTipNotification(CfmFormResourceEnum.RepaymentPlanModifyPlugin_9.loadKDString(repayStatePropName));
                    e.setCancel(true);
                }
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("repayplan_entry".equals(entryName)) {
            this.calLastRowAmtVal();
        }
    }

    private void newScheduleEntry(int index, String entryName) {
        DynamicObject loanBill = this.getLoanBill();
        if (EmptyUtil.isEmpty((DynamicObject)loanBill) || loanBill == null) {
            return;
        }
        DynamicObject accountBank = loanBill.getDynamicObject("accountbank");
        if ("repayplan_entry".equals(entryName)) {
            this.calLastRowAmtVal();
            this.setUpdateRowInfo(index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repayaccount", (Object)accountBank, (int)index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaymentdesc", (Object)this.getDefaultRemark(), (int)index);
            return;
        }
        if ("interest_entry".equals(entryName)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intaccount", (Object)accountBank, (int)index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intstate", (Object)"0", (int)index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"instdescription", (Object)this.getDefaultRemark(), (int)index);
        }
    }

    private void calLastRowAmtVal() {
        DynamicObjectCollection repayEntry = this.getModel().getEntryEntity("repayplan_entry");
        if (repayEntry.size() > 0) {
            int lastRow = repayEntry.getRowCount() - 1;
            BigDecimal allEntryRowsAmt = BigDecimal.ZERO;
            for (int i = 0; i < repayEntry.size() - 1; ++i) {
                allEntryRowsAmt = allEntryRowsAmt.add(((DynamicObject)repayEntry.get(i)).getBigDecimal("exdrawamount"));
            }
            BigDecimal drawAmt = (BigDecimal)this.getModel().getValue("drawamount");
            BigDecimal remainAmt = drawAmt.subtract(allEntryRowsAmt);
            if (EmptyUtil.isNoEmpty((BigDecimal)remainAmt) && !"1".equals(this.getModel().getValue("repaystate", lastRow))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exdrawamount", (Object)remainAmt, (int)lastRow);
            }
        }
    }

    private void setUpdateRowInfo(int rowIndex) {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaymentmodifier", (Object)RequestContext.get().getCurrUserId(), (int)rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaymentmodifytime", (Object)DateUtils.getCurrentTime(), (int)rowIndex);
    }

    private String getDefaultRemark() {
        return CfmFormResourceEnum.RepaymentPlanModifyPlugin_6.loadKDString();
    }

    private void openLoanBill() {
        Long userPK = RequestContext.get().getCurrUserId();
        List<String> drawTypes = Arrays.asList(DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue());
        QFilter qFilter = new QFilter("drawtype", "in", drawTypes);
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        String billFormId = this.getView().getFormShowParameter().getFormId();
        if ("cim_apply_loanbill".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.INVEST.getValue());
            qFilter.and(new QFilter("creditorg.id", "in", (Object)orgIdSet));
        } else if ("cfm_apply_loanbill".equals(billFormId)) {
            qFilter.and("datasource", "in", Arrays.asList(DataSourceEnum.CFM.getValue(), DataSourceEnum.IFM.getValue()));
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
        }
        ListShowParameter paramter = ShowFormHelper.createShowListForm((String)this.getOpenFormId(billFormId), (boolean)false, (int)0, (boolean)true);
        logger.info("LoanBillApplyEdit openLoanBill filter: " + qFilter);
        paramter.getListFilterParameter().getQFilters().add(qFilter);
        paramter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_LOAN_BILL_CALLBACK));
        this.getView().showForm((FormShowParameter)paramter);
    }

    private String getOpenFormId(String billFormId) {
        String entity = "cfm_loanbill";
        if ("cim_apply_loanbill".equals(billFormId)) {
            entity = "cim_invest_loanbill";
        }
        return entity;
    }

    private void initByLoanBill(Object loanBillId) {
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)(props + "," + repayPlanProps + "," + interestEntryProps + "," + interestSubEntryProps), (QFilter[])new QFilter[]{new QFilter("id", "=", loanBillId)});
        DataEntityPropertyCollection loanContractProperties = loanBill.getDataEntityType().getProperties();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        for (IDataEntityProperty property : loanContractProperties) {
            String prop = property.getName();
            if (propList.contains(prop)) {
                if ("workcalendar".equals(prop)) {
                    this.getModel().setValue(prop, (Object)loanBill.getDynamicObjectCollection(prop));
                } else if ("datasource".equals(prop)) {
                    if ("cfm_apply_loanbill".equals(this.getModel().getDataEntityType().getName())) {
                        this.getModel().setValue(prop, (Object)DataSourceEnum.CFM.getValue());
                    } else if ("cim_apply_loanbill".equals(this.getModel().getDataEntityType().getName())) {
                        this.getModel().setValue(prop, (Object)DataSourceEnum.INVEST.getValue());
                    }
                } else {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)prop, (Object)loanBill.get(prop));
                }
            }
            if (!prop.equals("id")) continue;
            model.setValue("loanbill", loanBill.get("id"));
        }
        model.setValue("loanbillno", loanBill.get("billno"));
        this.loadRepayPlan(loanBill);
        this.loadInterestPlan(loanBill);
        this.initDateEnable();
        this.setLockByRepayWay();
        this.getView().updateView();
    }

    protected void callExprieDate() {
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        Date bizDate = (Date)this.getModel().getValue("startintdate");
        String term = (String)this.getModel().getValue("term");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((String)term)) {
            Date expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)bizDate);
            String loanExpireRule = AdjustMethodEnum.no_adjust.getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
                loanExpireRule = productFactory.getString("loanexpireadjustrule");
            }
            expireDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)expireDate, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)loanExpireRule));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate);
        }
    }

    private void callTerm() {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        Date bizDate = (Date)this.getModel().getValue("startintdate");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)expireDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)expireDate));
        }
    }

    private void updatePlanByDate() {
        String error = this.checkLoanBillNotEmpty();
        if (EmptyUtil.isNoEmpty((String)error)) {
            this.getView().showTipNotification(error);
            return;
        }
        DynamicObject loanBill = this.getLoanBill();
        if (EmptyUtil.isEmpty((DynamicObject)loanBill) || loanBill == null) {
            return;
        }
        LoanBillRepayPlanHelper.updateLoanBillRepayPlan((DynamicObject)loanBill, (boolean)true);
        this.loadRepayPlan(loanBill);
        Pair intBills = InterestCalcHelper.callIntPlan((DynamicObject)loanBill);
        LoanWriteBackHelper.loanBillWriteBack((Pair)intBills, (DynamicObject)loanBill, (boolean)false);
        this.loadInterestPlan(loanBill);
        this.setCanEditByIntState();
        this.setCanEditByRepayState();
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u671f\u6216\u5230\u671f\u65e5\u671f\u6216\u671f\u9650\u53d8\u66f4\uff0c\u7cfb\u7edf\u4f1a\u81ea\u52a8\u66f4\u65b0%1$s\u8ba1\u5212\u548c%2$s\u8ba1\u5212\u3002", (String)"LoanBillApplyEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[]{this.getRepayMsg(), this.getIntMsg()}));
    }

    private String getRepayMsg() {
        if ("cfm_apply_loanbill".equals(this.getModel().getDataEntityType().getName())) {
            return ResManager.loadKDString((String)"\u8fd8\u6b3e", (String)"LoanBillApplyEdit_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u672c\u91d1\u6536\u56de", (String)"LoanBillApplyEdit_03", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
    }

    private String getIntMsg() {
        if ("cfm_apply_loanbill".equals(this.getModel().getDataEntityType().getName())) {
            return ResManager.loadKDString((String)"\u4ed8\u606f", (String)"LoanBillApplyEdit_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6536\u606f", (String)"LoanBillApplyEdit_05", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
    }

    private void updatePlanEntry() {
        DynamicObjectCollection repayplanEntryDC = this.getModel().getEntryEntity("repayplan_entry");
        Collections.sort(repayplanEntryDC, Comparator.comparing(o -> o.getDate("exrepaymentdate")));
        for (int i = 0; i <= repayplanEntryDC.size() - 1; ++i) {
            DynamicObject repayplanEntry = (DynamicObject)repayplanEntryDC.get(i);
            BigDecimal exdrawAmount = repayplanEntry.getBigDecimal("exdrawamount");
            BigDecimal erepayAmount = repayplanEntry.getBigDecimal("erepayamount");
            repayplanEntry.set("enotrepayamount", (Object)exdrawAmount.subtract(erepayAmount));
            repayplanEntry.set("seq", (Object)(i + 1));
        }
        this.getModel().updateEntryCache(repayplanEntryDC);
        this.getView().updateView("repayplan_entry");
        DynamicObjectCollection instplanEntryDC = this.getModel().getEntryEntity("interest_entry");
        Collections.sort(instplanEntryDC, Comparator.comparing(o -> o.getDate("interesdate")));
        for (int i = 0; i <= instplanEntryDC.size() - 1; ++i) {
            ((DynamicObject)instplanEntryDC.get(i)).set("seq", (Object)(i + 1));
            ((DynamicObject)instplanEntryDC.get(i)).set("interestseq", (Object)(i + 1));
        }
        this.getModel().updateEntryCache(instplanEntryDC);
        this.getView().updateView("interest_entry");
    }

    private void loadRepayPlan(DynamicObject loanBill) {
        this.getModel().deleteEntryData("repayplan_entry");
        DynamicObjectCollection repayPlans = loanBill.getDynamicObjectCollection("repayplan_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)repayPlans)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("exrepaymentdate", new Object[0]).addField("exdrawamount", new Object[0]).addField("erepayamount", new Object[0]).addField("enotrepayamount", new Object[0]).addField("repaystate", new Object[0]).addField("repaymentdesc", new Object[0]).addField("repayaccount", new Object[0]).addField("repaymentmodifier", new Object[0]).addField("repaymentmodifytime", new Object[0]);
            for (DynamicObject repayPlan : repayPlans) {
                vs.addRow(new Object[]{repayPlan.get("exrepaymentdate"), repayPlan.get("exdrawamount"), repayPlan.get("erepayamount"), repayPlan.get("enotrepayamount"), repayPlan.getString("repaystate"), repayPlan.get("repaymentdesc"), EmptyUtil.isEmpty((Object)repayPlan.get("repayaccount")) ? null : repayPlan.getDynamicObject("repayaccount").getPkValue(), this.getModifier(repayPlan), repayPlan.get("repaymentmodifytime")});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("repayplan_entry", vs);
            model.endInit();
            this.getView().updateView("repayplan_entry");
        }
    }

    private Long getModifier(DynamicObject repayPlan) {
        Object modifier = repayPlan.get("repaymentmodifier");
        if (EmptyUtil.isEmpty((Object)modifier)) {
            return null;
        }
        if (modifier instanceof DynamicObject) {
            return ((DynamicObject)modifier).getLong("id");
        }
        if (modifier instanceof Long) {
            return (Long)modifier;
        }
        return null;
    }

    private void loadInterestPlan(DynamicObject loanBill) {
        this.getModel().deleteEntryData("interest_entry");
        DynamicObjectCollection intPlans = loanBill.getDynamicObjectCollection("interest_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)intPlans)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("intway", new Object[0]).addField("interestseq", new Object[0]).addField("intstartdate", new Object[0]).addField("intenddate", new Object[0]).addField("interesdate", new Object[0]).addField("interestcalamount", new Object[0]).addField("intstate", new Object[0]).addField("instdescription", new Object[0]).addField("intaccount", new Object[0]);
            for (DynamicObject intPlan : intPlans) {
                vs.addRow(new Object[]{intPlan.get("intway"), intPlan.get("interestseq"), intPlan.get("intstartdate"), intPlan.get("intenddate"), intPlan.get("interesdate"), intPlan.get("interestcalamount"), intPlan.get("intstate"), intPlan.get("instdescription"), EmptyUtil.isEmpty((Object)intPlan.get("intaccount")) ? null : intPlan.getDynamicObject("intaccount").getPkValue()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("interest_entry", vs);
            model.endInit();
            this.getView().updateView("interest_entry");
        }
    }

    private void startIntDateBeforePost(BeforeFieldPostBackEvent e, String key, Object value) {
        String error = this.checkLoanBillNotEmpty();
        if (EmptyUtil.isNoEmpty((String)error)) {
            e.setCancel(true);
            this.getView().showTipNotification(error);
            this.getView().updateView(key);
            return;
        }
        String fmtStr = ((DateEdit)this.getControl("startintdate")).getFormatString();
        Date startIntDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        Date startDate = contractBill.getDate("startdate");
        Date endDate = contractBill.getDate("enddate");
        if (startIntDate.compareTo(startDate) < 0 || startIntDate.compareTo(endDate) >= 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5408\u540c\u5f00\u59cb\u65e5\u671f\uff0c\u5c0f\u4e8e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u3002", (String)"LoanBillApplyEdit_06", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        }
    }

    private void expaymentDateBeforePost(BeforeFieldPostBackEvent e, String key, int rowIndex, Object value) {
        String fmtStr = ((DateEdit)this.getControl("exrepaymentdate")).getFormatString();
        Date repaymentDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        Date maxYetDoRepayDate = this.getMaxYetDoRepayDate();
        if (EmptyUtil.isNoEmpty((Object)maxYetDoRepayDate) && repaymentDate.compareTo(maxYetDoRepayDate) <= 0) {
            e.setCancel(true);
            String repayDatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"exrepaymentdate");
            this.getView().showTipNotification(CfmFormResourceEnum.RepaymentPlanModifyPlugin_7.loadKDString(repayDatePropName, repayDatePropName, DateUtils.formatString((Date)maxYetDoRepayDate, (String)"yyyy-MM-dd")));
            this.getView().updateView(key, rowIndex);
        }
    }

    private Date getMaxYetDoRepayDate() {
        DynamicObjectCollection repayEntry = this.getModel().getEntryEntity("repayplan_entry");
        return repayEntry.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.getDate("exrepaymentdate"))).filter(o -> "1".equals(o.getString("repaystate"))).map(o -> o.getDate("exrepaymentdate")).max(Comparator.comparing(o -> o)).orElse(null);
    }

    private void setLockByRepayWay() {
        DynamicObject loanBill = (DynamicObject)this.getModel().getValue("loanbill");
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            return;
        }
        boolean isNeedLock = RepaymentWayEnum.isHbfx((String)loanBill.getString("repaymentway"));
        this.getView().setEnable(Boolean.valueOf(!isNeedLock), new String[]{"repayplan_entry", "interest_entry", "newentryplan", "deleteentryplan", "entryimport", "handinstplan", "calinstplan"});
        boolean isHandInstPlan = (Boolean)this.getModel().getValue("handinstplan");
        this.getView().setEnable(Boolean.valueOf(!isNeedLock && isHandInstPlan), new String[]{"instplannewentry", "instplandeleteentry", "intplanentryimport"});
    }

    private void exdrawAmountBeforePost(BeforeFieldPostBackEvent e, String key, int rowIndex, Object value) {
        BigDecimal newRowtotalAmts;
        BigDecimal drawAmt = (BigDecimal)this.getModel().getValue("drawamount");
        BigDecimal allEntryRowsAmt = this.getAllEntryRowsAmt("exdrawamount");
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("repayplan_entry", rowIndex);
        BigDecimal beforeRowAmt = rowInfo.getBigDecimal("exdrawamount");
        DynamicObjectCollection repayEntry = this.getModel().getEntryEntity("repayplan_entry");
        BigDecimal lastRowAmt = BigDecimal.ZERO;
        if (repayEntry.size() - 1 != rowIndex) {
            lastRowAmt = ((DynamicObject)repayEntry.get(repayEntry.size() - 1)).getBigDecimal("exdrawamount");
        }
        if ((newRowtotalAmts = allEntryRowsAmt.subtract(beforeRowAmt).subtract(lastRowAmt).add(new BigDecimal(value + ""))).compareTo(drawAmt) > 0) {
            e.setCancel(true);
            String entityName = this.getModel().getDataEntityType().getName();
            String msg = EmptyUtil.isNoEmpty((String)entityName) && (entityName.startsWith("ifm") || entityName.startsWith("cim")) ? CfmFormResourceEnum.RepaymentPlanModifyPlugin_8.loadKDString() : (DataSourceEnum.isBond((String)((String)this.getModel().getValue("datasource"))) ? CfmFormResourceEnum.RepaymentPlanModifyPlugin_10.loadKDString() : CfmFormResourceEnum.RepaymentPlanModifyPlugin_5.loadKDString());
            this.getView().showTipNotification(msg);
            this.getView().updateView(key, rowIndex);
        }
    }

    private BigDecimal getAllEntryRowsAmt(String entryField) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("repayplan_entry");
        return entryGrid.getSum(entryField);
    }

    private void interestBeforePost(BeforeFieldPostBackEvent e, int rowIndex, Object value) {
        String dateFormat = ((DateEdit)this.getControl("interesdate")).getFormatString();
        Date repaymentDate = DateUtils.stringToDate((String)value.toString(), (String)dateFormat);
        String volidRepayDateResult = LoanBillFormHelper.getVolidRepayDateResult(this.getModel(), repaymentDate);
        if (EmptyUtil.isNoEmpty((String)volidRepayDateResult)) {
            this.showInterestDateNotification(e, rowIndex, volidRepayDateResult);
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("interest_entry");
        Date maxInterestDate = entrys.stream().filter(b -> b.getInt("intstate") == 1).map(b -> b.getDate("interesdate")).max(Date::compareTo).orElse(null);
        if (maxInterestDate != null && repaymentDate.compareTo(maxInterestDate) <= 0) {
            this.showInterestDateNotification(e, rowIndex, CfmFormResourceEnum.LoanInstPlanModifyPlugin_06.loadKDString(DateUtils.formatString((Date)maxInterestDate, (String)dateFormat)));
            return;
        }
        String error = LoanBillApplyEdit.checkForYkx(this.getModel(), repaymentDate);
        if (EmptyUtil.isNoEmpty((String)error)) {
            this.showInterestDateNotification(e, rowIndex, error);
        }
    }

    public static String checkForYkx(IDataModel model, Date repaymentDate) {
        DynamicObject loanBillApply = model.getDataEntity();
        if (!LoanBillHelper.isYkx((DynamicObject)loanBillApply)) {
            return "";
        }
        DynamicObject loanBill = loanBillApply.getDynamicObject("loanbill");
        Date endIntDate = loanBill.getDate("endinstdate");
        if (endIntDate != null && endIntDate.after(repaymentDate)) {
            return CfmFormResourceEnum.LoanInstPlanModifyPlugin_09.loadKDString(DateUtils.formatString((Date)endIntDate, (String)"yyyy-MM-dd"));
        }
        Date expireDate = loanBillApply.getDate("expiredate");
        if (expireDate != null && expireDate.compareTo(repaymentDate) >= 0) {
            LocaleString expireDateProp = CfmBillCommonHelper.getDisPlayPropName((IDataModel)model, (String)"expiredate");
            return CfmFormResourceEnum.LoanInstPlanModifyPlugin_08.loadKDString(expireDateProp, DateUtils.formatString((Date)expireDate, (String)"yyyy-MM-dd"));
        }
        return "";
    }

    private void showInterestDateNotification(BeforeFieldPostBackEvent e, int rowIndex, String error) {
        e.setCancel(true);
        this.getView().showTipNotification(error);
        this.getView().updateView("interesdate", rowIndex);
    }

    private void isHandinstPlanChgEvt(boolean isHandin) {
        if (isHandin) {
            String error = this.checkLoanBillNotEmpty();
            if (EmptyUtil.isNoEmpty((String)error)) {
                this.getView().showTipNotification(error);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"handinstplan", (Object)false);
                this.getView().setEnable(Boolean.FALSE, new String[]{"instplannewentry", "instplandeleteentry", "intplanentryimport", "calinstplan"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"instplannewentry", "instplandeleteentry", "intplanentryimport", "calinstplan"});
            }
        }
    }

    private String checkLoanBillNotEmpty() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("loanbillno"))) {
            LocaleString loanBillno = CfmBillCommonHelper.getDisPlayPropName((IDataModel)this.getModel(), (String)"loanbillno");
            return CfmFormResourceEnum.LoanInstPlanModifyPlugin_03.loadKDString(loanBillno);
        }
        return null;
    }

    private boolean isExRepaymentDateNull() {
        DynamicObjectCollection repayEntry = this.getModel().getEntryEntity("repayplan_entry");
        int size = repayEntry.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject repayPlan = (DynamicObject)repayEntry.get(i);
            if (!EmptyUtil.isEmpty((Object)repayPlan.getDate("exrepaymentdate"))) continue;
            String dataSource = (String)this.getModel().getValue("datasource");
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            this.getView().showErrorNotification(String.format(bizResource.getExRepaymentDateNull(), i + 1));
            return true;
        }
        return false;
    }

    private void showConfirmTip(String flag) {
        this.getView().showConfirm(CfmFormResourceEnum.LoanInstPlanModifyPlugin_01.loadKDString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(String.format("handInstPlan_callBackId_%s", flag), (IFormPlugin)this));
    }

    private void reCalInstPlanAndSetVal(boolean isHand) {
        DynamicObject loanBill = this.getLoanBill();
        if (EmptyUtil.isEmpty((DynamicObject)loanBill) || loanBill == null) {
            return;
        }
        DynamicObjectCollection repayEntry = loanBill.getDynamicObjectCollection("repayplan_entry");
        repayEntry.clear();
        DynamicObjectCollection newRepay = this.getModel().getEntryEntity("repayplan_entry");
        repayEntry.addAll((Collection)newRepay);
        DynamicObjectCollection interestEntry = loanBill.getDynamicObjectCollection("interest_entry");
        interestEntry.clear();
        DynamicObjectCollection newInterest = this.getModel().getEntryEntity("interest_entry");
        interestEntry.addAll((Collection)newInterest);
        Pair intBills = null;
        if (isHand) {
            DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("interest_entry");
            if (!this.checkEntrys(loanBill, entrys)) {
                return;
            }
            ArrayList<PlanCallResult> intPlanList = new ArrayList<PlanCallResult>(entrys.size());
            for (DynamicObject entry : entrys) {
                PlanCallResult callResult = new PlanCallResult();
                if (LoanBillHelper.isPrePayint((String)entry.getString("intway"))) {
                    callResult.setBizDate(loanBill.getDate("expiredate"));
                } else {
                    callResult.setBizDate(entry.getDate("interesdate"));
                }
                intPlanList.add(callResult);
            }
            intBills = InterestCalcHelper.callIntPlanByHand((DynamicObject)loanBill, intPlanList);
        } else {
            intBills = InterestCalcHelper.callIntPlan((DynamicObject)loanBill);
        }
        LoanWriteBackHelper.loanBillWriteBack((Pair)intBills, (DynamicObject)loanBill, (boolean)false);
        this.loadInterestPlan(loanBill);
    }

    private boolean checkEntrys(DynamicObject loanBill, DynamicObjectCollection instPlans) {
        int size = instPlans.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject rowLoanBill = (DynamicObject)instPlans.get(i);
            Date interesDate = rowLoanBill.getDate("interesdate");
            if (!EmptyUtil.isEmpty((Object)interesDate)) continue;
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
            this.getView().showErrorNotification(String.format(bizResource.getLbPreInstDateIsNotnull(), i + 1));
            return false;
        }
        return true;
    }

    private void initDateEnable() {
        DynamicObject loanBill = (DynamicObject)this.getModel().getValue("loanbill");
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            return;
        }
        boolean isLock = (loanBill = LoanBillRepository.getLoanBillById((Long)loanBill.getLong("id"))).getBoolean("isvoucher") || EmptyUtil.isNoEmpty((Object)loanBill.getDate("lastrepaydate")) || EmptyUtil.isNoEmpty((Object)loanBill.getDate("endinstdate")) || EmptyUtil.isNoEmpty((Object)loanBill.getDate("endpreinstdate")) || EmptyUtil.isNoEmpty((Object)loanBill.getDate("renewalexpiredate"));
        this.getView().setEnable(Boolean.valueOf(!isLock), new String[]{"startintdate", "term", "expiredate"});
    }

    private void setCanEditByIntState() {
        DynamicObject loanBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = loanBill.getDynamicObjectCollection("interest_entry");
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject repayPlan = (DynamicObject)entrys.get(i);
            if (repayPlan.getInt("intstate") == 1) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"interesdate", "interestcalamount", "instdescription", "intaccount", "intstartdate", "intenddate", "intstate", "intway"});
            }
            if (!LoanBillHelper.isYkx((DynamicObject)loanBill) || i != 0 || !LoanBillHelper.isPrePayint((String)repayPlan.getString("intway"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"interesdate"});
        }
    }

    private void setCanEditByRepayState() {
        DynamicObjectCollection repayEntry = this.getModel().getEntryEntity("repayplan_entry");
        int size = repayEntry.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject repayPlan = (DynamicObject)repayEntry.get(i);
            if (repayPlan.getInt("repaystate") != 1) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"exrepaymentdate", "exdrawamount", "erepayamount", "enotrepayamount", "repayaccount", "repaymentdesc"});
        }
    }

    private DynamicObject getLoanBill() {
        DynamicObject loanBill = (DynamicObject)this.getModel().getValue("loanbill");
        if (EmptyUtil.isEmpty((DynamicObject)loanBill) || loanBill == null) {
            return null;
        }
        loanBill = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (QFilter[])new QFilter[]{new QFilter("id", "=", loanBill.getPkValue())});
        Date startIntDate = (Date)this.getModel().getValue("startintdate");
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (EmptyUtil.isNoEmpty((Object)startIntDate) && EmptyUtil.isNoEmpty((Object)expireDate)) {
            loanBill.set("startintdate", (Object)startIntDate);
            loanBill.set("expiredate", (Object)expireDate);
        }
        return loanBill;
    }

    static {
        propList.add("contractname");
        propList.add("org");
        propList.add("debtortype");
        propList.add("debtor");
        propList.add("textdebtor");
        propList.add("finproduct");
        propList.add("creditortype");
        propList.add("creditor");
        propList.add("textcreditor");
        propList.add("clientorg");
        propList.add("accountbank");
        propList.add("productfactory");
        propList.add("confirmdescription");
        propList.add("startintdate");
        propList.add("term");
        propList.add("expiredate");
        propList.add("drawway");
        propList.add("currency");
        propList.add("amount");
        propList.add("contractcny");
        propList.add("convertrate");
        propList.add("notdrawamount");
        propList.add("lockpayamt");
        propList.add("drawamount");
        propList.add("convertdrawamt");
        propList.add("bizdate");
        propList.add("confirmstatus");
        propList.add("creditorg");
        propList.add("workcalendar");
        propList.add("loancontractbill");
        propList.add("loantype");
        propList.add("datasource");
        propList.add("settleintmode");
        propList.add("handinstplan");
        ArrayList<String> selProp = new ArrayList<String>();
        selProp.addAll(propList);
        selProp.add("billstatus");
        selProp.add("id");
        selProp.add("billno");
        selProp.add("repaymentway");
        props = StringUtils.join((Object[])selProp.toArray(new String[0]), (String)",");
        repayPlanProps = String.join((CharSequence)",", "repayplan_entry", "repayplan_entry.exrepaymentdate", "repayplan_entry.exdrawamount", "repayplan_entry.erepayamount", "repayplan_entry.enotrepayamount", "repayplan_entry.repaystate", "repayplan_entry.repaymentdesc", "repayplan_entry.repayaccount", "repayplan_entry.repaymentmodifier", "repayplan_entry.repaymentmodifytime");
        interestEntryProps = String.join((CharSequence)",", "interest_entry", "interest_entry.seq", "interest_entry.intway", "interest_entry.interestseq", "interest_entry.intstartdate", "interest_entry.intenddate", "interest_entry.interesdate", "interest_entry.interestcalamount", "interest_entry.intstate", "interest_entry.instdescription", "interest_entry.intaccount");
        interestSubEntryProps = String.join((CharSequence)",", "interest_subentry", "interest_subentry.seq", "interest_subentry.intereststartdate", "interest_subentry.interestenddate", "interest_subentry.interestdate", "interest_subentry.interestbalance", "interest_subentry.interestrate", "interest_subentry.interestdays", "interest_subentry.interestamount", "interest_subentry.interestway", "interest_subentry.floatrate", "interest_subentry.benchmarkrate", "interest_subentry.floatint", "interest_subentry.benchmarkint", "interest_subentry.lasttotalint", "interest_subentry.curtotalint", "interest_subentry.confirmratedate", "interest_subentry.lookdays");
    }
}

