/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.preinterestbill.batch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.formplugin.common.BatchEntryAddNewHelper;
import kd.tmc.cfm.formplugin.interestbill.batch.AbstractIntBillBatchEdit;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.helper.EntityMapBizHelper;
import org.apache.commons.lang3.tuple.Pair;

public class LoanPreIntBillBatchEdit
extends AbstractIntBillBatchEdit
implements RowClickEventListener {
    static final List<String> forms = Arrays.asList("cim_depositprebatch", "ifm_depositprebatch");

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        if (evt.getFieldName().equals("sumpreint")) {
            this.showSumPreInts(evt.getRowIndex());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            if (index < 0) {
                return;
            }
            this.loanIntEntry(index);
        }
    }

    private void loanIntEntry(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        this.getModel().setValue("intnum", (Object)entry.getString("intdetailnum"));
        this.getModel().setValue("preloannum", (Object)entry.getString("loannum"));
        if (this.getIntDetailFormId(entry).equals("ifm_intbillsofr_detail")) {
            BatchIntBillHelper.loanSofrIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        } else {
            BatchIntBillHelper.loanIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        }
    }

    public void afterBindData(EventObject e) {
        this.loanIntEntry(0);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentryloans".equals(operateKey)) {
            String errMsg = this.checkLoansEntry();
            if (EmptyUtil.isNoEmpty((String)errMsg)) {
                args.setCancel(true);
                this.getView().showTipNotification(errMsg);
                return;
            }
            this.dealInterest();
        } else if ("addentryloans".equals(operateKey)) {
            args.setCancel(true);
            BatchEntryAddNewHelper.openAddNewNavigateForm(this, this.initParams());
        }
    }

    private FormShowParameter initParams() {
        DynamicObject loan;
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        List loanIds = entrys.stream().map(dny -> dny.getLong("loanbillid")).collect(Collectors.toList());
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter)) {
            showParameter.getCustomParams().put("settlecenter", settleCenter.getPkValue());
            initParams.put("settlecenter", settleCenter.getPkValue());
        }
        if ("ifm_depositprebatch".equals(this.getView().getEntityId())) {
            DynamicObject finorginfo = (DynamicObject)this.getModel().getValue("finorginfo");
            initParams.put("settlecenter", finorginfo.getPkValue());
        }
        showParameter.getCustomParams().put("loanIds", loanIds);
        if (!forms.contains(this.getParentFormId()) && EmptyUtil.isNoEmpty((DynamicObject)(loan = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)entrys.get(0)).getLong("loanbillid"), (String)"cfm_loanbill", (String)"creditortype")))) {
            initParams.put("settlecenterloan", CreditorTypeEnum.SETTLECENTER.getValue().equals(loan.getString("creditortype")));
        }
        initParams.put("calcOverInt", ((DynamicObject)entrys.get(0)).getBoolean("calcoverint"));
        initParams.put("endintdate", this.getModel().getValue("bizdate"));
        HashSet<String> orgIds = new HashSet<String>(entrys.size());
        HashSet<String> currenyIds = new HashSet<String>(entrys.size());
        HashSet<String> contractNums = new HashSet<String>(entrys.size());
        Set<Object> contractIds = new HashSet(entrys.size());
        String loanType = (String)this.getModel().getValue("loantype");
        for (DynamicObject dyn2 : entrys) {
            this.addOrgIds(loanType, dyn2, orgIds);
            currenyIds.add(dyn2.getDynamicObject("currency").getPkValue().toString());
            contractNums.add(dyn2.getString("loancontractbillno"));
        }
        if (EmptyUtil.isNoEmpty(contractNums)) {
            DynamicObject[] contractObject = BusinessDataServiceHelper.load((String)"cfm_loancontractbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", contractNums)});
            contractIds = Arrays.stream(contractObject).map(dyn -> dyn.getPkValue().toString()).collect(Collectors.toSet());
        }
        initParams.put("orgs", orgIds);
        initParams.put("currencys", currenyIds);
        initParams.put("contracts", contractIds);
        showParameter.getCustomParams().put("initParams", initParams);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map navParam = (Map)evt.getReturnData();
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            navParam = (Map)evt.getReturnData();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            paramMap.put("startdatemap", navParam.get("startdatemap"));
            paramMap.put("operateType", "preint");
            String intCalResultJSON = (String)navParam.get("calcIntResult");
            String formId = (String)navParam.get("formid");
            paramMap.put("calcIntResult", intCalResultJSON);
            paramMap.put("calcOverInt", navParam.get("calcOverInt"));
            paramMap.put("formid", formId);
            List<Map<String, Object>> intDetail = this.genIntDetails(paramMap, "preint");
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail, (boolean)false);
            this.dealNoBotpTake(intCalResultJSON, formId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.getView().updateView();
        } else if ("deleteentryloans".equals(operateKey)) {
            this.getView().invokeOperation("save");
        }
        this.loanIntEntry(0);
        if (Arrays.asList("save", "submit", "unsubmit", "audit", "unaudit", "deleteentryloans").contains(args.getOperateKey())) {
            this.getModel().setDataChanged(false);
        }
    }

    private void dealInterest() {
        String loanType = (String)this.getModel().getValue("loantype");
        String datasource = (String)this.getModel().getValue("datasource");
        Pair botpPairObj = BatchIntBillHelper.getPreIntBotpPair((String)loanType, (String)datasource);
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (int i = 0; i < indexs.length; ++i) {
            Long id = ((DynamicObject)cl.get(indexs[i])).getLong("intbillid");
            if (!EmptyUtil.isNoEmpty((Long)id) || !TmcDataServiceHelper.exists((Object)id, (String)((String)botpPairObj.getRight()))) continue;
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)((String)botpPairObj.getRight()), (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)((String)botpPairObj.getRight()), (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
        }
    }

    private String checkLoansEntry() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        if (cl.size() == indexs.length) {
            return ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"InterestBillBatchEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    protected void loadIntDetail() {
        JSONObject navParam = (JSONObject)this.getView().getFormShowParameter().getCustomParams().get("navparam");
        this.getModel().setValue("interesttype", (Object)"preint");
        this.getModel().setValue("operateType", (Object)"preint");
        String endintdate = navParam.getString("endintdate");
        this.getModel().setValue("preintdate", (Object)endintdate);
        String intCalResultJSON = (String)navParam.get((Object)"calcIntResult");
        String formId = (String)navParam.get((Object)"formid");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("startdatemap", navParam.get((Object)"startdatemap"));
        paramMap.put("operateType", "preint");
        paramMap.put("calcIntResult", intCalResultJSON);
        paramMap.put("calcOverInt", navParam.get((Object)"calcOverInt"));
        paramMap.put("formid", formId);
        List<Map<String, Object>> intDetail = this.genIntDetails(paramMap, navParam.getString("operatetype"));
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail);
        this.dealNoBotpTake(intCalResultJSON, formId);
    }

    private void dealNoBotpTake(String intCalResultJSON, String formId) {
        Map<Object, IntBillExtInfo> intBillExtInfoMap = LoanPreIntBillBatchEdit.getIntBillExtInfoMap(intCalResultJSON);
        if (EmptyUtil.isEmpty(intBillExtInfoMap) || intBillExtInfoMap.isEmpty()) {
            return;
        }
        Set<Object> loanIds = intBillExtInfoMap.keySet();
        String srcFormId = BatchIntBillHelper.isDepostPreIntBatch((String)formId) ? "cim_deposit" : "cfm_loanbill";
        EntityMapBizHelper.dealNoneBotpPush(loanIds, (String)srcFormId, (IDataModel)this.getModel());
    }

    public List<Map<String, Object>> genIntDetails(Map<String, Object> paramMap, String operateType) {
        Map<Object, IntBillExtInfo> calcIntResult = LoanPreIntBillBatchEdit.getIntBillExtInfoMap((String)paramMap.get("calcIntResult"));
        ArrayList<Map<String, Object>> intDetails = new ArrayList<Map<String, Object>>(calcIntResult.size());
        String formid = (String)paramMap.get("formid");
        if (BatchIntBillHelper.isDepostPreIntBatch((String)formid)) {
            DynamicObject[] loanBills;
            for (DynamicObject loanBill : loanBills = TmcDataServiceHelper.load((Object[])calcIntResult.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit"))) {
                this.fillDepositIntDetail(loanBill, (IntBillInfo)calcIntResult.get(loanBill.getPkValue()), intDetails);
            }
        } else {
            Set<Object> loanIds = calcIntResult.keySet();
            boolean calcOverInt = true;
            if (paramMap.containsKey("calcOverInt")) {
                calcOverInt = Boolean.parseBoolean((String)paramMap.get("calcOverInt"));
            }
            String queryFields = "textdebtor,org,billno,currency,loancontractbill,textcreditor";
            DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"ifm_loanbill", (String)queryFields, (QFilter[])new QFilter[]{new QFilter("id", "in", loanIds)});
            Map billMap = Arrays.stream(loanBills).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
            for (Map.Entry<Object, IntBillExtInfo> entry : calcIntResult.entrySet()) {
                this.fillIntDetail((DynamicObject)billMap.get(entry.getKey()), entry.getValue(), intDetails, calcOverInt, operateType);
            }
        }
        return intDetails;
    }

    private static Map<Object, IntBillExtInfo> getIntBillExtInfoMap(String intCalResultJSON) {
        return (Map)JSON.parseObject((String)intCalResultJSON, (TypeReference)new TypeReference<Map<Object, IntBillExtInfo>>(){}, (Feature[])new Feature[0]);
    }

    protected void fillIntDetail(DynamicObject loanBill, IntBillExtInfo intBill, List<Map<String, Object>> dataMap, boolean isCalcOverInt, String operateType) {
        if (EmptyUtil.isEmpty((Object)intBill) || EmptyUtil.isEmpty((BigDecimal)intBill.getAmount())) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("loanbillid", loanBill.getPkValue());
        data.put("company", loanBill.getDynamicObject("org"));
        data.put("textdebtor", loanBill.getString("textdebtor"));
        data.put("loannum", loanBill.getString("billno"));
        data.put("currency", loanBill.getDynamicObject("currency"));
        data.put("loancontractbillno", loanBill.getDynamicObject("loancontractbill").getString("number"));
        data.put("contractnum", loanBill.getDynamicObject("loancontractbill").getString("contractno"));
        data.put("inttype", "loanint");
        data.put("startdate", intBill.getBeginDate());
        data.put("enddate", intBill.getEndDate());
        List details = intBill.getDetails();
        int days = 0;
        for (IntBillDetailInfo detail : details) {
            days += detail.getDays();
        }
        data.put("intdays", days);
        BigDecimal princple = details.stream().map(IntBillDetailInfo::getPrinciple).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        data.put("principle", princple);
        details.sort((arg0, arg1) -> arg1.getEndDate().compareTo(arg0.getEndDate()));
        data.put("rate", ((IntBillDetailInfo)details.get(0)).getRate());
        if (PreIntOperateTypeEnum.PREINT.getValue().equals(operateType)) {
            data.put("notpreint", intBill.getAmount());
            data.put("isreverse", Boolean.FALSE);
        } else {
            data.put("reverseintamt", BigDecimal.ZERO);
            data.put("isinterest", Boolean.FALSE);
        }
        data.put("sumpreint", this.getTotalPreIntAmt(loanBill.getLong("id")));
        data.put("interestamt", intBill.getAmount());
        data.put("actualinstamt", intBill.getAmount());
        data.put("intdetail_tag", SerializationUtils.toJsonString((Object)intBill));
        data.put("textcreditor", loanBill.getString("textcreditor"));
        data.put("calcoverint", isCalcOverInt);
        dataMap.add(data);
    }

    protected void fillDepositIntDetail(DynamicObject finBill, IntBillInfo intBill, List<Map<String, Object>> dataMap) {
        if (EmptyUtil.isEmpty((Object)intBill) || EmptyUtil.isEmpty((BigDecimal)intBill.getAmount())) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("company", finBill.getDynamicObject("org"));
        data.put("currency", finBill.getDynamicObject("currency"));
        data.put("finorginfo", finBill.getDynamicObject("finorginfo"));
        data.put("loanbillid", finBill.getLong("id"));
        String appId = this.getView().getFormShowParameter().getAppId();
        if (finBill.getDynamicObjectType().getProperty("investvarieties") != null && EmptyUtil.isNoEmpty((String)appId) && "cim".equals(appId)) {
            data.put("investvarieties", finBill.get("investvarieties"));
        }
        data.put("loannum", finBill.getString("billno"));
        data.put("startdate", intBill.getBeginDate());
        data.put("enddate", intBill.getEndDate());
        List details = intBill.getDetails();
        if (EmptyUtil.isNoEmpty((Object)details)) {
            Integer days = details.stream().map(r -> r.getDays()).reduce((a, b) -> a + b).orElse(0);
            data.put("intdays", days);
        }
        data.put("interestamt", intBill.getAmount());
        data.put("actualinstamt", intBill.getAmount());
        data.put("isreverse", Boolean.FALSE);
        data.put("intdetail_tag", SerializationUtils.toJsonString((Object)intBill));
        dataMap.add(data);
    }

    private BigDecimal getTotalPreIntAmt(Long loanBillId) {
        DynamicObject[] preIntBills = this.getSumPreIntBills(loanBillId);
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject preIntBill : preIntBills) {
            amount = PreIntOperateTypeEnum.PREINT.getValue().equals(preIntBill.getString("operateType")) ? amount.add(preIntBill.getBigDecimal("actpreinstamt")) : amount.subtract(preIntBill.getBigDecimal("actpreinstamt"));
        }
        return amount;
    }

    private void showSumPreInts(int rowIndex) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", rowIndex);
        Long loanBillId = entry.getLong("loanbillid");
        List preIntBillIds = Arrays.stream(this.getSumPreIntBills(loanBillId)).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("ifm_preinterestbill");
        show.getListFilterParameter().setFilter(new QFilter("id", "in", preIntBillIds));
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("isFromHyperLink", (Object)"true");
        this.getView().showForm((FormShowParameter)show);
    }

    private DynamicObject[] getSumPreIntBills(Long loanBillId) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)loanBillId);
        filter = filter.and(new QFilter("chargeinstid", "=", (Object)0).or(QFilter.isNull((String)"chargeinstid")));
        DynamicObject[] preIntBills = TmcDataServiceHelper.load((String)"ifm_preinterestbill", (String)"actpreinstamt,operatetype,drawamount", (QFilter[])filter.toArray());
        return preIntBills;
    }

    @Override
    protected String getEntityName() {
        return "ifm_intbill_batch_pre";
    }

    @Override
    protected String getIntDetailFormId(DynamicObject entry) {
        long loanBillid;
        DynamicObject loanBill;
        String parentEntityName = entry.getDataEntityType().getParent().getName();
        if ("cfm_intbill_batch_pre".equals(parentEntityName) && (loanBill = TmcDataServiceHelper.loadSingle((Object)(loanBillid = entry.getLong("loanbillid")), (String)"cfm_loanbill")).getBoolean("issofrrate")) {
            return "ifm_intbillsofr_detail";
        }
        return "ifm_intbill_detail";
    }

    private void addOrgIds(String loanType, DynamicObject dyn, Set<String> orgIds) {
        if (StringUtils.equals((CharSequence)"ec", (CharSequence)loanType) && dyn.containsProperty("creditorg") && EmptyUtil.isNoEmpty((DynamicObject)dyn.getDynamicObject("creditorg"))) {
            orgIds.add(dyn.getDynamicObject("creditorg").getPkValue().toString());
        } else if ((StringUtils.equals((CharSequence)"loan", (CharSequence)loanType) || StringUtils.equals((CharSequence)"entrust", (CharSequence)loanType)) && dyn.containsProperty("company") && EmptyUtil.isNoEmpty((DynamicObject)dyn.getDynamicObject("company"))) {
            orgIds.add(dyn.getDynamicObject("company").getPkValue().toString());
        }
    }
}

