/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.preinterestbill.batch;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.formplugin.interestbill.batch.AbstractNavAddNewPlugin;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreIntBillNavAddNewPlugin
extends AbstractNavAddNewPlugin {
    @Override
    public boolean isPreInt() {
        return true;
    }

    @Override
    public boolean isPayIntByPlan() {
        return false;
    }

    @Override
    public Date getStartDate(DynamicObject loanBill) {
        Date preBeginDate = loanBill.getDate("endpreinstdate");
        preBeginDate = EmptyUtil.isNoEmpty((Object)preBeginDate) ? DateUtils.getNextDay((Date)preBeginDate, (int)1) : loanBill.getDate("startintdate");
        return preBeginDate;
    }

    @Override
    public String getNonIntDataTip() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u9884\u63d0\u7684\u6570\u636e\u3002", (String)"PreIntBillNavAddNewPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public String getExistOnWayDataTip(String loanNum, String batchNums) {
        return ResManager.loadKDString((String)"%1$s\u5b58\u5728\u6b63\u5728\u5904\u7406\u7684\u6279\u91cf\u9884\u63d0\u5355%2$s\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"PreIntBillNavAddNewPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[]{loanNum, batchNums});
    }

    @Override
    public String getEndIntDateTip() {
        return null;
    }

    @Override
    public void addExclusiveFilter(QFilter qfiter) {
        List<Long> loans;
        Date endintdate = (Date)this.getModel().getValue("endintdate");
        if (endintdate != null) {
            qfiter.and(QFilter.isNotNull((String)"endpreinstdate").and(new QFilter("endpreinstdate", "<", (Object)DateUtils.getLastDay((Date)endintdate, (int)1))).or(QFilter.isNull((String)"endpreinstdate").and(new QFilter("startintdate", "<=", (Object)endintdate))));
        }
        this.addPreIntParamFilter(qfiter);
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qfiter.and("id", "not in", loanIds);
        }
        if (EmptyUtil.isNoEmpty(loans = PreIntBillNavAddNewPlugin.queryLoanIds())) {
            qfiter.and("id", "not in", loans);
        }
    }

    public static List<Long> queryLoanIds() {
        QFilter qFilter = new QFilter("drawtype", "=", (Object)DrawTypeEnum.CLOSEOUT.getValue()).and("closeoffdate", "!=", null).and("endpreinstdate", "!=", null);
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id, billno, endpreinstdate, closeoffdate", (QFilter[])qFilter.toArray());
        List<Long> loanIds = loanBills.stream().filter(o -> DateUtils.getDataFormat((Date)o.getDate("endpreinstdate"), (boolean)true).compareTo(DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)o.getDate("closeoffdate"), (int)1), (boolean)true)) >= 0).map(o -> o.getLong("id")).collect(Collectors.toList());
        return loanIds;
    }

    private void addPreIntParamFilter(QFilter qfilter) {
        DynamicObject[] loanBills;
        Set loanBillIds;
        BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        String loanType = batchIntViewInfo.getLoanType();
        String operateType = batchIntViewInfo.getOperateType();
        boolean settlecenterLoan = (Boolean)this.getModel().getValue("settlecenterloan");
        if (settlecenterLoan && StringUtils.equals((CharSequence)"loan", (CharSequence)loanType) && StringUtils.equals((CharSequence)"preint", (CharSequence)operateType) && EmptyUtil.isNoEmpty(loanBillIds = Arrays.stream(loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"org,creditortype", (QFilter[])new QFilter[]{qfilter, new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue())})).filter(v -> StringUtils.equals((CharSequence)CreditorTypeEnum.SETTLECENTER.getValue(), (CharSequence)v.getString("creditortype"))).filter(this::isPreIntBySettlecenter).map(DataEntityBase::getPkValue).collect(Collectors.toSet()))) {
            qfilter.and(new QFilter("id", "not in", loanBillIds));
        }
    }

    private boolean isPreIntBySettlecenter(DynamicObject loanBill) {
        DynamicObject org = loanBill.getDynamicObject("org");
        return CfmSysParamHelper.getAppBoolParameter((long)org.getLong("id"), (String)"cfm003");
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.intLoanBillFormPreInt(e);
    }

    private void intLoanBillFormPreInt(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("fromLoanBill")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"company", "settlecenter", "settlecenterloan", "currency", "contractbill", "contractnum", "loanbill"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("fromLoanBill")) {
            this.getModel().setValue("loanbill", customParams.get("loanBillNos"));
            this.getPageCache().put("loanbill", SerializationUtils.toJsonString(customParams.get("loanBillIds")));
        }
    }
}

