/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.rateadjust;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.common.enums.AdjustEleEnum;
import kd.tmc.cfm.common.enums.BatchRateAdjustViewInfoEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.common.helper.RateAdjustHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class CreateRateAdjustBill {
    private static final String[] drawProps = new String[]{"id", "billno", "loanrate", "ratesign", "startloanrate", "repaymentway", "ratefloatpoint", "drawamount", "notrepayamount", "settleintmode", "interestsettledplan", "interesttype", "rateresetdays", "rateadjuststyle", "loantype", "referencerate", "rateadjustcycletype", "rateadjustcycle", "currency", "issofrrate", "datasource"};

    public static List<DynamicObject> createRateAdjustBill(Map<String, Object> returnDataMap, Map<String, String> paramMap) {
        String contractBillIdStr = (String)returnDataMap.get("contractbill");
        if (EmptyUtil.isEmpty((String)contractBillIdStr)) {
            return null;
        }
        List contractIds = SerializationUtils.fromJsonStringToList((String)contractBillIdStr, Long.class);
        ArrayList<DynamicObject> rateAdjustBills = new ArrayList<DynamicObject>(contractIds.size());
        BatchRateAdjustViewInfoEnum viewInfoEnum = CreateRateAdjustBill.getViewInfoEnum(paramMap);
        for (Long contractId : contractIds) {
            DynamicObject contractBill = TmcDataServiceHelper.loadSingle((Object)contractId, (String)("bond".equals(paramMap.get("dataSource")) ? "cfm_loancontract_bo" : "cfm_loancontractbill"));
            DynamicObject rateAdjust = CreateRateAdjustBill.createRateAdjust(returnDataMap, contractBill, paramMap, viewInfoEnum);
            if (rateAdjust == null) continue;
            rateAdjustBills.add(rateAdjust);
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)viewInfoEnum.getParentEntityId(), (DynamicObject[])rateAdjustBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        return rateAdjustBills;
    }

    private static BatchRateAdjustViewInfoEnum getViewInfoEnum(Map<String, String> paramMap) {
        String formId = paramMap.get("formId");
        String dataSrc = paramMap.get("dataSrc");
        if ("rateAdjust".equals(dataSrc)) {
            return BatchRateAdjustViewInfoEnum.getInfoEnumByFormId((String)formId);
        }
        return BatchRateAdjustViewInfoEnum.getInfoEnumByContractFormId((String)formId);
    }

    private static DynamicObject createRateAdjust(Map<String, Object> returnDataMap, DynamicObject contractBill, Map<String, String> paramMap, BatchRateAdjustViewInfoEnum viewInfoEnum) {
        Date intDate = DateUtils.stringToDate((String)((String)returnDataMap.get("intdate")), (String)"yyyy-MM-dd");
        DynamicObject referenceRate = (DynamicObject)returnDataMap.get("referencerate");
        boolean isAdjustToFloat = EmptyUtil.isEmpty((Object)returnDataMap.get("isAdjustToFloat")) ? false : (Boolean)returnDataMap.get("isAdjustToFloat");
        String rateAdjustStyle = (String)returnDataMap.get("rateadjuststyle");
        String rateAdjustCycleType = (String)returnDataMap.get("rateadjustcycletype");
        int rateAdjustCycle = (Integer)returnDataMap.get("rateadjustcycle");
        Date rateAdjustDate = (Date)returnDataMap.get("rateadjustdate");
        String settleIntMode = (String)returnDataMap.get("settleintmode");
        settleIntMode = EmptyUtil.isNoEmpty((String)settleIntMode) ? settleIntMode : SettleIntModeEnum.gdpljx.getValue();
        DynamicObject interestSettledPlan = (DynamicObject)returnDataMap.get("interestsettledplan");
        DynamicObject rateAdjust = BusinessDataServiceHelper.newDynamicObject((String)viewInfoEnum.getParentEntityId());
        rateAdjust.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        rateAdjust.set("loancontractbill", (Object)contractBill);
        rateAdjust.set("adjusteffectdate", (Object)intDate);
        rateAdjust.set("creator", (Object)RequestContext.get().getCurrUserId());
        rateAdjust.set("datasource", (Object)paramMap.get("dataSource"));
        String formId = paramMap.get("formId");
        if (StringUtils.equals((CharSequence)"cfm_rateadjustbill_bond", (CharSequence)formId) || StringUtils.equals((CharSequence)"cfm_loancontract_bo", (CharSequence)formId)) {
            rateAdjust.set("adjustele", (Object)AdjustEleEnum.ADJUSTLOAN.getValue());
        } else {
            rateAdjust.set("adjustele", (Object)AdjustEleEnum.ADJUSTCONTRACT.getValue());
        }
        CreateRateAdjustBill.setAfterProps(contractBill, returnDataMap, paramMap, rateAdjust, isAdjustToFloat);
        rateAdjust.set("productfactory", (Object)contractBill.getLong("productfactory.id"));
        rateAdjust.set("org", (Object)contractBill.getDynamicObject("org"));
        if (!StringUtils.equals((CharSequence)"cfm_rateadjustbill_bond", (CharSequence)formId)) {
            rateAdjust.set("creditorg", (Object)contractBill.getDynamicObject("creditorg"));
        }
        rateAdjust.set("creditortype", (Object)contractBill.getString("creditortype"));
        rateAdjust.set("interestrate", (Object)contractBill.getBigDecimal("interestrate"));
        rateAdjust.set("currency", (Object)contractBill.getDynamicObject("currency"));
        rateAdjust.set("amount", (Object)contractBill.getBigDecimal("amount"));
        rateAdjust.set("drawamount", (Object)contractBill.getBigDecimal("drawamount"));
        rateAdjust.set("notrepayamount", (Object)contractBill.getBigDecimal("notrepayamount"));
        rateAdjust.set("refrate", (Object)(isAdjustToFloat ? referenceRate : contractBill.getDynamicObject("referencerate")));
        rateAdjust.set("rateadjustkey", isAdjustToFloat ? null : contractBill.getString("rateadjustcycletype"));
        rateAdjust.set("rateadjustval", isAdjustToFloat ? null : Integer.valueOf(contractBill.getInt("rateadjustcycle")));
        rateAdjust.set("afterrateadjustkey", (Object)(isAdjustToFloat ? rateAdjustCycleType : contractBill.getString("rateadjustcycletype")));
        rateAdjust.set("afterrateadjustval", (Object)(isAdjustToFloat ? rateAdjustCycle : contractBill.getInt("rateadjustcycle")));
        rateAdjust.set("ratesign", (Object)(isAdjustToFloat ? RateSignEnum.ADD.getValue() : contractBill.getString("ratesign")));
        rateAdjust.set("ratefloatpoint", (Object)(isAdjustToFloat ? BigDecimal.ZERO : contractBill.getBigDecimal("ratefloatpoint")));
        if (isAdjustToFloat) {
            rateAdjust.set("isadjusttofloat", (Object)true);
            rateAdjust.set("rateadjuststyle", (Object)rateAdjustStyle);
            rateAdjust.set("rateadjustdate", (Object)rateAdjustDate);
        }
        rateAdjust.set("beforeinteresttype", (Object)contractBill.getString("interesttype"));
        String repayWay = contractBill.getString("repaymentway");
        rateAdjust.set("repaymentway", (Object)(EmptyUtil.isEmpty((String)repayWay) ? RepaymentWayEnum.bqhbdqhx.getValue() : repayWay));
        if (RepaymentWayEnum.isZdyhk((String)contractBill.getString("repaymentway"))) {
            rateAdjust.set("settleintmode", (Object)settleIntMode);
        } else {
            rateAdjust.set("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        }
        rateAdjust.set("interestsettledplan", (Object)interestSettledPlan);
        CreateRateAdjustBill.setAdjustEntry(contractBill, returnDataMap, rateAdjust, isAdjustToFloat);
        return rateAdjust;
    }

    private static void setAfterProps(DynamicObject contractBill, Map<String, Object> returnDataMap, Map<String, String> paramMap, DynamicObject rateAdjust, boolean isAdjustToFloat) {
        BigDecimal interestRate = (BigDecimal)returnDataMap.get("interestrate");
        DynamicObject referenceRate = (DynamicObject)returnDataMap.get("referencerate");
        BigDecimal rateFloatPoint = (BigDecimal)returnDataMap.get("ratefloatpoint");
        String rateSign = (String)returnDataMap.get("ratesign");
        if (!"bond".equals(paramMap.get("dataSource"))) {
            String interestType = contractBill.getString("interesttype");
            if ((InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && !isAdjustToFloat) {
                rateAdjust.set("afterinterestrate", (Object)interestRate);
            } else {
                rateAdjust.set("afterrefrate", (Object)referenceRate);
                rateAdjust.set("afterratesign", (Object)rateSign);
                rateAdjust.set("afterratefloatpoint", (Object)rateFloatPoint);
                rateAdjust.set("issofrrate", (Object)contractBill.getBoolean("issofrrate"));
            }
        } else if ("floatratebond".equals(contractBill.getString("bondtype"))) {
            rateAdjust.set("afterrefrate", (Object)referenceRate);
            rateAdjust.set("afterratesign", (Object)rateSign);
            rateAdjust.set("afterratefloatpoint", (Object)rateFloatPoint);
        } else {
            rateAdjust.set("afterinterestrate", (Object)interestRate);
        }
    }

    private static void setAdjustEntry(DynamicObject contractBill, Map<String, Object> returnDataMap, DynamicObject rateAdjust, boolean isAdjustToFloat) {
        Date intDate = DateUtils.stringToDate((String)((String)returnDataMap.get("intdate")), (String)"yyyy-MM-dd");
        BigDecimal afterLoanRate = (BigDecimal)returnDataMap.get("interestrate");
        String afterRateSign = (String)returnDataMap.get("ratesign");
        BigDecimal afterRateFloatPoint = (BigDecimal)returnDataMap.get("ratefloatpoint");
        DynamicObject afterReferenceRate = (DynamicObject)returnDataMap.get("referencerate");
        String afterRateAdjustStyle = (String)returnDataMap.get("rateadjuststyle");
        String afterRateAdjustCycleType = (String)returnDataMap.get("rateadjustcycletype");
        int afterRateAdjustCycle = (Integer)returnDataMap.get("rateadjustcycle");
        Date rateAdjustDate = (Date)returnDataMap.get("rateadjustdate");
        String settleIntMode = (String)returnDataMap.get("settleintmode");
        settleIntMode = EmptyUtil.isNoEmpty((String)settleIntMode) ? settleIntMode : SettleIntModeEnum.gdpljx.getValue();
        DynamicObject interestSettledPlan = (DynamicObject)returnDataMap.get("interestsettledplan");
        DynamicObjectCollection entry = rateAdjust.getDynamicObjectCollection("entry");
        DynamicObject[] loanBills = CreateRateAdjustBill.getLoanBills(contractBill);
        Map loanIdAdjustInfoMap = RateAdjustHelper.getLoanIdAdjustInfoMap((DynamicObject[])loanBills);
        DynamicObject contractCurrency = contractBill.getDynamicObject("currency");
        Date adjustDate = intDate;
        for (DynamicObject loanBill : loanBills) {
            long loanId = loanBill.getLong("id");
            String rateSign = loanBill.getString("ratesign");
            BigDecimal rateFloatPoint = loanBill.getBigDecimal("ratefloatpoint");
            DynamicObject referenceRate = loanBill.getDynamicObject("referencerate");
            String rateAdjustCycleType = loanBill.getString("rateadjustcycletype");
            int rateAdjustCycle = loanBill.getInt("rateadjustcycle");
            BigDecimal beforeLoanRate = loanBill.getBigDecimal("loanrate");
            if (EmptyUtil.isNoEmpty(loanIdAdjustInfoMap.get(loanId))) {
                Map adjustInfoMap = (Map)loanIdAdjustInfoMap.get(loanId);
                Date lastAdjustDate = DateUtils.getNextDay((Date)((Date)adjustInfoMap.get("adjustdate")), (int)1);
                adjustDate = intDate.compareTo(lastAdjustDate) > 0 ? intDate : lastAdjustDate;
                rateSign = adjustInfoMap.get("ratesign").toString();
                rateFloatPoint = (BigDecimal)adjustInfoMap.get("ratefloatpoint");
                referenceRate = (DynamicObject)adjustInfoMap.get("referencerate");
                beforeLoanRate = (BigDecimal)adjustInfoMap.get("loanrate");
            }
            DynamicObject loanCurrency = loanBill.getDynamicObject("currency");
            boolean isDiffCurrency = !StringUtils.equals((CharSequence)contractCurrency.getString("number"), (CharSequence)loanCurrency.getString("number"));
            DynamicObject r1 = entry.addNew();
            r1.set("ldrawbill", (Object)loanBill);
            r1.set("ldrawamount", (Object)loanBill.getBigDecimal("drawamount"));
            r1.set("lnotrepayamount", (Object)loanBill.getBigDecimal("notrepayamount"));
            r1.set("loancurrency", (Object)loanBill.getDynamicObject("currency"));
            r1.set("lisadjust", (Object)true);
            r1.set("ladjusteffectdate", (Object)adjustDate);
            r1.set("lloanrate", (Object)beforeLoanRate);
            r1.set("afterlloanrate", (Object)afterLoanRate);
            r1.set("lratesign", (Object)(isAdjustToFloat ? RateSignEnum.ADD.getValue() : rateSign));
            r1.set("lratefloatpoint", (Object)(isAdjustToFloat ? BigDecimal.ZERO : rateFloatPoint));
            r1.set("afterlratesign", (Object)afterRateSign);
            r1.set("afterlratefloatpoint", (Object)afterRateFloatPoint);
            r1.set("lrefrate", (Object)(isAdjustToFloat ? afterReferenceRate : referenceRate));
            r1.set("afterlrefrate", (Object)(isDiffCurrency ? null : afterReferenceRate));
            r1.set("lissofrrate", (Object)loanBill.getBoolean("issofrrate"));
            if (isAdjustToFloat && RateAdjustStyleEnum.isCycle((String)afterRateAdjustStyle) || RateAdjustStyleEnum.isCycle((String)loanBill.getString("rateadjuststyle"))) {
                r1.set("lrateadjustdate", (Object)rateAdjustDate);
                r1.set("lrateadjustkey", (Object)(isAdjustToFloat ? null : rateAdjustCycleType));
                r1.set("lrateadjustval", (Object)(isAdjustToFloat ? null : Integer.valueOf(rateAdjustCycle)));
                r1.set("afterlrateadjustkey", (Object)(isAdjustToFloat ? afterRateAdjustCycleType : rateAdjustCycleType));
                r1.set("afterlrateadjustval", (Object)(isAdjustToFloat ? afterRateAdjustCycle : rateAdjustCycle));
            }
            r1.set("loanrateadjuststyle", (Object)loanBill.getString("rateadjuststyle"));
            if (isAdjustToFloat) {
                r1.set("loanrateadjuststyle", (Object)afterRateAdjustStyle);
            }
            r1.set("lsettleintmode", (Object)loanBill.getString("settleintmode"));
            r1.set("linterestsettledplan", (Object)loanBill.getDynamicObject("interestsettledplan"));
            String interestType = loanBill.getString("interesttype");
            if ((InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("startloanrate")) == 0 && BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("loanrate")) == 0) {
                String repaymentWay = loanBill.getString("repaymentway");
                if (RepaymentWayEnum.isZdyhk((String)repaymentWay)) {
                    r1.set("lsettleintmode", (Object)settleIntMode);
                    r1.set("linterestsettledplan", (Object)interestSettledPlan);
                } else if (RepaymentWayEnum.isBqhbdqhx((String)repaymentWay) || RepaymentWayEnum.isDqhbdqhx((String)repaymentWay)) {
                    r1.set("linterestsettledplan", (Object)interestSettledPlan);
                }
                if (SettleIntModeEnum.isLsbq((String)loanBill.getString("settleintmode"))) {
                    r1.set("linterestsettledplan", null);
                }
            }
            if (LoanTypeEnum.isBond((String)loanBill.getString("loantype"))) {
                afterReferenceRate = loanBill.getDynamicObject("referencerate");
            }
            BigDecimal afterAdjustRate = CreateRateAdjustBill.getAfterAdjustRate(loanBill, afterLoanRate, adjustDate, afterReferenceRate, afterRateSign, afterRateFloatPoint, isAdjustToFloat);
            if (isDiffCurrency) {
                afterAdjustRate = BigDecimal.ZERO;
            }
            r1.set("afteradjustrate", (Object)afterAdjustRate);
        }
    }

    public static BigDecimal getAfterAdjustRate(DynamicObject loanBill, BigDecimal afterLoanRate, Date adjustEffectDate, DynamicObject referenceRate, String rateSign, BigDecimal rateFloatPoint, boolean isAdjustToFloat) {
        if (!InterestTypeEnum.FLOAT.getValue().equals(loanBill.getString("interesttype")) && !isAdjustToFloat) {
            return afterLoanRate;
        }
        Date startDate = adjustEffectDate;
        if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate) && EmptyUtil.isNoEmpty((Object)startDate)) {
            BigDecimal rate;
            if (EmptyUtil.isNoEmpty((Integer)loanBill.getInt("rateresetdays"))) {
                int rateResetDays = loanBill.getInt("rateresetdays");
                startDate = DateUtils.getLastDay((Date)startDate, (int)rateResetDays);
            }
            if (EmptyUtil.isEmpty((BigDecimal)(rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)startDate, (boolean)false)))) {
                return BigDecimal.ZERO;
            }
            BigDecimal rateFloat = new BigDecimal(BigInteger.ZERO);
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
            }
            return rate.add(rateFloat);
        }
        return BigDecimal.ZERO;
    }

    private static DynamicObject[] getLoanBills(DynamicObject contractBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        Object[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)String.join((CharSequence)",", drawProps), (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])loanBills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5408\u540c\u5355\u4e0b\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u63d0\u6b3e\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CfmRateAdjustHelper_2", (String)"tmc-cfm-common", (Object[])new Object[0]));
        }
        return loanBills;
    }
}

