/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.rateadjust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BatchRateAdjustViewInfoEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.formplugin.rateadjust.CreateRateAdjustBill;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class RateAdjustBillList
extends AbstractTmcBillBaseList {
    public void setFilter(SetFilterEvent e) {
        String formId;
        String creditorType;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            Object[] bizTypes = bizType.split(",");
            if (EmptyUtil.isNoEmpty((Object[])bizTypes)) {
                e.getQFilters().add(new QFilter("loancontractbill.loantype", "in", (Object)bizTypes));
            }
            String billFormId = ((ListView)this.getView()).getBillFormId();
            QFilter resFilter = this.addFilterByFormId(billFormId);
            e.getQFilters().add(resFilter);
        }
        if (parameter.getCustomParams().containsKey("creditortype") && EmptyUtil.isNoEmpty((String)(creditorType = (String)parameter.getCustomParam("creditortype")))) {
            e.getQFilters().add(new QFilter("creditortype", "=", (Object)creditorType));
        }
        if (Objects.equals(formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId(), "cfm_rateadjustbill") && !CfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue())) {
            e.getQFilters().add(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumns = args.getFastFilterColumns();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!"loancontractbill.number".equals(fieldName) || !parameter.getCustomParams().containsKey("contractBills")) continue;
            filterColumn.setDefaultValue((String)parameter.getCustomParam("contractBills"));
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        if (parameter.getCustomParams().containsKey("contractBills")) {
            for (FilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!"org.name".equals(fieldName) && !"creditorg.name".equals(fieldName)) continue;
                filterColumn.setDefaultValue("");
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            e.getParameter().getCustomParams().put("biztype", bizType);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("cfm_financingvarieties".equals(args.getRefEntityId())) {
            List<String> bizTypes = this.getBizTypes();
            List qfilters = args.getQfilters();
            if (bizTypes.contains("bond")) {
                qfilters.add(new QFilter("finsource", "=", (Object)"bond"));
            } else {
                qfilters.add(new QFilter("finsource", "!=", (Object)"bond"));
                qfilters.add(new QFilter("finsource", "!=", (Object)" "));
            }
            qfilters.add(new QFilter("isleaf", "=", (Object)"1"));
        }
    }

    public List<QFilter> addCustomFilterForFilterCol(String field) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        if ("loancontractbill.finproduct.number".equals(field)) {
            List<String> bizTypes = this.getBizTypes();
            if (bizTypes.contains("bond")) {
                qFilters.add(new QFilter("finsource", "=", (Object)"bond"));
            } else {
                qFilters.add(new QFilter("finsource", "!=", (Object)"bond"));
                qFilters.add(new QFilter("finsource", "!=", (Object)" "));
            }
            qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
        }
        return qFilters;
    }

    private List<String> getBizTypes() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List<String> bizTypes = new ArrayList<String>(3);
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            bizTypes = Arrays.asList(bizType.split(","));
        }
        return bizTypes;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operateKey)) {
            formOperate.getOption().setVariableValue("RATEADJUSTBILL_FORMID", CfmRateAdjustHelper.getFormIdFromView((IFormView)this.getView()));
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"new")) {
            args.setCancel(true);
            this.openAddNewNavigateForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_RATE_ADJUST", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map returnDataMap = (Map)evt.getReturnData();
            HashMap<String, String> paramMap = new HashMap<String, String>(2);
            paramMap.put("dataSource", this.getDataSource());
            paramMap.put("formId", this.getFormId());
            paramMap.put("dataSrc", "rateAdjust");
            CreateRateAdjustBill.createRateAdjustBill(returnDataMap, paramMap);
            this.getView().invokeOperation("refresh");
        }
    }

    private void openAddNewNavigateForm() {
        FormShowParameter showParameter = new FormShowParameter();
        this.configShowParameter(showParameter);
        String dataSource = this.getDataSource();
        showParameter.getCustomParams().put("entity", this.getEntityId());
        showParameter.getCustomParams().put("formid", this.getFormId());
        showParameter.getCustomParams().put("dataSrc", "rateAdjust");
        showParameter.getCustomParams().put("biztype", this.getBizTypes());
        showParameter.getCustomParams().put("dataSource", dataSource);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_RATE_ADJUST"));
        this.getView().showForm(showParameter);
    }

    private void configShowParameter(FormShowParameter showParameter) {
        String formId = this.getFormId();
        if (StringUtils.equals((CharSequence)"cim_rateadjustbill", (CharSequence)formId)) {
            showParameter.setFormId("cim_rateadjust_batch");
        } else if (StringUtils.equals((CharSequence)"cfm_rateadjustbill_bond", (CharSequence)formId)) {
            showParameter.setFormId("cfm_rateadjust_bond_batch");
        } else {
            showParameter.setFormId("ifm_rateadjust_batch");
        }
    }

    private String getFormId() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getBillFormId();
    }

    private String getEntityId() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getEntityId();
    }

    private String getDataSource() {
        BatchRateAdjustViewInfoEnum viewInfoEnum = BatchRateAdjustViewInfoEnum.getInfoEnumByFormId((String)this.getFormId());
        return viewInfoEnum.getDataSource();
    }

    private QFilter addFilterByFormId(String billFormId) {
        QFilter resFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        switch (billFormId) {
            case "cfm_rateadjustbill": {
                resFilter = this.getBankRateAdjustFilter();
                break;
            }
            case "cfm_rateadjustbill_e_l": {
                resFilter = this.getEntBorrowRateAdjustFilter();
                break;
            }
            case "cim_rateadjustbill": {
                resFilter = this.getEntLoanRateAdjustFilter();
                break;
            }
        }
        return resFilter;
    }

    private QFilter getBankRateAdjustFilter() {
        QFilter settleCenterFilter = new QFilter("creditortype", "=", (Object)"settlecenter");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter notSettleCenterFilter = new QFilter("creditortype", "!=", (Object)"settlecenter");
        QFilter partFilter = settleCenterFilter.and(statusFilter);
        return partFilter.or(notSettleCenterFilter);
    }

    private QFilter getEntBorrowRateAdjustFilter() {
        QFilter selfFilter = new QFilter("datasource", "=", (Object)"cfm");
        QFilter cimDataSourceFilter = new QFilter("datasource", "=", (Object)"invest");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter cimFilter = cimDataSourceFilter.and(statusFilter);
        return selfFilter.or(cimFilter);
    }

    private QFilter getEntLoanRateAdjustFilter() {
        QFilter selfFilter = new QFilter("datasource", "=", (Object)"invest");
        QFilter cfmDataSourceFilter = new QFilter("datasource", "=", (Object)"cfm");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter cfmFilter = cfmDataSourceFilter.and(statusFilter);
        return selfFilter.or(cfmFilter);
    }
}

