/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.rateadjust;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.business.service.loanbill.LoanRateAdjustBean;
import kd.tmc.cfm.common.bean.FloatRateCalBean;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.helper.RateAdjustHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateAdjustPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadEntry();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initVisible();
        this.initEntryLock();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "newentry": 
            case "insertentry": {
                this.addNewEntry();
                this.initEntryLock();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "insertentry": {
                this.insertEntryOP(args);
                break;
            }
            case "deleteentry": {
                this.deleteEntryOP(args);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        Object newVal = e.getChangeSet()[0].getNewValue();
        if (EmptyUtil.isEmpty((Object)newVal)) {
            return;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName = e.getProperty().getName()) {
            case "ra_confirmdate": {
                this.setRateByDateChg(rowIndex, (Date)newVal);
                this.setDataSource(propName, rowIndex, newVal);
                break;
            }
            case "ra_effectdate": {
                this.setDataSource(propName, rowIndex, newVal);
                break;
            }
            case "ra_yearrate": {
                this.setDataSource(propName, rowIndex, newVal);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.clickEvt();
        }
    }

    private void loadEntry() {
        if (this.getControl("entry") != null) {
            this.getModel().deleteEntryData("entry");
            DynamicObject loanBillDB = this.getLoanBill();
            DynamicObjectCollection rateAdjustCals = loanBillDB.getDynamicObjectCollection("rateadjust_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rateAdjustCals)) {
                List rateAdjustCalList = rateAdjustCals.stream().sorted(Comparator.comparing(o -> o.getDate("ra_effectdate"))).collect(Collectors.toList());
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("ra_effectdate", new Object[0]).addField("ra_confirmdate", new Object[0]).addField("ra_yearrate", new Object[0]).addField("ra_remark", new Object[0]).addField("ra_datasource", new Object[0]).addField("ra_modifier", new Object[0]).addField("ra_modifydate", new Object[0]).addField("ra_src_seq", new Object[0]);
                for (DynamicObject rateAdjustCal : rateAdjustCalList) {
                    vs.addRow(new Object[]{rateAdjustCal.getDate("ra_effectdate"), rateAdjustCal.getDate("ra_confirmdate"), rateAdjustCal.getBigDecimal("ra_yearrate"), rateAdjustCal.getString("ra_remark"), rateAdjustCal.getString("ra_datasource"), rateAdjustCal.getDynamicObject("ra_modifier").getPkValue(), rateAdjustCal.getDate("ra_modifydate"), rateAdjustCal.getInt("seq")});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("entry", vs);
                model.endInit();
                this.getView().updateView("entry");
            }
        }
    }

    private void initVisible() {
        this.getView().setVisible(Boolean.valueOf(RateAdjustStyleEnum.isCycle((String)this.getLoanBill().getString("rateadjuststyle"))), new String[]{"insertentry"});
    }

    private void initEntryLock() {
        DynamicObject loanBill = this.getLoanBill();
        Date adjustEffectDate = this.getAdjustEffectDate(loanBill);
        Date lastPayInstDate = loanBill.getDate("endinstdate");
        String rateAdjustStyle = loanBill.getString("rateadjuststyle");
        DynamicObjectCollection repayEntrys = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < repayEntrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)repayEntrys.get(i);
            Date effectDate = entry.getDate("ra_effectdate");
            boolean isAdjust = EmptyUtil.isEmpty((Object)effectDate) || EmptyUtil.isEmpty((Object)adjustEffectDate) || effectDate.compareTo(adjustEffectDate) >= 0;
            boolean isEnable = EmptyUtil.isEmpty((Object)effectDate) || EmptyUtil.isEmpty((Object)lastPayInstDate) || effectDate.compareTo(lastPayInstDate) > 0;
            this.getView().setEnable(Boolean.valueOf(isAdjust && isEnable), i, new String[]{"ra_confirmdate", "ra_effectdate", "ra_remark"});
            this.getView().setEnable(Boolean.valueOf(isAdjust && isEnable && RateAdjustStyleEnum.isHand((String)rateAdjustStyle)), i, new String[]{"ra_yearrate"});
        }
    }

    private Date getAdjustEffectDate(DynamicObject loanBill) {
        DynamicObject rateAdjustBill = RateAdjustHelper.getRateChangeAdjustBills((DynamicObject)loanBill);
        if (EmptyUtil.isNoEmpty((DynamicObject)rateAdjustBill) && rateAdjustBill != null) {
            return rateAdjustBill.getDate("adjusteffectdate");
        }
        return null;
    }

    private void addNewEntry() {
        int currRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        this.getModel().setValue("ra_datasource", (Object)"hand");
        this.getModel().setValue("ra_modifier", (Object)RequestContext.get().getCurrUserId(), currRowIndex);
        this.getModel().setValue("ra_modifydate", (Object)new Date(), currRowIndex);
    }

    private void deleteEntryOP(BeforeDoOperationEventArgs args) {
        if (this.getModel().getEntryCurrentRowIndex("entry") == 0) {
            this.getView().showTipNotification(CfmFormResourceEnum.RateAdjustPlugin_0.loadKDString());
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        DynamicObject loanBill = this.getLoanBill();
        if (this.validateDate(loanBill.getDate("lastpayinstdate"))) {
            this.getView().showTipNotification(CfmFormResourceEnum.RateAdjustPlugin_4.loadKDString());
            args.setCancel(Boolean.TRUE.booleanValue());
        }
        if (this.validateDate(this.getAdjustEffectDate(loanBill))) {
            this.getView().showTipNotification(CfmFormResourceEnum.RateAdjustPlugin_6.loadKDString());
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    private void insertEntryOP(BeforeDoOperationEventArgs args) {
        DynamicObject loanBill = this.getLoanBill();
        if (this.validateDate(loanBill.getDate("lastpayinstdate"))) {
            this.getView().showTipNotification(CfmFormResourceEnum.RateAdjustPlugin_5.loadKDString());
            args.setCancel(Boolean.TRUE.booleanValue());
        }
        if (this.validateDate(this.getAdjustEffectDate(loanBill))) {
            this.getView().showTipNotification(CfmFormResourceEnum.RateAdjustPlugin_7.loadKDString());
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    private boolean validateDate(Date date) {
        int currRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        Date effectDate = (Date)this.getModel().getValue("ra_effectdate", currRowIndex);
        return EmptyUtil.isNoEmpty((Object)effectDate) && EmptyUtil.isNoEmpty((Object)date) && effectDate.compareTo(date) <= 0;
    }

    private void setRateByDateChg(int rowIndex, Date newDate) {
        DynamicObject loanBill = this.getLoanBill();
        DynamicObject rateAdjustBill = RateAdjustHelper.getRateChangeAdjustBills((DynamicObject)loanBill);
        Map rateAdjustBeanMap = CfmRateAdjustHelper.getRateAdjustList((DynamicObject)loanBill, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN, (DynamicObject)rateAdjustBill);
        List floatRateBizSegmBeans = (List)rateAdjustBeanMap.get("floatRateBizSegmBeans");
        BigDecimal yearRate = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((Object)floatRateBizSegmBeans)) {
            yearRate = this.getYearRate(newDate, floatRateBizSegmBeans);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"ra_yearrate", (Object)yearRate, (int)rowIndex);
    }

    private BigDecimal getYearRate(Date getRateDate, List<FloatRateCalBean> floatRateBizSegmBeans) {
        BigDecimal yearRate = BigDecimal.ZERO;
        for (FloatRateCalBean floatRateSegBean : floatRateBizSegmBeans) {
            BigDecimal referRate = MarketDataServiceHelper.referRate((String)floatRateSegBean.getRefrateNum(), (Date)getRateDate, (boolean)false);
            BigDecimal rateFloat = RateAdjustHelper.getRateFloat((FloatRateCalBean)floatRateSegBean);
            yearRate = EmptyUtil.isNoEmpty((BigDecimal)referRate) ? referRate.add(rateFloat) : rateFloat;
        }
        return yearRate;
    }

    private void setDataSource(String propName, int rowIndex, Object newVal) {
        Date oldDate;
        BigDecimal oldRate;
        DynamicObject loanBillDB = this.getLoanBill();
        DynamicObjectCollection rateAdjustCalsEntry = loanBillDB.getDynamicObjectCollection("rateadjust_entry");
        int srcSeq = (Integer)this.getModel().getValue("ra_src_seq", rowIndex);
        if (srcSeq == 0) {
            return;
        }
        DynamicObject rowObject = (DynamicObject)rateAdjustCalsEntry.get(srcSeq - 1);
        String datasource = "ra_yearrate".equals(propName) ? ((oldRate = rowObject.getBigDecimal("ra_yearrate")).compareTo((BigDecimal)newVal) == 0 ? "auto" : "hand") : ((oldDate = DateUtils.getDataFormat((Date)rowObject.getDate(propName), (boolean)true)).compareTo((Date)newVal) == 0 ? "auto" : "hand");
        this.getModel().setValue("ra_datasource", (Object)datasource, rowIndex);
    }

    private void clickEvt() {
        List<String> errMsgList = this.validate();
        if (!errMsgList.isEmpty()) {
            this.showErrorMsg(errMsgList);
            return;
        }
        DynamicObject loanBillDB = this.getLoanBill();
        DynamicObjectCollection entryDOC = this.getModel().getEntryEntity("entry");
        DynamicObjectCollection rateAdjustCalsEntry = loanBillDB.getDynamicObjectCollection("rateadjust_entry");
        boolean ischange = true;
        List loanMarketRateDosList = entryDOC.stream().filter(Objects::nonNull).sorted(Comparator.comparing(c -> c.getDate("ra_effectdate"))).map(LoanRateAdjustBean::fromDo2Bean).collect(Collectors.toList());
        List dbLoanMarketRateDosList = rateAdjustCalsEntry.stream().filter(Objects::nonNull).sorted(Comparator.comparing(c -> c.getDate("ra_effectdate"))).map(LoanRateAdjustBean::fromDo2Bean).collect(Collectors.toList());
        if (JSONObject.toJSONString(loanMarketRateDosList).equals(JSONObject.toJSONString(dbLoanMarketRateDosList))) {
            ischange = false;
        }
        if (ischange) {
            rateAdjustCalsEntry.clear();
            int seq = 1;
            for (LoanRateAdjustBean loanRateAdjust : loanMarketRateDosList) {
                DynamicObject loanRateAdjustDO = rateAdjustCalsEntry.addNew();
                loanRateAdjustDO.set("seq", (Object)seq++);
                loanRateAdjustDO.set("ra_effectdate", (Object)loanRateAdjust.getEffectDate());
                loanRateAdjustDO.set("ra_confirmdate", (Object)loanRateAdjust.getConfirmDate());
                loanRateAdjustDO.set("ra_yearrate", (Object)loanRateAdjust.getYearRate());
                loanRateAdjustDO.set("ra_remark", (Object)loanRateAdjust.getRemark());
                loanRateAdjustDO.set("ra_datasource", (Object)loanRateAdjust.getDatasource());
                loanRateAdjustDO.set("ra_modifier", (Object)loanRateAdjust.getModifier());
                loanRateAdjustDO.set("ra_modifydate", (Object)loanRateAdjust.getModifyDate());
            }
            loanBillDB.set("israteadjustbyhand", (Object)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loanBillDB});
            TmcOperateServiceHelper.execOperate((String)"saverate", (String)"cfm_loanbill", (DynamicObject[])new DynamicObject[]{loanBillDB}, (OperateOption)OperateOption.create());
            HashMap<String, Boolean> returnData = new HashMap<String, Boolean>(16);
            returnData.put("isChange", true);
            this.getView().returnDataToParent(returnData);
        }
        this.getView().close();
    }

    private List<String> validate() {
        ArrayList<String> errorMsg = new ArrayList<String>(10);
        DynamicObjectCollection rateEntrys = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < rateEntrys.size(); ++i) {
            DynamicObject rateEntry = (DynamicObject)rateEntrys.get(i);
            if (!EmptyUtil.isEmpty((Object)rateEntry.getDate("ra_effectdate"))) continue;
            errorMsg.add(CfmFormResourceEnum.RateAdjustPlugin_1.loadKDString(i + 1));
        }
        if (errorMsg.size() == 0) {
            Date tempEffectDate = ((DynamicObject)rateEntrys.get(0)).getDate("ra_effectdate");
            for (int i = 1; i < rateEntrys.size(); ++i) {
                Date effectDate = ((DynamicObject)rateEntrys.get(i)).getDate("ra_effectdate");
                if (!EmptyUtil.isNoEmpty((Object)effectDate)) continue;
                if (tempEffectDate.compareTo(effectDate) >= 0) {
                    errorMsg.add(CfmFormResourceEnum.RateAdjustPlugin_3.loadKDString(i + 1));
                    continue;
                }
                tempEffectDate = effectDate;
            }
        }
        return errorMsg;
    }

    private void showErrorMsg(List<String> errMsgList) {
        String str = String.join((CharSequence)",", errMsgList);
        this.getView().showErrorNotification(str);
    }

    private DynamicObject getLoanBill() {
        return LoanBillRepository.loadSingle((Long)((Long)this.getView().getFormShowParameter().getCustomParam("formPrimId")));
    }
}

