/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.repayapply;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class RepayApplyBillList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilter = e.getQFilters();
        String formId = this.getBillFormId();
        if ("fl_rentpay_apply".equals(formId)) {
            qFilter.add(new QFilter("loantype", "=", (Object)LoanTypeEnum.FINLEASE.getValue()));
        } else if ("cfm_repayapplybill_bond".equals(formId)) {
            qFilter.add(new QFilter("loantype", "=", (Object)LoanTypeEnum.BOND.getValue()));
        } else {
            qFilter.add(new QFilter("loantype", "not in", Arrays.asList(LoanTypeEnum.BOND.getValue(), LoanTypeEnum.FINLEASE.getValue())));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("trace2repay".equals(opKey)) {
            Long selectedId = this.getSelectedId();
            if (EmptyUtil.isNoEmpty((Long)selectedId)) {
                DynamicObject applyBill = TmcDataServiceHelper.loadSingle((Object)selectedId, (String)"cfm_repayapplybill", (String)"id,billstatus,loantype");
                CfmBillCommonHelper.trace2RepayExtendBill((DynamicObject)applyBill, (IFormView)this.getView(), (String)"repay");
            }
        } else if (("audit".equals(opKey) || "push2repay".equals(opKey)) && args.getOperationResult().getValidateResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }
}

