/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.repaymentbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CasPayBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entries = entitySet.FindByEntityKey(this.getTgtMainType().getName());
        String selectProps = "amount,totalamt,loans,loans.e_combineinst,loans.e_actintamt,issuretyrepay,lockpayamt";
        for (ExtendedDataEntity entity : entries) {
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObjectCollection paymentEntries = dataEntity.getDynamicObjectCollection("entry");
            int size = paymentEntries.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject enrty = (DynamicObject)paymentEntries.get(i);
                long sourcebillid = enrty.getLong("e_sourcebillid");
                DynamicObject repaymentBill = TmcDataServiceHelper.loadSingle((Object)sourcebillid, (String)"cfm_repaymentbill", (String)"amount,totalamt,loans,loans.e_combineinst,loans.e_actintamt,issuretyrepay,lockpayamt");
                DynamicObjectCollection loans = repaymentBill.getDynamicObjectCollection("loans");
                BigDecimal intAmt = loans.stream().filter(o -> o.getBoolean("e_combineinst")).map(o -> o.getBigDecimal("e_actintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean isCombineInt = intAmt.compareTo(BigDecimal.ZERO) > 0;
                BigDecimal repayAmt = repaymentBill.getBigDecimal("amount");
                BigDecimal lockAmt = RepaymentbillHelper.getAllPayBillAmt((DynamicObject)repaymentBill, null);
                isCombineInt = isCombineInt && lockAmt.compareTo(BigDecimal.ZERO) == 0;
                BigDecimal actAmt = CasPayBillConvertPlugin.dealSuretyRepayAmt(repaymentBill, repayAmt.subtract(lockAmt));
                BigDecimal payActAmt = isCombineInt ? actAmt : actAmt.add(intAmt);
                dataEntity.set("actpayamt", (Object)payActAmt);
                enrty.set("e_payableamt", (Object)payActAmt);
                enrty.set("e_actamt", (Object)payActAmt);
                if (!isCombineInt) continue;
                DynamicObject secondLine = paymentEntries.addNew();
                secondLine.set("seq", (Object)0);
                secondLine.set("e_payableamt", (Object)intAmt);
                secondLine.set("e_actamt", (Object)intAmt);
                secondLine.set("e_sourcebillid", (Object)sourcebillid);
                secondLine.set("e_sourcebillentryid", (Object)sourcebillid);
                secondLine.set("e_remark", (Object)ResManager.loadKDString((String)"\u5229\u606f", (String)"CasPayBillConvertPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                TmcBotpHelper.addLinkEntity((DynamicObject)dataEntity, (String)"entry", (String)"sourcebilltype", (DynamicObject)repaymentBill, (String)"e_sourcebillentryid");
            }
            paymentEntries.removeIf(v -> EmptyUtil.isEmpty((BigDecimal)v.getBigDecimal("e_payableamt")));
        }
    }

    private static BigDecimal dealSuretyRepayAmt(DynamicObject repaymentBill, BigDecimal actPayAmt) {
        QFilter filter = new QFilter("repaybillid", "=", repaymentBill.getPkValue());
        DynamicObject suretyRelease = QueryServiceHelper.queryOne((String)"fbd_suretyreleasebill", (String)"amount", (QFilter[])new QFilter[]{filter});
        if (repaymentBill.getBoolean("issuretyrepay") && EmptyUtil.isNoEmpty((DynamicObject)suretyRelease)) {
            BigDecimal releaseAmt = suretyRelease.getBigDecimal("amount");
            actPayAmt = actPayAmt.subtract(releaseAmt);
        }
        return actPayAmt;
    }
}

