/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.repaymentbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.CfmPush2PayFormOrListHelper;
import kd.tmc.cfm.formplugin.common.CommonBillFormHelper;
import kd.tmc.cfm.formplugin.helper.CfmFormHelper;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class RepaymentBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String[] repayProps = new String[]{"amount", "bizdate", "predictinstamt", "entrys", "entrys.inststartdate", "entrys.instenddate", "entrys.instdays", "entrys.instprincipalamt", "entrys.rate", "entrys.ratetrandays", "entrys.instamt", "entrys.instctg"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)false);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isInvestRepayBill()) {
            this.getModel().setValue("creditorg", null);
        } else {
            this.getModel().setValue("org", null);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountF7 = (BasedataEdit)this.getControl("accountbank");
        this.addBeforeF7Select(accountF7);
        BasedataEdit loanAccountF7 = (BasedataEdit)this.getControl("loaneracctbank");
        this.addBeforeF7Select(loanAccountF7);
        EntryGrid loans = (EntryGrid)this.getControl("loans");
        if (loans != null) {
            loans.addHyperClickListener((HyperLinkClickListener)this);
        }
        BasedataEdit lendDrAccount = (BasedataEdit)this.getControl("lenddraccount");
        this.addBeforeF7Select(lendDrAccount);
        BasedataEdit lendCrAccount = (BasedataEdit)this.getControl("lendcraccount");
        this.addBeforeF7Select(lendCrAccount);
        BasedataEdit loanDrAccount = (BasedataEdit)this.getControl("loandraccount");
        this.addBeforeF7Select(loanDrAccount);
        BasedataEdit loanCrAccount = (BasedataEdit)this.getControl("loancraccount");
        this.addBeforeF7Select(loanCrAccount);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName;
        switch (propName = args.getProperty().getName()) {
            case "accountbank": {
                this.accountBankF7Evt(args);
                break;
            }
            case "loaneracctbank": {
                this.loanAccountBankF7Evt(args);
                break;
            }
            case "lenddraccount": 
            case "lendcraccount": 
            case "loandraccount": 
            case "loancraccount": {
                CommonBillFormHelper.setAccountF7Evt(args, this.getModel(), this.getView());
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showNoDBPageVal();
        if (StringUtils.equals((CharSequence)BillStatusEnum.SAVE.getValue(), (CharSequence)((String)this.getModel().getValue("billstatus")))) {
            this.handleByFactory();
            this.saveStatusLoadLoanInfo();
            this.setFreeRate();
            this.setEntryAmount();
            this.setVisible();
            this.setEnable();
        }
        this.setCurrenctBalance();
        CfmFormHelper.setUnlockPayAmt(this.getModel(), "needpayamt");
    }

    private void setVisible() {
        DynamicObject repayApplyBill;
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        DynamicObject currency = contractBill.getDynamicObject("currency");
        QFilter qFilter = new QFilter("loancontractbill", "=", contractBill.getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("currency", "!=", currency.getPkValue()));
        boolean exists = TmcDataServiceHelper.exists((String)"cfm_loanbill", (QFilter[])qFilter.toArray());
        if (exists) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isratio"});
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(repayApplyBill = (DynamicObject)this.getModel().getValue("repayapplyf7")))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isratio"});
        }
    }

    private void setEntryAmount() {
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loans)) {
            return;
        }
        for (int i = 0; i < loans.size(); ++i) {
            DynamicObject loanBillF7 = ((DynamicObject)loans.get(i)).getDynamicObject("e_loanbill");
            BigDecimal lockinamount = LoanBillHelper.calLockInAmout((Long)loanBillF7.getLong("id"));
            BigDecimal repayableamount = loanBillF7.getBigDecimal("drawamount").subtract(lockinamount);
            this.getModel().setValue("e_repayableamount", (Object)repayableamount, i);
        }
    }

    private void setEnable() {
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        String flieds = "id, org, currency, drawamount, notrepayamount, loantype, datasource, creditortype, productfactory, creditorg";
        contractBill = TmcDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (String)"cfm_loancontractbill", (String)flieds);
        boolean isRepayByPlan = CfmContractBillHelper.isRepayByPlan((DynamicObject)contractBill);
        this.getView().setEnable(Boolean.valueOf(!isRepayByPlan), new String[]{"bizdate"});
        String repaymentWay = (String)this.getModel().getValue("repaymentway");
        this.getView().setEnable(Boolean.valueOf(!RepaymentWayEnum.isHbfx((String)repaymentWay) && !isRepayByPlan), new String[]{"isratio"});
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("loans");
        for (int i = 0; i < entrys.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(!isRepayByPlan), i, new String[]{"e_repayamount"});
        }
    }

    private void setFreeRate() {
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        if (!CollectionUtils.isEmpty((Collection)loans)) {
            int len = loans.size();
            for (int i = 0; i < len; ++i) {
                DynamicObject loan = (DynamicObject)loans.get(i);
                DynamicObject loanBill = loan.getDynamicObject("e_loanbill");
                BigDecimal loanRate = loanBill.getBigDecimal("loanrate");
                String interestType = loanBill.getString("interesttype");
                if (null == loanRate || loanRate.compareTo(BigDecimal.ZERO) != 0 || !EmptyUtil.isNoEmpty((String)interestType) || InterestTypeEnum.FLOAT.getValue().equals(interestType)) continue;
                this.getModel().setValue("e_ispayinst", (Object)false, i);
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_ispayinst"});
            }
        }
    }

    private void showNoDBPageVal() {
        DynamicObject contractF7 = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isNoEmpty((DynamicObject)contractF7)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"contractdrawamt", (Object)contractF7.getBigDecimal("drawamount"));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"contractnotrepayamt", (Object)contractF7.getBigDecimal("notrepayamount"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "bizdate": {
                this.repayDateCgs(false);
                break;
            }
            case "e_ispayinst": {
                this.IsPayInstChgEvt(e);
                break;
            }
            case "e_repayamount": {
                this.entryRepayAmtChgEvt(e);
                break;
            }
            case "isratio": 
            case "amount": {
                if (!((Boolean)this.getModel().getValue("isratio")).booleanValue()) {
                    return;
                }
                this.calEntryAmt();
                this.calcTotalAmt();
                break;
            }
            case "e_actintamt": {
                this.calcConvertActIntAmt(e);
                this.calcTotalAmt();
                break;
            }
            case "accountbank": {
                this.setCurrenctBalance();
                break;
            }
            case "currency": {
                this.setCurrenctBalance();
                break;
            }
            case "isrelcash": {
                CfmFormHelper.setUnlockPayAmt(this.getModel(), "needpayamt");
                break;
            }
        }
    }

    private void calcTotalAmt() {
        this.getModel().setValue("totalamt", (Object)RepaymentbillHelper.getTotalAmt((DynamicObject)this.getModel().getDataEntity(true)));
    }

    private void calcTotalAmount() {
        BigDecimal totalRepayAmt = this.getAllEntryRowsAmt("e_repayamount");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)totalRepayAmt);
    }

    private void calcConvertActIntAmt(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        BigDecimal actIntAmt = (BigDecimal)this.getModel().getValue("e_actintamt", index);
        BigDecimal convertRate = (BigDecimal)this.getModel().getValue("convertrate", index);
        this.getModel().setValue("e_convertactintamt", (Object)actIntAmt.multiply(convertRate), index);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String errMsg;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        CfmPush2PayFormOrListHelper.formPush2PayForwardValid(args, this.getView());
        if ("deleteentryloans".equals(operateKey) && EmptyUtil.isNoEmpty((String)(errMsg = this.checkLoansNumAndAmt()))) {
            args.setCancel(true);
            this.getView().showTipNotification(errMsg);
        }
        if ("repaypush2paybill".equals(operateKey)) {
            CfmBillCommonHelper.checkLinkPush2TarBill((BeforeDoOperationEventArgs)args, (IFormView)this.getView(), (String)"cfm_repaymentbill");
        }
        if ("submit".equals(operateKey) && "cfm_repaymentbill_bond".equals(this.getView().getFormShowParameter().getFormId()) && EmptyUtil.isNoEmpty((String)(errMsg = this.checkBondRequiredAmt()))) {
            args.setCancel(true);
            this.getView().showTipNotification(errMsg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("loans");
        switch (opKey) {
            case "trackinterest": {
                this.traceInterestBill();
                break;
            }
            case "calint": {
                this.calInt(rowIndex, false);
                break;
            }
            case "repaymentsc": {
                this.repaymentSc(model, rowIndex);
                break;
            }
            case "deleteentryloans": {
                this.calcTotalAmt();
                this.calcTotalAmount();
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("e_loanbill".equals(fieldName)) {
            this.hyper2LoanBill(evt);
        } else if ("e_calintamt".equals(fieldName)) {
            this.showIntDetailForm(evt.getRowIndex());
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        switch (key) {
            case "e_repayamount": {
                DynamicObject rowInfo = this.getModel().getEntryRowEntity("loans", rowIndex);
                BigDecimal norepayAmt = rowInfo.getBigDecimal("e_notrepayamount");
                if (!EmptyUtil.isNoEmpty((Object)value) || new BigDecimal(value + "").compareTo(norepayAmt) <= 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u8fd8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u8fd8\u672c\u91d1\u3002", (String)"RepaymentBillEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key, rowIndex);
                break;
            }
            case "amount": {
                BigDecimal repayableamount = this.getAllEntryRowsAmt("e_repayableamount");
                if (!EmptyUtil.isNoEmpty((Object)value) || new BigDecimal(value + "").compareTo(repayableamount) <= 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5934\u7684\u8fd8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u8fd8\u6b3e\u91d1\u989d\u4e4b\u548c\u3002", (String)"RepaymentBillEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
            }
        }
    }

    private boolean isInvestRepayBill() {
        return "cim_invest_repaybill".equals(this.getModel().getDataEntityType().getName());
    }

    private void calEntryAmt() {
        BigDecimal repayAmt = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal contractNotRepayAmt = (BigDecimal)this.getModel().getValue("contractnotrepayamt");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("loans");
        if (BigDecimal.ZERO.compareTo(repayAmt) == 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_repayamount", (Object)0, (int)i);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_convertrepayamt", (Object)0, (int)i);
                this.clearEntryVal(i, "e_actintamt", "e_calintamt", "intdetail_tag", "e_convertactintamt");
            }
        } else {
            BigDecimal allLoansAmt = this.getAllEntryRowsAmt("e_drawamount");
            BigDecimal rowRepayAmt_sum = BigDecimal.ZERO;
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            int scale = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 10;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                BigDecimal loanAmt = entry.getBigDecimal("e_drawamount");
                BigDecimal rowRepayAmt = loanAmt.divide(allLoansAmt, 10, 4).multiply(repayAmt).setScale(scale, 4);
                if (i == entrys.size() - 1) {
                    rowRepayAmt = repayAmt.subtract(rowRepayAmt_sum);
                }
                rowRepayAmt_sum = rowRepayAmt.add(rowRepayAmt_sum);
                if (repayAmt.compareTo(contractNotRepayAmt) == 0) {
                    rowRepayAmt = entry.getBigDecimal("e_repayableamount");
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_repayamount", (Object)rowRepayAmt, (int)i);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_convertrepayamt", (Object)rowRepayAmt, (int)i);
                this.calInt(i, false);
            }
        }
    }

    private void repayDateCgs(boolean isBind) {
        Date repayDate = (Date)this.getModel().getValue("bizdate");
        for (int i = 0; i < this.getModel().getEntryRowCount("loans"); ++i) {
            DynamicObject loansEntry = this.getModel().getEntryRowEntity("loans", i);
            DynamicObject loanBillF7 = loansEntry.getDynamicObject("e_loanbill");
            boolean enable = !LoanBillHelper.isYkx((DynamicObject)loanBillF7) || repayDate.compareTo(loanBillF7.getDate("expiredate")) > 0;
            this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"e_ispayinst"});
            this.calInt(i, isBind);
        }
    }

    private void entryRepayAmtChgEvt(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        this.calInt(index, false);
        this.calcConvertRepayAmt(index);
        this.calcTotalAmt();
        this.calcTotalAmount();
    }

    private void calcConvertRepayAmt(int index) {
        BigDecimal repayAmount = (BigDecimal)this.getModel().getValue("e_repayamount", index);
        BigDecimal convertRate = (BigDecimal)this.getModel().getValue("convertrate", index);
        BigDecimal convertRepayAmt = repayAmount.multiply(convertRate);
        BigDecimal noRepayAmount = (BigDecimal)this.getModel().getValue("e_notrepayamount", index);
        if (repayAmount.compareTo(noRepayAmount) == 0) {
            DynamicObject loanBill = (DynamicObject)this.getModel().getValue("e_loanbill", index);
            BigDecimal yetRepayAmt = RepaymentBillRepository.getRepayAmountByLoanBillId((Long)loanBill.getLong("id"));
            convertRepayAmt = loanBill.getBigDecimal("convertdrawamt").subtract(yetRepayAmt);
        }
        this.getModel().setValue("e_convertrepayamt", (Object)convertRepayAmt, index);
    }

    private void clearEntryVal(int rowIndex, String ... entryFields) {
        for (String entryField : entryFields) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)entryField, null, (int)rowIndex);
        }
    }

    private BigDecimal getAllEntryRowsAmt(String entryField) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("loans");
        return entryGrid.getSum(entryField);
    }

    private void repaymentSc(IDataModel model, int rowIndex) {
        DynamicObject loanEntry = (DynamicObject)model.getEntryEntity("loans").get(rowIndex);
        DynamicObject loanBillF7 = loanEntry.getDynamicObject("e_loanbill");
        String repaymentWay = loanBillF7.getString("repaymentway");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource((String)model.getValue("datasource"));
        if (RepaymentWayEnum.isHbfx((String)repaymentWay)) {
            this.getView().showTipNotification(bizResource.getLbRepaymentplan_OpError());
            return;
        }
        BillShowParameter repaymentscParam = new BillShowParameter();
        repaymentscParam.setPkId(loanBillF7.getPkValue());
        String formId = "cfm_loadbill_view";
        String entityName = this.getModel().getDataEntityType().getName();
        if ("cim_invest_repaybill".equals(entityName)) {
            formId = "cim_invest_loanbil_plan";
        } else if (LoanTypeEnum.BOND.getValue().equals(loanBillF7.getString("loantype"))) {
            formId = "cfm_loanbill_bond_p";
        } else if ("ifm_repaymentbill".equals(entityName)) {
            formId = "ifm_loanbill_repayplan_l";
        }
        repaymentscParam.setFormId(formId);
        repaymentscParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        repaymentscParam.setBillStatus(BillOperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)repaymentscParam);
    }

    private void IsPayInstChgEvt(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        Boolean ispayinst = (Boolean)this.getModel().getValue("e_ispayinst", index);
        if (!ispayinst.booleanValue()) {
            this.clearEntryVal(index, "e_actintamt", "e_calintamt", "intdetail_tag", "e_convertactintamt");
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"e_actintamt", "e_calintamt"});
        } else {
            this.calInt(index, false);
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"e_actintamt", "e_calintamt"});
        }
        this.calcTotalAmt();
    }

    private void accountBankF7Evt(BeforeF7SelectEvent args) {
        DynamicObject creditor;
        ListShowParameter formShowParameter = (ListShowParameter)args.getFormShowParameter();
        DynamicObject company = (DynamicObject)this.getModel().getValue("org");
        long orgId = company == null ? 0L : Long.parseLong(company.getPkValue().toString());
        QFilter accountBankFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
        QFilter acctStatusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        QFilter acctFilters = accountBankFilter == null ? acctStatusFilter : accountBankFilter.and(acctStatusFilter);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("ifm".equals(appId) && EmptyUtil.isNoEmpty((DynamicObject)(creditor = (DynamicObject)this.getModel().getValue("settlecenter")))) {
            acctFilters.and(new QFilter("bank", "=", creditor.getPkValue()));
        }
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(this.getModel().getDataEntity().getString("creditortype"))) {
            DynamicObject currency;
            Long creditorid = this.getModel().getDataEntity().getLong("creditor");
            if (EmptyUtil.isNoEmpty((Long)creditorid)) {
                acctFilters.and(new QFilter("bank.id", "=", (Object)creditorid));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency")))) {
                acctFilters.and("currency.fbasedataid", "=", currency.getPkValue());
            }
        } else {
            acctFilters.and(new QFilter("acctclassify", "!=", (Object)"I"));
        }
        formShowParameter.getListFilterParameter().getQFilters().add(acctFilters);
    }

    private void loanAccountBankF7Evt(BeforeF7SelectEvent args) {
        QFilter acctFilters;
        ListShowParameter formShowParameter = (ListShowParameter)args.getFormShowParameter();
        DynamicObject loanOrg = (DynamicObject)this.getModel().getValue("creditorg");
        long orgId = loanOrg == null ? 0L : Long.parseLong(loanOrg.getPkValue().toString());
        QFilter accountBankFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
        QFilter acctStatusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        QFilter qFilter = acctFilters = accountBankFilter == null ? acctStatusFilter : accountBankFilter.and(acctStatusFilter);
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(this.getModel().getDataEntity().getString("creditortype"))) {
            acctFilters.and(new QFilter("acctclassify", "=", (Object)"I"));
        } else {
            acctFilters.and(new QFilter("acctclassify", "!=", (Object)"I"));
        }
        formShowParameter.getListFilterParameter().getQFilters().add(acctFilters);
    }

    private void saveStatusLoadLoanInfo() {
        boolean isChanged = this.getModel().getDataChanged();
        String entityName = this.getModel().getDataEntityType().getName();
        if ("cfm_repaymentbill_bond".equals(entityName)) {
            this.getModel().setValue("datasource", (Object)DataSourceEnum.BOND.getValue());
        }
        DynamicObjectCollection loanBills = (DynamicObjectCollection)this.getModel().getValue("loans");
        for (int index = 0; index < loanBills.size(); ++index) {
            DynamicObject loanBillF7 = ((DynamicObject)loanBills.get(index)).getDynamicObject("e_loanbill");
            if (null == loanBillF7) continue;
            this.getModel().setValue("e_notrepayamount", loanBillF7.get("notrepayamount"), index);
        }
        this.getModel().setDataChanged(isChanged);
    }

    private void calInt(int index, boolean isBind) {
        IntBillExtInfo intBill;
        if (!BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u4e0d\u80fd\u70b9\u51fb\u6d4b\u7b97\u5229\u606f\u3002", (String)"RepaymentBillEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject bizBill = this.getModel().getDataEntity();
        DynamicObject loansEntry = this.getModel().getEntryRowEntity("loans", index);
        DynamicObject loanBillF7 = loansEntry.getDynamicObject("e_loanbill");
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillF7.getPkValue(), (String)"cfm_loanbill");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
        boolean isPayInst = (Boolean)this.getModel().getValue("e_ispayinst", index);
        if (!isPayInst) {
            return;
        }
        String msg = this.vailRepayDate(bizResource, index);
        if (EmptyUtil.isNotEmpty((CharSequence)msg)) {
            return;
        }
        BigDecimal repayAmount = (BigDecimal)this.getModel().getValue("e_repayamount", index);
        if (repayAmount == null || repayAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Date repayDate = (Date)this.getModel().getValue("bizdate");
        String error = LoanBillHelper.verifyLastEntIntDate((DynamicObject)loanBill, (Date)repayDate);
        if (EmptyUtil.isNoEmpty((String)error)) {
            this.getView().showTipNotification(error);
            return;
        }
        Date lastPayInstDate = loanBill.getDate("lastpayinstdate");
        if (lastPayInstDate != null && repayDate.compareTo(lastPayInstDate) < 0) {
            this.getView().showTipNotification(String.format(bizResource.getRbPayinterestDateMin(), DateUtils.formatString((Date)lastPayInstDate, (String)"yyyy-MM-dd")));
            return;
        }
        Date instDate = loanBill.getDate("bizdate");
        if (instDate != null && repayDate.compareTo(instDate) <= 0) {
            this.getView().showTipNotification(String.format(bizResource.getRepayAndInstdateCompare(), DateUtils.formatString((Date)instDate, (String)"yyyy-MM-dd")));
            return;
        }
        try {
            intBill = RepaymentbillHelper.getIntBillInfo((DynamicObject)bizBill, (DynamicObject)loanBill, (Date)repayDate, (BigDecimal)repayAmount);
        }
        catch (TmcBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        IDataModel model = this.getModel();
        if (intBill != null) {
            model.setValue("e_calintamt", (Object)intBill.getAmount(), index);
            model.setValue("intdetail_tag", (Object)SerializationUtils.toJsonString((Object)intBill), index);
            BigDecimal actIntAmt = (BigDecimal)this.getModel().getValue("e_actintamt", index);
            BigDecimal convertRate = (BigDecimal)model.getValue("convertrate", index);
            convertRate = convertRate.compareTo(BigDecimal.ZERO) > 0 ? convertRate : BigDecimal.ONE;
            model.setValue("e_convertactintamt", (Object)actIntAmt.multiply(convertRate), index);
            if (!isBind || EmptyUtil.isEmpty((BigDecimal)actIntAmt)) {
                model.setValue("e_actintamt", (Object)intBill.getAmount(), index);
                model.setValue("e_convertactintamt", (Object)intBill.getAmount().multiply(convertRate), index);
            }
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_ispayinst", (Object)Boolean.FALSE, (int)index);
            model.setValue("e_combineinst", (Object)Boolean.FALSE, index);
            model.setValue("e_calintamt", (Object)BigDecimal.ZERO, index);
            model.setValue("e_actintamt", (Object)BigDecimal.ZERO, index);
            model.setValue("e_convertactintamt", (Object)BigDecimal.ZERO, index);
            this.getView().showTipNotification(bizResource.getcanNotcalIntamt());
            return;
        }
        Date startIntDate = loanBill.getDate("startintdate");
        if (intBill == null && startIntDate != null && repayDate.compareTo(startIntDate) <= 0) {
            this.getView().showTipNotification(String.format(bizResource.getStartinterestDate(), DateUtils.formatString((Date)startIntDate, (String)"yyyy-MM-dd")), Integer.valueOf(6000));
        }
    }

    private void traceInterestBill() {
        DynamicObject bizBill = this.getModel().getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
        Long billId = (Long)this.getModel().getValue("id");
        if (billId == null || billId == 0L) {
            this.getView().showTipNotification(bizResource.getRbNotTrackdata());
            return;
        }
        DynamicObjectCollection targetBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("repaymentid", "=", (Object)billId)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)targetBills)) {
            this.getView().showTipNotification(bizResource.getRbNotTrackdata());
            return;
        }
        String formId = FormParameterHelper.getInterestBillFormByBizType((IFormView)this.getView());
        if (targetBills.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)targetBills.get(0)).get("id"));
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(formId);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            HashSet<Object> pks = new HashSet<Object>(targetBills.size());
            for (DynamicObject targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private String vailRepayDate(AbstractBizResource bizResource, int index) {
        Object loanbill = this.getModel().getValue("e_loanbill", index);
        if (EmptyUtil.isEmpty((Object)loanbill)) {
            return bizResource.getRbLoanbillNotNull();
        }
        Date repayDate = (Date)this.getModel().getValue("bizdate");
        if (repayDate == null) {
            return bizResource.getRbRepayDateNotNull();
        }
        return "";
    }

    private void handleByFactory() {
        boolean dataChanged = this.getModel().getDataChanged();
        boolean isPayIntest = false;
        String repaymentMode = (String)this.getModel().getValue("repaymentway");
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("loans");
        if (RepaymentWayEnum.isHbfx((String)repaymentMode)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizdate", "amount", "isratio"});
            for (int i = 0; i < entrys.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_repayamount"});
            }
            isPayIntest = true;
        }
        DynamicObject product = (DynamicObject)this.getModel().getValue("productfactory");
        for (int i = 0; i < entrys.size(); ++i) {
            if (!isPayIntest || product != null && !product.getBoolean("iscallint") || ((Boolean)this.getModel().getValue("isinit")).booleanValue()) continue;
            this.getModel().setValue("e_ispayinst", (Object)true, i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_ispayinst"});
        }
        this.getModel().setDataChanged(dataChanged);
    }

    private void hyper2LoanBill(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("loans", rowIndex);
            DynamicObject loanBill = entryRowEntity.getDynamicObject("e_loanbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(FormParameterHelper.getLoanBillFormByBizType((IFormView)this.getView()));
                parameter.setPkId((Object)loanBill.getLong("id"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractRateAdjustTabEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showIntDetailForm(int index) {
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject entry = this.getModel().getEntryRowEntity("loans", index);
        if (!entry.getBoolean("e_ispayinst")) {
            return;
        }
        if (EmptyUtil.isEmpty((BigDecimal)entry.getBigDecimal("e_calintamt"))) {
            return;
        }
        if (EmptyUtil.isEmpty((String)entry.getString("intdetail_tag"))) {
            this.fillInterestCalAndSave(entry.getDynamicObject("e_loanbill"));
        }
        Map customParams = parameter.getCustomParams();
        customParams.put("intdetail", entry.getString("intdetail_tag"));
        customParams.put("currency", entry.getDynamicObject("e_currency").getPkValue());
        customParams.put("loanbillid", entry.getDynamicObject("e_loanbill").getLong("id"));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(this.getIntDetailFormId(entry));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private String getIntDetailFormId(DynamicObject entry) {
        DynamicObject loanBill = entry.getDynamicObject("e_loanbill");
        if ((loanBill = TmcDataServiceHelper.loadSingle((Object)loanBill.getPkValue(), (String)"cfm_loanbill")).getBoolean("issofrrate")) {
            return "ifm_intbillsofr_detail";
        }
        return "ifm_intbill_detail";
    }

    private void fillInterestCalAndSave(DynamicObject loanBillF7) {
        Long repaymentBillId = (Long)this.getModel().getValue("id");
        if (repaymentBillId == null || repaymentBillId.intValue() == 0) {
            return;
        }
        QFilter instFilter = new QFilter("sourcebillid", "=", loanBillF7.getPkValue()).and(new QFilter("repaymentid", "=", (Object)repaymentBillId));
        DynamicObject interestBill = TmcDataServiceHelper.loadSingle((String)"cfm_interestbill", (String)String.join((CharSequence)",", repayProps), (QFilter[])new QFilter[]{instFilter});
        if (EmptyUtil.isEmpty((DynamicObject)interestBill)) {
            return;
        }
        this.getModel().setValue("intdetail_tag", (Object)SerializationUtils.toJsonString((Object)this.genIntDetail(interestBill)));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
    }

    private IntBillInfo genIntDetail(DynamicObject interestBill) {
        IntBillInfo detail = new IntBillInfo();
        detail.setAmount(interestBill.getBigDecimal("amount"));
        detail.setBizDate(interestBill.getDate("bizdate"));
        DynamicObjectCollection entrys = interestBill.getDynamicObjectCollection("entrys");
        int index = 0;
        ArrayList<IntBillDetailInfo> intDetails = new ArrayList<IntBillDetailInfo>(16);
        for (DynamicObject entry : entrys) {
            IntBillDetailInfo intDetail = new IntBillDetailInfo();
            intDetail.setPrinciple(entry.getBigDecimal("instprincipalamt"));
            intDetail.setDays(entry.getInt("instdays"));
            intDetail.setBeginDate(entry.getDate("inststartdate"));
            intDetail.setEndDate(entry.getDate("instenddate"));
            InterTypeEnum intType = InterTypeEnum.valueOf((String)entry.getString("instctg"));
            intDetail.setIntType(intType);
            intDetail.setBasisDay(entry.getInt("ratetrandays"));
            intDetail.setAmount(entry.getBigDecimal("instamt"));
            intDetail.setRate(entry.getBigDecimal("rate"));
            intDetail.setSeq(index++);
            intDetails.add(intDetail);
        }
        detail.setDetails(intDetails);
        return detail;
    }

    private String checkBondRequiredAmt() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("loans");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cl.size(); ++i) {
            DynamicObject rp = (DynamicObject)cl.get(i);
            if (!EmptyUtil.isEmpty((BigDecimal)rp.getBigDecimal("e_repayamount"))) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c:\u201c%3$s\u201d\u3002", (String)"RepaymentBillEdit_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d1\u884c\u4fe1\u606f", (String)"RepaymentBillEdit_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u8fd8\u6b3e\u91d1\u989d", (String)"RepaymentBillEdit_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0])));
        }
        return sb.toString();
    }

    private String checkLoansNumAndAmt() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("loans");
        int[] indexs = ((EntryGrid)this.getControl("loans")).getSelectRows();
        Arrays.sort(indexs);
        for (int i = indexs.length - 1; i >= 0; --i) {
            cl.remove(indexs[i]);
        }
        if (cl.size() == 0 || cl.size() == 1 && EmptyUtil.isEmpty((BigDecimal)((DynamicObject)cl.get(0)).getBigDecimal("e_repayamount"))) {
            return new BizResourceFactory().getBizResource((String)this.getModel().getValue("datasource")).getAtLeastOneEntry();
        }
        return "";
    }

    private void addBeforeF7Select(BasedataEdit basedataEdit) {
        if (EmptyUtil.isNoEmpty((Object)basedataEdit)) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void setCurrenctBalance() {
        DynamicObject acctBank = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)acctBank) && EmptyUtil.isNoEmpty((DynamicObject)currency) && this.getView().getControl("curbalance") != null) {
            Long acctBankId = acctBank.getLong("id");
            Long currencyId = currency.getLong("id");
            BizBalanceModelBean balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)acctBankId, (long)currencyId);
            if (balance != null && balance.getAmount() != null) {
                this.getModel().setValue("curbalance", (Object)balance.getAmount());
            }
        }
    }
}

