/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.repaymentbill;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RepaymentBillSlbankEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateSlCanRepayAmount();
        this.controlSlPayinst();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "amount": {
                this.slBankRepayFromAmount();
                break;
            }
            case "e_repayamount": {
                this.updateSlRepayInstAmount(e, "e_repayamount", "s_repayamount");
                break;
            }
            case "e_actintamt": {
                this.updateSlRepayInstAmount(e, "e_actintamt", "s_repayinst");
                break;
            }
            case "e_ispayinst": {
                this.controlSlPayinst();
                break;
            }
            case "s_repayamount": {
                this.slRepayInstAmountChange("e_repayamount", "s_repayamount");
                break;
            }
            case "s_repayinst": {
                this.slRepayInstAmountChange("e_actintamt", "s_repayinst");
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "s_repayamount": {
                this.checkSlAmount(e, "e_repayamount");
                break;
            }
            case "s_repayinst": {
                this.checkSlAmount(e, "e_actintamt");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "deleteentryloans": {
                this.updateSlbankEntrys();
                break;
            }
        }
    }

    private void slBankRepayFromAmount() {
        boolean isBanksLoan = LoanTypeEnum.isBanksLoan((String)((String)this.getModel().getValue("loantype")));
        if (!isBanksLoan) {
            return;
        }
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        DynamicObjectCollection slEntrys = this.getModel().getEntryEntity("slentryentity");
        for (DynamicObject loanEntry : loans) {
            DynamicObject loan = loanEntry.getDynamicObject("e_loanbill");
            if (EmptyUtil.isEmpty((DynamicObject)loan)) continue;
            HashMap<Long, Pair> repayAmountPair = new HashMap<Long, Pair>();
            repayAmountPair.put(loan.getLong("id"), Pair.of((Object)loanEntry.getBigDecimal("e_drawamount"), (Object)loanEntry.getBigDecimal("e_repayamount")));
            List slBankEntrys = slEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && o.getDynamicObject("s_loanbillno").getLong("id") == loan.getLong("id")).collect(Collectors.toList());
            int currencyPresion = BusinessHelper.getCurrencyPresion((DynamicObject)((DynamicObject)this.getModel().getValue("currency")));
            RepaymentbillHelper.setSlBankRepayEntrys(slBankEntrys, repayAmountPair, (String)"s_repayamount", (boolean)false, (int)currencyPresion);
            repayAmountPair.put(loan.getLong("id"), Pair.of((Object)loanEntry.getBigDecimal("e_drawamount"), (Object)loanEntry.getBigDecimal("e_actintamt")));
            RepaymentbillHelper.setSlBankRepayEntrys(slBankEntrys, repayAmountPair, (String)"s_repayinst", (boolean)false, (int)currencyPresion);
        }
        this.getView().updateView("slentryentity");
    }

    private void slRepayInstAmountChange(String loanRepayAmountField, String slRepayAmountField) {
        int currIdx = this.getModel().getEntryCurrentRowIndex("slentryentity");
        DynamicObject bank = (DynamicObject)this.getModel().getValue("s_bank", currIdx);
        DynamicObject slLoanBill = (DynamicObject)this.getModel().getValue("s_loanbillno", currIdx);
        if (EmptyUtil.isEmpty((DynamicObject)slLoanBill)) {
            return;
        }
        DynamicObjectCollection loanEntrys = this.getModel().getEntryEntity("loans");
        DynamicObject loanEntry = loanEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_loanbill")) && slLoanBill.getLong("id") == o.getDynamicObject("e_loanbill").getLong("id")).findFirst().orElse(null);
        BigDecimal totalAmount = loanEntry.getBigDecimal(loanRepayAmountField);
        DynamicObjectCollection slBankEntrys = this.getModel().getEntryEntity("slentryentity");
        List slBankEntryList = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && o.getDynamicObject("s_loanbillno").getLong("id") == slLoanBill.getLong("id")).collect(Collectors.toList());
        BigDecimal slTotalRepayAmount = slBankEntryList.stream().map(o -> o.getBigDecimal(slRepayAmountField)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal subAmount = totalAmount.subtract(slTotalRepayAmount);
        if (EmptyUtil.isNoEmpty(slBankEntryList) && EmptyUtil.isNoEmpty((DynamicObject)bank)) {
            if (slBankEntryList.size() == 2) {
                DynamicObject entry = slBankEntryList.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_bank")) && bank.getLong("id") != o.getDynamicObject("s_bank").getLong("id")).findFirst().orElse(null);
                this.setSubAmount(entry, loanRepayAmountField, slRepayAmountField, subAmount);
            } else {
                int slRowCount = this.getModel().getEntryRowCount("slentryentity");
                for (int i = currIdx + 1; i <= slRowCount; ++i) {
                    DynamicObject loanBill;
                    DynamicObject dynamicObject = loanBill = i < slRowCount ? (DynamicObject)this.getModel().getValue("s_loanbillno", i) : null;
                    if (slRowCount != i && (loanBill == null || loanBill.getLong("id") == slLoanBill.getLong("id"))) continue;
                    DynamicObject rowEntity = this.getModel().getEntryRowEntity("slentryentity", i - 1);
                    this.setSubAmount(rowEntity, loanRepayAmountField, slRepayAmountField, subAmount);
                    break;
                }
            }
        }
        this.getView().updateView("slentryentity");
        this.controlSlPayinst();
    }

    private void setSubAmount(DynamicObject entry, String loanRepayAmountField, String slRepayAmountField, BigDecimal subAmount) {
        if (EmptyUtil.isEmpty((DynamicObject)entry)) {
            return;
        }
        BigDecimal canRepayAmount = entry.getBigDecimal("s_canrepayamount");
        BigDecimal loanAmount = entry.getBigDecimal("s_loanamount");
        BigDecimal repayAmount = entry.getBigDecimal(slRepayAmountField).add(subAmount);
        if (EmptyUtil.isEmpty((BigDecimal)loanAmount) || "e_repayamount".equals(loanRepayAmountField) && repayAmount.compareTo(canRepayAmount) > 0) {
            return;
        }
        entry.set(slRepayAmountField, (Object)(BigDecimal.ZERO.compareTo(repayAmount) > 0 ? BigDecimal.ZERO : repayAmount));
    }

    private void checkSlAmount(BeforeFieldPostBackEvent e, String maxField) {
        int amtPrecision;
        BigDecimal amount;
        DynamicObjectCollection loanEntrys;
        DynamicObject loanEntry;
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        DynamicObject loanBill = (DynamicObject)this.getModel().getValue("s_loanbillno");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        BigDecimal maxAmount = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBill) && EmptyUtil.isNoEmpty((DynamicObject)(loanEntry = (DynamicObject)(loanEntrys = this.getModel().getEntryEntity("loans")).stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_loanbill")) && loanBill.getLong("id") == o.getDynamicObject("e_loanbill").getLong("id")).findFirst().orElse(null)))) {
            maxAmount = loanEntry.getBigDecimal(maxField);
        }
        BigDecimal bigDecimal = amount = EmptyUtil.isEmpty((Object)value) ? BigDecimal.ZERO : new BigDecimal(String.valueOf(value));
        if (BigDecimal.ZERO.compareTo(amount) > 0) {
            e.setCancel(true);
            this.getView().updateView(maxField.equals("e_repayamount") ? "s_repayamount" : "s_repayinst", rowIndex);
            return;
        }
        if ("e_repayamount".equals(maxField)) {
            BigDecimal canAmount = (BigDecimal)this.getModel().getValue("s_canrepayamount", rowIndex);
            if (EmptyUtil.isNoEmpty((BigDecimal)amount) && amount.compareTo(canAmount) > 0) {
                e.setCancel(true);
                this.getView().showTipNotification(CfmFormResourceEnum.RepaymentBillSlbankEdit_0.loadKDString());
                this.getView().updateView("s_repayamount", rowIndex);
                return;
            }
        }
        int n = amtPrecision = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 2;
        if (EmptyUtil.isNoEmpty((BigDecimal)amount) && amount.compareTo(maxAmount) > 0) {
            e.setCancel(true);
            String msg = CfmFormResourceEnum.RepaymentBillSlbankEdit_1.loadKDString(maxAmount.setScale(amtPrecision));
            if (!"e_repayamount".equals(maxField)) {
                msg = CfmFormResourceEnum.RepaymentBillSlbankEdit_2.loadKDString(maxAmount.setScale(amtPrecision));
            }
            this.getView().showTipNotification(msg);
            this.getView().updateView(maxField.equals("e_repayamount") ? "s_repayamount" : "s_repayinst", rowIndex);
        }
    }

    private void updateSlbankEntrys() {
        DynamicObjectCollection loanEntrys = this.getModel().getEntryEntity("loans");
        Set loanIds = BusinessHelper.getEntryBillIds((DynamicObjectCollection)loanEntrys, (String)"e_loanbill");
        int slRowCount = this.getModel().getEntryRowCount("slentryentity");
        HashSet<Integer> rowIdx = new HashSet<Integer>(slRowCount);
        for (int i2 = 0; i2 < slRowCount; ++i2) {
            DynamicObject loanBill = (DynamicObject)this.getModel().getValue("s_loanbillno", i2);
            if (!EmptyUtil.isEmpty((DynamicObject)loanBill) && loanIds.contains(loanBill.getLong("id"))) continue;
            rowIdx.add(i2);
        }
        if (rowIdx.size() > 0) {
            this.getModel().deleteEntryRows("slentryentity", rowIdx.stream().mapToInt(i -> i).toArray());
        }
    }

    private void updateSlCanRepayAmount() {
        if (!this.isNeedUpdateCanRepayAmount()) {
            return;
        }
        DynamicObjectCollection slBankEntrys = this.getModel().getEntryEntity("slentryentity");
        Set loanBillIds = BusinessHelper.getEntryBillIds((DynamicObjectCollection)slBankEntrys, (String)"s_loanbillno");
        DataSet repaySlBankDs = RepaymentbillHelper.getRepaySlBankDs((Set)loanBillIds);
        Map slBankRepayedMap = RepaymentbillHelper.getRepaySlBanks((DataSet)repaySlBankDs, (boolean)true);
        Map slBankRepayMap = RepaymentbillHelper.getRepaySlBanks((DataSet)repaySlBankDs, (boolean)false);
        int entryRowCount = this.getModel().getEntryRowCount("slentryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject loanBill = (DynamicObject)this.getModel().getValue("s_loanbillno", i);
            DynamicObject bank = (DynamicObject)this.getModel().getValue("s_bank", i);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{loanBill, bank})) continue;
            long billId = loanBill.getLong("id");
            long bankId = bank.getLong("id");
            BigDecimal bankRepayedAmount = slBankRepayedMap.getOrDefault(String.valueOf(billId) + bankId, BigDecimal.ZERO);
            BigDecimal bankRepayAmount = slBankRepayMap.getOrDefault(String.valueOf(billId) + bankId, BigDecimal.ZERO);
            BigDecimal loanAmount = (BigDecimal)this.getModel().getValue("s_loanamount", i);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"s_notrepayamount", (Object)loanAmount.subtract(bankRepayedAmount), (int)i);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"s_canrepayamount", (Object)loanAmount.subtract(bankRepayAmount), (int)i);
        }
        this.getView().updateView("slentryentity");
    }

    private void controlSlPayinst() {
        if (!this.isNeedUpdateCanRepayAmount()) {
            return;
        }
        DynamicObjectCollection loanEntrys = this.getModel().getEntryEntity("loans");
        Set payIntLoanIds = loanEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_loanbill")) && o.getBoolean("e_ispayinst")).map(o -> o.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toSet());
        int entryRowCount = this.getModel().getEntryRowCount("slentryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject slLoanBill = (DynamicObject)this.getModel().getValue("s_loanbillno", i);
            BigDecimal loanAmount = (BigDecimal)this.getModel().getValue("s_loanamount", i);
            if (EmptyUtil.isEmpty((BigDecimal)loanAmount)) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"s_repayamount"});
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)i, (String[])new String[]{"s_repayamount"});
            }
            if (EmptyUtil.isEmpty((BigDecimal)loanAmount) || EmptyUtil.isNoEmpty((DynamicObject)slLoanBill) && !payIntLoanIds.contains(slLoanBill.getLong("id"))) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"s_repayinst"});
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)i, (String[])new String[]{"s_repayinst"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"s_repayinst"});
        }
    }

    private void updateSlRepayInstAmount(PropertyChangedArgs e, String loanAmountField, String slAmountField) {
        DynamicObject loanBill = this.getLoanBill(e);
        if (loanBill == null) {
            return;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        HashMap<Long, Pair> repayAmountPair = new HashMap<Long, Pair>();
        repayAmountPair.put(loanBill.getLong("id"), Pair.of((Object)((BigDecimal)this.getModel().getValue("e_repayableamount", rowIndex)), (Object)((BigDecimal)this.getModel().getValue(loanAmountField, rowIndex))));
        DynamicObjectCollection slEntrys = this.getModel().getEntryEntity("slentryentity");
        List slBankEntrys = slEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && o.getDynamicObject("s_loanbillno").getLong("id") == loanBill.getLong("id")).collect(Collectors.toList());
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        RepaymentbillHelper.setSlBankRepayEntrys(slBankEntrys, repayAmountPair, (String)slAmountField, (boolean)false, (int)BusinessHelper.getCurrencyPresion((DynamicObject)currency));
        this.getView().updateView("slentryentity");
        this.controlSlPayinst();
    }

    private DynamicObject getLoanBill(PropertyChangedArgs e) {
        boolean isBanksLoan = LoanTypeEnum.isBanksLoan((String)((String)this.getModel().getValue("loantype")));
        if (!isBanksLoan) {
            return null;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject loanBill = (DynamicObject)this.getModel().getValue("e_loanbill", rowIndex);
        return loanBill;
    }

    private boolean isNeedUpdateCanRepayAmount() {
        boolean isBanksLoan = LoanTypeEnum.isBanksLoan((String)((String)this.getModel().getValue("loantype")));
        return isBanksLoan && BillStatusEnum.isSave((String)((String)this.getModel().getValue("billstatus")));
    }
}

