/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.unifyloanreturn;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UnifyLoanRepayList
extends AbstractListPlugin {
    private static final String SELECT_ENTRY = "select_entry";
    private static final String FROM_ENTRY = "fromEntry";
    private static final String USE_ENTRY = "useEntry";

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("isunifyloanreturn", "=", (Object)Boolean.TRUE));
        String selectEntry = this.getView().getPageCache().get(SELECT_ENTRY);
        if (FROM_ENTRY.equals(selectEntry)) {
            qFilters.add(new QFilter("isunifycredit", "=", (Object)Boolean.TRUE));
        } else if (USE_ENTRY.equals(selectEntry)) {
            qFilters.add(new QFilter("isunifydebit", "=", (Object)Boolean.TRUE));
        } else {
            qFilters.add(new QFilter("isunifycredit", "=", (Object)Boolean.TRUE));
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        String entryEntity = args.getEntryEntity();
        if ("unifyloanfrom_entry".equals(entryEntity)) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put(SELECT_ENTRY, FROM_ENTRY);
        } else if ("unifyloanuse_entry".equals(entryEntity)) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put(SELECT_ENTRY, USE_ENTRY);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!fieldName.startsWith("finproduct.")) continue;
            commonFilter.setComboItems(this.getFinproductCombo());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("finproduct.")) {
            List qfilters = args.getQfilters();
            QFilter qFilter = new QFilter("isunifyloanreturn", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection finproductCols = QueryServiceHelper.query((String)"cfm_loanbill", (String)"finproduct", (QFilter[])new QFilter[]{qFilter}, (String)"");
            Set finproductIds = finproductCols.stream().map(r -> r.getLong("finproduct")).collect(Collectors.toSet());
            qfilters.clear();
            qfilters.add(new QFilter("id", "in", finproductIds));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billlistap.getCurrentSelectedRowInfo();
        Object selectedRowId = currentSelectedRowInfo.getPrimaryKeyValue();
        Object entryPrimaryId = currentSelectedRowInfo.getEntryPrimaryKeyValue();
        switch (fieldName = args.getFieldName()) {
            case "billno": {
                this.showCurrentBill(args, selectedRowId);
                break;
            }
            case "e_loanbill": {
                this.showFromEntryBill(args, selectedRowId, entryPrimaryId);
                break;
            }
            case "u_loanbill": {
                this.showUseEntryBill(args, selectedRowId, entryPrimaryId);
                break;
            }
        }
    }

    private List<ComboItem> getFinproductCombo() {
        ArrayList<ComboItem> ids = new ArrayList<ComboItem>(10);
        QFilter qFilter = new QFilter("isunifyloanreturn", "=", (Object)Boolean.TRUE);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loanbill", (String)"finproduct.id finproductid, finproduct.name finproductname", (QFilter[])new QFilter[]{qFilter}, (String)"");
        if (EmptyUtil.isEmpty((Object)dataSet)) {
            return null;
        }
        dataSet = dataSet.distinct();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(row.getString("finproductname")));
            item.setValue(row.getString("finproductid"));
            ids.add(item);
        }
        return ids;
    }

    private void showCurrentBill(HyperLinkClickArgs args, Object selectedRowId) {
        args.setCancel(true);
        DynamicObject loanBill = this.getLoanBill(selectedRowId);
        String selectEntry = this.getPageCache().get(SELECT_ENTRY);
        String formId = "cfm_loanbill";
        if (EmptyUtil.isEmpty((String)selectEntry) || FROM_ENTRY.equals(selectEntry)) {
            formId = "cim_invest_loanbill";
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(loanBill.getString("creditortype"))) {
                formId = "ifm_loanbill";
            }
        } else if (USE_ENTRY.equals(selectEntry)) {
            formId = "cfm_loanbill_b_l";
            if (LoanTypeEnum.isBond((String)loanBill.getString("loantype"))) {
                formId = "cfm_loanbill_bond";
            }
        }
        this.buildAndShowForm(formId, (Long)selectedRowId);
    }

    private void showFromEntryBill(HyperLinkClickArgs args, Object selectedRowId, Object entryPrimaryId) {
        args.setCancel(true);
        DynamicObject loanBill = this.getLoanBill(selectedRowId);
        DynamicObjectCollection fromEntry = loanBill.getDynamicObjectCollection("unifyloanfrom_entry");
        Long loanBillId = 0L;
        String formId = "cfm_loanbill";
        for (int i = 0; i < fromEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)fromEntry.get(i);
            if (!row.getPkValue().equals(entryPrimaryId)) continue;
            loanBillId = row.getDynamicObject("e_loanbillid").getLong("id");
            String fromType = row.getString("e_fromtype");
            if ("bond".equals(fromType)) {
                formId = "cfm_loanbill_bond";
                break;
            }
            if (!"cfm".equals(fromType)) break;
            formId = "cfm_loanbill_b_l";
            break;
        }
        this.buildAndShowForm(formId, loanBillId);
    }

    private void showUseEntryBill(HyperLinkClickArgs args, Object selectedRowId, Object entryPrimaryId) {
        args.setCancel(true);
        DynamicObject loanBill = this.getLoanBill(selectedRowId);
        DynamicObjectCollection useEntry = loanBill.getDynamicObjectCollection("unifyloanuse_entry");
        Long loanBillId = 0L;
        String formId = "cfm_loanbill";
        for (int i = 0; i < useEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)useEntry.get(i);
            if (!row.getPkValue().equals(entryPrimaryId)) continue;
            loanBillId = row.getDynamicObject("u_loanbillid").getLong("id");
            String useType = row.getString("u_usetype");
            if ("enter".equals(useType)) {
                formId = "cim_invest_loanbill";
                break;
            }
            if (!"bank".equals(useType)) break;
            formId = "ifm_loanbill";
            break;
        }
        this.buildAndShowForm(formId, loanBillId);
    }

    private DynamicObject getLoanBill(Object selectedRowId) {
        return TmcDataServiceHelper.loadSingleFromCache((String)"cfm_loanbill", (String)"id,creditortype,loantype,unifyloanfrom_entry.e_fromtype,unifyloanfrom_entry.e_loanbillid,unifyloanuse_entry.u_usetype,unifyloanuse_entry.u_loanbillid", (QFilter[])new QFilter[]{new QFilter("id", "=", selectedRowId)});
    }

    private void buildAndShowForm(String formId, Long loanBillId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(formId);
        parameter.setPkId((Object)loanBillId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

