/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.mservice.interest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cfm.common.bean.BatchInterestCalcRequest;
import kd.tmc.cfm.common.bean.CalcInterestSegmRequest;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.mservice.api.BatchCalcLoanBillIntReq;
import kd.tmc.cfm.mservice.api.BatchCalcLoanBillIntSegmReq;
import kd.tmc.cfm.mservice.api.CalcLoanBillIntReq;
import kd.tmc.cfm.mservice.api.CalcLoanBillIntSegmReq;
import kd.tmc.cfm.mservice.api.CalcLoanBillIntService;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.ListUtils;

public class CalcLoanBillIntServiceImpl
implements CalcLoanBillIntService {
    public IntBillExtInfo callLoanInt(Long loanBillid, Date beginDate, Date endDate) {
        return InterestCalcHelper.callInt((Long)loanBillid, (Date)beginDate, (Date)endDate, (boolean)false);
    }

    public IntBillExtInfo callLoanPreInt(Long loanBillid, Date beginDate, Date endDate) {
        return InterestCalcHelper.callInt((Long)loanBillid, (Date)beginDate, (Date)endDate, (boolean)true);
    }

    public IntBillExtInfo calRepayInt(Long loanBillid, Date endDate, BigDecimal repayAmt) {
        return InterestCalcHelper.callInt((Long)loanBillid, (Date)endDate, (BigDecimal)repayAmt);
    }

    public Map<Long, IntBillExtInfo> batchCallLoanInt(List<Long> loanBillids, Date beginDate, Date endDate) {
        return this.batchCallLoanInt(loanBillids, beginDate, endDate, false);
    }

    public Map<Long, IntBillExtInfo> batchCallLoanInt(List<Long> loanBillids, Date beginDate, Date endDate, boolean isWithPayInt) {
        HashMap<Long, IntBillExtInfo> result = new HashMap<Long, IntBillExtInfo>(loanBillids.size());
        List splitList = ListUtils.splitList(loanBillids, (long)100L);
        for (List billIds : splitList) {
            result.putAll(InterestCalcHelper.batchCallInt((List)billIds, (Date)beginDate, (Date)endDate, (boolean)isWithPayInt));
        }
        return result;
    }

    public Map<Long, IntBillExtInfo> batchCalcLoanBillInt(BatchCalcLoanBillIntReq req) {
        HashMap<Long, IntBillExtInfo> result = new HashMap<Long, IntBillExtInfo>(req.getRequests().size());
        List splitList = ListUtils.splitList((List)req.getRequests(), (long)100L);
        for (List intReqs : splitList) {
            BatchInterestCalcRequest request = new BatchInterestCalcRequest().setSkipException(true);
            Map<Long, CalcLoanBillIntReq> reqMap = intReqs.stream().collect(Collectors.toMap(CalcLoanBillIntReq::getLoanBillId, r -> r));
            ArrayList<Long> loanBillIds = new ArrayList<Long>(reqMap.keySet());
            List loanBills = InterestCalcHelper.getLoanBills(loanBillIds);
            for (DynamicObject loanBill : loanBills) {
                long loanBillId = loanBill.getLong("id");
                CalcLoanBillIntReq intReq = reqMap.get(loanBillId);
                InterestCalcRequest calcRequest = InterestCalcRequest.build((DynamicObject)loanBill, (Date)intReq.getBeginDate(), (Date)intReq.getEndDate());
                calcRequest.setCalcOverInt(intReq.isCalcOverInt()).setPreInt(intReq.isPreInt());
                request.addInterestCalcRequest(calcRequest);
            }
            result.putAll(InterestCalcHelper.batchCalcLoanBillInt((BatchInterestCalcRequest)request));
        }
        return result;
    }

    public List<IntBillExtInfo> calcLoanBillSegmInt(CalcLoanBillIntSegmReq request) {
        CalcInterestSegmRequest req = this.getCalcInterestSegmRequest(request);
        return InterestCalcHelper.calcLoanBillSegmInt((CalcInterestSegmRequest)req);
    }

    private CalcInterestSegmRequest getCalcInterestSegmRequest(CalcLoanBillIntSegmReq request) {
        CalcInterestSegmRequest req = new CalcInterestSegmRequest(request.getLoanBillId());
        for (CalcLoanBillIntSegmReq.DateParam dateParam : request.getDateParams()) {
            req.addDateParam(dateParam.getBeginDate(), dateParam.getEndDate());
        }
        return req;
    }

    public Map<Long, List<IntBillExtInfo>> batchCalcLoanBillSegmInt(BatchCalcLoanBillIntSegmReq request) {
        ArrayList segmRequests = new ArrayList(request.getRequests().size());
        request.getRequests().forEach(req -> segmRequests.add(this.getCalcInterestSegmRequest((CalcLoanBillIntSegmReq)req)));
        return InterestCalcHelper.batchCalcLoanBillSegmInt(segmRequests);
    }
}

